/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.internal.com.google.dart.compiler.ast;

import org.jetbrains.jet.internal.com.google.dart.compiler.ast.DartContext;
import org.jetbrains.jet.internal.com.google.dart.compiler.ast.DartExpression;
import org.jetbrains.jet.internal.com.google.dart.compiler.ast.DartPlainVisitor;
import org.jetbrains.jet.internal.com.google.dart.compiler.ast.DartVisitor;
import org.jetbrains.jet.internal.com.google.dart.compiler.ast.ElementReference;
import org.jetbrains.jet.internal.com.google.dart.compiler.common.Symbol;
import org.jetbrains.jet.internal.com.google.dart.compiler.resolver.Element;

public class DartIdentifier
extends DartExpression
implements ElementReference {
    private final String targetName;
    private Element targetSymbol;
    private DartExpression normalizedNode = this;
    private Element referencedElement;

    public DartIdentifier(String targetName) {
        assert (targetName != null);
        this.targetName = targetName;
    }

    public DartIdentifier(DartIdentifier original) {
        this.targetName = original.targetName;
    }

    public void setNormalizedNode(DartExpression normalizedNode) {
        normalizedNode.setSourceInfo(this);
        this.normalizedNode = normalizedNode;
    }

    @Override
    public DartExpression getNormalizedNode() {
        return this.normalizedNode;
    }

    @Override
    public Element getSymbol() {
        return this.targetSymbol;
    }

    @Override
    public boolean isAssignable() {
        return true;
    }

    public String getTargetName() {
        return this.targetName;
    }

    public Element getTargetSymbol() {
        return this.targetSymbol;
    }

    @Override
    public void setSymbol(Symbol symbol) {
        this.targetSymbol = (Element)symbol;
    }

    @Override
    public void traverse(DartVisitor v, DartContext ctx) {
        v.visit(this, ctx);
        v.endVisit(this, ctx);
    }

    @Override
    public void visitChildren(DartPlainVisitor<?> visitor) {
    }

    @Override
    public <R> R accept(DartPlainVisitor<R> visitor) {
        return visitor.visitIdentifier(this);
    }

    @Override
    public void setReferencedElement(Element element) {
        this.referencedElement = element;
    }

    @Override
    public Element getReferencedElement() {
        return this.referencedElement;
    }

    public static boolean isPrivateName(String name) {
        return name.startsWith("_");
    }
}

