/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.internal.com.google.dart.compiler.ast;

import org.jetbrains.jet.internal.com.google.dart.compiler.ast.DartContext;
import org.jetbrains.jet.internal.com.google.dart.compiler.ast.DartExpression;
import org.jetbrains.jet.internal.com.google.dart.compiler.ast.DartFunction;
import org.jetbrains.jet.internal.com.google.dart.compiler.ast.DartIdentifier;
import org.jetbrains.jet.internal.com.google.dart.compiler.ast.DartNode;
import org.jetbrains.jet.internal.com.google.dart.compiler.ast.DartPlainVisitor;
import org.jetbrains.jet.internal.com.google.dart.compiler.ast.DartVisitor;
import org.jetbrains.jet.internal.com.google.dart.compiler.common.HasSymbol;
import org.jetbrains.jet.internal.com.google.dart.compiler.common.Symbol;
import org.jetbrains.jet.internal.com.google.dart.compiler.resolver.MethodElement;

public class DartFunctionExpression
extends DartExpression
implements HasSymbol {
    private DartIdentifier name;
    private final boolean isStmt;
    private MethodElement symbol;
    private DartFunction function;

    public DartFunctionExpression(DartIdentifier name, DartFunction function, boolean isStmt) {
        this.name = this.becomeParentOf(name);
        this.function = this.becomeParentOf(function);
        this.isStmt = isStmt;
    }

    public DartFunction getFunction() {
        return this.function;
    }

    public String getFunctionName() {
        if (this.name == null) {
            return null;
        }
        return this.name.getTargetName();
    }

    public DartIdentifier getName() {
        return this.name;
    }

    @Override
    public MethodElement getSymbol() {
        return this.symbol;
    }

    public boolean isStatement() {
        return this.isStmt;
    }

    public void setName(DartIdentifier newName) {
        this.name = this.becomeParentOf(newName);
    }

    @Override
    public void setSymbol(Symbol symbol) {
        this.symbol = (MethodElement)symbol;
    }

    @Override
    public void traverse(DartVisitor v, DartContext ctx) {
        if (v.visit(this, ctx)) {
            this.function = (DartFunction)this.becomeParentOf((DartNode)v.accept(this.function));
        }
        v.endVisit(this, ctx);
    }

    @Override
    public void visitChildren(DartPlainVisitor<?> visitor) {
        this.function.accept(visitor);
    }

    @Override
    public <R> R accept(DartPlainVisitor<R> visitor) {
        return visitor.visitFunctionExpression(this);
    }
}

