/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.internal.com.google.dart.compiler.ast;

import java.util.List;
import org.jetbrains.jet.internal.com.google.dart.compiler.ast.DartContext;
import org.jetbrains.jet.internal.com.google.dart.compiler.ast.DartDeclaration;
import org.jetbrains.jet.internal.com.google.dart.compiler.ast.DartField;
import org.jetbrains.jet.internal.com.google.dart.compiler.ast.DartFieldDefinition;
import org.jetbrains.jet.internal.com.google.dart.compiler.ast.DartIdentifier;
import org.jetbrains.jet.internal.com.google.dart.compiler.ast.DartMethodDefinition;
import org.jetbrains.jet.internal.com.google.dart.compiler.ast.DartNode;
import org.jetbrains.jet.internal.com.google.dart.compiler.ast.DartParameterizedTypeNode;
import org.jetbrains.jet.internal.com.google.dart.compiler.ast.DartPlainVisitor;
import org.jetbrains.jet.internal.com.google.dart.compiler.ast.DartStringLiteral;
import org.jetbrains.jet.internal.com.google.dart.compiler.ast.DartTypeNode;
import org.jetbrains.jet.internal.com.google.dart.compiler.ast.DartTypeParameter;
import org.jetbrains.jet.internal.com.google.dart.compiler.ast.DartVisitor;
import org.jetbrains.jet.internal.com.google.dart.compiler.ast.Modifiers;
import org.jetbrains.jet.internal.com.google.dart.compiler.common.HasSymbol;
import org.jetbrains.jet.internal.com.google.dart.compiler.common.Symbol;
import org.jetbrains.jet.internal.com.google.dart.compiler.resolver.ClassElement;

public class DartClass
extends DartDeclaration<DartIdentifier>
implements HasSymbol {
    private ClassElement element;
    private DartTypeNode superclass;
    private final List<DartNode> members;
    private final List<DartTypeParameter> typeParameters;
    private final List<DartTypeNode> interfaces;
    private boolean isInterface;
    private DartParameterizedTypeNode defaultClass;
    private final Modifiers modifiers;
    private int hash = -1;
    private final DartStringLiteral nativeName;

    public DartClass(DartIdentifier name, DartStringLiteral nativeName, DartTypeNode superclass, List<DartTypeNode> interfaces, List<DartNode> members, List<DartTypeParameter> typeParameters, Modifiers modifiers) {
        this(name, nativeName, superclass, interfaces, members, typeParameters, null, false, modifiers);
    }

    public DartClass(DartIdentifier name, DartTypeNode superclass, List<DartTypeNode> interfaces, List<DartNode> members, List<DartTypeParameter> typeParameters, DartParameterizedTypeNode defaultClass) {
        this(name, null, superclass, interfaces, members, typeParameters, defaultClass, true, Modifiers.NONE);
    }

    void setHash(int hash) {
        this.hash = hash;
    }

    public DartClass(DartIdentifier name, DartStringLiteral nativeName, DartTypeNode superclass, List<DartTypeNode> interfaces, List<DartNode> members, List<DartTypeParameter> typeParameters, DartParameterizedTypeNode defaultClass, boolean isInterface, Modifiers modifiers) {
        super(name);
        this.nativeName = nativeName;
        this.superclass = this.becomeParentOf(superclass);
        this.members = this.becomeParentOf(members);
        this.typeParameters = this.becomeParentOf(typeParameters);
        this.interfaces = this.becomeParentOf(interfaces);
        this.defaultClass = this.becomeParentOf(defaultClass);
        this.isInterface = isInterface;
        this.modifiers = modifiers;
    }

    public boolean isInterface() {
        return this.isInterface;
    }

    public Modifiers getModifiers() {
        return this.modifiers;
    }

    public boolean isAbstract() {
        if (this.modifiers.isAbstract()) {
            return true;
        }
        for (DartNode node : this.members) {
            DartMethodDefinition methodDefinition;
            if (node instanceof DartMethodDefinition && (methodDefinition = (DartMethodDefinition)node).getModifiers().isAbstract()) {
                return true;
            }
            if (!(node instanceof DartFieldDefinition)) continue;
            DartFieldDefinition fieldDefinition = (DartFieldDefinition)node;
            for (DartField field : fieldDefinition.getFields()) {
                if (!field.getModifiers().isAbstract()) continue;
                return true;
            }
        }
        return false;
    }

    public List<DartNode> getMembers() {
        return this.members;
    }

    public List<DartTypeParameter> getTypeParameters() {
        return this.typeParameters;
    }

    public List<DartTypeNode> getInterfaces() {
        return this.interfaces;
    }

    public String getClassName() {
        if (this.getName() == null) {
            return null;
        }
        return ((DartIdentifier)this.getName()).getTargetName();
    }

    public DartTypeNode getSuperclass() {
        return this.superclass;
    }

    public DartParameterizedTypeNode getDefaultClass() {
        return this.defaultClass;
    }

    public Symbol getDefaultSymbol() {
        if (this.defaultClass != null) {
            return this.defaultClass.getType().getElement();
        }
        return null;
    }

    public Symbol getSuperSymbol() {
        if (this.superclass != null) {
            return this.superclass.getType().getElement();
        }
        return null;
    }

    @Override
    public ClassElement getSymbol() {
        return this.element;
    }

    public void setDefaultClass(DartParameterizedTypeNode newName) {
        this.defaultClass = this.becomeParentOf(newName);
    }

    public void setSuperclass(DartTypeNode newName) {
        this.superclass = this.becomeParentOf(newName);
    }

    @Override
    public void setSymbol(Symbol symbol) {
        this.element = (ClassElement)symbol;
    }

    public DartStringLiteral getNativeName() {
        return this.nativeName;
    }

    @Override
    public void traverse(DartVisitor v, DartContext ctx) {
        if (v.visit(this, ctx)) {
            if (this.superclass != null) {
                this.superclass = (DartTypeNode)this.becomeParentOf((DartNode)v.accept(this.superclass));
            }
            v.acceptWithInsertRemove(this, this.getMembers());
            if (this.getTypeParameters() != null) {
                v.acceptWithInsertRemove(this, this.getTypeParameters());
            }
            if (this.getInterfaces() != null) {
                v.acceptWithInsertRemove(this, this.getInterfaces());
            }
            if (this.defaultClass != null) {
                this.defaultClass = (DartParameterizedTypeNode)this.becomeParentOf((DartNode)v.accept(this.defaultClass));
            }
        }
        v.endVisit(this, ctx);
    }

    @Override
    public void visitChildren(DartPlainVisitor<?> visitor) {
        visitor.visit(this.typeParameters);
        if (this.superclass != null) {
            this.superclass.accept(visitor);
        }
        visitor.visit(this.interfaces);
        if (this.defaultClass != null) {
            this.defaultClass.accept(visitor);
        }
        visitor.visit(this.members);
    }

    @Override
    public <R> R accept(DartPlainVisitor<R> visitor) {
        return visitor.visitClass(this);
    }

    @Override
    public int computeHash() {
        if (this.hash == -1) {
            this.hash = super.computeHash();
        }
        return this.hash;
    }
}

