/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.internal.com.google.dart.compiler.ast;

import org.jetbrains.jet.internal.com.google.dart.compiler.ast.DartContext;
import org.jetbrains.jet.internal.com.google.dart.compiler.ast.DartExpression;
import org.jetbrains.jet.internal.com.google.dart.compiler.ast.DartNode;
import org.jetbrains.jet.internal.com.google.dart.compiler.ast.DartPlainVisitor;
import org.jetbrains.jet.internal.com.google.dart.compiler.ast.DartSyntheticErrorExpression;
import org.jetbrains.jet.internal.com.google.dart.compiler.ast.DartVisitor;
import org.jetbrains.jet.internal.com.google.dart.compiler.ast.ElementReference;
import org.jetbrains.jet.internal.com.google.dart.compiler.parser.Token;
import org.jetbrains.jet.internal.com.google.dart.compiler.resolver.Element;

public class DartBinaryExpression
extends DartExpression
implements ElementReference {
    private final Token op;
    private DartExpression arg1;
    private DartExpression arg2;
    private DartExpression normalizedNode = this;
    private Element referencedElement;

    public DartBinaryExpression(Token op, DartExpression arg1, DartExpression arg2) {
        assert (op.isBinaryOperator()) : op;
        this.op = op;
        this.arg1 = this.becomeParentOf(arg1 != null ? arg1 : new DartSyntheticErrorExpression());
        this.arg2 = this.becomeParentOf(arg2 != null ? arg2 : new DartSyntheticErrorExpression());
    }

    public DartExpression getArg1() {
        return this.arg1;
    }

    public DartExpression getArg2() {
        return this.arg2;
    }

    public Token getOperator() {
        return this.op;
    }

    public void setNormalizedNode(DartExpression normalizedNode) {
        normalizedNode.setSourceInfo(this);
        this.normalizedNode = normalizedNode;
    }

    @Override
    public DartExpression getNormalizedNode() {
        return this.normalizedNode;
    }

    @Override
    public void traverse(DartVisitor v, DartContext ctx) {
        if (v.visit(this, ctx)) {
            this.arg1 = this.op.isAssignmentOperator() ? this.becomeParentOf(v.acceptLvalue(this.arg1)) : (DartExpression)this.becomeParentOf((DartNode)v.accept(this.arg1));
            this.arg2 = (DartExpression)this.becomeParentOf((DartNode)v.accept(this.arg2));
        }
        v.endVisit(this, ctx);
    }

    @Override
    public void visitChildren(DartPlainVisitor<?> visitor) {
        this.arg1.accept(visitor);
        this.arg2.accept(visitor);
    }

    @Override
    public <R> R accept(DartPlainVisitor<R> visitor) {
        return visitor.visitBinaryExpression(this);
    }

    @Override
    public Element getReferencedElement() {
        return this.referencedElement;
    }

    @Override
    public void setReferencedElement(Element referencedElement) {
        this.referencedElement = referencedElement;
    }
}

