/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.internal.com.google.dart.compiler.ast;

import java.math.BigInteger;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.jet.internal.com.google.dart.compiler.CommandLineOptions;
import org.jetbrains.jet.internal.com.google.dart.compiler.CompilerConfiguration;
import org.jetbrains.jet.internal.com.google.dart.compiler.ast.DartBlock;
import org.jetbrains.jet.internal.com.google.dart.compiler.ast.DartCase;
import org.jetbrains.jet.internal.com.google.dart.compiler.ast.DartCatchBlock;
import org.jetbrains.jet.internal.com.google.dart.compiler.ast.DartContext;
import org.jetbrains.jet.internal.com.google.dart.compiler.ast.DartDefault;
import org.jetbrains.jet.internal.com.google.dart.compiler.ast.DartDoWhileStatement;
import org.jetbrains.jet.internal.com.google.dart.compiler.ast.DartExprStmt;
import org.jetbrains.jet.internal.com.google.dart.compiler.ast.DartExpression;
import org.jetbrains.jet.internal.com.google.dart.compiler.ast.DartForInStatement;
import org.jetbrains.jet.internal.com.google.dart.compiler.ast.DartForStatement;
import org.jetbrains.jet.internal.com.google.dart.compiler.ast.DartFunction;
import org.jetbrains.jet.internal.com.google.dart.compiler.ast.DartIdentifier;
import org.jetbrains.jet.internal.com.google.dart.compiler.ast.DartIfStatement;
import org.jetbrains.jet.internal.com.google.dart.compiler.ast.DartIntegerLiteral;
import org.jetbrains.jet.internal.com.google.dart.compiler.ast.DartMethodDefinition;
import org.jetbrains.jet.internal.com.google.dart.compiler.ast.DartModVisitor;
import org.jetbrains.jet.internal.com.google.dart.compiler.ast.DartNode;
import org.jetbrains.jet.internal.com.google.dart.compiler.ast.DartStatement;
import org.jetbrains.jet.internal.com.google.dart.compiler.ast.DartStringLiteral;
import org.jetbrains.jet.internal.com.google.dart.compiler.ast.DartSwitchMember;
import org.jetbrains.jet.internal.com.google.dart.compiler.ast.DartSwitchStatement;
import org.jetbrains.jet.internal.com.google.dart.compiler.ast.DartTryStatement;
import org.jetbrains.jet.internal.com.google.dart.compiler.ast.DartUnit;
import org.jetbrains.jet.internal.com.google.dart.compiler.ast.DartUnqualifiedInvocation;
import org.jetbrains.jet.internal.com.google.dart.compiler.ast.DartWhileStatement;
import org.jetbrains.jet.internal.com.google.dart.compiler.ast.LibraryUnit;
import org.jetbrains.jet.internal.com.google.dart.compiler.common.SourceInfo;

public class CoverageInstrumenter {
    private List<BaseInstrumenter> instrumenters;
    private static final String[] ignoredLibs = new String[]{"corelib", "corelib_impl", "dom", "html", "htmlimpl", "base", "touch", "view", "utilslib", "observable", "layout.dart", "unittest", "dartest"};

    private CoverageInstrumenter() {
    }

    public static CoverageInstrumenter createInstance(CompilerConfiguration config) {
        CommandLineOptions.CompilerOptions compilerOptions = config.getCompilerOptions();
        String coverageTypes = compilerOptions.getCoverageType();
        CoverageInstrumenter instr = new CoverageInstrumenter();
        if (!"".equals(coverageTypes)) {
            String outDir = compilerOptions.getWorkDirectory().getAbsolutePath();
            instr.createInstrumenters(coverageTypes, outDir);
        }
        return instr;
    }

    public void process(Map<URI, LibraryUnit> libraries) {
        if (this.instrumenters == null) {
            return;
        }
        for (LibraryUnit lib : libraries.values()) {
            for (DartUnit unit : lib.getUnits()) {
                this.exec(unit);
            }
        }
        for (LibraryUnit lib : libraries.values()) {
            for (DartUnit unit : lib.getUnits()) {
                this.init(unit);
            }
        }
    }

    private void exec(DartUnit unit) {
        if (this.isIgnored(unit)) {
            return;
        }
        System.out.println("Instrumenting " + unit.getSourceName() + ", lib:" + unit.getLibrary().getName());
        for (BaseInstrumenter instrumenter : this.instrumenters) {
            instrumenter.accept(unit);
        }
    }

    private boolean isIgnored(DartUnit unit) {
        LibraryUnit lu = unit.getLibrary();
        if (lu != null) {
            String libName = lu.getName();
            for (String ignoredLib : ignoredLibs) {
                if (!ignoredLib.equals(libName)) continue;
                return true;
            }
        }
        return false;
    }

    private void init(DartUnit unit) {
        if (this.isIgnored(unit)) {
            return;
        }
        new TotalSettingInstrumenter().accept(unit);
    }

    private void createInstrumenters(String coverageTypes, String outDir) {
        BaseInstrumenter.setOutDir(outDir);
        this.instrumenters = new ArrayList<BaseInstrumenter>();
        if (coverageTypes.length() > 0) {
            for (String covType : coverageTypes.split(",")) {
                if ("all".equals(covType)) {
                    this.instrumenters.add(new StatementInstrumenter());
                    this.instrumenters.add(new FunctionInstrumenter());
                    this.instrumenters.add(new BranchInstrumenter());
                }
                if ("statement".equals(covType)) {
                    this.instrumenters.add(new StatementInstrumenter());
                }
                if ("function".equals(covType)) {
                    this.instrumenters.add(new FunctionInstrumenter());
                }
                if (!"branch".equals(covType)) continue;
                this.instrumenters.add(new BranchInstrumenter());
            }
        }
    }

    private class BranchInstrumenter
    extends BaseInstrumenter {
        private int numBranches;

        private BranchInstrumenter() {
        }

        @Override
        public boolean visit(DartUnit x, DartContext ctx) {
            this.numBranches = 0;
            return super.visit(x, ctx);
        }

        @Override
        public void endVisit(DartUnit x, DartContext ctx) {
            numBranchesMap.put(this.currentUnit.getSourceName(), this.numBranches);
            super.endVisit(x, ctx);
        }

        @Override
        public void endVisit(DartIfStatement x, DartContext ctx) {
            DartIfStatement newIfStmt;
            DartStatement thenStmt = x.getThenStatement();
            DartStatement elseStmt = x.getElseStatement();
            List<DartStatement> newThen = this.doCallCoverBranch(thenStmt);
            ++this.numBranches;
            if (thenStmt instanceof DartBlock) {
                List<DartStatement> stmts = ((DartBlock)thenStmt).getStatements();
                if (stmts != null) {
                    newThen.addAll(stmts);
                }
            } else {
                newThen.add(thenStmt);
            }
            if (elseStmt instanceof DartIfStatement) {
                newIfStmt = new DartIfStatement(x.getCondition(), new DartBlock(newThen), elseStmt);
            } else {
                List<DartStatement> newElse;
                if (elseStmt != null) {
                    newElse = this.doCallCoverBranch(elseStmt);
                    if (elseStmt instanceof DartBlock) {
                        List<DartStatement> stmts = ((DartBlock)elseStmt).getStatements();
                        if (stmts != null) {
                            newElse.addAll(stmts);
                        }
                    } else {
                        newElse.add(elseStmt);
                    }
                } else {
                    newElse = this.doCallCoverBranch(x);
                }
                newIfStmt = new DartIfStatement(x.getCondition(), new DartBlock(newThen), new DartBlock(newElse));
                ++this.numBranches;
            }
            newIfStmt.setSourceInfo(x.getSourceInfo());
            ctx.replaceMe(newIfStmt);
            super.endVisit(x, ctx);
        }

        @Override
        public void endVisit(DartSwitchStatement x, DartContext ctx) {
            ArrayList<DartSwitchMember> newSwitchMembers = new ArrayList<DartSwitchMember>();
            boolean hasDefault = false;
            for (DartSwitchMember swMember : x.getMembers()) {
                DartSwitchMember newMember;
                List<DartStatement> stmts = this.doCallCoverBranch(swMember);
                List<DartStatement> oldStmts = swMember.getStatements();
                if (oldStmts == null || oldStmts.size() == 0) {
                    newSwitchMembers.add(swMember);
                    continue;
                }
                stmts.addAll(oldStmts);
                assert (swMember instanceof DartCase || swMember instanceof DartDefault);
                if (swMember instanceof DartCase) {
                    newMember = new DartCase(((DartCase)swMember).getExpr(), swMember.getLabel(), stmts);
                } else {
                    hasDefault = true;
                    newMember = new DartDefault(swMember.getLabel(), stmts);
                }
                this.setInstrumentedSourceInfo(newMember, swMember);
                newSwitchMembers.add(newMember);
                ++this.numBranches;
            }
            if (!hasDefault) {
                List<DartStatement> statements = this.doCallCoverBranch(x);
                DartDefault defaultMember = new DartDefault(null, statements);
                newSwitchMembers.add(defaultMember);
                ++this.numBranches;
            }
            DartSwitchStatement newSwitch = new DartSwitchStatement(x.getExpression(), newSwitchMembers);
            newSwitch.setSourceInfo(x.getSourceInfo());
            ctx.replaceMe(newSwitch);
            super.visit(x, ctx);
        }

        @Override
        public void endVisit(DartTryStatement x, DartContext ctx) {
            List<DartStatement> finallyStmts;
            DartBlock tryBlock = x.getTryBlock();
            DartBlock finallyBlock = x.getFinallyBlock();
            List<DartCatchBlock> catchBlocks = x.getCatchBlocks();
            List<DartStatement> tryStmts = this.doCallCoverBranch(tryBlock);
            if (tryBlock != null && tryBlock.getStatements() != null) {
                tryStmts.addAll(tryBlock.getStatements());
            }
            DartBlock newTryBlock = new DartBlock(tryStmts);
            this.setInstrumentedSourceInfo(newTryBlock, tryBlock.getSourceInfo());
            ++this.numBranches;
            ArrayList<DartCatchBlock> newCatchBlocks = null;
            if (catchBlocks != null) {
                newCatchBlocks = new ArrayList<DartCatchBlock>();
                for (DartCatchBlock cBlock : catchBlocks) {
                    DartBlock oldBlock = cBlock.getBlock();
                    List<DartStatement> cBlockStmts = this.doCallCoverBranch(cBlock);
                    if (oldBlock != null && oldBlock.getStatements() != null) {
                        cBlockStmts.addAll(oldBlock.getStatements());
                    }
                    DartBlock newBlock = new DartBlock(cBlockStmts);
                    this.setInstrumentedSourceInfo(newBlock, oldBlock.getSourceInfo());
                    DartCatchBlock newCatchBlock = new DartCatchBlock(newBlock, cBlock.getException(), cBlock.getStackTrace());
                    this.setInstrumentedSourceInfo(newCatchBlock, cBlock.getSourceInfo());
                    newCatchBlocks.add(newCatchBlock);
                    ++this.numBranches;
                }
            }
            DartBlock newFinallyBlock = null;
            if (finallyBlock != null) {
                finallyStmts = this.doCallCoverBranch(finallyBlock);
                if (finallyBlock.getStatements() != null) {
                    finallyStmts.addAll(finallyBlock.getStatements());
                }
                newFinallyBlock = new DartBlock(finallyStmts);
                this.setInstrumentedSourceInfo(newFinallyBlock, finallyBlock.getSourceInfo());
            } else {
                finallyStmts = this.doCallCoverBranch(x);
                newFinallyBlock = new DartBlock(finallyStmts);
                this.setInstrumentedSourceInfo(newFinallyBlock, x.getSourceInfo());
            }
            ++this.numBranches;
            DartTryStatement newTry = new DartTryStatement(tryBlock, newCatchBlocks, newFinallyBlock);
            ctx.replaceMe(newTry);
            super.endVisit(x, ctx);
        }

        @Override
        public void endVisit(DartBlock x, DartContext ctx) {
            ArrayList<DartStatement> blockStmts = new ArrayList<DartStatement>();
            for (DartStatement stmt : x.getStatements()) {
                DartBlock body;
                if (stmt instanceof DartForInStatement) {
                    this.doLoopBefore(stmt, blockStmts);
                    DartForInStatement oldForIn = (DartForInStatement)stmt;
                    DartStatement setup = null;
                    setup = oldForIn.introducesVariable() ? oldForIn.getVariableStatement() : new DartExprStmt(oldForIn.getIdentifier());
                    DartBlock body2 = this.doLoopInside(stmt, oldForIn.getBody());
                    DartForInStatement newForIn = new DartForInStatement(setup, oldForIn.getIterable(), body2);
                    this.setInstrumentedSourceInfo(newForIn, oldForIn.getSourceInfo());
                    this.doLoopAfter(stmt, blockStmts);
                    this.numBranches += 2;
                    continue;
                }
                if (stmt instanceof DartForStatement) {
                    this.doLoopBefore(stmt, blockStmts);
                    DartForStatement oldFor = (DartForStatement)stmt;
                    body = this.doLoopInside(stmt, oldFor.getBody());
                    DartForStatement newFor = new DartForStatement(oldFor.getInit(), oldFor.getCondition(), oldFor.getIncrement(), body);
                    this.setInstrumentedSourceInfo(newFor, oldFor.getSourceInfo());
                    this.doLoopAfter(stmt, blockStmts);
                    this.numBranches += 2;
                    continue;
                }
                if (stmt instanceof DartWhileStatement) {
                    this.doLoopBefore(stmt, blockStmts);
                    DartWhileStatement oldWhile = (DartWhileStatement)stmt;
                    body = this.doLoopInside(stmt, oldWhile.getBody());
                    DartWhileStatement newWhile = new DartWhileStatement(oldWhile.getCondition(), body);
                    this.setInstrumentedSourceInfo(newWhile, oldWhile.getSourceInfo());
                    this.doLoopAfter(stmt, blockStmts);
                    this.numBranches += 2;
                    continue;
                }
                if (stmt instanceof DartDoWhileStatement) {
                    this.doLoopBefore(stmt, blockStmts);
                    DartDoWhileStatement oldDoWhile = (DartDoWhileStatement)stmt;
                    body = this.doLoopInside(stmt, oldDoWhile.getBody());
                    DartDoWhileStatement newDoWhile = new DartDoWhileStatement(oldDoWhile.getCondition(), body);
                    this.setInstrumentedSourceInfo(newDoWhile, oldDoWhile.getSourceInfo());
                    this.doLoopAfter(stmt, blockStmts);
                    this.numBranches += 2;
                    continue;
                }
                blockStmts.add(stmt);
            }
            super.visit(x, ctx);
        }

        private List<DartStatement> doCallCoverBranch(DartNode blockNode) {
            ArrayList<DartStatement> newBlockStmts = new ArrayList<DartStatement>();
            List<DartExpression> covArgs = this.makeCoverageArgs(blockNode);
            DartExprStmt callCoverBranch = this.createFunctionCall("coverBranch", covArgs, blockNode);
            newBlockStmts.add(callCoverBranch);
            this.setInstrumentedSourceInfo(callCoverBranch, blockNode.getSourceInfo());
            return newBlockStmts;
        }

        private void doLoopBefore(DartNode loopNode, List<DartStatement> stmts) {
            List<DartExpression> args = this.makeCoverageArgs(loopNode);
            DartExprStmt callLoopBefore = this.createFunctionCall("loopBranchBefore", args, loopNode);
            stmts.add(callLoopBefore);
        }

        private void doLoopAfter(DartNode loopNode, List<DartStatement> stmts) {
            List<DartExpression> args = this.makeCoverageArgs(loopNode);
            args.add(DartIntegerLiteral.get(BigInteger.valueOf(loopNode.getSourceStart() + loopNode.getSourceLength())));
            DartExprStmt callLoopAfter = this.createFunctionCall("coverLoopBranch", args, loopNode);
            stmts.add(callLoopAfter);
        }

        private DartBlock doLoopInside(DartNode loopNode, DartStatement body) {
            ArrayList<DartStatement> newBlockStmts = new ArrayList<DartStatement>();
            List<DartExpression> covArgs = this.makeCoverageArgs(loopNode);
            DartExprStmt callCoverBranch = this.createFunctionCall("loopBranchInside", covArgs, loopNode);
            newBlockStmts.add(callCoverBranch);
            this.setInstrumentedSourceInfo(callCoverBranch, loopNode.getSourceInfo());
            if (body instanceof DartBlock) {
                newBlockStmts.addAll(((DartBlock)body).getStatements());
            } else {
                newBlockStmts.add(body);
            }
            return new DartBlock(newBlockStmts);
        }

        private List<DartExpression> makeCoverageArgs(DartNode blockNode) {
            ArrayList<DartExpression> covArgs = new ArrayList<DartExpression>();
            covArgs.add(DartStringLiteral.get(this.currentUnit.getSourceName()));
            covArgs.add(DartIntegerLiteral.get(BigInteger.valueOf(blockNode.getSourceLine())));
            covArgs.add(DartIntegerLiteral.get(BigInteger.valueOf(blockNode.getSourceStart())));
            return covArgs;
        }
    }

    private class StatementInstrumenter
    extends BaseInstrumenter {
        private int numStatements;

        private StatementInstrumenter() {
        }

        @Override
        public boolean visit(DartUnit x, DartContext ctx) {
            this.numStatements = 0;
            return super.visit(x, ctx);
        }

        @Override
        public void endVisit(DartUnit x, DartContext ctx) {
            numStatementsMap.put(this.currentUnit.getSourceName(), this.numStatements);
            super.endVisit(x, ctx);
        }

        @Override
        public boolean visit(DartBlock x, DartContext ctx) {
            ArrayList<DartStatement> newStmts = new ArrayList<DartStatement>();
            for (DartStatement stmt : x.getStatements()) {
                if (!stmt.isInstrumentedNode()) {
                    ArrayList<DartExpression> covArgs = new ArrayList<DartExpression>();
                    covArgs.add(DartStringLiteral.get(this.currentUnit.getSourceName()));
                    covArgs.add(DartIntegerLiteral.get(BigInteger.valueOf(stmt.getSourceLine())));
                    DartExprStmt callCoverStmt = this.createFunctionCall("coverStatement", covArgs, stmt);
                    newStmts.add(callCoverStmt);
                }
                newStmts.add(stmt);
                ++this.numStatements;
            }
            DartBlock newBlock = new DartBlock(newStmts);
            ctx.replaceMe(newBlock);
            return super.visit(x, ctx);
        }
    }

    private class FunctionInstrumenter
    extends BaseInstrumenter {
        private int numFunctions;

        private FunctionInstrumenter() {
        }

        @Override
        public boolean visit(DartFunction x, DartContext ctx) {
            DartNode parent = x.getParent();
            if (parent instanceof DartMethodDefinition) {
                String funcName = ((DartNode)((DartMethodDefinition)parent).getName()).toString();
                DartBlock oldBody = x.getBody();
                ArrayList<DartExpression> covArgs = new ArrayList<DartExpression>();
                covArgs.add(DartStringLiteral.get(this.currentUnit.getSourceName()));
                covArgs.add(DartStringLiteral.get(funcName));
                DartExprStmt callCovFunc = this.createFunctionCall("coverFunction", covArgs, oldBody);
                DartBlock newFnBody = this.prependToFnBody(oldBody, callCovFunc);
                this.replaceFunction(ctx, x, newFnBody);
                ++this.numFunctions;
            }
            return super.visit(x, ctx);
        }

        @Override
        public boolean visit(DartUnit x, DartContext ctx) {
            this.numFunctions = 0;
            return super.visit(x, ctx);
        }

        @Override
        public void endVisit(DartUnit x, DartContext ctx) {
            numFunctionsMap.put(this.currentUnit.getSourceName(), this.numFunctions);
            super.endVisit(x, ctx);
        }
    }

    private class TotalSettingInstrumenter
    extends BaseInstrumenter {
        private TotalSettingInstrumenter() {
        }

        @Override
        public boolean visit(DartFunction x, DartContext ctx) {
            String funcName;
            DartNode parent = x.getParent();
            if (parent instanceof DartMethodDefinition && "main".equals(funcName = ((DartNode)((DartMethodDefinition)parent).getName()).toString())) {
                DartBlock newFnBody = x.getBody();
                for (String unitName : unitsVisited) {
                    int numFunctions = this.nullCheckingUnBox((Integer)numFunctionsMap.get(unitName));
                    int numStatements = this.nullCheckingUnBox((Integer)numStatementsMap.get(unitName));
                    int numBranches = this.nullCheckingUnBox((Integer)numBranchesMap.get(unitName));
                    ArrayList<DartExpression> args = new ArrayList<DartExpression>();
                    args.add(DartStringLiteral.get(unitName));
                    args.add(DartIntegerLiteral.get(BigInteger.valueOf(numFunctions)));
                    args.add(DartIntegerLiteral.get(BigInteger.valueOf(numStatements)));
                    args.add(DartIntegerLiteral.get(BigInteger.valueOf(numBranches)));
                    DartExprStmt callCovTotals = this.createFunctionCall("setCoverageTotals", args, newFnBody);
                    callCovTotals.setInstrumentedNode(true);
                    newFnBody = this.prependToFnBody(newFnBody, callCovTotals);
                }
                this.replaceFunction(ctx, x, newFnBody);
            }
            return super.visit(x, ctx);
        }

        int nullCheckingUnBox(Integer value) {
            int ret = 0;
            if (value != null) {
                ret = value;
            }
            return ret;
        }
    }

    private static class BaseInstrumenter
    extends DartModVisitor {
        private static String outputDir;
        protected DartUnit currentUnit;
        protected static Set<String> unitsVisited;
        protected static Map<String, Integer> numFunctionsMap;
        protected static Map<String, Integer> numStatementsMap;
        protected static Map<String, Integer> numBranchesMap;

        private BaseInstrumenter() {
        }

        public static void setOutDir(String outDir) {
            outputDir = outDir;
        }

        @Override
        public boolean visit(DartUnit x, DartContext ctx) {
            this.currentUnit = x;
            unitsVisited.add(x.getSourceName());
            return super.visit(x, ctx);
        }

        protected DartBlock prependToFnBody(DartBlock oldBody, DartExprStmt functionStmt) {
            List<DartStatement> stmts;
            ArrayList<DartStatement> blockStmts = new ArrayList<DartStatement>();
            blockStmts.add(functionStmt);
            if (oldBody != null && (stmts = oldBody.getStatements()) != null) {
                blockStmts.addAll(stmts);
            }
            DartBlock newDB = new DartBlock(blockStmts);
            if (oldBody != null) {
                newDB.setSourceInfo(oldBody.getSourceInfo());
            }
            return newDB;
        }

        protected void replaceFunction(DartContext ctx, DartFunction x, DartBlock newFnBody) {
            DartFunction newFn = new DartFunction(x.getParams(), newFnBody, x.getReturnTypeNode());
            newFn.setSourceInfo(x.getSourceInfo());
            ctx.replaceMe(newFn);
        }

        protected DartExprStmt createFunctionCall(String functionName, List<DartExpression> args, DartNode oldNode) {
            DartIdentifier funcName = new DartIdentifier(functionName);
            DartUnqualifiedInvocation funcInvocation = new DartUnqualifiedInvocation(funcName, args);
            DartExprStmt functionStmt = new DartExprStmt(funcInvocation);
            if (oldNode != null) {
                SourceInfo sourceInfo = oldNode.getSourceInfo();
                this.setInstrumentedSourceInfo(functionStmt, sourceInfo);
                this.setInstrumentedSourceInfo(funcInvocation, sourceInfo);
                this.setInstrumentedSourceInfo(funcName, sourceInfo);
                for (DartExpression arg : args) {
                    this.setInstrumentedSourceInfo(arg, sourceInfo);
                }
            }
            return functionStmt;
        }

        void setInstrumentedSourceInfo(DartNode node, SourceInfo info) {
            node.setInstrumentedNode(true);
            node.setSourceInfo(info);
        }

        static {
            unitsVisited = new HashSet<String>();
            numFunctionsMap = new HashMap<String, Integer>();
            numStatementsMap = new HashMap<String, Integer>();
            numBranchesMap = new HashMap<String, Integer>();
        }
    }
}

