/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.internal.com.google.dart.compiler;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.JarURLConnection;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.jar.JarEntry;
import org.jetbrains.jet.internal.com.google.dart.compiler.Source;
import org.jetbrains.jet.internal.com.google.dart.compiler.SystemLibraryManager;

public abstract class UrlSource
implements Source {
    private static final URI CURRENT_DIR = new File(".").toURI().normalize();
    private static final Charset UTF8 = Charset.forName("UTF8");
    private static final URI BASE_URI = CURRENT_DIR;
    private final URI uri;
    private final URI absoluteUri;
    private final URI translatedUri;
    private final boolean shouldCareAboutLastModified;
    private volatile boolean exists = false;
    private volatile long lastModified = -1L;
    private volatile boolean propertiesInitialized = false;
    private volatile File sourceFile = null;
    private volatile JarURLConnection jarConn = null;
    protected final SystemLibraryManager systemLibraryManager;

    protected UrlSource(URI uri) {
        this(uri, null);
    }

    protected UrlSource(URI uri, SystemLibraryManager slm) {
        URI expanded;
        URI uRI = expanded = slm != null ? slm.expandRelativeDartUri(uri) : uri;
        if (expanded == null) {
            expanded = uri;
        }
        this.uri = BASE_URI.relativize(expanded.normalize());
        this.absoluteUri = BASE_URI.resolve(expanded);
        this.systemLibraryManager = slm;
        if (SystemLibraryManager.isDartUri(this.uri)) {
            assert (slm != null);
            this.shouldCareAboutLastModified = false;
            this.translatedUri = slm.resolveDartUri(this.absoluteUri);
        } else {
            this.shouldCareAboutLastModified = true;
            this.translatedUri = this.absoluteUri;
        }
    }

    protected UrlSource(File file) {
        URL url;
        URI uri = file.toURI().normalize();
        if (!file.exists() && (url = this.getClass().getClassLoader().getResource(file.getPath())) != null) {
            uri = URI.create(url.toString());
        }
        this.uri = BASE_URI.relativize(uri);
        this.translatedUri = this.absoluteUri = BASE_URI.resolve(uri);
        this.systemLibraryManager = null;
        this.shouldCareAboutLastModified = true;
    }

    @Override
    public boolean exists() {
        this.initProperties();
        return this.exists;
    }

    @Override
    public long getLastModified() {
        this.initProperties();
        return this.lastModified;
    }

    @Override
    public Reader getSourceReader() throws IOException {
        InputStream stream;
        this.initProperties();
        if (this.sourceFile != null) {
            return new FileReader(this.sourceFile);
        }
        if (this.jarConn != null) {
            return new InputStreamReader(this.jarConn.getInputStream());
        }
        if (this.translatedUri != null && (stream = this.translatedUri.toURL().openStream()) != null) {
            return new InputStreamReader(stream, UTF8);
        }
        throw new FileNotFoundException(this.getName());
    }

    @Override
    public URI getUri() {
        return this.uri;
    }

    protected URI getAbsoluteUri() {
        return this.absoluteUri;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initProperties() {
        if (!this.propertiesInitialized) {
            UrlSource urlSource = this;
            synchronized (urlSource) {
                block13: {
                    if (!this.propertiesInitialized) {
                        try {
                            URI resolvedUri = BASE_URI.resolve(this.uri);
                            String scheme = resolvedUri.getScheme();
                            if (scheme == null || "file".equals(scheme)) {
                                File file = new File(resolvedUri);
                                this.lastModified = file.lastModified();
                                this.exists = file.exists();
                                this.sourceFile = file;
                                break block13;
                            }
                            try {
                                URL url = this.translatedUri.toURL();
                                if ("jar".equals(url.getProtocol())) {
                                    this.getJarEntryProperties(url);
                                } else {
                                    this.lastModified = 0L;
                                    this.exists = true;
                                }
                            }
                            catch (MalformedURLException e) {
                                this.propertiesInitialized = true;
                                return;
                            }
                        }
                        finally {
                            this.propertiesInitialized = true;
                        }
                    }
                }
            }
        }
    }

    private void getJarEntryProperties(URL url) {
        try {
            this.jarConn = (JarURLConnection)url.openConnection();
            this.jarConn.setUseCaches(true);
            JarEntry jarEntry = this.jarConn.getJarEntry();
            if (jarEntry != null) {
                this.exists = true;
                if (!this.shouldCareAboutLastModified) {
                    this.lastModified = 0L;
                    return;
                }
                this.lastModified = jarEntry.getTime();
            }
            if (!this.exists) {
                this.lastModified = -1L;
                return;
            }
        }
        catch (IOException e) {
            this.exists = false;
            this.lastModified = -1L;
        }
    }
}

