/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.internal.com.google.dart.compiler;

import java.io.File;
import java.net.URI;
import java.net.URISyntaxException;
import org.jetbrains.jet.internal.com.google.dart.compiler.DartSource;
import org.jetbrains.jet.internal.com.google.dart.compiler.LibrarySource;
import org.jetbrains.jet.internal.com.google.dart.compiler.SystemLibraryManager;
import org.jetbrains.jet.internal.com.google.dart.compiler.UrlDartSource;
import org.jetbrains.jet.internal.com.google.dart.compiler.UrlSource;

public class UrlLibrarySource
extends UrlSource
implements LibrarySource {
    public UrlLibrarySource(URI uri, SystemLibraryManager slm) {
        super(uri, slm);
    }

    public UrlLibrarySource(URI uri) {
        this(uri, null);
    }

    public UrlLibrarySource(File file) {
        super(file);
    }

    @Override
    public String getName() {
        return this.getUri().toString();
    }

    @Override
    public DartSource getSourceFor(String relPath) {
        try {
            URI uri = this.getAbsoluteUri().resolve(new URI(null, null, relPath, null)).normalize();
            return new UrlDartSource(uri, relPath, this, this.systemLibraryManager);
        }
        catch (URISyntaxException e) {
            throw new AssertionError((Object)e);
        }
    }

    @Override
    public LibrarySource getImportFor(String relPath) {
        return new UrlLibrarySource(this.getAbsoluteUri().resolve(relPath).normalize(), this.systemLibraryManager);
    }
}

