/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.internal.com.google.dart.compiler;

import java.io.BufferedReader;
import java.io.InputStreamReader;

public class UnitTestBatchRunner {
    public static void runAsBatch(String[] batchArgs, Invocation toolInvocation) throws Throwable {
        System.out.println(">>> BATCH START");
        BufferedReader cmdlineReader = new BufferedReader(new InputStreamReader(System.in));
        long startTime = System.currentTimeMillis();
        int testsFailed = 0;
        int totalTests = 0;
        try {
            String line;
            while ((line = cmdlineReader.readLine()) != null) {
                long testStart = System.currentTimeMillis();
                String[] args = line.trim().split("\\s+");
                boolean result = toolInvocation.invoke(args);
                if (!result) {
                    ++testsFailed;
                }
                System.out.println(">>> TEST " + (result ? "PASS" : "FAIL") + " " + (System.currentTimeMillis() - testStart) + "ms");
                System.out.flush();
                ++totalTests;
            }
        }
        catch (Throwable e) {
            System.out.println(">>> TEST CRASH");
            System.out.flush();
            throw e;
        }
        long elapsed = System.currentTimeMillis() - startTime;
        System.out.println(">>> BATCH END (" + (totalTests - testsFailed) + "/" + totalTests + ") " + elapsed + "ms");
        System.out.flush();
    }

    public static interface Invocation {
        public boolean invoke(String[] var1) throws Throwable;
    }
}

