/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.internal.com.google.dart.compiler;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.jar.JarFile;
import org.jetbrains.jet.internal.com.google.dart.compiler.SystemLibrary;

public class SystemLibraryManager {
    private static final File executionFile = new File(SystemLibraryManager.class.getProtectionDomain().getCodeSource().getLocation().getPath());
    private HashMap<String, String> expansionMap;
    private Map<String, SystemLibrary> hostMap;
    private SystemLibrary[] libraries;

    public SystemLibraryManager() {
        this.setLibraries(this.getDefaultLibraries());
    }

    public URI resolveDartUri(URI uri) {
        return this.translateDartUri(this.expandRelativeDartUri(uri));
    }

    public URI translateDartUri(URI uri) {
        if (SystemLibraryManager.isDartUri(uri)) {
            String host = uri.getHost();
            SystemLibrary library = this.hostMap.get(host);
            if (library == null) {
                throw new RuntimeException("No system library defined for " + uri);
            }
            return library.translateUri(uri);
        }
        return uri;
    }

    public URI expandRelativeDartUri(URI uri) throws AssertionError {
        String host;
        if (SystemLibraryManager.isDartUri(uri) && (host = uri.getHost()) == null) {
            String spec = uri.getSchemeSpecificPart();
            String replacement = this.expansionMap.get(spec);
            if (replacement != null) {
                try {
                    uri = new URI("dart:" + replacement);
                }
                catch (URISyntaxException e) {
                    throw new AssertionError();
                }
            } else {
                return null;
            }
        }
        return uri;
    }

    public static boolean isDartUri(URI uri) {
        return uri != null && "dart".equals(uri.getScheme());
    }

    public static boolean isDartSpec(String spec) {
        return spec != null && spec.startsWith("dart:");
    }

    private void setLibraries(SystemLibrary[] newLibraries) {
        this.libraries = newLibraries;
        this.hostMap = new HashMap<String, SystemLibrary>();
        this.expansionMap = new HashMap();
        for (SystemLibrary library : this.libraries) {
            this.hostMap.put(library.getHost(), library);
            this.expansionMap.put(library.getShortName(), "//" + library.getHost() + "/" + library.getPathToLib());
        }
    }

    private File getResource(String name, boolean failOnMissing) {
        URL baseUrl = SystemLibraryManager.class.getClassLoader().getResource(name);
        if (baseUrl == null) {
            if (!failOnMissing) {
                return null;
            }
            throw new RuntimeException("Failed to find the system library: " + name);
        }
        return SystemLibraryManager.resolveResource(baseUrl, name);
    }

    private static File resolveResource(URL baseUrl, String name) {
        if (baseUrl == null) {
            return null;
        }
        File coreDirOrZip = null;
        String protocol = baseUrl.getProtocol();
        String path = baseUrl.getPath();
        if ("file".equals(protocol)) {
            coreDirOrZip = new File(path.substring(0, path.lastIndexOf(name)));
        } else if ("jar".equals(protocol) && path.startsWith("file:")) {
            int index = path.indexOf(33);
            coreDirOrZip = new File(path.substring(5, index > 0 ? index : path.length()));
        }
        if (coreDirOrZip == null) {
            throw new RuntimeException("Failed to find system library in " + baseUrl);
        }
        if (!coreDirOrZip.exists()) {
            throw new RuntimeException("System library container does not exist " + coreDirOrZip + "\n  from " + baseUrl);
        }
        return coreDirOrZip;
    }

    private File searchForResource(String searchPath, String libraryName, boolean failOnMissing) {
        File foundLibrary;
        URL urlPath = null;
        File sourcePath = new File(searchPath);
        if (sourcePath.isDirectory()) {
            foundLibrary = new File(sourcePath.getPath() + File.separator + libraryName);
            if (!foundLibrary.exists()) {
                if (failOnMissing) {
                    throw new RuntimeException("Failed to find system library " + libraryName + " with " + sourcePath.toString());
                }
                return null;
            }
            try {
                urlPath = foundLibrary.toURI().toURL();
            }
            catch (MalformedURLException e) {
                throw new RuntimeException(e);
            }
        }
        if (sourcePath.isFile() && sourcePath.toString().endsWith(".jar")) {
            JarFile jarFile = null;
            try {
                jarFile = new JarFile(sourcePath);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            if (null != jarFile.getJarEntry(libraryName)) {
                String path = "jar:file:" + sourcePath.getPath() + "!/" + libraryName;
                try {
                    urlPath = new URL(path);
                }
                catch (MalformedURLException e) {
                    throw new RuntimeException(e);
                }
            } else {
                if (failOnMissing) {
                    throw new RuntimeException("Failed to find system library " + libraryName + " with " + sourcePath.getPath());
                }
                return null;
            }
        }
        if ((foundLibrary = SystemLibraryManager.resolveResource(urlPath, libraryName)) == null && failOnMissing) {
            throw new RuntimeException("Failed to find system library " + libraryName + " with " + sourcePath.getPath());
        }
        return foundLibrary;
    }

    protected SystemLibrary locateSystemLibrary(SystemLibraryPath path) {
        String executionPath;
        File libraryDirOrZip = this.getResource(path.lib, path.failIfMissing);
        if (libraryDirOrZip == null && (libraryDirOrZip = this.searchForResource(executionPath = executionFile.isDirectory() ? executionFile.getParent() + File.separator + ".." + File.separator + ".." + File.separator + ".." + File.separator + "client" : executionFile.getParent() + File.separator + path.jar, path.lib, false)) == null && executionFile.isFile()) {
            libraryDirOrZip = this.searchForResource(executionFile.getParent(), path.lib, false);
        }
        if (libraryDirOrZip != null) {
            return new SystemLibrary(path.shortName, path.hostName, path.lib, libraryDirOrZip);
        }
        return null;
    }

    protected SystemLibrary[] getDefaultLibraries() {
        ArrayList<SystemLibrary> defaultLibraries = new ArrayList<SystemLibrary>();
        File[] baseFiles = new File[SystemLibraryPath.values().length];
        for (SystemLibraryPath path : SystemLibraryPath.values()) {
            if (path.base != null) {
                defaultLibraries.add(new SystemLibrary(path.shortName, path.hostName, path.lib, baseFiles[path.base.ordinal()]));
                baseFiles[path.ordinal()] = baseFiles[path.base.ordinal()];
                continue;
            }
            SystemLibrary library = this.locateSystemLibrary(path);
            if (library == null) continue;
            defaultLibraries.add(library);
            baseFiles[path.ordinal()] = library.getFile();
        }
        return defaultLibraries.toArray(new SystemLibrary[defaultLibraries.size()]);
    }

    private static enum SystemLibraryPath {
        CORE("core", "core", "org/jetbrains/jet/internal/com/google/dart/corelib/", "corelib.dart", "corelib.jar", true),
        COREIMPL("core", "coreimpl", "org/jetbrains/jet/internal/com/google/dart/corelib/", "corelib_impl.dart", "corelib.jar", CORE, true),
        DOM("dom", "dom", "dom/", "dom.dart", "domlib.jar"),
        HTML("html", "html", "html/", "html.dart", "htmllib.jar"),
        HTMLIMPL("html", "htmlimpl", "html/", "htmlimpl.dart", "htmllib.jar"),
        JSON("json", "json", "json/", "json.dart", "jsonlib.jar");

        final String hostName;
        final SystemLibraryPath base;
        final String shortName;
        final String jar;
        final String lib;
        final boolean failIfMissing;

        private SystemLibraryPath(String hostName, String shortName, String path, String file, String jar, boolean failIfMissing) {
            this(hostName, shortName, path, file, jar, null, failIfMissing);
        }

        private SystemLibraryPath(String hostName, String shortName, String path, String file, String jar) {
            this(hostName, shortName, path, file, jar, null, false);
        }

        private SystemLibraryPath(String hostName, String shortName, String path, String file, String jar, SystemLibraryPath base, boolean failIfMissing) {
            this.hostName = hostName;
            this.shortName = shortName;
            this.jar = jar;
            this.lib = path + file;
            this.base = base;
            this.failIfMissing = failIfMissing;
        }
    }
}

