/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.internal.com.google.dart.compiler;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.PrintStream;
import java.io.Reader;
import org.jetbrains.jet.internal.com.google.common.io.Closeables;
import org.jetbrains.jet.internal.com.google.dart.compiler.CompilerConfiguration;
import org.jetbrains.jet.internal.com.google.dart.compiler.DartCompilationError;
import org.jetbrains.jet.internal.com.google.dart.compiler.DartSource;
import org.jetbrains.jet.internal.com.google.dart.compiler.DefaultErrorFormatter;
import org.jetbrains.jet.internal.com.google.dart.compiler.LibrarySource;
import org.jetbrains.jet.internal.com.google.dart.compiler.Source;

public class PrettyErrorFormatter
extends DefaultErrorFormatter {
    private static String RED_BOLD_COLOR = "\u001b[31;1m";
    private static String RED_COLOR = "\u001b[31m";
    private static String NO_COLOR = "\u001b[0m";
    private final boolean useColor;

    public PrettyErrorFormatter(PrintStream outputStream, boolean useColor, CompilerConfiguration.ErrorFormat errorFormat) {
        super(outputStream, errorFormat);
        this.useColor = useColor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void format(DartCompilationError event) {
        String lineText;
        String lineBefore;
        int line;
        BufferedReader reader;
        Source sourceFile;
        block18: {
            sourceFile = event.getSource();
            if (!(sourceFile instanceof DartSource) && !(sourceFile instanceof LibrarySource)) {
                super.format(event);
                return;
            }
            reader = null;
            Reader sourceReader = sourceFile.getSourceReader();
            if (sourceReader != null) {
                reader = new BufferedReader(sourceReader);
            }
            line = event.getLineNumber();
            lineBefore = null;
            lineText = null;
            if (reader != null) {
                lineBefore = this.getLineAt(reader, line - 1);
                lineText = this.getLineAt(reader, 1);
            }
            if (lineText != null) break block18;
            super.format(event);
            if (reader == null) return;
            Closeables.closeQuietly(reader);
            return;
        }
        try {
            int col = event.getColumnNumber() - 1;
            int length = event.getLength();
            col = PrettyErrorFormatter.between(col, 0, lineText.length());
            length = PrettyErrorFormatter.between(length, 0, lineText.length() - col);
            length = length == 0 ? lineText.length() - col : length;
            StringBuilder buf = new StringBuilder();
            if (this.useColor) {
                buf.append(RED_BOLD_COLOR);
            }
            if (this.errorFormat == CompilerConfiguration.ErrorFormat.MACHINE) {
                buf.append(String.format("%s:%s:%s:%s:%d:%d:%d: %s", new Object[]{event.getErrorCode().getErrorSeverity(), event.getErrorCode().getSubSystem(), event.getErrorCode(), sourceFile.getName(), event.getLineNumber(), 1 + col, length, event.getMessage()}));
            } else {
                String sourceName = sourceFile.getUri().toString();
                String includeFrom = this.getImportString(sourceFile);
                buf.append(String.format("%s:%d: %s%s", sourceName, event.getLineNumber(), event.getMessage(), includeFrom));
            }
            if (this.useColor) {
                buf.append(NO_COLOR);
            }
            buf.append("\n");
            if (lineBefore != null) {
                buf.append(String.format("%6d: %s\n", line - 1, lineBefore));
            }
            if (this.useColor) {
                buf.append(String.format("%6d: %s%s%s%s%s\n", line, lineText.substring(0, col), RED_COLOR, lineText.substring(col, col + length), NO_COLOR, lineText.substring(col + length)));
            } else {
                int i;
                buf.append(String.format("%6d: %s\n", line, lineText));
                buf.append("        ");
                for (i = 0; i < col; ++i) {
                    buf.append(' ');
                }
                buf.append('~');
                if (length > 1) {
                    for (i = 0; i < length - 2; ++i) {
                        buf.append('~');
                    }
                    buf.append('~');
                }
                buf.append('\n');
            }
            this.outputStream.print(buf.toString());
            if (reader == null) return;
        }
        catch (IOException ex) {
            try {
                super.format(event);
                if (reader == null) return;
            }
            catch (Throwable throwable) {
                if (reader == null) throw throwable;
                Closeables.closeQuietly(reader);
                throw throwable;
            }
            Closeables.closeQuietly(reader);
            return;
        }
        Closeables.closeQuietly(reader);
        return;
    }

    private String getLineAt(BufferedReader reader, int line) throws IOException {
        if (line <= 0) {
            return null;
        }
        String currentLine = null;
        while ((currentLine = reader.readLine()) != null && line-- > 1) {
        }
        return currentLine;
    }

    private static int between(int val, int start, int end) {
        return Math.max(start, Math.min(val, end));
    }
}

