/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.internal.com.google.dart.compiler;

import java.net.URI;
import org.jetbrains.jet.internal.com.google.dart.compiler.DartSource;
import org.jetbrains.jet.internal.com.google.dart.compiler.LibraryDeps;
import org.jetbrains.jet.internal.com.google.dart.compiler.Source;
import org.jetbrains.jet.internal.com.google.dart.compiler.ast.DartClass;
import org.jetbrains.jet.internal.com.google.dart.compiler.ast.DartField;
import org.jetbrains.jet.internal.com.google.dart.compiler.ast.DartIdentifier;
import org.jetbrains.jet.internal.com.google.dart.compiler.ast.DartMethodDefinition;
import org.jetbrains.jet.internal.com.google.dart.compiler.ast.DartNode;
import org.jetbrains.jet.internal.com.google.dart.compiler.ast.DartNodeTraverser;
import org.jetbrains.jet.internal.com.google.dart.compiler.ast.DartParameterizedTypeNode;
import org.jetbrains.jet.internal.com.google.dart.compiler.ast.DartPropertyAccess;
import org.jetbrains.jet.internal.com.google.dart.compiler.ast.DartTypeNode;
import org.jetbrains.jet.internal.com.google.dart.compiler.ast.DartUnit;
import org.jetbrains.jet.internal.com.google.dart.compiler.resolver.Element;
import org.jetbrains.jet.internal.com.google.dart.compiler.resolver.ElementKind;
import org.jetbrains.jet.internal.com.google.dart.compiler.resolver.EnclosingElement;
import org.jetbrains.jet.internal.com.google.dart.compiler.type.InterfaceType;
import org.jetbrains.jet.internal.com.google.dart.compiler.type.Type;
import org.jetbrains.jet.internal.com.google.dart.compiler.type.TypeKind;

public class LibraryDepsVisitor
extends DartNodeTraverser<Void> {
    private final LibraryDeps.Source source = new LibraryDeps.Source();
    private DartClass currentClass;

    static void exec(DartUnit unit, LibraryDeps deps) {
        LibraryDepsVisitor v = new LibraryDepsVisitor();
        unit.accept(v);
        String relPath = unit.getSource().getRelativePath();
        deps.setSource(relPath, v.source);
    }

    private LibraryDepsVisitor() {
    }

    @Override
    public Void visitIdentifier(DartIdentifier node) {
        Element target = node.getTargetSymbol();
        ElementKind kind = ElementKind.of(target);
        switch (kind) {
            case FIELD: 
            case METHOD: {
                EnclosingElement enclosing = target.getEnclosingElement();
                this.addHoleIfSuper(node, enclosing);
                if (!enclosing.getKind().equals((Object)ElementKind.LIBRARY)) break;
                this.addElementDependency(target);
                break;
            }
        }
        switch (kind) {
            case NONE: 
            case DYNAMIC: {
                break;
            }
            default: {
                Element element;
                Type type = target.getType();
                if (type == null || !ElementKind.of(element = type.getElement()).equals((Object)ElementKind.CLASS)) break;
                this.addElementDependency(element);
                break;
            }
        }
        return null;
    }

    @Override
    public Void visitPropertyAccess(DartPropertyAccess node) {
        DartIdentifier qualifier;
        Element target;
        if (node.getQualifier() instanceof DartIdentifier && (target = (qualifier = (DartIdentifier)node.getQualifier()).getTargetSymbol()) != null && target.getKind() == ElementKind.LIBRARY) {
            return (Void)super.visitPropertyAccess(node);
        }
        return node.getQualifier().accept(this);
    }

    @Override
    public Void visitClass(DartClass node) {
        this.currentClass = node;
        node.visitChildren(this);
        this.currentClass = null;
        return null;
    }

    @Override
    public Void visitParameterizedTypeNode(DartParameterizedTypeNode node) {
        if (TypeKind.of(node.getType()).equals((Object)TypeKind.INTERFACE)) {
            this.addElementDependency(((InterfaceType)node.getType()).getElement());
        }
        node.visitChildren(this);
        return null;
    }

    @Override
    public Void visitTypeNode(DartTypeNode node) {
        if (TypeKind.of(node.getType()).equals((Object)TypeKind.INTERFACE)) {
            this.addElementDependency(((InterfaceType)node.getType()).getElement());
        }
        node.visitChildren(this);
        return null;
    }

    private void addHoleIfSuper(DartIdentifier node, Element holder) {
        if (ElementKind.of(holder).equals((Object)ElementKind.CLASS) && holder != this.currentClass.getSymbol()) {
            this.source.putHole(node.getTargetName());
        }
    }

    private void addElementDependency(Element elem) {
        DartNode node = elem.getNode();
        if (node != null) {
            String name;
            Source nodeSource = node.getSource();
            URI libUri = ((DartSource)nodeSource).getLibrary().getUri();
            LibraryDeps.Dependency dep = new LibraryDeps.Dependency(libUri, Integer.toString(node.computeHash()));
            switch (elem.getKind()) {
                case CLASS: {
                    name = ((DartClass)node).getClassName();
                    break;
                }
                case FIELD: {
                    name = ((DartIdentifier)((DartField)node).getName()).getTargetName();
                    break;
                }
                case METHOD: {
                    DartMethodDefinition method = (DartMethodDefinition)node;
                    DartIdentifier ident = (DartIdentifier)method.getName();
                    name = ident.getTargetName();
                    break;
                }
                default: {
                    throw new AssertionError((Object)"Unexpected top-level node type");
                }
            }
            this.source.putDependency(name, dep);
        }
    }
}

