/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.internal.com.google.dart.compiler;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.jetbrains.jet.internal.com.google.dart.compiler.DartCompilerContext;
import org.jetbrains.jet.internal.com.google.dart.compiler.LibraryDepsVisitor;
import org.jetbrains.jet.internal.com.google.dart.compiler.ast.DartUnit;

public class LibraryDeps {
    private final Map<String, Source> sources = new ConcurrentHashMap<String, Source>();

    public static LibraryDeps fromReader(Reader reader) throws IOException {
        String srcName;
        LibraryDeps deps = new LibraryDeps();
        BufferedReader buf = new BufferedReader(reader);
        while (null != (srcName = buf.readLine())) {
            String line;
            Source src = new Source();
            block7: while (null != (line = buf.readLine()) && line.length() != 0) {
                String[] parts = line.split(" ");
                switch (parts.length) {
                    case 3: {
                        try {
                            src.deps.put(parts[0], new Dependency(new URI(parts[1]), parts[2]));
                            continue block7;
                        }
                        catch (URISyntaxException e) {
                            return null;
                        }
                    }
                    case 1: {
                        src.deps.put(parts[0], Source.HOLE);
                        continue block7;
                    }
                }
                return null;
            }
            deps.sources.put(srcName, src);
        }
        return deps;
    }

    public Source getSource(String sourceName) {
        return this.sources.get(sourceName);
    }

    public Iterable<String> getSourceNames() {
        return this.sources.keySet();
    }

    public void setSource(String sourceName, Source source) {
        this.sources.put(sourceName, source);
    }

    public String toString() {
        try {
            StringWriter writer = new StringWriter();
            this.write(writer);
            return writer.toString();
        }
        catch (IOException e) {
            throw new AssertionError();
        }
    }

    public void update(DartUnit unit, DartCompilerContext context) {
        LibraryDepsVisitor.exec(unit, this);
    }

    public void write(Writer writer) throws IOException {
        ArrayList<String> sortedSourceNames = new ArrayList<String>(this.sources.size());
        sortedSourceNames.addAll(this.sources.keySet());
        Collections.sort(sortedSourceNames);
        for (String srcName : sortedSourceNames) {
            writer.write(srcName);
            writer.write(10);
            Source src = this.sources.get(srcName);
            ArrayList sortedTypes = new ArrayList(src.deps.size());
            sortedTypes.addAll(src.deps.keySet());
            Collections.sort(sortedTypes);
            for (String type : sortedTypes) {
                writer.write(type);
                Dependency dep = src.getDependency(type);
                if (dep != Source.HOLE) {
                    writer.write(32);
                    writer.write(dep.libUri.toString());
                    writer.write(32);
                    writer.write(dep.hash);
                }
                writer.write(10);
            }
            writer.write(10);
        }
    }

    public static class Source {
        private final Map<String, Dependency> deps = new ConcurrentHashMap<String, Dependency>();
        private static final Dependency HOLE = new Dependency(null, null);

        public Iterable<String> getNodeNames() {
            return this.deps.keySet();
        }

        public void putDependency(String nodeName, Dependency dep) {
            this.deps.put(nodeName, dep);
        }

        public Dependency getDependency(String nodeName) {
            return this.deps.get(nodeName);
        }

        public void putHole(String nodeName) {
            this.deps.put(nodeName, HOLE);
        }

        public boolean isHole(String nodeName) {
            return this.deps.containsKey(nodeName) && this.deps.get(nodeName) == HOLE;
        }
    }

    public static class Dependency {
        private final URI libUri;
        private final String hash;

        public Dependency(URI libUri, String hash) {
            this.libUri = libUri;
            this.hash = hash;
        }

        public String getHash() {
            return this.hash;
        }

        public URI getLibUri() {
            return this.libUri;
        }
    }
}

