/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.internal.com.google.dart.compiler;

import java.io.PrintStream;
import org.jetbrains.jet.internal.com.google.dart.compiler.CompilerConfiguration;
import org.jetbrains.jet.internal.com.google.dart.compiler.DartCompilationError;
import org.jetbrains.jet.internal.com.google.dart.compiler.DartCompilerListener;
import org.jetbrains.jet.internal.com.google.dart.compiler.DartSource;
import org.jetbrains.jet.internal.com.google.dart.compiler.ErrorFormatter;
import org.jetbrains.jet.internal.com.google.dart.compiler.ErrorSeverity;
import org.jetbrains.jet.internal.com.google.dart.compiler.PrettyErrorFormatter;
import org.jetbrains.jet.internal.com.google.dart.compiler.SubSystem;
import org.jetbrains.jet.internal.com.google.dart.compiler.ast.DartUnit;

public class DefaultDartCompilerListener
implements DartCompilerListener {
    private int errorCount = 0;
    private int warningCount = 0;
    private int typeErrorCount = 0;
    protected final ErrorFormatter formatter;

    public DefaultDartCompilerListener(CompilerConfiguration.ErrorFormat errorFormat) {
        this(System.err, errorFormat);
    }

    public DefaultDartCompilerListener(PrintStream outputStream, CompilerConfiguration.ErrorFormat errorFormat) {
        this.formatter = new PrettyErrorFormatter(outputStream, this.useColor(), errorFormat);
    }

    private boolean useColor() {
        return String.valueOf(System.getenv("TERM")).startsWith("xterm") && System.console() != null;
    }

    public int getErrorCount() {
        return this.errorCount;
    }

    public int getWarningCount() {
        return this.warningCount;
    }

    public int getTypeErrorCount() {
        return this.typeErrorCount;
    }

    protected void incrementErrorCount() {
        ++this.errorCount;
    }

    protected void incrementWarningCount() {
        ++this.warningCount;
    }

    protected void incrementTypeErrorCount() {
        ++this.typeErrorCount;
    }

    @Override
    public void onError(DartCompilationError event) {
        this.formatter.format(event);
        if (event.getErrorCode().getSubSystem() == SubSystem.STATIC_TYPE) {
            this.incrementTypeErrorCount();
        } else if (event.getErrorCode().getErrorSeverity() == ErrorSeverity.ERROR) {
            this.incrementErrorCount();
        } else if (event.getErrorCode().getErrorSeverity() == ErrorSeverity.WARNING) {
            this.incrementWarningCount();
        }
    }

    @Override
    public void unitAboutToCompile(DartSource source, boolean diet) {
    }

    @Override
    public void unitCompiled(DartUnit unit) {
    }
}

