/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.internal.com.google.dart.compiler;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.net.URI;
import java.net.URISyntaxException;
import org.jetbrains.jet.internal.com.google.dart.compiler.DartArtifactProvider;
import org.jetbrains.jet.internal.com.google.dart.compiler.DartSource;
import org.jetbrains.jet.internal.com.google.dart.compiler.LibrarySource;
import org.jetbrains.jet.internal.com.google.dart.compiler.Source;
import org.jetbrains.jet.internal.com.google.dart.compiler.SystemLibraryManager;

public class DefaultDartArtifactProvider
extends DartArtifactProvider {
    private final File outputDirectory;

    public DefaultDartArtifactProvider() {
        this(new File("out"));
    }

    public DefaultDartArtifactProvider(File outputDirectory) {
        this.outputDirectory = outputDirectory;
    }

    @Override
    public Reader getArtifactReader(Source source, String part, String extension) throws IOException {
        File file;
        DartSource bundledSource;
        if (SystemLibraryManager.isDartUri(source.getUri()) && (bundledSource = this.getBundledArtifact(source, source, part, extension)) != null) {
            Reader reader = null;
            try {
                reader = bundledSource.getSourceReader();
            }
            catch (FileNotFoundException fileNotFoundException) {
                // empty catch block
            }
            if (reader != null) {
                return new BufferedReader(reader);
            }
        }
        if (!(file = this.getArtifactFile(source, part, extension)).exists()) {
            return null;
        }
        return new BufferedReader(new FileReader(file));
    }

    @Override
    public URI getArtifactUri(Source source, String part, String extension) {
        try {
            return new URI("file", this.getArtifactFile(source, part, extension).getPath(), null);
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException(e);
        }
    }

    @Override
    public Writer getArtifactWriter(Source source, String part, String extension) throws IOException {
        return new BufferedWriter(new FileWriter(this.makeDirectories(this.getArtifactFile(source, part, extension))));
    }

    @Override
    public boolean isOutOfDate(Source source, Source base, String extension) {
        DartSource bundledSource;
        if (SystemLibraryManager.isDartUri(base.getUri()) && (bundledSource = this.getBundledArtifact(source, base, "", extension)) != null && bundledSource.exists()) {
            return false;
        }
        File artifactFile = this.getArtifactFile(base, "", extension);
        return artifactFile.lastModified() < source.getLastModified();
    }

    protected DartSource getBundledArtifact(Source source, Source base, String part, String extension) {
        URI relativeUri;
        LibrarySource library;
        if (base instanceof LibrarySource) {
            library = (LibrarySource)base;
            relativeUri = library.getUri().resolve(".").normalize().relativize(base.getUri());
        } else if (base instanceof DartSource) {
            library = ((DartSource)base).getLibrary();
            String name = base.getName();
            URI nameUri = URI.create(name).normalize();
            relativeUri = library.getUri().resolve(".").normalize().relativize(nameUri);
        } else {
            throw new AssertionError((Object)base.getClass().getName());
        }
        DartSource bundledSource = !relativeUri.isAbsolute() ? library.getSourceFor(this.fullname(relativeUri.getPath(), part, extension)) : null;
        return bundledSource;
    }

    protected File getArtifactFile(Source source, String part, String extension) {
        String name = source.getName();
        name = URI.create(name).normalize().toString();
        name = this.normalizeArtifactName(name);
        File file = new File(this.outputDirectory, this.fullname(name, part, extension));
        return file;
    }

    private String normalizeArtifactName(String name) {
        boolean lastCharWasSlash = false;
        boolean lastCharWasPeriod = false;
        boolean madeChanges = false;
        int nameLen = name.length();
        char[] newName = new char[nameLen];
        int idx = 0;
        block5: for (char ch : name.toCharArray()) {
            if (lastCharWasPeriod && ch != '.') {
                newName[idx++] = 46;
                lastCharWasPeriod = false;
            } else if (lastCharWasSlash && ch != '/') {
                newName[idx++] = 47;
                lastCharWasSlash = false;
            }
            switch (ch) {
                case '!': 
                case ':': {
                    madeChanges = true;
                    continue block5;
                }
                case '/': {
                    if (lastCharWasSlash) {
                        madeChanges = true;
                        newName[idx++] = File.separatorChar;
                        lastCharWasSlash = false;
                        continue block5;
                    }
                    lastCharWasSlash = true;
                    continue block5;
                }
                case '.': {
                    if (lastCharWasPeriod) {
                        madeChanges = true;
                        newName[idx++] = 95;
                        lastCharWasPeriod = false;
                        continue block5;
                    }
                    lastCharWasPeriod = true;
                    continue block5;
                }
                default: {
                    newName[idx++] = ch;
                    lastCharWasSlash = false;
                    lastCharWasPeriod = false;
                }
            }
        }
        if (lastCharWasPeriod) {
            newName[idx++] = 46;
        } else if (lastCharWasSlash) {
            newName[idx++] = 47;
        }
        if (madeChanges) {
            name = new String(newName, 0, idx);
        }
        return name;
    }

    private File makeDirectories(File file) {
        file.getParentFile().mkdirs();
        return file;
    }

    private String fullname(String name, String part, String extension) {
        if (part.isEmpty()) {
            return name + "." + extension;
        }
        return name + "$" + part + "." + extension;
    }
}

