/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.internal.com.google.dart.compiler;

import java.io.File;
import java.io.FileNotFoundException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.jetbrains.jet.internal.com.google.dart.compiler.Backend;
import org.jetbrains.jet.internal.com.google.dart.compiler.CommandLineOptions;
import org.jetbrains.jet.internal.com.google.dart.compiler.CompilerConfiguration;
import org.jetbrains.jet.internal.com.google.dart.compiler.DartCompilationPhase;
import org.jetbrains.jet.internal.com.google.dart.compiler.LibrarySource;
import org.jetbrains.jet.internal.com.google.dart.compiler.SystemLibraryManager;
import org.jetbrains.jet.internal.com.google.dart.compiler.UrlLibrarySource;
import org.jetbrains.jet.internal.com.google.dart.compiler.backend.doc.DartDocumentationGenerator;
import org.jetbrains.jet.internal.com.google.dart.compiler.backend.isolate.DartIsolateStubGenerator;
import org.jetbrains.jet.internal.com.google.dart.compiler.backend.js.ClosureJsBackend;
import org.jetbrains.jet.internal.com.google.dart.compiler.backend.js.JavascriptBackend;
import org.jetbrains.jet.internal.com.google.dart.compiler.metrics.CompilerMetrics;
import org.jetbrains.jet.internal.com.google.dart.compiler.resolver.CompileTimeConstantAnalyzer;
import org.jetbrains.jet.internal.com.google.dart.compiler.resolver.Resolver;
import org.jetbrains.jet.internal.com.google.dart.compiler.type.TypeAnalyzer;

public class DefaultCompilerConfiguration
implements CompilerConfiguration {
    private List<Backend> backends;
    private final CommandLineOptions.CompilerOptions compilerOptions;
    private final CompilerMetrics compilerMetrics;
    private final SystemLibraryManager systemLibraryManager;

    public DefaultCompilerConfiguration() {
        this((Backend)new JavascriptBackend());
    }

    private static Backend selectBackend(CommandLineOptions.CompilerOptions compilerOptions) throws FileNotFoundException {
        if (compilerOptions.generateDocumentation()) {
            return new DartDocumentationGenerator(compilerOptions.getDocumentationOutputDirectory(), compilerOptions.getDocumentationLibrary());
        }
        if (!compilerOptions.getIsolateStubClasses().isEmpty()) {
            return new DartIsolateStubGenerator(compilerOptions.getIsolateStubClasses(), compilerOptions.getIsolateStubOutputFile());
        }
        if (compilerOptions.shouldOptimize()) {
            return new ClosureJsBackend(compilerOptions.developerModeChecks(), compilerOptions.generateHumanReadableOutput());
        }
        return new JavascriptBackend();
    }

    public DefaultCompilerConfiguration(CommandLineOptions.CompilerOptions compilerOptions) throws FileNotFoundException {
        this(DefaultCompilerConfiguration.selectBackend(compilerOptions), compilerOptions);
    }

    public DefaultCompilerConfiguration(Backend backend) {
        this(new CommandLineOptions.CompilerOptions(), backend);
    }

    public DefaultCompilerConfiguration(Backend backend, CommandLineOptions.CompilerOptions compilerOptions) {
        this(compilerOptions, backend);
    }

    public DefaultCompilerConfiguration(Backend ... backends) {
        this(new CommandLineOptions.CompilerOptions(), backends);
    }

    public DefaultCompilerConfiguration(CommandLineOptions.CompilerOptions compilerOptions, Backend ... backends) {
        this(compilerOptions, new SystemLibraryManager(), backends);
    }

    public DefaultCompilerConfiguration(CommandLineOptions.CompilerOptions compilerOptions, SystemLibraryManager libraryManager) throws FileNotFoundException {
        this(compilerOptions, libraryManager, DefaultCompilerConfiguration.selectBackend(compilerOptions));
    }

    public DefaultCompilerConfiguration(CommandLineOptions.CompilerOptions compilerOptions, SystemLibraryManager libraryManager, Backend ... backends) {
        this.backends = Arrays.asList(backends);
        this.compilerOptions = compilerOptions;
        this.compilerMetrics = compilerOptions.showMetrics() ? new CompilerMetrics() : null;
        this.systemLibraryManager = libraryManager;
    }

    @Override
    public List<DartCompilationPhase> getPhases() {
        ArrayList<DartCompilationPhase> phases = new ArrayList<DartCompilationPhase>();
        phases.add(new CompileTimeConstantAnalyzer.Phase());
        phases.add(new Resolver.Phase());
        phases.add(new TypeAnalyzer());
        return phases;
    }

    @Override
    public List<Backend> getBackends() {
        return this.backends;
    }

    @Override
    public boolean developerModeChecks() {
        return this.compilerOptions.developerModeChecks();
    }

    @Override
    public boolean shouldOptimize() {
        return this.compilerOptions.shouldOptimize();
    }

    @Override
    public CompilerMetrics getCompilerMetrics() {
        return this.compilerMetrics;
    }

    @Override
    public String getJvmMetricOptions() {
        return this.compilerOptions.getJvmMetricOptions();
    }

    @Override
    public boolean typeErrorsAreFatal() {
        return this.compilerOptions.typeErrorsAreFatal();
    }

    @Override
    public boolean warningsAreFatal() {
        return this.compilerOptions.warningsAreFatal();
    }

    @Override
    public boolean resolveDespiteParseErrors() {
        return false;
    }

    @Override
    public boolean incremental() {
        return this.compilerOptions.buildIncrementally();
    }

    @Override
    public File getOutputFilename() {
        return this.compilerOptions.getOutputFilename();
    }

    @Override
    public File getOutputDirectory() {
        return this.compilerOptions.getWorkDirectory();
    }

    @Override
    public boolean checkOnly() {
        return this.compilerOptions.checkOnly();
    }

    @Override
    public boolean expectEntryPoint() {
        return false;
    }

    @Override
    public boolean shouldWarnOnNoSuchType() {
        return false;
    }

    @Override
    public boolean collectComments() {
        return this.compilerOptions.generateDocumentation();
    }

    @Override
    public LibrarySource getSystemLibraryFor(String importSpec) {
        URI systemUri;
        try {
            systemUri = new URI(importSpec);
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
        if (null == this.systemLibraryManager.expandRelativeDartUri(systemUri)) {
            return null;
        }
        return new UrlLibrarySource(systemUri, this.systemLibraryManager);
    }

    @Override
    public CommandLineOptions.CompilerOptions getCompilerOptions() {
        return this.compilerOptions;
    }

    @Override
    public CompilerConfiguration.ErrorFormat printErrorFormat() {
        return this.compilerOptions.printErrorFormat();
    }
}

