/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.internal.com.google.dart.compiler;

import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.io.Reader;
import java.io.Writer;
import java.net.URI;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.jet.internal.com.google.common.collect.Lists;
import org.jetbrains.jet.internal.com.google.common.io.CharStreams;
import org.jetbrains.jet.internal.com.google.common.io.Closeables;
import org.jetbrains.jet.internal.com.google.common.io.Files;
import org.jetbrains.jet.internal.com.google.dart.compiler.Backend;
import org.jetbrains.jet.internal.com.google.dart.compiler.CommandLineOptions;
import org.jetbrains.jet.internal.com.google.dart.compiler.CompilerConfiguration;
import org.jetbrains.jet.internal.com.google.dart.compiler.DartArtifactProvider;
import org.jetbrains.jet.internal.com.google.dart.compiler.DartCompilationError;
import org.jetbrains.jet.internal.com.google.dart.compiler.DartCompilationPhase;
import org.jetbrains.jet.internal.com.google.dart.compiler.DartCompilerContext;
import org.jetbrains.jet.internal.com.google.dart.compiler.DartCompilerErrorCode;
import org.jetbrains.jet.internal.com.google.dart.compiler.DartCompilerListener;
import org.jetbrains.jet.internal.com.google.dart.compiler.DartCompilerMainContext;
import org.jetbrains.jet.internal.com.google.dart.compiler.DartIsolateStubGeneratorCompilerConfiguration;
import org.jetbrains.jet.internal.com.google.dart.compiler.DartSource;
import org.jetbrains.jet.internal.com.google.dart.compiler.DefaultCompilerConfiguration;
import org.jetbrains.jet.internal.com.google.dart.compiler.DefaultDartArtifactProvider;
import org.jetbrains.jet.internal.com.google.dart.compiler.DefaultDartCompilerListener;
import org.jetbrains.jet.internal.com.google.dart.compiler.DelegatingCompilerConfiguration;
import org.jetbrains.jet.internal.com.google.dart.compiler.DeltaAnalyzer;
import org.jetbrains.jet.internal.com.google.dart.compiler.ErrorCode;
import org.jetbrains.jet.internal.com.google.dart.compiler.LibraryDeps;
import org.jetbrains.jet.internal.com.google.dart.compiler.LibrarySource;
import org.jetbrains.jet.internal.com.google.dart.compiler.Source;
import org.jetbrains.jet.internal.com.google.dart.compiler.SourceDelta;
import org.jetbrains.jet.internal.com.google.dart.compiler.SystemLibraryManager;
import org.jetbrains.jet.internal.com.google.dart.compiler.UnitTestBatchRunner;
import org.jetbrains.jet.internal.com.google.dart.compiler.UrlLibrarySource;
import org.jetbrains.jet.internal.com.google.dart.compiler.ast.CoverageInstrumenter;
import org.jetbrains.jet.internal.com.google.dart.compiler.ast.DartDirective;
import org.jetbrains.jet.internal.com.google.dart.compiler.ast.DartLibraryDirective;
import org.jetbrains.jet.internal.com.google.dart.compiler.ast.DartNode;
import org.jetbrains.jet.internal.com.google.dart.compiler.ast.DartUnit;
import org.jetbrains.jet.internal.com.google.dart.compiler.ast.LibraryNode;
import org.jetbrains.jet.internal.com.google.dart.compiler.ast.LibraryUnit;
import org.jetbrains.jet.internal.com.google.dart.compiler.ast.Modifiers;
import org.jetbrains.jet.internal.com.google.dart.compiler.ast.viz.ASTWriterFactory;
import org.jetbrains.jet.internal.com.google.dart.compiler.ast.viz.BaseASTWriter;
import org.jetbrains.jet.internal.com.google.dart.compiler.metrics.CompilerMetrics;
import org.jetbrains.jet.internal.com.google.dart.compiler.metrics.DartEventType;
import org.jetbrains.jet.internal.com.google.dart.compiler.metrics.JvmMetrics;
import org.jetbrains.jet.internal.com.google.dart.compiler.metrics.Tracer;
import org.jetbrains.jet.internal.com.google.dart.compiler.parser.CommentPreservingParser;
import org.jetbrains.jet.internal.com.google.dart.compiler.parser.DartParser;
import org.jetbrains.jet.internal.com.google.dart.compiler.parser.DartScanner;
import org.jetbrains.jet.internal.com.google.dart.compiler.parser.DartScannerParserContext;
import org.jetbrains.jet.internal.com.google.dart.compiler.parser.ParserContext;
import org.jetbrains.jet.internal.com.google.dart.compiler.resolver.CompileTimeConstantResolver;
import org.jetbrains.jet.internal.com.google.dart.compiler.resolver.CoreTypeProvider;
import org.jetbrains.jet.internal.com.google.dart.compiler.resolver.CoreTypeProviderImplementation;
import org.jetbrains.jet.internal.com.google.dart.compiler.resolver.Element;
import org.jetbrains.jet.internal.com.google.dart.compiler.resolver.ElementKind;
import org.jetbrains.jet.internal.com.google.dart.compiler.resolver.LibraryElement;
import org.jetbrains.jet.internal.com.google.dart.compiler.resolver.MemberBuilder;
import org.jetbrains.jet.internal.com.google.dart.compiler.resolver.MethodElement;
import org.jetbrains.jet.internal.com.google.dart.compiler.resolver.Resolver;
import org.jetbrains.jet.internal.com.google.dart.compiler.resolver.ResolverErrorCode;
import org.jetbrains.jet.internal.com.google.dart.compiler.resolver.SupertypeResolver;
import org.jetbrains.jet.internal.com.google.dart.compiler.resolver.TopLevelElementBuilder;
import org.jetbrains.jet.internal.com.google.dart.compiler.type.TypeAnalyzer;
import org.jetbrains.jet.internal.org.kohsuke.args4j.CmdLineException;
import org.jetbrains.jet.internal.org.kohsuke.args4j.CmdLineParser;

public class DartCompiler {
    public static final String EXTENSION_API = "api";
    public static final String EXTENSION_DEPS = "deps";
    public static final String EXTENSION_LOG = "log";
    public static final String CORELIB_URL_SPEC = "dart:core";
    public static final String MAIN_ENTRY_POINT_NAME = "main";

    private static CommandLineOptions.CompilerOptions processCommandLineOptions(String[] args) {
        CmdLineParser cmdLineParser = null;
        CommandLineOptions.CompilerOptions compilerOptions = null;
        try {
            compilerOptions = new CommandLineOptions.CompilerOptions();
            cmdLineParser = CommandLineOptions.parse(args, compilerOptions);
            if (args.length == 0 || compilerOptions.showHelp()) {
                DartCompiler.showUsage(cmdLineParser, System.err);
                System.exit(1);
            }
        }
        catch (CmdLineException e) {
            System.err.println(e.getLocalizedMessage());
            DartCompiler.showUsage(cmdLineParser, System.err);
            System.exit(1);
        }
        assert (compilerOptions != null);
        return compilerOptions;
    }

    public static void main(String[] args) {
        Tracer.init();
        CommandLineOptions.CompilerOptions topCompilerOptions = DartCompiler.processCommandLineOptions(args);
        boolean result = false;
        try {
            if (topCompilerOptions.shouldBatch()) {
                if (args.length > 1) {
                    System.err.println("(Extra arguments specified with -batch ignored.)");
                }
                UnitTestBatchRunner.runAsBatch(args, new UnitTestBatchRunner.Invocation(){

                    @Override
                    public boolean invoke(String[] args) throws Throwable {
                        CommandLineOptions.CompilerOptions compilerOptions = DartCompiler.processCommandLineOptions(args);
                        if (compilerOptions.shouldBatch()) {
                            System.err.println("-batch ignored: Already in batch mode.");
                        }
                        return DartCompiler.compilerMain(compilerOptions);
                    }
                });
            } else {
                result = DartCompiler.compilerMain(topCompilerOptions);
            }
        }
        catch (Throwable t) {
            t.printStackTrace();
            DartCompiler.crash();
        }
        if (!result) {
            System.exit(1);
        }
    }

    public static boolean compilerMain(CommandLineOptions.CompilerOptions compilerOptions) throws IOException {
        List<String> sourceFiles = compilerOptions.getSourceFiles();
        if (sourceFiles.size() == 0) {
            System.err.println("dartc: no source files were specified.");
            DartCompiler.showUsage(null, System.err);
            return false;
        }
        File sourceFile = new File(sourceFiles.get(0));
        if (!sourceFile.exists()) {
            System.err.println("dartc: file not found: " + sourceFile);
            DartCompiler.showUsage(null, System.err);
            return false;
        }
        DefaultCompilerConfiguration config = compilerOptions.getIsolateStubClasses().isEmpty() ? new DefaultCompilerConfiguration(compilerOptions) : new DartIsolateStubGeneratorCompilerConfiguration(compilerOptions);
        return DartCompiler.compilerMain(sourceFile, config);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean compilerMain(File sourceFile, CompilerConfiguration config) throws IOException {
        String errorMessage = DartCompiler.compileApp(sourceFile, config);
        if (errorMessage != null) {
            System.err.println(errorMessage);
            return false;
        }
        Tracer.TraceEvent logEvent = Tracer.canTrace() ? Tracer.start(DartEventType.WRITE_METRICS, new String[0]) : null;
        try {
            DartCompiler.maybeShowMetrics(config);
        }
        finally {
            Tracer.end(logEvent, new String[0]);
        }
        return true;
    }

    public static void crash() {
        System.exit(253);
    }

    private static void showUsage(CmdLineParser cmdLineParser, PrintStream out) {
        out.println("Usage: dartc [<options>] <dart-script> [script-arguments]");
        out.println("Available options:");
        if (cmdLineParser == null) {
            cmdLineParser = new CmdLineParser(new CommandLineOptions.CompilerOptions());
        }
        cmdLineParser.printUsage(out);
    }

    private static void maybeShowMetrics(CompilerConfiguration config) {
        CompilerMetrics compilerMetrics = config.getCompilerMetrics();
        if (compilerMetrics != null) {
            compilerMetrics.write(System.out);
        }
        JvmMetrics.maybeWriteJvmMetrics(System.out, config.getJvmMetricOptions());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String compileApp(File sourceFile, CompilerConfiguration config) throws IOException {
        Tracer.TraceEvent logEvent = Tracer.canTrace() ? Tracer.start(DartEventType.COMPILE_APP, "src", sourceFile.toString()) : null;
        File outFile = config.getOutputFilename();
        if (outFile != null && config.getBackends().size() > 1) {
            throw new IllegalArgumentException("Output filename " + outFile + " specified.  Only valid with a single backend.");
        }
        try {
            File outputDirectory = config.getOutputDirectory();
            DefaultDartArtifactProvider provider = new DefaultDartArtifactProvider(outputDirectory);
            DefaultDartCompilerListener listener = new DefaultDartCompilerListener(config.printErrorFormat());
            UrlLibrarySource lib = new UrlLibrarySource(sourceFile);
            config = new DelegatingCompilerConfiguration(config){

                @Override
                public boolean expectEntryPoint() {
                    return true;
                }
            };
            String errorString = DartCompiler.compileLib(lib, config, provider, listener);
            if (errorString == null && outFile != null && !config.getBackends().isEmpty()) {
                Reader r;
                block12: {
                    File dir = outFile.getParentFile();
                    if (dir != null) {
                        if (dir != null && !dir.exists()) {
                            throw new IOException("Cannot create: " + outFile.getName() + ".  " + dir + " does not exist");
                        }
                        if (!dir.canWrite()) {
                            throw new IOException("Cannot write " + outFile.getName() + " to " + dir + ":  Permission denied.");
                        }
                    } else {
                        dir = new File(".");
                        if (!dir.canWrite()) {
                            throw new IOException("Cannot write " + outFile.getName() + " to " + dir + ":  Permission denied.");
                        }
                    }
                    r = null;
                    try {
                        r = provider.getArtifactReader(lib, "", config.getBackends().get(0).getAppExtension());
                        String js = CharStreams.toString(r);
                        if (r == null) break block12;
                        Files.write(js, outFile, Charset.defaultCharset());
                    }
                    catch (Throwable throwable) {
                        Closeables.close(r, true);
                        throw throwable;
                    }
                }
                Closeables.close(r, true);
            }
            String string = errorString;
            return string;
        }
        finally {
            Tracer.end(logEvent, new String[0]);
        }
    }

    public static String compileLib(LibrarySource lib, CompilerConfiguration config, DartArtifactProvider provider, DartCompilerListener listener) throws IOException {
        return DartCompiler.compileLib(lib, Collections.<LibrarySource>emptyList(), config, provider, listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String compileLib(LibrarySource lib, List<LibrarySource> embeddedLibraries, CompilerConfiguration config, DartArtifactProvider provider, DartCompilerListener listener) throws IOException {
        DartCompilerMainContext context = new DartCompilerMainContext(lib, provider, listener, config);
        if (config.getCompilerOptions().shouldExposeCoreImpl()) {
            if (embeddedLibraries == null) {
                embeddedLibraries = Lists.newArrayList();
            }
            embeddedLibraries.add(new NamedPlaceHolderLibrarySource("dart:coreimpl"));
        }
        new Compiler(lib, embeddedLibraries, config, context).compile();
        int errorCount = context.getErrorCount();
        if (config.typeErrorsAreFatal()) {
            errorCount += context.getTypeErrorCount();
        }
        if (config.warningsAreFatal()) {
            errorCount += context.getWarningCount();
        }
        if (errorCount > 0) {
            return "Compilation failed with " + errorCount + (errorCount == 1 ? " problem." : " problems.");
        }
        if (!context.getFilesHaveChanged()) {
            return null;
        }
        if (config.checkOnly()) {
            Writer writer = provider.getArtifactWriter(lib, "", EXTENSION_LOG);
            boolean threw = true;
            try {
                writer.write(String.format("Checked %s and found:%n", lib.getName()));
                writer.write(String.format("  no load/resolution errors%n", new Object[0]));
                writer.write(String.format("  %s type errors%n", context.getTypeErrorCount()));
                threw = false;
            }
            finally {
                Closeables.close(writer, threw);
            }
        }
        return null;
    }

    public static LibraryUnit analyzeLibrary(LibrarySource lib, Map<URI, DartUnit> parsedUnits, CompilerConfiguration config, DartArtifactProvider provider, DartCompilerListener listener) throws IOException {
        lib.getClass();
        provider.getClass();
        listener.getClass();
        DartCompilerMainContext context = new DartCompilerMainContext(lib, provider, listener, config);
        SelectiveCompiler compiler = new SelectiveCompiler(lib, parsedUnits, config, context);
        LibraryUnit libraryUnit = ((Compiler)compiler).updateAndResolve();
        if (libraryUnit != null) {
            DartCompilationPhase[] phases = new DartCompilationPhase[]{new Resolver.Phase(), new TypeAnalyzer()};
            for (DartUnit unit : libraryUnit.getUnits()) {
                if (unit.isDiet()) continue;
                for (DartCompilationPhase phase : phases) {
                    unit = phase.exec(unit, context, compiler.getTypeProvider());
                }
            }
        }
        return libraryUnit;
    }

    public static DartNode analyzeDelta(SourceDelta delta, LibraryElement enclosingLibrary, LibraryElement coreLibrary, DartNode interestNode, int interestStart, int interestLength, CompilerConfiguration config, DartCompilerListener listener) throws IOException {
        DeltaAnalyzer analyzer = new DeltaAnalyzer(delta, enclosingLibrary, coreLibrary, interestNode, interestStart, interestLength, config, listener);
        return analyzer.analyze();
    }

    public static LibraryUnit findLibrary(LibraryUnit libraryUnit, String uri, Set<LibraryElement> seen) {
        if (seen.contains(libraryUnit.getElement())) {
            return null;
        }
        seen.add(libraryUnit.getElement());
        for (LibraryNode src : libraryUnit.getSourcePaths()) {
            if (!src.getText().equals(uri)) continue;
            return libraryUnit;
        }
        for (LibraryUnit importedLibrary : libraryUnit.getImports()) {
            LibraryUnit unit = DartCompiler.findLibrary(importedLibrary, uri, seen);
            if (unit == null) continue;
            return unit;
        }
        return null;
    }

    public static LibraryUnit getCoreLib(LibraryUnit libraryUnit) {
        return DartCompiler.findLibrary(libraryUnit, "corelib.dart", new HashSet<LibraryElement>());
    }

    private static class SelectiveCompiler
    extends Compiler {
        private final Map<URI, DartUnit> parsedUnits;

        private SelectiveCompiler(LibrarySource app, Map<URI, DartUnit> suppliedUnits, CompilerConfiguration config, DartCompilerMainContext context) {
            super(app, Collections.emptyList(), config, context);
            this.parsedUnits = suppliedUnits;
        }

        @Override
        DartUnit parse(DartSource dartSrc, Set<String> prefixes) throws IOException {
            if (this.parsedUnits == null) {
                return super.parse(dartSrc, prefixes);
            }
            URI srcUri = dartSrc.getUri();
            DartUnit parsedUnit = this.parsedUnits.get(srcUri);
            return parsedUnit == null ? super.parse(dartSrc, prefixes) : parsedUnit;
        }
    }

    private static class Compiler {
        private final LibrarySource app;
        private final List<LibrarySource> embeddedLibraries = new ArrayList<LibrarySource>();
        private final DartCompilerMainContext context;
        private final CompilerConfiguration config;
        private final Map<URI, LibraryUnit> libraries = new LinkedHashMap<URI, LibraryUnit>();
        private boolean packageApp = false;
        private final boolean checkOnly;
        private final boolean collectComments;
        private CoreTypeProvider typeProvider;
        private final boolean incremental;
        private final boolean usePrecompiledDartLibs;
        private final List<DartCompilationPhase> phases;
        private final List<Backend> backends;
        private final LibrarySource coreLibrarySource;

        private Compiler(LibrarySource app, List<LibrarySource> embedded, CompilerConfiguration config, DartCompilerMainContext context) {
            this.app = app;
            this.config = config;
            this.phases = config.getPhases();
            this.backends = config.getBackends();
            this.context = context;
            this.checkOnly = config.checkOnly();
            this.collectComments = config.collectComments();
            for (LibrarySource library : embedded) {
                if (SystemLibraryManager.isDartSpec(library.getName())) {
                    this.embeddedLibraries.add(context.getSystemLibraryFor(library.getName()));
                    continue;
                }
                this.embeddedLibraries.add(library);
            }
            this.coreLibrarySource = context.getSystemLibraryFor(DartCompiler.CORELIB_URL_SPEC);
            this.embeddedLibraries.add(this.coreLibrarySource);
            if (config.shouldOptimize()) {
                this.incremental = false;
                this.usePrecompiledDartLibs = false;
            } else {
                this.incremental = config.incremental();
                this.usePrecompiledDartLibs = true;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void compile() {
            Tracer.TraceEvent logEvent = Tracer.canTrace() ? Tracer.start(DartEventType.COMPILE, new String[0]) : null;
            try {
                this.updateAndResolve();
                if (this.context.getErrorCount() > 0) {
                    return;
                }
                if (!this.context.getFilesHaveChanged()) {
                    return;
                }
                this.compileLibraries();
                this.packageApp();
            }
            catch (IOException e) {
                this.context.onError(new DartCompilationError((Source)this.app, (ErrorCode)DartCompilerErrorCode.IO, e.getMessage()));
            }
            finally {
                Tracer.end(logEvent, new String[0]);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private LibraryUnit updateAndResolve() throws IOException {
            Tracer.TraceEvent logEvent = Tracer.canTrace() ? Tracer.start(DartEventType.UPDATE_RESOLVE, new String[0]) : null;
            CompilerMetrics compilerMetrics = this.context.getCompilerMetrics();
            if (compilerMetrics != null) {
                compilerMetrics.startUpdateAndResolveTime();
            }
            try {
                LibraryUnit library = this.updateLibraries(this.app);
                this.importEmbeddedLibraries();
                this.parseOutOfDateFiles();
                if (this.incremental) {
                    this.addOutOfDateDeps();
                }
                if (!this.context.getFilesHaveChanged()) {
                    LibraryUnit libraryUnit = library;
                    return libraryUnit;
                }
                if (!this.config.resolveDespiteParseErrors() && this.context.getErrorCount() > 0) {
                    LibraryUnit libraryUnit = library;
                    return libraryUnit;
                }
                this.buildLibraryScopes();
                LibraryUnit corelibUnit = this.updateLibraries(this.coreLibrarySource);
                this.typeProvider = new CoreTypeProviderImplementation(corelibUnit.getElement().getScope(), this.context);
                this.resolveLibraries();
                this.validateLibraryDirectives();
                LibraryUnit libraryUnit = library;
                return libraryUnit;
            }
            finally {
                if (compilerMetrics != null) {
                    compilerMetrics.endUpdateAndResolveTime();
                }
                Tracer.end(logEvent, new String[0]);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void parseOutOfDateFiles() throws IOException {
            Tracer.TraceEvent logEvent = Tracer.canTrace() ? Tracer.start(DartEventType.PARSE_OUTOFDATE, new String[0]) : null;
            CompilerMetrics compilerMetrics = this.context.getCompilerMetrics();
            long parseStart = compilerMetrics != null ? CompilerMetrics.getCPUTime() : 0L;
            try {
                for (LibraryUnit lib : this.libraries.values()) {
                    LibrarySource libSrc = lib.getSource();
                    boolean libIsDartUri = SystemLibraryManager.isDartUri(libSrc.getUri());
                    LibraryUnit apiLib = new LibraryUnit(libSrc);
                    LibraryNode selfSourcePath = lib.getSelfSourcePath();
                    boolean shouldLoadApi = this.incremental || libIsDartUri && this.usePrecompiledDartLibs;
                    boolean apiOutOfDate = !shouldLoadApi || !apiLib.loadApi(this.context, this.context);
                    for (LibraryNode libNode : lib.getSourcePaths()) {
                        DartSource dartSrc = libSrc.getSourceFor(libNode.getText());
                        if (dartSrc == null || !dartSrc.exists()) {
                            this.reportMissingSource(this.context, libSrc, libNode);
                            continue;
                        }
                        DartUnit apiUnit = apiLib.getUnit(dartSrc.getName());
                        if (apiUnit == null || !libIsDartUri && this.isSourceOutOfDate(dartSrc, libSrc)) {
                            DartUnit unit = this.parse(dartSrc, lib.getPrefixes());
                            if (unit == null) continue;
                            if (libNode == selfSourcePath) {
                                lib.setSelfDartUnit(unit);
                            }
                            lib.putUnit(unit);
                            apiOutOfDate = true;
                            continue;
                        }
                        if (libNode == selfSourcePath) {
                            lib.setSelfDartUnit(apiUnit);
                        }
                        lib.putUnit(apiUnit);
                    }
                    if (apiOutOfDate) {
                        this.context.setFilesHaveChanged();
                        if (!this.checkOnly) {
                            lib.saveApi(this.context);
                        }
                    }
                    lib.populateTopLevelNodes();
                }
            }
            finally {
                if (compilerMetrics != null) {
                    compilerMetrics.addParseWallTimeNano(CompilerMetrics.getCPUTime() - parseStart);
                }
                Tracer.end(logEvent, new String[0]);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void importEmbeddedLibraries() throws IOException {
            Tracer.TraceEvent importEvent = Tracer.canTrace() ? Tracer.start(DartEventType.IMPORT_EMBEDDED_LIBRARIES, new String[0]) : null;
            try {
                for (LibrarySource embedded : this.embeddedLibraries) {
                    this.updateLibraries(embedded);
                }
                for (LibraryUnit lib : this.libraries.values()) {
                    for (LibrarySource embedded : this.embeddedLibraries) {
                        LibraryUnit imp = this.libraries.get(embedded.getUri());
                        if (lib == imp || lib.hasImport(imp)) continue;
                        lib.addImport(imp, null);
                    }
                }
            }
            finally {
                Tracer.end(importEvent, new String[0]);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private LibraryUnit updateLibraries(LibrarySource libSrc) throws IOException {
            LibraryUnit libraryUnit;
            LibraryUnit lib;
            Tracer.TraceEvent updateEvent;
            block11: {
                block10: {
                    updateEvent = Tracer.canTrace() ? Tracer.start(DartEventType.UPDATE_LIBRARIES, "name", libSrc.getName()) : null;
                    lib = this.libraries.get(libSrc.getUri());
                    if (lib == null) break block10;
                    LibraryUnit libraryUnit2 = lib;
                    Tracer.end(updateEvent, new String[0]);
                    return libraryUnit2;
                }
                lib = this.context.getLibraryUnit(libSrc);
                if (lib != null) break block11;
                LibraryUnit libraryUnit3 = null;
                Tracer.end(updateEvent, new String[0]);
                return libraryUnit3;
            }
            try {
                this.libraries.put(libSrc.getUri(), lib);
                for (LibraryNode libNode : lib.getImportPaths()) {
                    LibrarySource dep;
                    String libSpec = libNode.getText();
                    if (SystemLibraryManager.isDartSpec(libSpec)) {
                        dep = this.context.getSystemLibraryFor(libSpec);
                    } else {
                        try {
                            dep = libSrc.getImportFor(libSpec);
                        }
                        catch (IllegalArgumentException ex) {
                            this.reportImportError(this.context, libSrc, libNode);
                            continue;
                        }
                    }
                    if (dep == null || !dep.exists()) {
                        this.reportMissingSource(this.context, libSrc, libNode);
                        continue;
                    }
                    lib.addImport(this.updateLibraries(dep), libNode);
                }
                libraryUnit = lib;
            }
            catch (Throwable throwable) {
                Tracer.end(updateEvent, new String[0]);
                throw throwable;
            }
            Tracer.end(updateEvent, new String[0]);
            return libraryUnit;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
         * Unable to fully structure code
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private boolean isSourceOutOfDate(DartSource dartSrc, LibrarySource libSrc) {
            logEvent = Tracer.canTrace() != false ? Tracer.start(DartEventType.IS_SOURCE_OUTOFDATE, new String[]{"src", dartSrc.getName()}) : null;
            try {
                if (!this.incremental) {
                    var4_4 = true;
                }
                ** GOTO lbl-1000
            }
            catch (Throwable var9_11) {
                Tracer.end(logEvent, new String[0]);
                throw var9_11;
            }
            Tracer.end(logEvent, new String[0]);
            return var4_4;
lbl-1000:
            // 2 sources

            {
                for (Backend backend : this.backends) {
                    backendEvent = Tracer.canTrace() != false ? Tracer.start(DartEventType.BACKEND_OUTOFDATE, new String[]{"be", backend.getClass().getCanonicalName(), "src", dartSrc.getName()}) : null;
                    try {
                        if (!backend.isOutOfDate(dartSrc, this.context)) continue;
                        var7_9 = true;
                    }
                    finally {
                        Tracer.end(backendEvent, new String[0]);
                    }
                }
            }
            {
                var4_6 = this.context.isOutOfDate(dartSrc, libSrc, "api");
            }
            Tracer.end(logEvent, new String[0]);
            return var4_6;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void buildLibraryScopes() {
            Tracer.TraceEvent logEvent = Tracer.canTrace() ? Tracer.start(DartEventType.BUILD_LIB_SCOPES, new String[0]) : null;
            try {
                Collection<LibraryUnit> libs = this.libraries.values();
                for (LibraryUnit lib : libs) {
                    new TopLevelElementBuilder().exec(lib, (DartCompilerContext)this.context);
                }
                for (LibraryUnit lib : libs) {
                    new TopLevelElementBuilder().fillInLibraryScope(lib, this.context);
                }
            }
            finally {
                Tracer.end(logEvent, new String[0]);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void addOutOfDateDeps() throws IOException {
            Tracer.TraceEvent logEvent = Tracer.canTrace() ? Tracer.start(DartEventType.ADD_OUTOFDATE, new String[0]) : null;
            try {
                boolean filesHaveChanged = false;
                for (LibraryUnit lib : this.libraries.values()) {
                    if (SystemLibraryManager.isDartUri(lib.getSource().getUri())) continue;
                    LibraryDeps deps = lib.getDeps(this.context);
                    for (String sourceName : deps.getSourceNames()) {
                        DartUnit unit;
                        LibraryDeps.Source depSource = deps.getSource(sourceName);
                        if (!this.isSourceOutOfDate(lib, depSource)) continue;
                        filesHaveChanged = true;
                        DartSource dartSrc = lib.getSource().getSourceFor(sourceName);
                        if (dartSrc == null || !dartSrc.exists() || (unit = this.parse(dartSrc, lib.getPrefixes())) == null) continue;
                        lib.putUnit(unit);
                    }
                }
                if (filesHaveChanged) {
                    this.context.setFilesHaveChanged();
                }
            }
            finally {
                Tracer.end(logEvent, new String[0]);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean isSourceOutOfDate(LibraryUnit lib, LibraryDeps.Source depSource) {
            for (String nodeName : depSource.getNodeNames()) {
                Tracer.TraceEvent logEvent;
                block7: {
                    DartNode depNode;
                    LibraryDeps.Dependency dep;
                    block9: {
                        LibraryUnit depLib;
                        block8: {
                            block6: {
                                boolean bl;
                                logEvent = Tracer.canTrace() ? Tracer.start(DartEventType.IS_CLASS_OUT_OF_DATE, "class", nodeName) : null;
                                try {
                                    if (!depSource.isHole(nodeName)) break block6;
                                    if (lib.getTopLevelNode(nodeName) == null) break block7;
                                    bl = true;
                                }
                                catch (Throwable throwable) {
                                    Tracer.end(logEvent, new String[0]);
                                    throw throwable;
                                }
                                Tracer.end(logEvent, new String[0]);
                                return bl;
                            }
                            dep = depSource.getDependency(nodeName);
                            depLib = this.libraries.get(dep.getLibUri());
                            if (depLib != null) break block8;
                            boolean bl = true;
                            Tracer.end(logEvent, new String[0]);
                            return bl;
                        }
                        depNode = depLib.getTopLevelNode(nodeName);
                        if (depNode != null) break block9;
                        boolean bl = true;
                        Tracer.end(logEvent, new String[0]);
                        return bl;
                    }
                    String hash = Integer.toString(depNode.computeHash());
                    if (hash.equals(dep.getHash())) break block7;
                    boolean bl = true;
                    Tracer.end(logEvent, new String[0]);
                    return bl;
                }
                Tracer.end(logEvent, new String[0]);
            }
            return false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void resolveLibraries() {
            Tracer.TraceEvent logEvent = Tracer.canTrace() ? Tracer.start(DartEventType.RESOLVE_LIBRARIES, new String[0]) : null;
            try {
                for (LibraryUnit lib : this.libraries.values()) {
                    for (DartUnit unit : lib.getUnits()) {
                        new SupertypeResolver().exec(unit, this.context, this.getTypeProvider());
                        new MemberBuilder().exec(unit, this.context, this.getTypeProvider());
                    }
                }
                for (LibraryUnit lib : this.libraries.values()) {
                    for (DartUnit unit : lib.getUnits()) {
                        new CompileTimeConstantResolver().exec(unit, this.context, this.getTypeProvider());
                    }
                }
            }
            finally {
                Tracer.end(logEvent, new String[0]);
            }
        }

        private void validateLibraryDirectives() {
            for (LibraryUnit lib : this.libraries.values()) {
                if (SystemLibraryManager.isDartUri(lib.getSource().getUri())) continue;
                for (LibraryUnit importedLib : lib.getImports()) {
                    DartUnit unit;
                    if (SystemLibraryManager.isDartUri(importedLib.getSource().getUri()) || (unit = importedLib.getSelfDartUnit()).isDiet()) continue;
                    boolean foundLibraryDirective = false;
                    for (DartDirective directive : unit.getDirectives()) {
                        if (!(directive instanceof DartLibraryDirective)) continue;
                        foundLibraryDirective = true;
                        break;
                    }
                    if (foundLibraryDirective) continue;
                    LibraryNode info = null;
                    for (LibraryNode importPath : lib.getImportPaths()) {
                        if (!importPath.getText().equals(importedLib.getSelfSourcePath().getText())) continue;
                        info = importPath;
                        break;
                    }
                    if (info == null) continue;
                    this.context.onError(new DartCompilationError(info, (ErrorCode)DartCompilerErrorCode.MISSING_LIBRARY_DIRECTIVE, unit.getSource().getRelativePath()));
                }
                for (DartUnit unit : lib.getUnits()) {
                    if (unit.isDiet() || unit.getDirectives().size() <= 0) continue;
                    for (LibraryNode sourceNode : lib.getSourcePaths()) {
                        if (sourceNode == lib.getSelfSourcePath() || !unit.getSource().getRelativePath().equals(sourceNode.getText())) continue;
                        this.context.onError(new DartCompilationError(unit.getDirectives().get(0), (ErrorCode)DartCompilerErrorCode.ILLEGAL_DIRECTIVES_IN_SOURCED_UNIT, unit.getSource().getRelativePath()));
                    }
                }
            }
        }

        private void setEntryPoint() {
            LibraryUnit lib = this.context.getAppLibraryUnit();
            lib.setEntryNode(new LibraryNode(DartCompiler.MAIN_ENTRY_POINT_NAME));
            Element element = lib.getElement().lookupLocalElement(DartCompiler.MAIN_ENTRY_POINT_NAME);
            switch (ElementKind.of(element)) {
                case NONE: {
                    break;
                }
                case METHOD: {
                    MethodElement methodElement = (MethodElement)element;
                    Modifiers modifiers = methodElement.getModifiers();
                    if (modifiers.isGetter()) {
                        this.context.onError(new DartCompilationError(element.getNode(), (ErrorCode)DartCompilerErrorCode.ENTRY_POINT_METHOD_MAY_NOT_BE_GETTER, DartCompiler.MAIN_ENTRY_POINT_NAME));
                        break;
                    }
                    if (modifiers.isSetter()) {
                        this.context.onError(new DartCompilationError(element.getNode(), (ErrorCode)DartCompilerErrorCode.ENTRY_POINT_METHOD_MAY_NOT_BE_SETTER, DartCompiler.MAIN_ENTRY_POINT_NAME));
                        break;
                    }
                    if (methodElement.getParameters().size() > 0) {
                        this.context.onError(new DartCompilationError(element.getNode(), (ErrorCode)DartCompilerErrorCode.ENTRY_POINT_METHOD_CANNOT_HAVE_PARAMETERS, DartCompiler.MAIN_ENTRY_POINT_NAME));
                        break;
                    }
                    lib.getElement().setEntryPoint(methodElement);
                    break;
                }
                default: {
                    this.context.onError(new DartCompilationError(element.getNode(), (ErrorCode)ResolverErrorCode.NOT_A_STATIC_METHOD, DartCompiler.MAIN_ENTRY_POINT_NAME));
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void compileLibraries() throws IOException {
            Tracer.TraceEvent logEvent = Tracer.canTrace() ? Tracer.start(DartEventType.COMPILE_LIBRARIES, new String[0]) : null;
            CompilerMetrics compilerMetrics = this.context.getCompilerMetrics();
            if (compilerMetrics != null) {
                compilerMetrics.startCompileLibrariesTime();
            }
            try {
                this.setEntryPoint();
                BaseASTWriter astWriter = ASTWriterFactory.create(this.config);
                CoverageInstrumenter coverageInstrumenter = CoverageInstrumenter.createInstance(this.config);
                coverageInstrumenter.process(this.libraries);
                for (LibraryUnit lib : this.libraries.values()) {
                    boolean persist = false;
                    for (DartUnit unit : lib.getUnits()) {
                        astWriter.process(unit);
                        if (unit.isDiet()) continue;
                        for (DartCompilationPhase phase : this.phases) {
                            Tracer.TraceEvent phaseEvent = Tracer.canTrace() ? Tracer.start(DartEventType.EXEC_PHASE, "phase", phase.getClass().getCanonicalName(), "lib", lib.getName(), "unit", unit.getSourceName()) : null;
                            try {
                                unit = phase.exec(unit, this.context, this.getTypeProvider());
                            }
                            finally {
                                Tracer.end(phaseEvent, new String[0]);
                            }
                            if (this.context.getErrorCount() <= 0) continue;
                            this.packageApp = false;
                            return;
                        }
                        this.context.unitCompiled(unit);
                        if (this.checkOnly) continue;
                        for (Backend be : this.config.getBackends()) {
                            Tracer.TraceEvent backendEvent = Tracer.canTrace() ? Tracer.start(DartEventType.BACKEND_COMPILE, "be", be.getClass().getSimpleName(), "lib", lib.getName(), "unit", unit.getSourceName()) : null;
                            try {
                                be.compileUnit(unit, unit.getSource(), this.context, this.typeProvider);
                            }
                            finally {
                                Tracer.end(backendEvent, new String[0]);
                            }
                        }
                        lib.getDeps(this.context).update(unit, this.context);
                        persist = true;
                        this.packageApp = true;
                    }
                    if (!persist || this.checkOnly) continue;
                    lib.writeDeps(this.context);
                }
            }
            finally {
                if (compilerMetrics != null) {
                    compilerMetrics.endCompileLibrariesTime();
                }
                Tracer.end(logEvent, new String[0]);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private void packageApp() throws IOException {
            Tracer.TraceEvent logEvent = Tracer.canTrace() ? Tracer.start(DartEventType.PACKAGE_APP, new String[0]) : null;
            CompilerMetrics compilerMetrics = this.context.getCompilerMetrics();
            if (compilerMetrics != null) {
                compilerMetrics.startPackageAppTime();
            }
            try {
                if (!this.packageApp) return;
                if (this.context.getApplicationUnit().getEntryNode() == null && !this.collectComments) {
                    if (!this.config.expectEntryPoint()) return;
                    this.context.onError(new DartCompilationError((Source)this.context.getApplicationUnit().getSource(), DartScanner.Location.NONE, DartCompilerErrorCode.NO_ENTRY_POINT, new Object[0]));
                    return;
                }
                for (Backend be : this.backends) {
                    Tracer.TraceEvent backendEvent = Tracer.canTrace() ? Tracer.start(DartEventType.BACKEND_PACKAGE_APP, "be", be.getClass().getSimpleName()) : null;
                    try {
                        be.packageApp(this.app, this.libraries.values(), this.context, this.typeProvider);
                    }
                    catch (Throwable throwable) {
                        Tracer.end(backendEvent, new String[0]);
                        throw throwable;
                        return;
                    }
                    Tracer.end(backendEvent, new String[0]);
                }
            }
            finally {
                if (compilerMetrics != null) {
                    compilerMetrics.endPackageAppTime();
                }
                Tracer.end(logEvent, new String[0]);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        DartUnit parse(DartSource dartSrc, Set<String> libraryPrefixes) throws IOException {
            Tracer.TraceEvent parseEvent = Tracer.canTrace() ? Tracer.start(DartEventType.PARSE, "src", dartSrc.getName()) : null;
            CompilerMetrics compilerMetrics = this.context.getCompilerMetrics();
            long parseStart = compilerMetrics != null ? CompilerMetrics.getThreadTime() : 0L;
            Reader r = dartSrc.getSourceReader();
            boolean failed = true;
            try {
                DartParser parser;
                DartScannerParserContext parserContext;
                String srcCode;
                try {
                    srcCode = CharStreams.toString(r);
                    failed = false;
                }
                finally {
                    Closeables.close(r, failed);
                }
                if (this.collectComments) {
                    parserContext = CommentPreservingParser.createContext(dartSrc, srcCode, this.context, this.context.getCompilerMetrics());
                    parser = new CommentPreservingParser((ParserContext)parserContext, false);
                } else {
                    parserContext = new DartScannerParserContext(dartSrc, srcCode, this.context, this.context.getCompilerMetrics());
                    parser = new DartParser((ParserContext)parserContext, libraryPrefixes);
                }
                DartUnit unit = ((DartParser)parser).parseUnit(dartSrc);
                if (compilerMetrics != null) {
                    compilerMetrics.addParseTimeNano(CompilerMetrics.getThreadTime() - parseStart);
                }
                if (!this.config.resolveDespiteParseErrors() && this.context.getErrorCount() > 0) {
                    ASTWriterFactory.create(this.config).process(unit);
                    DartUnit dartUnit = null;
                    return dartUnit;
                }
                DartUnit dartUnit = unit;
                return dartUnit;
            }
            finally {
                Tracer.end(parseEvent, new String[0]);
            }
        }

        private void reportMissingSource(DartCompilerContext context, LibrarySource libSrc, LibraryNode libNode) {
            DartCompilationError event = new DartCompilationError(libNode, (ErrorCode)DartCompilerErrorCode.MISSING_SOURCE, libNode.getText());
            event.setSource(libSrc);
            context.onError(event);
        }

        private void reportImportError(DartCompilerContext context, LibrarySource libSrc, LibraryNode libNode) {
            DartCompilationError event = new DartCompilationError(libNode, (ErrorCode)DartCompilerErrorCode.COULD_NOT_PARSE_IMPORT, libNode.getText());
            event.setSource(libSrc);
            context.onError(event);
        }

        CoreTypeProvider getTypeProvider() {
            this.typeProvider.getClass();
            return this.typeProvider;
        }
    }

    private static class NamedPlaceHolderLibrarySource
    implements LibrarySource {
        private final String name;

        public NamedPlaceHolderLibrarySource(String name) {
            this.name = name;
        }

        @Override
        public boolean exists() {
            throw new AssertionError();
        }

        @Override
        public long getLastModified() {
            throw new AssertionError();
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public Reader getSourceReader() {
            throw new AssertionError();
        }

        @Override
        public URI getUri() {
            throw new AssertionError();
        }

        @Override
        public LibrarySource getImportFor(String relPath) {
            throw new AssertionError();
        }

        @Override
        public DartSource getSourceFor(String relPath) {
            throw new AssertionError();
        }
    }
}

