/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.internal.com.google.dart.compiler;

import org.jetbrains.jet.internal.com.google.dart.compiler.ErrorCode;
import org.jetbrains.jet.internal.com.google.dart.compiler.Source;
import org.jetbrains.jet.internal.com.google.dart.compiler.common.SourceInfo;
import org.jetbrains.jet.internal.com.google.dart.compiler.parser.DartScanner;

public class DartCompilationError {
    private int startPosition = 0;
    private int length = 0;
    private int lineNumber = -1;
    private int columnNumber = -1;
    private ErrorCode errorCode;
    private String message;
    private Source source;

    public DartCompilationError(Source source, ErrorCode errorCode, Object ... arguments) {
        this.source = source;
        this.errorCode = errorCode;
        this.message = String.format(errorCode.getMessage(), arguments);
    }

    public DartCompilationError(SourceInfo location, ErrorCode errorCode, Object ... arguments) {
        this.source = location.getSource();
        this.lineNumber = location.getSourceLine();
        this.columnNumber = location.getSourceColumn();
        this.startPosition = location.getSourceStart();
        this.length = location.getSourceLength();
        this.errorCode = errorCode;
        this.message = String.format(errorCode.getMessage(), arguments);
    }

    public DartCompilationError(Source source, DartScanner.Location location, ErrorCode errorCode, Object ... arguments) {
        this.source = source;
        this.errorCode = errorCode;
        this.message = String.format(errorCode.getMessage(), arguments);
        if (location != null) {
            DartScanner.Position end;
            DartScanner.Position begin = location.getBegin();
            if (begin != null) {
                this.startPosition = begin.getPos();
                this.lineNumber = begin.getLine();
                this.columnNumber = begin.getCol();
            }
            if ((end = location.getEnd()) != null) {
                this.length = end.getPos() - this.startPosition;
                if (this.length < 0) {
                    this.length = 0;
                }
            }
        }
    }

    public int getColumnNumber() {
        return this.columnNumber;
    }

    public ErrorCode getErrorCode() {
        return this.errorCode;
    }

    public int getLineNumber() {
        return this.lineNumber;
    }

    public String getMessage() {
        return this.message;
    }

    public Source getSource() {
        return this.source;
    }

    public int getStartPosition() {
        return this.startPosition;
    }

    public int getLength() {
        return this.length;
    }

    public int hashCode() {
        int hashCode = this.startPosition;
        hashCode ^= this.message != null ? this.message.hashCode() : 0;
        return hashCode ^= this.source != null ? this.source.getName().hashCode() : 0;
    }

    public void setSource(Source source) {
        this.source = source;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.source != null ? this.source.getName() : "<unknown source>");
        sb.append("(" + this.lineNumber + ":" + this.columnNumber + "): ");
        sb.append(this.message);
        return sb.toString();
    }
}

