/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.internal.com.google.dart.compiler;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.jet.internal.com.google.common.collect.Lists;
import org.jetbrains.jet.internal.com.google.dart.compiler.CompilerConfiguration;
import org.jetbrains.jet.internal.com.google.dart.runner.RunnerOptions;
import org.jetbrains.jet.internal.org.kohsuke.args4j.Argument;
import org.jetbrains.jet.internal.org.kohsuke.args4j.CmdLineException;
import org.jetbrains.jet.internal.org.kohsuke.args4j.CmdLineParser;
import org.jetbrains.jet.internal.org.kohsuke.args4j.Option;

public class CommandLineOptions {
    public static CmdLineParser parse(String[] args, CompilerOptions parsedOptions) throws CmdLineException {
        CmdLineParser cmdLineParser;
        boolean ignoreUnrecognized = false;
        for (String arg : args) {
            if (!arg.equals("--ignore-unrecognized-flags")) continue;
            ignoreUnrecognized = true;
            break;
        }
        if (!ignoreUnrecognized) {
            cmdLineParser = new CmdLineParser(parsedOptions);
            cmdLineParser.parseArgument(args);
            return cmdLineParser;
        }
        cmdLineParser = new CmdLineParser(parsedOptions);
        int len = args.length;
        for (int i = 0; i < len; ++i) {
            try {
                cmdLineParser.parseArgument(args);
                break;
            }
            catch (CmdLineException e) {
                String msg = e.getMessage();
                if (!e.getMessage().endsWith(" is not a valid option")) break;
                String option = msg.substring(1);
                int closeQuote = option.indexOf(34);
                option = option.substring(0, closeQuote);
                ArrayList<String> newArgs = Lists.newArrayList();
                for (String arg : args) {
                    if (arg.equals(option)) {
                        System.out.println("(Ignoring unrecognized flag: " + arg + ")");
                        continue;
                    }
                    newArgs.add(arg);
                }
                args = newArgs.toArray(new String[newArgs.size()]);
                cmdLineParser = new CmdLineParser(parsedOptions);
                continue;
            }
        }
        return cmdLineParser;
    }

    public static class DartRunnerOptions
    extends CompilerOptions
    implements RunnerOptions {
        @Option(name="--compile-only", usage="Compile but do not execute")
        private boolean compileOnly = false;
        @Option(name="--verbose", usage="Extra diagnostic output")
        private boolean verbose = false;
        @Option(name="--prof", usage="Enable profiling")
        private boolean prof;
        @Option(name="--rhino", usage="Use rhino as the javascript interpreter")
        private boolean rhino = false;

        @Override
        public boolean shouldCompileOnly() {
            return this.compileOnly;
        }

        @Override
        public boolean shouldProfile() {
            return this.prof;
        }

        @Override
        public boolean useRhino() {
            return this.rhino;
        }

        @Override
        public boolean verbose() {
            return this.verbose;
        }

        public void setVerbose(boolean value) {
            this.verbose = value;
        }
    }

    public static class CompilerOptions {
        @Option(name="--batch", aliases={"-batch"}, usage="Batch mode (for unit testing)")
        private boolean batch = false;
        @Option(name="--check-only", aliases={"-check-only"}, usage="Do not generate output, only analyze")
        private boolean checkOnly = false;
        @Option(name="--expose_core_impl", usage="Automatic import of dart:coreimpl library")
        private boolean exposeCoreImpl = false;
        @Option(name="--error_format", usage="Format errors as normal or machine")
        private String errorFormat = "";
        @Option(name="--enable_type_checks", usage="Generate runtime type checks")
        private boolean developerModeChecks = false;
        @Option(name="--disable-type-optimizations", usage="Turn off type optimizations\n (for debugging)")
        private boolean disableTypeOptimizations = false;
        @Option(name="--documentation-lib", aliases={"-documentation-lib"}, usage="Only generate docs for the\n given library")
        private String documentationLibrary = null;
        @Option(name="--documentation-out", aliases={"-documentation-out"}, usage="Directory to write documentation")
        private String documentationOutputDirectory = "out";
        @Option(name="--generate-documentation", aliases={"-generate-documentation"}, usage="Generate docs from source")
        private boolean generateDocumentation = false;
        @Option(name="--generate-isolate-stubs", aliases={"-generate-isolate-stubs"}, usage="Classes to generate stubs\n (comma-separated list)")
        private String generateIsolateStubs = null;
        @Option(name="--generate_source_maps", usage="Generate source maps")
        private boolean generateSourceMaps = false;
        @Option(name="--dump_ast_format", usage="Dump parse tree. Supported formats include console, text or dot")
        private String dumpAST = "";
        @Option(name="--coverage_type", usage="Add instrumentation probes for collecting coverage. Supported types include function, statement, branch and all")
        private String coverage = "";
        @Option(name="--human-readable-output", usage="Write human readable javascript")
        private boolean generateHumanReadableOutput = false;
        @Option(name="--ignore-unrecognized-flags", usage="Ignore unrecognized command line flags")
        private boolean ignoreUnrecognizedFlags = false;
        @Option(name="--isolate-stub-out", aliases={"-isolate-stub-out"}, usage="File to receive generated stub output")
        private String isolateStubOutputFile = null;
        @Option(name="--jvm-metrics-detail", usage="Display summary (default) or\n verbose metrics")
        private String jvmMetricDetail = "summary";
        @Option(name="--jvm-metrics-format", usage="Output metrics in tabular (default)\n or pretty format")
        private String jvmMetricFormat = "tabular";
        @Option(name="--jvm-metrics-type", usage="Comma-separated list to display:\n   all:  (default) all stat types\n   gc:   show garbage collection stats\n   mem:  show memory stats\n   jit:  show jit stats")
        private String jvmMetricType = "all";
        @Option(name="--noincremental", aliases={"-noincremental"}, usage="Disable incremental compilation")
        private boolean noincremental = false;
        private boolean optimize = false;
        @Option(name="--out", usage="Write generated JavaScript to a file")
        private File outputFilename = null;
        @Option(name="--work", aliases={"-out"}, usage="Directory to receive compiler output\n for future incremental builds")
        private File workDirectory = new File("out");
        @Option(name="--help", aliases={"-?", "-help"}, usage="Prints this help message")
        private boolean showHelp = false;
        @Option(name="--jvm-metrics", usage="Print jvm metrics at end of compile")
        private boolean showJvmMetrics = false;
        @Option(name="--metrics", usage="Print compilation metrics")
        private boolean showMetrics = false;
        @Option(name="--fatal-type-errors", aliases={"-fatal-type-errors"}, usage="Treat type errors as fatal")
        private boolean typeErrorsAreFatal = false;
        @Option(name="--fatal-warnings", aliases={"-Werror"}, usage="Treat non-type warnings as fatal")
        private boolean warningsAreFatal = false;
        @Argument
        private final List<String> sourceFiles = new ArrayList<String>();

        @Option(name="--optimize", aliases={"-optimize"}, usage="Produce optimized code")
        public void setOptimize(boolean optimize) {
            this.optimize = optimize;
        }

        public boolean checkOnly() {
            return this.checkOnly;
        }

        public boolean shouldExposeCoreImpl() {
            return this.exposeCoreImpl;
        }

        public boolean generateDocumentation() {
            return this.generateDocumentation;
        }

        public String getDocumentationLibrary() {
            return this.documentationLibrary;
        }

        public String getDocumentationOutputDirectory() {
            return this.documentationOutputDirectory;
        }

        public Set<String> getIsolateStubClasses() {
            HashSet<String> set = new HashSet<String>();
            if (this.generateIsolateStubs != null) {
                set.addAll(Arrays.asList(this.generateIsolateStubs.split(",")));
            }
            return set;
        }

        public String getIsolateStubOutputFile() {
            return this.isolateStubOutputFile;
        }

        public String getJvmMetricOptions() {
            if (!this.showJvmMetrics) {
                return null;
            }
            return this.jvmMetricDetail + ":" + this.jvmMetricFormat + ":" + this.jvmMetricType;
        }

        public List<String> getSourceFiles() {
            return this.sourceFiles;
        }

        public File getWorkDirectory() {
            return this.workDirectory;
        }

        public boolean ignoreUnrecognizedFlags() {
            return this.ignoreUnrecognizedFlags;
        }

        public boolean buildIncrementally() {
            return !this.noincremental;
        }

        public boolean shouldBatch() {
            return this.batch;
        }

        public boolean disableTypeOptimizations() {
            return this.disableTypeOptimizations;
        }

        public boolean generateSourceMaps() {
            return this.generateSourceMaps;
        }

        public boolean generateHumanReadableOutput() {
            return this.generateHumanReadableOutput;
        }

        public String dumpAST() {
            return this.dumpAST;
        }

        public String getCoverageType() {
            return this.coverage;
        }

        public File getOutputFilename() {
            return this.outputFilename;
        }

        public boolean shouldOptimize() {
            return this.optimize;
        }

        public boolean showHelp() {
            return this.showHelp;
        }

        public boolean showJvmMetrics() {
            return this.showJvmMetrics;
        }

        public boolean showMetrics() {
            return this.showMetrics;
        }

        public boolean typeErrorsAreFatal() {
            return this.typeErrorsAreFatal;
        }

        public boolean warningsAreFatal() {
            return this.warningsAreFatal;
        }

        public boolean developerModeChecks() {
            return this.developerModeChecks;
        }

        public CompilerConfiguration.ErrorFormat printErrorFormat() {
            String lowerError = this.errorFormat.toLowerCase();
            if ("machine".equals(lowerError)) {
                return CompilerConfiguration.ErrorFormat.MACHINE;
            }
            return CompilerConfiguration.ErrorFormat.NORMAL;
        }
    }
}

