/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.internal.com.google.common.collect;

import java.util.HashMap;
import java.util.Map;
import org.jetbrains.jet.internal.com.google.common.annotations.GwtCompatible;
import org.jetbrains.jet.internal.com.google.common.collect.AbstractBiMap;
import org.jetbrains.jet.internal.com.google.common.collect.Maps;

@GwtCompatible(emulated=true)
public final class HashBiMap<K, V>
extends AbstractBiMap<K, V> {
    public static <K, V> HashBiMap<K, V> create() {
        return new HashBiMap<K, V>();
    }

    public static <K, V> HashBiMap<K, V> create(int expectedSize) {
        return new HashBiMap<K, V>(expectedSize);
    }

    public static <K, V> HashBiMap<K, V> create(Map<? extends K, ? extends V> map) {
        HashBiMap<K, V> bimap = HashBiMap.create(map.size());
        bimap.putAll((Map)map);
        return bimap;
    }

    private HashBiMap() {
        super(new HashMap(), new HashMap());
    }

    private HashBiMap(int expectedSize) {
        super(Maps.newHashMapWithExpectedSize(expectedSize), Maps.newHashMapWithExpectedSize(expectedSize));
    }

    @Override
    public V put(K key, V value) {
        return super.put(key, value);
    }

    @Override
    public V forcePut(K key, V value) {
        return super.forcePut(key, value);
    }
}

