/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.internal.com.google.common.collect;

import java.util.EnumMap;
import java.util.Iterator;
import org.jetbrains.jet.internal.com.google.common.annotations.GwtCompatible;
import org.jetbrains.jet.internal.com.google.common.base.Preconditions;
import org.jetbrains.jet.internal.com.google.common.collect.AbstractMapBasedMultiset;
import org.jetbrains.jet.internal.com.google.common.collect.Iterables;
import org.jetbrains.jet.internal.com.google.common.collect.WellBehavedMap;

@GwtCompatible(emulated=true)
public final class EnumMultiset<E extends Enum<E>>
extends AbstractMapBasedMultiset<E> {
    private transient Class<E> type;

    public static <E extends Enum<E>> EnumMultiset<E> create(Class<E> type) {
        return new EnumMultiset<E>(type);
    }

    public static <E extends Enum<E>> EnumMultiset<E> create(Iterable<E> elements) {
        Iterator<E> iterator = elements.iterator();
        Preconditions.checkArgument(iterator.hasNext(), "EnumMultiset constructor passed empty Iterable");
        EnumMultiset multiset = new EnumMultiset(((Enum)iterator.next()).getDeclaringClass());
        Iterables.addAll(multiset, elements);
        return multiset;
    }

    private EnumMultiset(Class<E> type) {
        super(WellBehavedMap.wrap(new EnumMap(type)));
        this.type = type;
    }
}

