/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.internal.com.google.common.collect;

import java.util.EnumMap;
import java.util.Map;
import org.jetbrains.jet.internal.com.google.common.annotations.GwtCompatible;
import org.jetbrains.jet.internal.com.google.common.collect.AbstractBiMap;
import org.jetbrains.jet.internal.com.google.common.collect.EnumBiMap;
import org.jetbrains.jet.internal.com.google.common.collect.Maps;
import org.jetbrains.jet.internal.com.google.common.collect.WellBehavedMap;

@GwtCompatible(emulated=true)
public final class EnumHashBiMap<K extends Enum<K>, V>
extends AbstractBiMap<K, V> {
    private transient Class<K> keyType;

    public static <K extends Enum<K>, V> EnumHashBiMap<K, V> create(Class<K> keyType) {
        return new EnumHashBiMap<K, V>(keyType);
    }

    public static <K extends Enum<K>, V> EnumHashBiMap<K, V> create(Map<K, ? extends V> map) {
        EnumHashBiMap<K, V> bimap = EnumHashBiMap.create(EnumBiMap.inferKeyType(map));
        bimap.putAll((Map)map);
        return bimap;
    }

    private EnumHashBiMap(Class<K> keyType) {
        super(WellBehavedMap.wrap(new EnumMap(keyType)), Maps.newHashMapWithExpectedSize(((Enum[])keyType.getEnumConstants()).length));
        this.keyType = keyType;
    }

    @Override
    public V put(K key, V value) {
        return super.put(key, value);
    }

    @Override
    public V forcePut(K key, V value) {
        return super.forcePut(key, value);
    }

    public Class<K> keyType() {
        return this.keyType;
    }
}

