/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.internal.com.google.common.collect;

import java.util.Map;
import org.jetbrains.jet.internal.com.google.common.annotations.GwtCompatible;
import org.jetbrains.jet.internal.com.google.common.base.Preconditions;
import org.jetbrains.jet.internal.com.google.common.collect.ImmutableCollection;
import org.jetbrains.jet.internal.com.google.common.collect.ImmutableMap;
import org.jetbrains.jet.internal.com.google.common.collect.ImmutableSet;
import org.jetbrains.jet.internal.com.google.common.collect.ImmutableTable;
import org.jetbrains.jet.internal.com.google.common.collect.Table;

@GwtCompatible
final class EmptyImmutableTable
extends ImmutableTable<Object, Object, Object> {
    static final EmptyImmutableTable INSTANCE = new EmptyImmutableTable();

    private EmptyImmutableTable() {
    }

    @Override
    public int size() {
        return 0;
    }

    @Override
    public Object get(Object rowKey, Object columnKey) {
        return null;
    }

    @Override
    public boolean isEmpty() {
        return true;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof Table) {
            Table that = (Table)obj;
            return that.isEmpty();
        }
        return false;
    }

    @Override
    public int hashCode() {
        return 0;
    }

    @Override
    public ImmutableSet<Table.Cell<Object, Object, Object>> cellSet() {
        return ImmutableSet.of();
    }

    @Override
    public ImmutableMap<Object, Object> column(Object columnKey) {
        Preconditions.checkNotNull(columnKey);
        return ImmutableMap.of();
    }

    @Override
    public ImmutableSet<Object> columnKeySet() {
        return ImmutableSet.of();
    }

    @Override
    public ImmutableMap<Object, Map<Object, Object>> columnMap() {
        return ImmutableMap.of();
    }

    @Override
    public boolean contains(Object rowKey, Object columnKey) {
        return false;
    }

    @Override
    public boolean containsColumn(Object columnKey) {
        return false;
    }

    @Override
    public boolean containsRow(Object rowKey) {
        return false;
    }

    @Override
    public boolean containsValue(Object value) {
        return false;
    }

    @Override
    public ImmutableMap<Object, Object> row(Object rowKey) {
        Preconditions.checkNotNull(rowKey);
        return ImmutableMap.of();
    }

    @Override
    public ImmutableSet<Object> rowKeySet() {
        return ImmutableSet.of();
    }

    @Override
    public ImmutableMap<Object, Map<Object, Object>> rowMap() {
        return ImmutableMap.of();
    }

    @Override
    public String toString() {
        return "{}";
    }

    @Override
    public ImmutableCollection<Object> values() {
        return ImmutableSet.of();
    }
}

