/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.internal.com.google.common.collect;

import org.jetbrains.jet.internal.com.google.common.annotations.GwtCompatible;
import org.jetbrains.jet.internal.com.google.common.base.Preconditions;
import org.jetbrains.jet.internal.com.google.common.collect.BstAggregate;
import org.jetbrains.jet.internal.com.google.common.collect.BstBalancePolicy;
import org.jetbrains.jet.internal.com.google.common.collect.BstNode;
import org.jetbrains.jet.internal.com.google.common.collect.BstNodeFactory;
import org.jetbrains.jet.internal.com.google.common.collect.BstPath;
import org.jetbrains.jet.internal.com.google.common.collect.BstPathFactory;
import org.jetbrains.jet.internal.com.google.common.collect.BstSide;
import org.jetbrains.jet.internal.com.google.common.collect.GeneralRange;

@GwtCompatible
final class BstRangeOps {
    public static <K, N extends BstNode<K, N>> long totalInRange(BstAggregate<? super N> aggregate, GeneralRange<K> range, N root) {
        Preconditions.checkNotNull(aggregate);
        Preconditions.checkNotNull(range);
        if (root == null || range.isEmpty()) {
            return 0L;
        }
        long total = aggregate.treeValue(root);
        if (range.hasLowerBound()) {
            total -= BstRangeOps.totalBeyondRangeToSide(aggregate, range, BstSide.LEFT, root);
        }
        if (range.hasUpperBound()) {
            total -= BstRangeOps.totalBeyondRangeToSide(aggregate, range, BstSide.RIGHT, root);
        }
        return total;
    }

    private static <K, N extends BstNode<K, N>> long totalBeyondRangeToSide(BstAggregate<? super N> aggregate, GeneralRange<K> range, BstSide side, N root) {
        long accum = 0L;
        while (root != null) {
            if (BstRangeOps.beyond(range, root.getKey(), side)) {
                accum += (long)aggregate.entryValue(root);
                accum += aggregate.treeValue(root.childOrNull(side));
                root = root.childOrNull(side.other());
                continue;
            }
            root = root.childOrNull(side);
        }
        return accum;
    }

    public static <K, N extends BstNode<K, N>> N minusRange(GeneralRange<K> range, BstBalancePolicy<N> balancePolicy, BstNodeFactory<N> nodeFactory, N root) {
        Preconditions.checkNotNull(range);
        Preconditions.checkNotNull(balancePolicy);
        Preconditions.checkNotNull(nodeFactory);
        Object higher = range.hasUpperBound() ? (Object)BstRangeOps.subTreeBeyondRangeToSide(range, balancePolicy, nodeFactory, BstSide.RIGHT, root) : null;
        Object lower = range.hasLowerBound() ? (Object)BstRangeOps.subTreeBeyondRangeToSide(range, balancePolicy, nodeFactory, BstSide.LEFT, root) : null;
        return balancePolicy.combine(nodeFactory, lower, higher);
    }

    private static <K, N extends BstNode<K, N>> N subTreeBeyondRangeToSide(GeneralRange<K> range, BstBalancePolicy<N> balancePolicy, BstNodeFactory<N> nodeFactory, BstSide side, N root) {
        if (root == null) {
            return null;
        }
        if (BstRangeOps.beyond(range, root.getKey(), side)) {
            N left = root.childOrNull(BstSide.LEFT);
            N right = root.childOrNull(BstSide.RIGHT);
            switch (side) {
                case LEFT: {
                    right = BstRangeOps.subTreeBeyondRangeToSide(range, balancePolicy, nodeFactory, BstSide.LEFT, right);
                    break;
                }
                case RIGHT: {
                    left = BstRangeOps.subTreeBeyondRangeToSide(range, balancePolicy, nodeFactory, BstSide.RIGHT, left);
                    break;
                }
                default: {
                    throw new AssertionError();
                }
            }
            return balancePolicy.balance(nodeFactory, root, left, right);
        }
        return BstRangeOps.subTreeBeyondRangeToSide(range, balancePolicy, nodeFactory, side, root.childOrNull(side));
    }

    public static <K, N extends BstNode<K, N>, P extends BstPath<N, P>> P furthestPath(GeneralRange<K> range, BstSide side, BstPathFactory<N, P> pathFactory, N root) {
        Preconditions.checkNotNull(range);
        Preconditions.checkNotNull(pathFactory);
        Preconditions.checkNotNull(side);
        if (root == null) {
            return null;
        }
        P path = pathFactory.initialPath(root);
        return BstRangeOps.furthestPath(range, side, pathFactory, path);
    }

    private static <K, N extends BstNode<K, N>, P extends BstPath<N, P>> P furthestPath(GeneralRange<K> range, BstSide side, BstPathFactory<N, P> pathFactory, P currentPath) {
        N tip = currentPath.getTip();
        K tipKey = ((BstNode)tip).getKey();
        if (BstRangeOps.beyond(range, tipKey, side)) {
            if (((BstNode)tip).hasChild(side.other())) {
                currentPath = pathFactory.extension(currentPath, side.other());
                return BstRangeOps.furthestPath(range, side, pathFactory, currentPath);
            }
            return null;
        }
        if (((BstNode)tip).hasChild(side)) {
            P alphaPath = pathFactory.extension(currentPath, side);
            if ((alphaPath = BstRangeOps.furthestPath(range, side, pathFactory, alphaPath)) != null) {
                return alphaPath;
            }
        }
        return BstRangeOps.beyond(range, tipKey, side.other()) ? null : (P)currentPath;
    }

    public static <K> boolean beyond(GeneralRange<K> range, K key, BstSide side) {
        Preconditions.checkNotNull(range);
        switch (side) {
            case LEFT: {
                return range.tooLow(key);
            }
            case RIGHT: {
                return range.tooHigh(key);
            }
        }
        throw new AssertionError();
    }

    private BstRangeOps() {
    }
}

