/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.internal.com.google.common.collect;

import org.jetbrains.jet.internal.com.google.common.annotations.GwtCompatible;
import org.jetbrains.jet.internal.com.google.common.base.Preconditions;
import org.jetbrains.jet.internal.com.google.common.collect.BstBalancePolicy;
import org.jetbrains.jet.internal.com.google.common.collect.BstModifier;
import org.jetbrains.jet.internal.com.google.common.collect.BstNode;
import org.jetbrains.jet.internal.com.google.common.collect.BstNodeFactory;

@GwtCompatible
final class BstMutationRule<K, N extends BstNode<K, N>> {
    private final BstModifier<K, N> modifier;
    private final BstBalancePolicy<N> balancePolicy;
    private final BstNodeFactory<N> nodeFactory;

    public static <K, N extends BstNode<K, N>> BstMutationRule<K, N> createRule(BstModifier<K, N> modifier, BstBalancePolicy<N> balancePolicy, BstNodeFactory<N> nodeFactory) {
        return new BstMutationRule<K, N>(modifier, balancePolicy, nodeFactory);
    }

    private BstMutationRule(BstModifier<K, N> modifier, BstBalancePolicy<N> balancePolicy, BstNodeFactory<N> nodeFactory) {
        this.balancePolicy = Preconditions.checkNotNull(balancePolicy);
        this.nodeFactory = Preconditions.checkNotNull(nodeFactory);
        this.modifier = Preconditions.checkNotNull(modifier);
    }

    public BstModifier<K, N> getModifier() {
        return this.modifier;
    }

    public BstBalancePolicy<N> getBalancePolicy() {
        return this.balancePolicy;
    }

    public BstNodeFactory<N> getNodeFactory() {
        return this.nodeFactory;
    }
}

