/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.internal.com.google.common.collect;

import org.jetbrains.jet.internal.com.google.common.annotations.GwtCompatible;
import org.jetbrains.jet.internal.com.google.common.base.Preconditions;
import org.jetbrains.jet.internal.com.google.common.collect.BstNode;

@GwtCompatible
final class BstModificationResult<N extends BstNode<?, N>> {
    private final N originalTarget;
    private final N changedTarget;
    private final ModificationType type;

    static <N extends BstNode<?, N>> BstModificationResult<N> identity(N target) {
        return new BstModificationResult<N>(target, target, ModificationType.IDENTITY);
    }

    static <N extends BstNode<?, N>> BstModificationResult<N> rebuildingChange(N originalTarget, N changedTarget) {
        return new BstModificationResult<N>(originalTarget, changedTarget, ModificationType.REBUILDING_CHANGE);
    }

    static <N extends BstNode<?, N>> BstModificationResult<N> rebalancingChange(N originalTarget, N changedTarget) {
        return new BstModificationResult<N>(originalTarget, changedTarget, ModificationType.REBALANCING_CHANGE);
    }

    private BstModificationResult(N originalTarget, N changedTarget, ModificationType type) {
        this.originalTarget = originalTarget;
        this.changedTarget = changedTarget;
        this.type = Preconditions.checkNotNull(type);
    }

    N getOriginalTarget() {
        return this.originalTarget;
    }

    N getChangedTarget() {
        return this.changedTarget;
    }

    ModificationType getType() {
        return this.type;
    }

    static enum ModificationType {
        IDENTITY,
        REBUILDING_CHANGE,
        REBALANCING_CHANGE;

    }
}

