/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.internal.com.google.common.base;

import java.io.Serializable;
import org.jetbrains.jet.internal.com.google.common.annotations.Beta;
import org.jetbrains.jet.internal.com.google.common.annotations.GwtCompatible;
import org.jetbrains.jet.internal.com.google.common.base.Function;
import org.jetbrains.jet.internal.com.google.common.base.Preconditions;

@GwtCompatible
@Beta
public final class Enums {
    private Enums() {
    }

    public static <T extends Enum<T>> Function<String, T> valueOfFunction(Class<T> enumClass) {
        return new ValueOfFunction(enumClass);
    }

    private static final class ValueOfFunction<T extends Enum<T>>
    implements Serializable,
    Function<String, T> {
        private final Class<T> enumClass;

        private ValueOfFunction(Class<T> enumClass) {
            this.enumClass = Preconditions.checkNotNull(enumClass);
        }

        @Override
        public T apply(String value) {
            try {
                return Enum.valueOf(this.enumClass, value);
            }
            catch (IllegalArgumentException e) {
                return null;
            }
        }

        @Override
        public boolean equals(Object obj) {
            return obj instanceof ValueOfFunction && this.enumClass.equals(((ValueOfFunction)obj).enumClass);
        }

        public int hashCode() {
            return this.enumClass.hashCode();
        }

        public String toString() {
            return "Enums.valueOf(" + this.enumClass + ")";
        }
    }
}

