/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.di;

import javax.annotation.PreDestroy;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jet.internal.com.intellij.openapi.project.Project;
import org.jetbrains.jet.lang.resolve.AnnotationResolver;
import org.jetbrains.jet.lang.resolve.BindingTrace;
import org.jetbrains.jet.lang.resolve.DescriptorResolver;
import org.jetbrains.jet.lang.resolve.QualifiedExpressionResolver;
import org.jetbrains.jet.lang.resolve.TypeResolver;
import org.jetbrains.jet.lang.resolve.calls.CallResolver;
import org.jetbrains.jet.lang.resolve.calls.OverloadingConflictResolver;
import org.jetbrains.jet.lang.resolve.lazy.ResolveSession;
import org.jetbrains.jet.lang.resolve.lazy.ScopeProvider;
import org.jetbrains.jet.lang.types.expressions.ExpressionTypingServices;

public class InjectorForLazyResolve {
    private final Project project;
    private final ResolveSession resolveSession;
    private final BindingTrace bindingTrace;
    private DescriptorResolver descriptorResolver;
    private ExpressionTypingServices expressionTypingServices;
    private TypeResolver typeResolver;
    private ScopeProvider scopeProvider;
    private AnnotationResolver annotationResolver;
    private QualifiedExpressionResolver qualifiedExpressionResolver;
    private CallResolver callResolver;
    private OverloadingConflictResolver overloadingConflictResolver;

    public InjectorForLazyResolve(@NotNull Project project, @NotNull ResolveSession resolveSession, @NotNull BindingTrace bindingTrace) {
        this.project = project;
        this.resolveSession = resolveSession;
        this.bindingTrace = bindingTrace;
        this.descriptorResolver = new DescriptorResolver();
        this.expressionTypingServices = new ExpressionTypingServices();
        this.typeResolver = new TypeResolver();
        this.scopeProvider = new ScopeProvider(resolveSession);
        this.annotationResolver = new AnnotationResolver();
        this.qualifiedExpressionResolver = new QualifiedExpressionResolver();
        this.callResolver = new CallResolver();
        this.overloadingConflictResolver = new OverloadingConflictResolver();
        this.descriptorResolver.setAnnotationResolver(this.annotationResolver);
        this.descriptorResolver.setExpressionTypingServices(this.expressionTypingServices);
        this.descriptorResolver.setTypeResolver(this.typeResolver);
        this.expressionTypingServices.setCallResolver(this.callResolver);
        this.expressionTypingServices.setDescriptorResolver(this.descriptorResolver);
        this.expressionTypingServices.setProject(project);
        this.expressionTypingServices.setTypeResolver(this.typeResolver);
        this.typeResolver.setAnnotationResolver(this.annotationResolver);
        this.typeResolver.setDescriptorResolver(this.descriptorResolver);
        this.typeResolver.setQualifiedExpressionResolver(this.qualifiedExpressionResolver);
        this.annotationResolver.setCallResolver(this.callResolver);
        this.annotationResolver.setExpressionTypingServices(this.expressionTypingServices);
        this.callResolver.setDescriptorResolver(this.descriptorResolver);
        this.callResolver.setExpressionTypingServices(this.expressionTypingServices);
        this.callResolver.setOverloadingConflictResolver(this.overloadingConflictResolver);
        this.callResolver.setTypeResolver(this.typeResolver);
    }

    @PreDestroy
    public void destroy() {
    }

    public DescriptorResolver getDescriptorResolver() {
        return this.descriptorResolver;
    }

    public ExpressionTypingServices getExpressionTypingServices() {
        return this.expressionTypingServices;
    }

    public TypeResolver getTypeResolver() {
        return this.typeResolver;
    }

    public ScopeProvider getScopeProvider() {
        return this.scopeProvider;
    }

    public AnnotationResolver getAnnotationResolver() {
        return this.annotationResolver;
    }

    public QualifiedExpressionResolver getQualifiedExpressionResolver() {
        return this.qualifiedExpressionResolver;
    }
}

