/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.codegen.signature.kotlin;

import java.util.BitSet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jet.internal.org.objectweb.asm.AnnotationVisitor;
import org.jetbrains.jet.internal.org.objectweb.asm.MethodVisitor;
import org.jetbrains.jet.lang.resolve.java.JvmStdlibNames;

public class JetMethodAnnotationWriter {
    private final AnnotationVisitor av;

    private JetMethodAnnotationWriter(AnnotationVisitor av) {
        this.av = av;
    }

    public void writeFlags(int ... flagBits) {
        BitSet bitSet = new BitSet();
        for (int bit : flagBits) {
            bitSet.set(bit);
        }
        this.writeFlags(bitSet);
    }

    private void writeFlags(BitSet flags) {
        int flagsValue = 0;
        for (int bit = 0; bit < flags.length(); ++bit) {
            if (!flags.get(bit)) continue;
            flagsValue |= 1 << bit;
        }
        if (flagsValue != 0) {
            this.av.visit("flags", flagsValue);
        }
    }

    public void writeTypeParameters(@NotNull String typeParameters) {
        if (typeParameters.length() > 0) {
            this.av.visit("typeParameters", typeParameters);
        }
    }

    public void writeReturnType(@NotNull String returnType) {
        if (returnType.length() > 0) {
            this.av.visit("returnType", returnType);
        }
    }

    public void writePropertyType(@NotNull String propertyType) {
        if (propertyType.length() > 0) {
            this.av.visit("propertyType", propertyType);
        }
    }

    public void writeNullableReturnType(boolean nullableReturnType) {
        if (nullableReturnType) {
            this.av.visit("nullableReturnType", nullableReturnType);
        }
    }

    public void visitEnd() {
        this.av.visitEnd();
    }

    public static JetMethodAnnotationWriter visitAnnotation(MethodVisitor mv) {
        return new JetMethodAnnotationWriter(mv.visitAnnotation(JvmStdlibNames.JET_METHOD.getDescriptor(), true));
    }
}

