/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.codegen.signature;

import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.codegen.signature.JvmMethodParameterKind;
import org.jetbrains.jet.codegen.signature.JvmMethodParameterSignature;
import org.jetbrains.jet.internal.org.objectweb.asm.Type;
import org.jetbrains.jet.internal.org.objectweb.asm.commons.Method;

public class JvmMethodSignature {
    @NotNull
    private final Method asmMethod;
    private final String genericsSignature;
    private final String kotlinTypeParameter;
    @NotNull
    private final List<JvmMethodParameterSignature> kotlinParameterTypes;
    @NotNull
    private final String kotlinReturnType;
    private final boolean genericsAvailable;

    public JvmMethodSignature(@NotNull Method asmMethod, @Nullable String genericsSignature, @Nullable String kotlinTypeParameters, @NotNull List<JvmMethodParameterSignature> kotlinParameterTypes, @NotNull String kotlinReturnType) {
        this.asmMethod = asmMethod;
        this.genericsSignature = genericsSignature;
        this.kotlinTypeParameter = kotlinTypeParameters;
        this.kotlinParameterTypes = kotlinParameterTypes;
        this.kotlinReturnType = kotlinReturnType;
        this.genericsAvailable = true;
    }

    public JvmMethodSignature(@NotNull Method asmMethod, @NotNull List<JvmMethodParameterSignature> kotlinParameterTypes) {
        this.asmMethod = asmMethod;
        this.genericsSignature = null;
        this.kotlinTypeParameter = null;
        this.kotlinParameterTypes = kotlinParameterTypes;
        this.kotlinReturnType = "";
        this.genericsAvailable = false;
    }

    public static JvmMethodSignature simple(@NotNull String methodName, @NotNull Type returnType, @NotNull List<JvmMethodParameterSignature> parameterSignatures) {
        return new JvmMethodSignature(new Method(methodName, returnType, JvmMethodSignature.getTypes(parameterSignatures).toArray(new Type[0])), parameterSignatures);
    }

    @NotNull
    private static List<Type> getTypes(@NotNull List<JvmMethodParameterSignature> signatures) {
        ArrayList<Type> r = new ArrayList<Type>(signatures.size());
        for (JvmMethodParameterSignature signature : signatures) {
            r.add(signature.getAsmType());
        }
        return r;
    }

    private void checkGenericsAvailable() {
        if (!this.genericsAvailable) {
            // empty if block
        }
    }

    @NotNull
    public Method getAsmMethod() {
        return this.asmMethod;
    }

    public String getGenericsSignature() {
        this.checkGenericsAvailable();
        return this.genericsSignature;
    }

    public String getKotlinTypeParameter() {
        this.checkGenericsAvailable();
        return this.kotlinTypeParameter;
    }

    @Nullable
    public List<JvmMethodParameterSignature> getKotlinParameterTypes() {
        this.checkGenericsAvailable();
        return this.kotlinParameterTypes;
    }

    public int getParameterCount() {
        return this.asmMethod.getArgumentTypes().length;
    }

    @NotNull
    public String getKotlinParameterType(int i) {
        this.checkGenericsAvailable();
        if (this.kotlinParameterTypes == null) {
            return "";
        }
        return this.kotlinParameterTypes.get(i).getKotlinSignature();
    }

    @NotNull
    public String getKotlinReturnType() {
        this.checkGenericsAvailable();
        return this.kotlinReturnType;
    }

    public List<Type> getValueParameterTypes() {
        ArrayList<Type> r = new ArrayList<Type>(this.kotlinParameterTypes.size());
        for (JvmMethodParameterSignature p : this.kotlinParameterTypes) {
            if (p.getKind() != JvmMethodParameterKind.VALUE) continue;
            r.add(p.getAsmType());
        }
        return r;
    }

    @NotNull
    public String getName() {
        return this.asmMethod.getName();
    }
}

