/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.codegen.intrinsics;

import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jet.codegen.CallableMethod;
import org.jetbrains.jet.codegen.ExpressionCodegen;
import org.jetbrains.jet.codegen.GenerationState;
import org.jetbrains.jet.codegen.OwnerKind;
import org.jetbrains.jet.codegen.StackValue;
import org.jetbrains.jet.codegen.intrinsics.IntrinsicMethod;
import org.jetbrains.jet.internal.com.intellij.psi.PsiElement;
import org.jetbrains.jet.internal.org.objectweb.asm.Type;
import org.jetbrains.jet.internal.org.objectweb.asm.commons.InstructionAdapter;
import org.jetbrains.jet.lang.descriptors.SimpleFunctionDescriptor;
import org.jetbrains.jet.lang.psi.JetCallExpression;
import org.jetbrains.jet.lang.psi.JetExpression;

public class PsiMethodCall
implements IntrinsicMethod {
    private final SimpleFunctionDescriptor myMethod;

    public PsiMethodCall(SimpleFunctionDescriptor method) {
        this.myMethod = method;
    }

    @Override
    public StackValue generate(ExpressionCodegen codegen, InstructionAdapter v, @NotNull Type expectedType, PsiElement element, List<JetExpression> arguments, StackValue receiver, @NotNull GenerationState state) {
        CallableMethod callableMethod = state.getInjector().getJetTypeMapper().mapToCallableMethod(this.myMethod, false, OwnerKind.IMPLEMENTATION);
        codegen.invokeMethodWithArguments(callableMethod, (JetCallExpression)element, receiver);
        return StackValue.onStack(callableMethod.getSignature().getAsmMethod().getReturnType());
    }
}

