/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.codegen.intrinsics;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.PostConstruct;
import org.jetbrains.jet.codegen.intrinsics.ArrayGet;
import org.jetbrains.jet.codegen.intrinsics.ArrayIndices;
import org.jetbrains.jet.codegen.intrinsics.ArrayIterator;
import org.jetbrains.jet.codegen.intrinsics.ArraySet;
import org.jetbrains.jet.codegen.intrinsics.ArraySize;
import org.jetbrains.jet.codegen.intrinsics.BinaryOp;
import org.jetbrains.jet.codegen.intrinsics.CompareTo;
import org.jetbrains.jet.codegen.intrinsics.Concat;
import org.jetbrains.jet.codegen.intrinsics.Equals;
import org.jetbrains.jet.codegen.intrinsics.IdentityEquals;
import org.jetbrains.jet.codegen.intrinsics.Increment;
import org.jetbrains.jet.codegen.intrinsics.IntrinsicMethod;
import org.jetbrains.jet.codegen.intrinsics.Inv;
import org.jetbrains.jet.codegen.intrinsics.IteratorIterator;
import org.jetbrains.jet.codegen.intrinsics.IteratorNext;
import org.jetbrains.jet.codegen.intrinsics.JavaClassArray;
import org.jetbrains.jet.codegen.intrinsics.JavaClassFunction;
import org.jetbrains.jet.codegen.intrinsics.JavaClassProperty;
import org.jetbrains.jet.codegen.intrinsics.NewArray;
import org.jetbrains.jet.codegen.intrinsics.Not;
import org.jetbrains.jet.codegen.intrinsics.NumberCast;
import org.jetbrains.jet.codegen.intrinsics.PsiMethodCall;
import org.jetbrains.jet.codegen.intrinsics.StringGetChar;
import org.jetbrains.jet.codegen.intrinsics.StringLength;
import org.jetbrains.jet.codegen.intrinsics.StringPlus;
import org.jetbrains.jet.codegen.intrinsics.StupidSync;
import org.jetbrains.jet.codegen.intrinsics.Sure;
import org.jetbrains.jet.codegen.intrinsics.ToString;
import org.jetbrains.jet.codegen.intrinsics.UnaryMinus;
import org.jetbrains.jet.codegen.intrinsics.UnaryPlus;
import org.jetbrains.jet.codegen.intrinsics.UpTo;
import org.jetbrains.jet.internal.com.google.common.collect.ImmutableList;
import org.jetbrains.jet.internal.com.intellij.openapi.project.Project;
import org.jetbrains.jet.internal.com.intellij.openapi.vfs.VirtualFile;
import org.jetbrains.jet.internal.com.intellij.psi.JavaPsiFacade;
import org.jetbrains.jet.internal.com.intellij.psi.PsiClass;
import org.jetbrains.jet.internal.com.intellij.psi.PsiMethod;
import org.jetbrains.jet.internal.com.intellij.psi.search.DelegatingGlobalSearchScope;
import org.jetbrains.jet.internal.com.intellij.psi.search.ProjectScope;
import org.jetbrains.jet.internal.javax.inject.Inject;
import org.jetbrains.jet.lang.descriptors.ClassDescriptor;
import org.jetbrains.jet.lang.descriptors.DeclarationDescriptor;
import org.jetbrains.jet.lang.descriptors.FunctionDescriptor;
import org.jetbrains.jet.lang.descriptors.SimpleFunctionDescriptor;
import org.jetbrains.jet.lang.descriptors.TypeParameterDescriptor;
import org.jetbrains.jet.lang.descriptors.VariableDescriptor;
import org.jetbrains.jet.lang.descriptors.annotations.AnnotationDescriptor;
import org.jetbrains.jet.lang.resolve.java.JvmPrimitiveType;
import org.jetbrains.jet.lang.resolve.name.Name;
import org.jetbrains.jet.lang.resolve.scopes.JetScope;
import org.jetbrains.jet.lang.types.TypeProjection;
import org.jetbrains.jet.lang.types.expressions.OperatorConventions;
import org.jetbrains.jet.lang.types.lang.JetStandardClasses;
import org.jetbrains.jet.lang.types.lang.JetStandardLibrary;
import org.jetbrains.jet.lang.types.lang.PrimitiveType;
import org.jetbrains.jet.plugin.JetFileType;

public class IntrinsicMethods {
    private static final IntrinsicMethod UNARY_MINUS = new UnaryMinus();
    private static final IntrinsicMethod UNARY_PLUS = new UnaryPlus();
    private static final IntrinsicMethod NUMBER_CAST = new NumberCast();
    private static final IntrinsicMethod INV = new Inv();
    private static final IntrinsicMethod UP_TO = new UpTo(true);
    private static final IntrinsicMethod DOWN_TO = new UpTo(false);
    private static final IntrinsicMethod INC = new Increment(1);
    private static final IntrinsicMethod DEC = new Increment(-1);
    private static final List<Name> PRIMITIVE_TYPES = ImmutableList.of(Name.identifier("Boolean"), Name.identifier("Byte"), Name.identifier("Char"), Name.identifier("Short"), Name.identifier("Int"), Name.identifier("Float"), Name.identifier("Long"), Name.identifier("Double"));
    private static final List<Name> PRIMITIVE_NUMBER_TYPES = ImmutableList.of(Name.identifier("Byte"), Name.identifier("Char"), Name.identifier("Short"), Name.identifier("Int"), Name.identifier("Float"), Name.identifier("Long"), Name.identifier("Double"));
    public static final IntrinsicMethod ARRAY_SIZE = new ArraySize();
    public static final IntrinsicMethod ARRAY_INDICES = new ArrayIndices();
    public static final Equals EQUALS = new Equals();
    public static final IdentityEquals IDENTITY_EQUALS = new IdentityEquals();
    public static final IteratorNext ITERATOR_NEXT = new IteratorNext();
    public static final ArraySet ARRAY_SET = new ArraySet();
    public static final ArrayGet ARRAY_GET = new ArrayGet();
    public static final StringPlus STRING_PLUS = new StringPlus();
    public static final String KOTLIN_JAVA_CLASS_FUNCTION = "kotlin.javaClass.function";
    public static final String KOTLIN_ARRAYS_ARRAY = "kotlin.arrays.array";
    public static final String KOTLIN_JAVA_CLASS_PROPERTY = "kotlin.javaClass.property";
    private Project myProject;
    private JetStandardLibrary myStdLib;
    private final Map<DeclarationDescriptor, IntrinsicMethod> myMethods = new HashMap<DeclarationDescriptor, IntrinsicMethod>();
    private final Map<String, IntrinsicMethod> namedMethods = new HashMap<String, IntrinsicMethod>();
    private static final IntrinsicMethod ARRAY_ITERATOR = new ArrayIterator();

    @Inject
    public void setMyProject(Project myProject) {
        this.myProject = myProject;
    }

    @Inject
    public void setMyStdLib(JetStandardLibrary myStdLib) {
        this.myStdLib = myStdLib;
    }

    @PostConstruct
    public void init() {
        this.namedMethods.put(KOTLIN_JAVA_CLASS_FUNCTION, new JavaClassFunction());
        this.namedMethods.put(KOTLIN_JAVA_CLASS_PROPERTY, new JavaClassProperty());
        this.namedMethods.put(KOTLIN_ARRAYS_ARRAY, new JavaClassArray());
        ImmutableList primitiveCastMethods = OperatorConventions.NUMBER_CONVERSIONS.asList();
        for (Name method : primitiveCastMethods) {
            this.declareIntrinsicFunction(Name.identifier("Number"), method, 0, NUMBER_CAST, true);
            for (Name type : PRIMITIVE_NUMBER_TYPES) {
                this.declareIntrinsicFunction(type, method, 0, NUMBER_CAST, true);
            }
        }
        for (Name type : PRIMITIVE_NUMBER_TYPES) {
            this.declareIntrinsicFunction(type, Name.identifier("plus"), 0, UNARY_PLUS, false);
            this.declareIntrinsicFunction(type, Name.identifier("minus"), 0, UNARY_MINUS, false);
            this.declareIntrinsicFunction(type, Name.identifier("inv"), 0, INV, false);
            this.declareIntrinsicFunction(type, Name.identifier("rangeTo"), 1, UP_TO, false);
            this.declareIntrinsicFunction(type, Name.identifier("upto"), 1, UP_TO, false);
            this.declareIntrinsicFunction(type, Name.identifier("downto"), 1, DOWN_TO, false);
            this.declareIntrinsicFunction(type, Name.identifier("inc"), 0, INC, false);
            this.declareIntrinsicFunction(type, Name.identifier("dec"), 0, DEC, false);
        }
        this.declareBinaryOp(Name.identifier("plus"), 96);
        this.declareBinaryOp(Name.identifier("minus"), 100);
        this.declareBinaryOp(Name.identifier("times"), 104);
        this.declareBinaryOp(Name.identifier("div"), 108);
        this.declareBinaryOp(Name.identifier("mod"), 112);
        this.declareBinaryOp(Name.identifier("shl"), 120);
        this.declareBinaryOp(Name.identifier("shr"), 122);
        this.declareBinaryOp(Name.identifier("ushr"), 124);
        this.declareBinaryOp(Name.identifier("and"), 126);
        this.declareBinaryOp(Name.identifier("or"), 128);
        this.declareBinaryOp(Name.identifier("xor"), 130);
        this.declareIntrinsicFunction(Name.identifier("Boolean"), Name.identifier("not"), 0, new Not(), true);
        this.declareIntrinsicFunction(Name.identifier("String"), Name.identifier("plus"), 1, new Concat(), true);
        this.declareIntrinsicFunction(Name.identifier("CharSequence"), Name.identifier("get"), 1, new StringGetChar(), true);
        this.declareIntrinsicFunction(Name.identifier("String"), Name.identifier("get"), 1, new StringGetChar(), true);
        this.declareOverload(this.myStdLib.getLibraryScope().getFunctions(Name.identifier("toString")), 0, new ToString());
        this.declareOverload(this.myStdLib.getLibraryScope().getFunctions(Name.identifier("equals")), 1, EQUALS);
        this.declareOverload(this.myStdLib.getLibraryScope().getFunctions(Name.identifier("identityEquals")), 1, IDENTITY_EQUALS);
        this.declareOverload(this.myStdLib.getLibraryScope().getFunctions(Name.identifier("plus")), 1, STRING_PLUS);
        this.declareOverload(this.myStdLib.getLibraryScope().getFunctions(Name.identifier("arrayOfNulls")), 1, new NewArray());
        this.declareOverload(this.myStdLib.getLibraryScope().getFunctions(Name.identifier("sure")), 0, new Sure());
        this.declareOverload(this.myStdLib.getLibraryScope().getFunctions(Name.identifier("synchronized")), 2, new StupidSync());
        this.declareOverload(this.myStdLib.getLibraryScope().getFunctions(Name.identifier("iterator")), 0, new IteratorIterator());
        this.declareIntrinsicFunction(Name.identifier("ByteIterator"), Name.identifier("next"), 0, ITERATOR_NEXT, false);
        this.declareIntrinsicFunction(Name.identifier("ShortIterator"), Name.identifier("next"), 0, ITERATOR_NEXT, false);
        this.declareIntrinsicFunction(Name.identifier("IntIterator"), Name.identifier("next"), 0, ITERATOR_NEXT, false);
        this.declareIntrinsicFunction(Name.identifier("LongIterator"), Name.identifier("next"), 0, ITERATOR_NEXT, false);
        this.declareIntrinsicFunction(Name.identifier("CharIterator"), Name.identifier("next"), 0, ITERATOR_NEXT, false);
        this.declareIntrinsicFunction(Name.identifier("BooleanIterator"), Name.identifier("next"), 0, ITERATOR_NEXT, false);
        this.declareIntrinsicFunction(Name.identifier("FloatIterator"), Name.identifier("next"), 0, ITERATOR_NEXT, false);
        this.declareIntrinsicFunction(Name.identifier("DoubleIterator"), Name.identifier("next"), 0, ITERATOR_NEXT, false);
        for (Name type : PRIMITIVE_TYPES) {
            this.declareIntrinsicFunction(type, Name.identifier("compareTo"), 1, new CompareTo(), false);
        }
        this.declareIntrinsicStringMethods();
        this.declareIntrinsicProperty(Name.identifier("CharSequence"), Name.identifier("length"), new StringLength());
        this.declareIntrinsicProperty(Name.identifier("String"), Name.identifier("length"), new StringLength());
        this.declareArrayMethods();
    }

    private void declareArrayMethods() {
        for (JvmPrimitiveType jvmPrimitiveType : JvmPrimitiveType.values()) {
            this.declareArrayMethodsForPrimitive(jvmPrimitiveType);
        }
        this.declareIntrinsicProperty(Name.identifier("Array"), Name.identifier("size"), ARRAY_SIZE);
        this.declareIntrinsicProperty(Name.identifier("Array"), Name.identifier("indices"), ARRAY_INDICES);
        this.declareIntrinsicFunction(Name.identifier("Array"), Name.identifier("set"), 2, ARRAY_SET, true);
        this.declareIntrinsicFunction(Name.identifier("Array"), Name.identifier("get"), 1, ARRAY_GET, true);
        this.declareIterator(this.myStdLib.getArray());
    }

    private void declareArrayMethodsForPrimitive(JvmPrimitiveType jvmPrimitiveType) {
        PrimitiveType primitiveType = jvmPrimitiveType.getPrimitiveType();
        this.declareIntrinsicProperty(primitiveType.getArrayTypeName(), Name.identifier("size"), ARRAY_SIZE);
        this.declareIntrinsicProperty(primitiveType.getArrayTypeName(), Name.identifier("indices"), ARRAY_INDICES);
        this.declareIntrinsicFunction(primitiveType.getArrayTypeName(), Name.identifier("set"), 2, ARRAY_SET, true);
        this.declareIntrinsicFunction(primitiveType.getArrayTypeName(), Name.identifier("get"), 1, ARRAY_GET, true);
        this.declareIterator(this.myStdLib.getPrimitiveArrayClassDescriptor(primitiveType));
    }

    private void declareIterator(ClassDescriptor classDescriptor) {
        this.declareOverload(classDescriptor.getDefaultType().getMemberScope().getFunctions(Name.identifier("iterator")), 0, ARRAY_ITERATOR);
    }

    private void declareIntrinsicStringMethods() {
        ClassDescriptor stringClass = this.myStdLib.getString();
        Collection<DeclarationDescriptor> stringMembers = stringClass.getMemberScope(Collections.<TypeProjection>emptyList()).getAllDescriptors();
        PsiClass stringPsiClass = JavaPsiFacade.getInstance(this.myProject).findClass("java.lang.String", new DelegatingGlobalSearchScope(ProjectScope.getLibrariesScope(this.myProject)){

            @Override
            public boolean contains(VirtualFile file) {
                return this.myBaseScope.contains(file) && file.getFileType() != JetFileType.INSTANCE;
            }
        });
        for (DeclarationDescriptor stringMember : stringMembers) {
            PsiMethod[] methods;
            if (!(stringMember instanceof SimpleFunctionDescriptor)) continue;
            SimpleFunctionDescriptor stringMethod = (SimpleFunctionDescriptor)stringMember;
            for (PsiMethod method : methods = stringPsiClass != null ? stringPsiClass.findMethodsByName(stringMember.getName().getName(), false) : new PsiMethod[]{}) {
                if (method.getParameterList().getParametersCount() != stringMethod.getValueParameters().size()) continue;
                this.myMethods.put(stringMethod, new PsiMethodCall(stringMethod));
            }
        }
    }

    private void declareBinaryOp(Name methodName, int opcode) {
        BinaryOp op = new BinaryOp(opcode);
        for (Name type : PRIMITIVE_TYPES) {
            this.declareIntrinsicFunction(type, methodName, 1, op, false);
        }
    }

    private void declareIntrinsicProperty(Name className, Name methodName, IntrinsicMethod implementation) {
        JetScope numberScope = this.getClassMemberScope(className);
        Set<VariableDescriptor> properties = numberScope.getProperties(methodName);
        assert (properties.size() == 1);
        VariableDescriptor property = properties.iterator().next();
        this.myMethods.put(property.getOriginal(), implementation);
    }

    private void declareIntrinsicFunction(Name className, Name functionName, int arity, IntrinsicMethod implementation, boolean original) {
        JetScope memberScope = this.getClassMemberScope(className);
        Set<FunctionDescriptor> group = memberScope.getFunctions(functionName);
        for (FunctionDescriptor descriptor : group) {
            if (!className.equals(descriptor.getContainingDeclaration().getName()) || descriptor.getValueParameters().size() != arity) continue;
            this.myMethods.put(original ? descriptor.getOriginal() : descriptor, implementation);
        }
    }

    private void declareOverload(Set<FunctionDescriptor> group, int arity, IntrinsicMethod implementation) {
        for (FunctionDescriptor descriptor : group) {
            if (descriptor.getValueParameters().size() != arity) continue;
            this.myMethods.put(descriptor.getOriginal(), implementation);
        }
    }

    private JetScope getClassMemberScope(Name className) {
        ClassDescriptor descriptor = (ClassDescriptor)this.myStdLib.getLibraryScope().getClassifier(className);
        List<TypeParameterDescriptor> typeParameterDescriptors = descriptor.getTypeConstructor().getParameters();
        ArrayList<TypeProjection> typeParameters = new ArrayList<TypeProjection>();
        for (TypeParameterDescriptor typeParameterDescriptor : typeParameterDescriptors) {
            typeParameters.add(new TypeProjection(JetStandardClasses.getAnyType()));
        }
        return descriptor.getMemberScope(typeParameters);
    }

    public IntrinsicMethod isIntrinsicMethod(DeclarationDescriptor descriptor) {
        List<AnnotationDescriptor> annotations = descriptor.getAnnotations();
        if (annotations != null) {
            for (AnnotationDescriptor annotation : annotations) {
                String value;
                IntrinsicMethod intrinsicMethod;
                if (!"Intrinsic".equals(annotation.getType().getConstructor().getDeclarationDescriptor().getName().getName()) || (intrinsicMethod = this.namedMethods.get(value = (String)annotation.getValueArguments().get(0).getValue())) == null) continue;
                return intrinsicMethod;
            }
        }
        return null;
    }

    public IntrinsicMethod getIntrinsic(DeclarationDescriptor descriptor) {
        IntrinsicMethod intrinsicMethod;
        block1: {
            List<AnnotationDescriptor> annotations;
            intrinsicMethod = this.myMethods.get(descriptor.getOriginal());
            if (intrinsicMethod != null || (annotations = descriptor.getAnnotations()) == null) break block1;
            for (AnnotationDescriptor annotation : annotations) {
                String value;
                if ("Intrinsic".equals(annotation.getType().getConstructor().getDeclarationDescriptor().getName().getName()) && (intrinsicMethod = this.namedMethods.get(value = (String)annotation.getValueArguments().get(0).getValue())) != null) break;
            }
        }
        return intrinsicMethod;
    }
}

