/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.codegen.intrinsics;

import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jet.codegen.ExpressionCodegen;
import org.jetbrains.jet.codegen.GenerationState;
import org.jetbrains.jet.codegen.JetTypeMapper;
import org.jetbrains.jet.codegen.StackValue;
import org.jetbrains.jet.codegen.intrinsics.IntrinsicMethod;
import org.jetbrains.jet.internal.com.intellij.psi.PsiElement;
import org.jetbrains.jet.internal.org.objectweb.asm.Type;
import org.jetbrains.jet.internal.org.objectweb.asm.commons.InstructionAdapter;
import org.jetbrains.jet.lang.psi.JetExpression;
import org.jetbrains.jet.lang.psi.JetParenthesizedExpression;
import org.jetbrains.jet.lang.psi.JetReferenceExpression;

public class Increment
implements IntrinsicMethod {
    private final int myDelta;

    public Increment(int delta) {
        this.myDelta = delta;
    }

    @Override
    public StackValue generate(ExpressionCodegen codegen, InstructionAdapter v, @NotNull Type expectedType, PsiElement element, List<JetExpression> arguments, StackValue receiver, @NotNull GenerationState state) {
        boolean nullable;
        boolean bl = nullable = expectedType.getSort() == 10;
        if (nullable) {
            expectedType = JetTypeMapper.unboxType(expectedType);
        }
        if (arguments.size() > 0) {
            int index;
            JetExpression operand = arguments.get(0);
            while (operand instanceof JetParenthesizedExpression) {
                operand = ((JetParenthesizedExpression)operand).getExpression();
            }
            if (operand instanceof JetReferenceExpression && (index = codegen.indexOfLocal((JetReferenceExpression)operand)) >= 0 && JetTypeMapper.isIntPrimitive(expectedType)) {
                return StackValue.preIncrement(index, this.myDelta);
            }
            StackValue value = codegen.genQualified(receiver, operand);
            value.dupReceiver(v);
            value.dupReceiver(v);
            value.put(expectedType, v);
            this.plusMinus(v, expectedType);
            value.store(expectedType, v);
            value.put(expectedType, v);
        } else {
            receiver.put(expectedType, v);
            this.plusMinus(v, expectedType);
        }
        return StackValue.onStack(expectedType);
    }

    private void plusMinus(InstructionAdapter v, Type expectedType) {
        if (expectedType == Type.LONG_TYPE) {
            v.lconst(this.myDelta);
        } else if (expectedType == Type.FLOAT_TYPE) {
            v.fconst(this.myDelta);
        } else if (expectedType == Type.DOUBLE_TYPE) {
            v.dconst(this.myDelta);
        } else {
            v.iconst(this.myDelta);
        }
        v.add(expectedType);
    }
}

