/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.codegen;

import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.codegen.Callable;
import org.jetbrains.jet.codegen.CallableMethod;
import org.jetbrains.jet.codegen.ExpressionCodegen;
import org.jetbrains.jet.codegen.FrameMap;
import org.jetbrains.jet.codegen.GenerationState;
import org.jetbrains.jet.codegen.JetTypeMapper;
import org.jetbrains.jet.codegen.MapTypeMode;
import org.jetbrains.jet.codegen.intrinsics.IntrinsicMethod;
import org.jetbrains.jet.internal.com.intellij.psi.tree.IElementType;
import org.jetbrains.jet.internal.org.objectweb.asm.Label;
import org.jetbrains.jet.internal.org.objectweb.asm.Type;
import org.jetbrains.jet.internal.org.objectweb.asm.commons.InstructionAdapter;
import org.jetbrains.jet.internal.org.objectweb.asm.commons.Method;
import org.jetbrains.jet.lang.descriptors.CallableDescriptor;
import org.jetbrains.jet.lang.descriptors.ClassDescriptor;
import org.jetbrains.jet.lang.descriptors.FunctionDescriptor;
import org.jetbrains.jet.lang.descriptors.TypeParameterDescriptor;
import org.jetbrains.jet.lang.descriptors.ValueParameterDescriptor;
import org.jetbrains.jet.lang.psi.JetExpression;
import org.jetbrains.jet.lang.resolve.calls.ResolvedCall;
import org.jetbrains.jet.lang.resolve.java.JvmClassName;
import org.jetbrains.jet.lang.resolve.java.JvmPrimitiveType;
import org.jetbrains.jet.lang.resolve.scopes.receivers.ReceiverDescriptor;
import org.jetbrains.jet.lexer.JetTokens;

public abstract class StackValue {
    @NotNull
    public final Type type;

    public StackValue(@NotNull Type type) {
        this.type = type;
    }

    public static void valueOf(InstructionAdapter instructionAdapter, Type type) {
        if (type.getSort() == 10 || type.getSort() == 9) {
            return;
        }
        if (type == Type.VOID_TYPE) {
            instructionAdapter.aconst(null);
        } else {
            Type boxed = JetTypeMapper.boxType(type);
            instructionAdapter.invokestatic(boxed.getInternalName(), "valueOf", "(" + type.getDescriptor() + ")" + boxed.getDescriptor());
        }
    }

    public abstract void put(Type var1, InstructionAdapter var2);

    public void moveToTopOfStack(Type type, InstructionAdapter v, int depth) {
        this.put(type, v);
    }

    public void store(Type topOfStackType, InstructionAdapter v) {
        throw new UnsupportedOperationException("cannot store to value " + this);
    }

    public void dupReceiver(InstructionAdapter v) {
    }

    public int receiverSize() {
        return 0;
    }

    public void condJump(Label label, boolean jumpIfFalse, InstructionAdapter v) {
        this.put(this.type, v);
        this.coerce(Type.BOOLEAN_TYPE, v);
        if (jumpIfFalse) {
            v.ifeq(label);
        } else {
            v.ifne(label);
        }
    }

    public static StackValue local(int index, Type type) {
        return new Local(index, type);
    }

    public static StackValue shared(int index, Type type) {
        return new Shared(index, type);
    }

    public static StackValue onStack(Type type) {
        return type == Type.VOID_TYPE ? StackValue.none() : new OnStack(type);
    }

    public static StackValue constant(@Nullable Object value, Type type) {
        return new Constant(value, type);
    }

    public static StackValue cmp(IElementType opToken, Type type) {
        return type.getSort() == 10 ? new ObjectCompare(opToken, type) : new NumberCompare(opToken, type);
    }

    public static StackValue not(StackValue stackValue) {
        return new Invert(stackValue);
    }

    public static StackValue arrayElement(Type type, boolean unbox) {
        return new ArrayElement(type, unbox);
    }

    public static StackValue collectionElement(Type type, ResolvedCall<FunctionDescriptor> getter, ResolvedCall<FunctionDescriptor> setter, ExpressionCodegen codegen, GenerationState state) {
        return new CollectionElement(type, getter, setter, codegen, state);
    }

    public static StackValue field(Type type, JvmClassName owner, String name, boolean isStatic) {
        return new Field(type, owner, name, isStatic);
    }

    public static Property property(String name, JvmClassName methodOwner, JvmClassName methodOwnerParam, Type type, boolean isStatic, boolean isInterface, boolean isSuper, Method getter, Method setter, int invokeOpcode) {
        return new Property(name, methodOwner, methodOwnerParam, getter, setter, isStatic, isInterface, isSuper, type, invokeOpcode);
    }

    public static StackValue expression(Type type, JetExpression expression, ExpressionCodegen generator) {
        return new Expression(type, expression, generator);
    }

    private static void box(Type type, Type toType, InstructionAdapter v) {
        if (type == Type.INT_TYPE || JetTypeMapper.isIntPrimitive(type) && toType.getInternalName().equals("java/lang/Integer")) {
            v.invokestatic("java/lang/Integer", "valueOf", "(I)Ljava/lang/Integer;");
        } else if (type == Type.BOOLEAN_TYPE) {
            v.invokestatic("java/lang/Boolean", "valueOf", "(Z)Ljava/lang/Boolean;");
        } else if (type == Type.CHAR_TYPE) {
            v.invokestatic("java/lang/Character", "valueOf", "(C)Ljava/lang/Character;");
        } else if (type == Type.SHORT_TYPE) {
            v.invokestatic("java/lang/Short", "valueOf", "(S)Ljava/lang/Short;");
        } else if (type == Type.LONG_TYPE) {
            v.invokestatic("java/lang/Long", "valueOf", "(J)Ljava/lang/Long;");
        } else if (type == Type.BYTE_TYPE) {
            v.invokestatic("java/lang/Byte", "valueOf", "(B)Ljava/lang/Byte;");
        } else if (type == Type.FLOAT_TYPE) {
            v.invokestatic("java/lang/Float", "valueOf", "(F)Ljava/lang/Float;");
        } else if (type == Type.DOUBLE_TYPE) {
            v.invokestatic("java/lang/Double", "valueOf", "(D)Ljava/lang/Double;");
        }
    }

    private static void unbox(Type type, InstructionAdapter v) {
        if (type == Type.INT_TYPE) {
            v.invokevirtual("java/lang/Number", "intValue", "()I");
        } else if (type == Type.BOOLEAN_TYPE) {
            v.invokevirtual("java/lang/Boolean", "booleanValue", "()Z");
        } else if (type == Type.CHAR_TYPE) {
            v.invokevirtual("java/lang/Character", "charValue", "()C");
        } else if (type == Type.SHORT_TYPE) {
            v.invokevirtual("java/lang/Number", "shortValue", "()S");
        } else if (type == Type.LONG_TYPE) {
            v.invokevirtual("java/lang/Number", "longValue", "()J");
        } else if (type == Type.BYTE_TYPE) {
            v.invokevirtual("java/lang/Number", "byteValue", "()B");
        } else if (type == Type.FLOAT_TYPE) {
            v.invokevirtual("java/lang/Number", "floatValue", "()F");
        } else if (type == Type.DOUBLE_TYPE) {
            v.invokevirtual("java/lang/Number", "doubleValue", "()D");
        }
    }

    public void upcast(Type type, InstructionAdapter v) {
        if (type.equals(this.type)) {
            return;
        }
        if (type.getSort() == 10 && this.type.getSort() == 10) {
            v.checkcast(type);
        } else {
            this.coerce(type, v);
        }
    }

    protected void coerce(Type toType, InstructionAdapter v) {
        StackValue.coerce(this.type, toType, v);
    }

    protected static void coerce(Type fromType, Type toType, InstructionAdapter v) {
        if (toType.equals(fromType)) {
            return;
        }
        if (toType.getSort() == 0 && fromType.getSort() != 0) {
            if (fromType.getSize() == 1) {
                v.pop();
            } else {
                v.pop2();
            }
        } else if (toType.getSort() != 0 && fromType.getSort() == 0) {
            if (toType.getSort() == 10) {
                StackValue.putTuple0Instance(v);
            } else if (toType == Type.LONG_TYPE) {
                v.lconst(0L);
            } else if (toType == Type.FLOAT_TYPE) {
                v.fconst(0.0f);
            } else if (toType == Type.DOUBLE_TYPE) {
                v.dconst(0.0);
            } else {
                v.iconst(0);
            }
        } else if (toType.getSort() == 10 && fromType.equals(JetTypeMapper.TYPE_OBJECT) || toType.getSort() == 9) {
            v.checkcast(toType);
        } else if (toType.getSort() == 10) {
            if (fromType.getSort() == 10 && !toType.equals(JetTypeMapper.TYPE_OBJECT)) {
                v.checkcast(toType);
            } else {
                StackValue.box(fromType, toType, v);
            }
        } else if (fromType.getSort() == 10 && toType.getSort() <= 8) {
            if (fromType.equals(JetTypeMapper.TYPE_OBJECT)) {
                if (toType.getSort() == 1) {
                    v.checkcast(JvmPrimitiveType.BOOLEAN.getWrapper().getAsmType());
                } else if (toType.getSort() == 2) {
                    v.checkcast(JvmPrimitiveType.CHAR.getWrapper().getAsmType());
                } else {
                    v.checkcast(JetTypeMapper.JL_NUMBER_TYPE);
                }
            }
            StackValue.unbox(toType, v);
        } else {
            v.cast(fromType, toType);
        }
    }

    public static void putTuple0Instance(InstructionAdapter v) {
        v.visitFieldInsn(178, "jet/Tuple0", "INSTANCE", "Ljet/Tuple0;");
    }

    protected void putAsBoolean(InstructionAdapter v) {
        Label ifTrue = new Label();
        Label end = new Label();
        this.condJump(ifTrue, false, v);
        v.iconst(0);
        v.goTo(end);
        v.mark(ifTrue);
        v.iconst(1);
        v.mark(end);
    }

    public static StackValue none() {
        return None.INSTANCE;
    }

    public static StackValue fieldForSharedVar(Type type, JvmClassName name, String fieldName) {
        return new FieldForSharedVar(type, name, fieldName);
    }

    public static StackValue composed(StackValue prefix, StackValue suffix) {
        return new Composed(prefix, suffix);
    }

    public static StackValue thisOrOuter(ExpressionCodegen codegen, ClassDescriptor descriptor) {
        return new ThisOuter(codegen, descriptor);
    }

    public static StackValue postIncrement(int index, int increment) {
        return new PostIncrement(index, increment);
    }

    public static StackValue preIncrement(int index, int increment) {
        return new PreIncrement(index, increment);
    }

    public static StackValue receiver(ResolvedCall<? extends CallableDescriptor> resolvedCall, StackValue receiver, ExpressionCodegen codegen, @Nullable CallableMethod callableMethod, GenerationState state) {
        if (resolvedCall.getThisObject().exists() || resolvedCall.getReceiverArgument().exists()) {
            return new CallReceiver(resolvedCall, receiver, codegen, state, callableMethod);
        }
        return receiver;
    }

    public static Type sharedTypeForType(Type type) {
        switch (type.getSort()) {
            case 9: 
            case 10: {
                return JetTypeMapper.TYPE_SHARED_VAR;
            }
            case 3: {
                return JetTypeMapper.TYPE_SHARED_BYTE;
            }
            case 4: {
                return JetTypeMapper.TYPE_SHARED_SHORT;
            }
            case 2: {
                return JetTypeMapper.TYPE_SHARED_CHAR;
            }
            case 5: {
                return JetTypeMapper.TYPE_SHARED_INT;
            }
            case 7: {
                return JetTypeMapper.TYPE_SHARED_LONG;
            }
            case 1: {
                return JetTypeMapper.TYPE_SHARED_BOOLEAN;
            }
            case 6: {
                return JetTypeMapper.TYPE_SHARED_FLOAT;
            }
            case 8: {
                return JetTypeMapper.TYPE_SHARED_DOUBLE;
            }
        }
        throw new UnsupportedOperationException();
    }

    public static Type refType(Type type) {
        if (type.getSort() == 10 || type.getSort() == 9) {
            return JetTypeMapper.TYPE_OBJECT;
        }
        return type;
    }

    public static class CallReceiver
    extends StackValue {
        private ResolvedCall<? extends CallableDescriptor> resolvedCall;
        StackValue receiver;
        private ExpressionCodegen codegen;
        @NotNull
        private final GenerationState state;
        private CallableMethod callableMethod;

        public CallReceiver(ResolvedCall<? extends CallableDescriptor> resolvedCall, StackValue receiver, ExpressionCodegen codegen, @NotNull GenerationState state, CallableMethod callableMethod) {
            super(CallReceiver.calcType(resolvedCall, codegen, callableMethod));
            this.resolvedCall = resolvedCall;
            this.receiver = receiver;
            this.codegen = codegen;
            this.state = state;
            this.callableMethod = callableMethod;
        }

        private static Type calcType(ResolvedCall<? extends CallableDescriptor> resolvedCall, ExpressionCodegen codegen, CallableMethod callableMethod) {
            ReceiverDescriptor thisObject = resolvedCall.getThisObject();
            ReceiverDescriptor receiverArgument = resolvedCall.getReceiverArgument();
            CallableDescriptor descriptor = resolvedCall.getResultingDescriptor();
            if (thisObject.exists()) {
                if (callableMethod != null) {
                    if (receiverArgument.exists()) {
                        return callableMethod.getReceiverClass();
                    }
                    return callableMethod.getThisType().getAsmType();
                }
                if (receiverArgument.exists()) {
                    return codegen.typeMapper.mapType(descriptor.getReceiverParameter().getType(), MapTypeMode.VALUE);
                }
                return codegen.typeMapper.mapType(descriptor.getExpectedThisObject().getType(), MapTypeMode.VALUE);
            }
            if (receiverArgument.exists()) {
                if (callableMethod != null) {
                    return callableMethod.getReceiverClass();
                }
                return codegen.typeMapper.mapType(descriptor.getReceiverParameter().getType(), MapTypeMode.VALUE);
            }
            return Type.VOID_TYPE;
        }

        @Override
        public void put(Type type, InstructionAdapter v) {
            CallableDescriptor descriptor = this.resolvedCall.getResultingDescriptor();
            ReceiverDescriptor thisObject = this.resolvedCall.getThisObject();
            ReceiverDescriptor receiverArgument = this.resolvedCall.getReceiverArgument();
            if (thisObject.exists()) {
                if (receiverArgument.exists()) {
                    if (this.callableMethod != null) {
                        this.codegen.generateFromResolvedCall(thisObject, this.callableMethod.getOwner().getAsmType());
                    } else {
                        this.codegen.generateFromResolvedCall(thisObject, this.codegen.typeMapper.mapType(descriptor.getExpectedThisObject().getType(), MapTypeMode.VALUE));
                    }
                    this.genReceiver(v, receiverArgument, type, descriptor.getReceiverParameter(), 1);
                } else {
                    this.genReceiver(v, thisObject, type, null, 0);
                }
            } else if (receiverArgument.exists()) {
                this.genReceiver(v, receiverArgument, type, descriptor.getReceiverParameter(), 0);
            }
        }

        private void genReceiver(InstructionAdapter v, ReceiverDescriptor receiverArgument, Type type, @Nullable ReceiverDescriptor receiverParameter, int depth) {
            if (this.receiver == StackValue.none()) {
                if (receiverParameter != null) {
                    Type receiverType = this.codegen.typeMapper.mapType(receiverParameter.getType(), MapTypeMode.VALUE);
                    this.codegen.generateFromResolvedCall(receiverArgument, receiverType);
                    StackValue.onStack(receiverType).put(type, v);
                } else {
                    this.codegen.generateFromResolvedCall(receiverArgument, type);
                }
            } else {
                this.receiver.moveToTopOfStack(type, v, depth);
            }
        }
    }

    private static class PreIncrement
    extends StackValue {
        private int index;
        private int increment;

        public PreIncrement(int index, int increment) {
            super(Type.INT_TYPE);
            this.index = index;
            this.increment = increment;
        }

        @Override
        public void put(Type type, InstructionAdapter v) {
            v.iinc(this.index, this.increment);
            if (!type.equals(Type.VOID_TYPE)) {
                v.load(this.index, Type.INT_TYPE);
                this.coerce(type, v);
            }
        }
    }

    private static class PostIncrement
    extends StackValue {
        private int index;
        private int increment;

        public PostIncrement(int index, int increment) {
            super(Type.INT_TYPE);
            this.index = index;
            this.increment = increment;
        }

        @Override
        public void put(Type type, InstructionAdapter v) {
            if (!type.equals(Type.VOID_TYPE)) {
                v.load(this.index, Type.INT_TYPE);
                this.coerce(type, v);
            }
            v.iinc(this.index, this.increment);
        }
    }

    private static class ThisOuter
    extends StackValue {
        private ExpressionCodegen codegen;
        private ClassDescriptor descriptor;

        public ThisOuter(ExpressionCodegen codegen, ClassDescriptor descriptor) {
            super(JetTypeMapper.TYPE_OBJECT);
            this.codegen = codegen;
            this.descriptor = descriptor;
        }

        @Override
        public void put(Type type, InstructionAdapter v) {
            this.codegen.generateThisOrOuter(this.descriptor);
        }
    }

    public static class Composed
    extends StackValue {
        public final StackValue prefix;
        public final StackValue suffix;

        public Composed(StackValue prefix, StackValue suffix) {
            super(suffix.type);
            this.prefix = prefix;
            this.suffix = suffix;
        }

        @Override
        public void put(Type type, InstructionAdapter v) {
            this.prefix.put(this.prefix.type, v);
            this.suffix.put(type, v);
        }

        @Override
        public void store(Type topOfStackType, InstructionAdapter v) {
            this.prefix.put(JetTypeMapper.TYPE_OBJECT, v);
            this.suffix.store(topOfStackType, v);
        }
    }

    static class FieldForSharedVar
    extends StackValue {
        final JvmClassName owner;
        final String name;

        public FieldForSharedVar(Type type, JvmClassName owner, String name) {
            super(type);
            this.owner = owner;
            this.name = name;
        }

        @Override
        public void dupReceiver(InstructionAdapter v) {
            v.dup();
        }

        @Override
        public int receiverSize() {
            return 1;
        }

        @Override
        public void put(Type type, InstructionAdapter v) {
            Type sharedType = FieldForSharedVar.sharedTypeForType(this.type);
            Type refType = FieldForSharedVar.refType(this.type);
            v.visitFieldInsn(180, sharedType.getInternalName(), "ref", refType.getDescriptor());
            StackValue.onStack(refType).coerce(this.type, v);
            StackValue.onStack(this.type).coerce(type, v);
        }

        @Override
        public void store(Type topOfStackType, InstructionAdapter v) {
            this.coerce(topOfStackType, v);
            v.visitFieldInsn(181, FieldForSharedVar.sharedTypeForType(this.type).getInternalName(), "ref", FieldForSharedVar.refType(this.type).getDescriptor());
        }
    }

    public static class Shared
    extends StackValue {
        private final int index;
        private boolean isReleaseOnPut = false;

        public Shared(int index, Type type) {
            super(type);
            this.index = index;
        }

        public void releaseOnPut() {
            this.isReleaseOnPut = true;
        }

        public int getIndex() {
            return this.index;
        }

        @Override
        public void put(Type type, InstructionAdapter v) {
            v.load(this.index, JetTypeMapper.TYPE_OBJECT);
            Type refType = Shared.refType(this.type);
            Type sharedType = Shared.sharedTypeForType(this.type);
            v.visitFieldInsn(180, sharedType.getInternalName(), "ref", refType.getDescriptor());
            Shared.coerce(refType, this.type, v);
            Shared.coerce(this.type, type, v);
            if (this.isReleaseOnPut) {
                v.aconst(null);
                v.store(this.index, JetTypeMapper.TYPE_OBJECT);
            }
        }

        @Override
        public void store(Type topOfStackType, InstructionAdapter v) {
            v.load(this.index, JetTypeMapper.TYPE_OBJECT);
            v.swap();
            Type refType = Shared.refType(this.type);
            Type sharedType = Shared.sharedTypeForType(this.type);
            v.visitFieldInsn(181, sharedType.getInternalName(), "ref", refType.getDescriptor());
        }
    }

    private static class Expression
    extends StackValue {
        private final JetExpression expression;
        private final ExpressionCodegen generator;

        public Expression(Type type, JetExpression expression, ExpressionCodegen generator) {
            super(type);
            this.expression = expression;
            this.generator = generator;
        }

        @Override
        public void put(Type type, InstructionAdapter v) {
            this.generator.gen(this.expression, type);
        }
    }

    static class Property
    extends StackValue {
        @NotNull
        private final String name;
        @Nullable
        private final Method getter;
        @Nullable
        private final Method setter;
        @NotNull
        public final JvmClassName methodOwner;
        @NotNull
        private final JvmClassName methodOwnerParam;
        private final boolean isStatic;
        private final boolean isInterface;
        private final boolean isSuper;
        private final int invokeOpcode;

        public Property(@NotNull String name, @NotNull JvmClassName methodOwner, @NotNull JvmClassName methodOwnerParam, Method getter, Method setter, boolean aStatic, boolean isInterface, boolean isSuper, Type type, int invokeOpcode) {
            super(type);
            this.name = name;
            this.methodOwner = methodOwner;
            this.methodOwnerParam = methodOwnerParam;
            this.getter = getter;
            this.setter = setter;
            this.isStatic = aStatic;
            this.isInterface = isInterface;
            this.isSuper = isSuper;
            this.invokeOpcode = invokeOpcode;
            if (invokeOpcode == 0 && (setter != null || getter != null)) {
                throw new IllegalArgumentException();
            }
        }

        @Override
        public void put(Type type, InstructionAdapter v) {
            if (this.isSuper && this.isInterface) {
                v.visitMethodInsn(184, this.methodOwner.getInternalName(), this.getter.getName(), this.getter.getDescriptor().replace("(", "(" + this.methodOwnerParam.getDescriptor()));
            } else if (this.getter == null) {
                v.visitFieldInsn(this.isStatic ? 178 : 180, this.methodOwner.getInternalName(), this.name, this.type.getDescriptor());
            } else {
                v.visitMethodInsn(this.invokeOpcode, this.methodOwner.getInternalName(), this.getter.getName(), this.getter.getDescriptor());
            }
            this.coerce(type, v);
        }

        @Override
        public void store(Type topOfStackType, InstructionAdapter v) {
            if (this.isSuper && this.isInterface) {
                v.visitMethodInsn(184, this.methodOwner.getInternalName(), this.setter.getName(), this.setter.getDescriptor().replace("(", "(" + this.methodOwnerParam.getDescriptor()));
            } else if (this.setter == null) {
                v.visitFieldInsn(this.isStatic ? 179 : 181, this.methodOwner.getInternalName(), this.name, this.type.getDescriptor());
            } else {
                v.visitMethodInsn(this.invokeOpcode, this.methodOwner.getInternalName(), this.setter.getName(), this.setter.getDescriptor());
            }
        }

        @Override
        public void dupReceiver(InstructionAdapter v) {
            if (!this.isStatic) {
                v.dup();
            }
        }

        @Override
        public int receiverSize() {
            return this.isStatic ? 0 : 1;
        }
    }

    static class Field
    extends StackValue {
        final JvmClassName owner;
        final String name;
        private final boolean isStatic;

        public Field(Type type, JvmClassName owner, String name, boolean isStatic) {
            super(type);
            this.owner = owner;
            this.name = name;
            this.isStatic = isStatic;
        }

        @Override
        public void put(Type type, InstructionAdapter v) {
            v.visitFieldInsn(this.isStatic ? 178 : 180, this.owner.getInternalName(), this.name, this.type.getDescriptor());
            this.coerce(type, v);
        }

        @Override
        public void dupReceiver(InstructionAdapter v) {
            if (!this.isStatic) {
                v.dup();
            }
        }

        @Override
        public int receiverSize() {
            return this.isStatic ? 0 : 1;
        }

        @Override
        public void store(Type topOfStackType, InstructionAdapter v) {
            Field.coerce(topOfStackType, this.type, v);
            v.visitFieldInsn(this.isStatic ? 179 : 181, this.owner.getInternalName(), this.name, this.type.getDescriptor());
        }
    }

    private static class CollectionElement
    extends StackValue {
        private final Callable getter;
        private final Callable setter;
        private final ExpressionCodegen codegen;
        private final GenerationState state;
        private final FrameMap frame;
        private final ResolvedCall<FunctionDescriptor> resolvedGetCall;
        private final ResolvedCall<FunctionDescriptor> resolvedSetCall;
        private final FunctionDescriptor setterDescriptor;
        private final FunctionDescriptor getterDescriptor;

        public CollectionElement(Type type, ResolvedCall<FunctionDescriptor> resolvedGetCall, ResolvedCall<FunctionDescriptor> resolvedSetCall, ExpressionCodegen codegen, GenerationState state) {
            super(type);
            this.resolvedGetCall = resolvedGetCall;
            this.resolvedSetCall = resolvedSetCall;
            this.state = state;
            this.setterDescriptor = resolvedSetCall == null ? null : resolvedSetCall.getResultingDescriptor();
            this.getterDescriptor = resolvedGetCall == null ? null : resolvedGetCall.getResultingDescriptor();
            this.setter = resolvedSetCall == null ? null : codegen.resolveToCallable(this.setterDescriptor, false);
            this.getter = resolvedGetCall == null ? null : codegen.resolveToCallable(this.getterDescriptor, false);
            this.codegen = codegen;
            this.frame = codegen.myFrameMap;
        }

        @Override
        public void put(Type type, InstructionAdapter v) {
            if (this.getter == null) {
                throw new UnsupportedOperationException("no getter specified");
            }
            if (this.getter instanceof CallableMethod) {
                ((CallableMethod)this.getter).invoke(v);
            } else {
                ((IntrinsicMethod)this.getter).generate(this.codegen, v, type, null, null, null, this.state);
            }
            this.coerce(type, v);
        }

        @Override
        public void store(Type topOfStackType, InstructionAdapter v) {
            if (this.setter == null) {
                throw new UnsupportedOperationException("no setter specified");
            }
            if (this.setter instanceof CallableMethod) {
                CallableMethod method = (CallableMethod)this.setter;
                Method asmMethod = method.getSignature().getAsmMethod();
                Type[] argumentTypes = asmMethod.getArgumentTypes();
                CollectionElement.coerce(topOfStackType, argumentTypes[argumentTypes.length - 1], v);
                method.invoke(v);
                Type returnType = asmMethod.getReturnType();
                if (returnType != Type.VOID_TYPE) {
                    if (returnType.getSize() == 2) {
                        v.pop2();
                    } else {
                        v.pop();
                    }
                }
            } else {
                ((IntrinsicMethod)this.setter).generate(this.codegen, v, null, null, null, null, this.state);
            }
        }

        @Override
        public int receiverSize() {
            if (this.isStandardStack(this.resolvedGetCall, 1) && this.isStandardStack(this.resolvedSetCall, 2)) {
                return 2;
            }
            return -1;
        }

        @Override
        public void dupReceiver(InstructionAdapter v) {
            if (this.isStandardStack(this.resolvedGetCall, 1) && this.isStandardStack(this.resolvedSetCall, 2)) {
                v.dup2();
            } else {
                int sz;
                Type type;
                int i;
                Type realReceiverType;
                int realReceiverIndex;
                int size = 0;
                int lastIndex = this.frame.enterTemp();
                this.frame.leaveTemp();
                List<ValueParameterDescriptor> valueParameters = this.resolvedGetCall.getResultingDescriptor().getValueParameters();
                int firstParamIndex = -1;
                for (int i2 = valueParameters.size() - 1; i2 >= 0; --i2) {
                    Type type2 = this.codegen.typeMapper.mapType(valueParameters.get(i2).getType(), MapTypeMode.VALUE);
                    int sz2 = type2.getSize();
                    this.frame.enterTemp(sz2);
                    size += sz2;
                    firstParamIndex = lastIndex += sz2;
                    v.store(firstParamIndex - sz2, type2);
                }
                List<TypeParameterDescriptor> typeParameters = this.resolvedGetCall.getResultingDescriptor().getTypeParameters();
                int firstTypeParamIndex = -1;
                for (int i3 = typeParameters.size() - 1; i3 >= 0; --i3) {
                    if (!typeParameters.get(i3).isReified()) continue;
                    this.frame.enterTemp();
                    ++size;
                    firstTypeParamIndex = ++lastIndex - 1;
                    v.store(firstTypeParamIndex, JetTypeMapper.TYPE_OBJECT);
                }
                ReceiverDescriptor receiverParameter = this.resolvedGetCall.getReceiverArgument();
                int receiverIndex = -1;
                if (receiverParameter.exists()) {
                    Type type3 = this.codegen.typeMapper.mapType(receiverParameter.getType(), MapTypeMode.VALUE);
                    int sz3 = type3.getSize();
                    this.frame.enterTemp(sz3);
                    size += sz3;
                    receiverIndex = lastIndex += sz3;
                    v.store(receiverIndex - sz3, type3);
                }
                ReceiverDescriptor thisObject = this.resolvedGetCall.getThisObject();
                int thisIndex = -1;
                if (thisObject.exists()) {
                    this.frame.enterTemp();
                    ++size;
                    thisIndex = ++lastIndex;
                    v.store(thisIndex - 1, JetTypeMapper.TYPE_OBJECT);
                }
                if (thisIndex != -1) {
                    if (receiverIndex != -1) {
                        realReceiverIndex = receiverIndex;
                        realReceiverType = this.codegen.typeMapper.mapType(receiverParameter.getType(), MapTypeMode.VALUE);
                    } else {
                        realReceiverIndex = thisIndex;
                        realReceiverType = JetTypeMapper.TYPE_OBJECT;
                    }
                } else if (receiverIndex != -1) {
                    realReceiverType = this.codegen.typeMapper.mapType(receiverParameter.getType(), MapTypeMode.VALUE);
                    realReceiverIndex = receiverIndex;
                } else {
                    throw new UnsupportedOperationException();
                }
                if (this.resolvedSetCall.getThisObject().exists()) {
                    if (this.resolvedSetCall.getReceiverArgument().exists()) {
                        this.codegen.generateFromResolvedCall(this.resolvedSetCall.getThisObject(), JetTypeMapper.TYPE_OBJECT);
                    }
                    v.load(realReceiverIndex - realReceiverType.getSize(), realReceiverType);
                } else if (this.resolvedSetCall.getReceiverArgument().exists()) {
                    v.load(realReceiverIndex - realReceiverType.getSize(), realReceiverType);
                } else {
                    throw new UnsupportedOperationException();
                }
                int index = firstParamIndex;
                for (i = 0; i != valueParameters.size(); ++i) {
                    type = this.codegen.typeMapper.mapType(valueParameters.get(i).getType(), MapTypeMode.VALUE);
                    sz = type.getSize();
                    v.load(index - sz, type);
                    index -= sz;
                }
                if (thisIndex != -1) {
                    v.load(thisIndex - 1, JetTypeMapper.TYPE_OBJECT);
                }
                if (receiverIndex != -1) {
                    Type type4 = this.codegen.typeMapper.mapType(receiverParameter.getType(), MapTypeMode.VALUE);
                    v.load(receiverIndex - type4.getSize(), type4);
                }
                if (firstTypeParamIndex != -1) {
                    index = firstTypeParamIndex;
                    for (i = 0; i != typeParameters.size(); ++i) {
                        if (!typeParameters.get(i).isReified()) continue;
                        v.load(index - 1, JetTypeMapper.TYPE_OBJECT);
                        --index;
                    }
                }
                index = firstParamIndex;
                for (i = 0; i != valueParameters.size(); ++i) {
                    type = this.codegen.typeMapper.mapType(valueParameters.get(i).getType(), MapTypeMode.VALUE);
                    sz = type.getSize();
                    v.load(index - sz, type);
                    index -= sz;
                }
                this.frame.leaveTemp(size);
            }
        }

        private boolean isStandardStack(ResolvedCall call, int valueParamsSize) {
            if (call == null) {
                return true;
            }
            for (TypeParameterDescriptor typeParameterDescriptor : call.getResultingDescriptor().getTypeParameters()) {
                if (!typeParameterDescriptor.isReified()) continue;
                return false;
            }
            List<ValueParameterDescriptor> valueParameters = call.getResultingDescriptor().getValueParameters();
            if (valueParameters.size() != valueParamsSize) {
                return false;
            }
            for (ValueParameterDescriptor valueParameter : valueParameters) {
                if (this.codegen.typeMapper.mapType(valueParameter.getType(), MapTypeMode.VALUE).getSize() == 1) continue;
                return false;
            }
            return !(call.getThisObject().exists() ? call.getReceiverArgument().exists() : this.codegen.typeMapper.mapType(call.getResultingDescriptor().getReceiverParameter().getType(), MapTypeMode.VALUE).getSize() != 1);
        }
    }

    private static class ArrayElement
    extends StackValue {
        private Type boxed;

        public ArrayElement(Type type, boolean unbox) {
            super(type);
            this.boxed = unbox ? JetTypeMapper.boxType(type) : type;
        }

        @Override
        public void put(Type type, InstructionAdapter v) {
            v.aload(this.boxed);
            ArrayElement.onStack(this.boxed).coerce(type, v);
        }

        @Override
        public void store(Type topOfStackType, InstructionAdapter v) {
            ArrayElement.onStack(this.type).coerce(this.boxed, v);
            v.astore(this.boxed);
        }

        @Override
        public void dupReceiver(InstructionAdapter v) {
            v.dup2();
        }

        @Override
        public int receiverSize() {
            return 2;
        }
    }

    private static class Invert
    extends StackValue {
        private StackValue myOperand;

        private Invert(StackValue operand) {
            super(Type.BOOLEAN_TYPE);
            this.myOperand = operand;
            if (this.myOperand.type != Type.BOOLEAN_TYPE) {
                throw new UnsupportedOperationException("operand of ! must be boolean");
            }
        }

        @Override
        public void put(Type type, InstructionAdapter v) {
            if (type == Type.VOID_TYPE) {
                this.myOperand.put(type, v);
                return;
            }
            if (type != Type.BOOLEAN_TYPE) {
                throw new UnsupportedOperationException("don't know how to put a compare as a non-boolean type");
            }
            this.putAsBoolean(v);
        }

        @Override
        public void condJump(Label label, boolean jumpIfFalse, InstructionAdapter v) {
            this.myOperand.condJump(label, !jumpIfFalse, v);
        }
    }

    private static class ObjectCompare
    extends NumberCompare {
        public ObjectCompare(IElementType opToken, Type operandType) {
            super(opToken, operandType);
        }

        @Override
        public void condJump(Label label, boolean jumpIfFalse, InstructionAdapter v) {
            int opcode;
            if (this.opToken == JetTokens.EQEQEQ) {
                opcode = jumpIfFalse ? 166 : 165;
            } else if (this.opToken == JetTokens.EXCLEQEQEQ) {
                opcode = jumpIfFalse ? 165 : 166;
            } else {
                throw new UnsupportedOperationException("don't know how to generate this condjump");
            }
            v.visitJumpInsn(opcode, label);
        }
    }

    private static class NumberCompare
    extends StackValue {
        protected final IElementType opToken;
        private final Type operandType;

        public NumberCompare(IElementType opToken, Type operandType) {
            super(Type.BOOLEAN_TYPE);
            this.opToken = opToken;
            this.operandType = operandType;
        }

        @Override
        public void put(Type type, InstructionAdapter v) {
            if (type == Type.VOID_TYPE) {
                return;
            }
            if (type.equals(JetTypeMapper.TUPLE0_TYPE)) {
                NumberCompare.putTuple0Instance(v);
                return;
            }
            if (type != Type.BOOLEAN_TYPE) {
                throw new UnsupportedOperationException("don't know how to put a compare as a non-boolean type " + type);
            }
            this.putAsBoolean(v);
        }

        @Override
        public void condJump(Label label, boolean jumpIfFalse, InstructionAdapter v) {
            int opcode;
            if (this.opToken == JetTokens.EQEQ) {
                opcode = jumpIfFalse ? 154 : 153;
            } else if (this.opToken == JetTokens.EXCLEQ) {
                opcode = jumpIfFalse ? 153 : 154;
            } else if (this.opToken == JetTokens.GT) {
                opcode = jumpIfFalse ? 158 : 157;
            } else if (this.opToken == JetTokens.GTEQ) {
                opcode = jumpIfFalse ? 155 : 156;
            } else if (this.opToken == JetTokens.LT) {
                opcode = jumpIfFalse ? 156 : 155;
            } else if (this.opToken == JetTokens.LTEQ) {
                opcode = jumpIfFalse ? 157 : 158;
            } else {
                throw new UnsupportedOperationException("don't know how to generate this condjump");
            }
            if (this.operandType == Type.FLOAT_TYPE || this.operandType == Type.DOUBLE_TYPE) {
                if (this.opToken == JetTokens.GT || this.opToken == JetTokens.GTEQ) {
                    v.cmpg(this.operandType);
                } else {
                    v.cmpl(this.operandType);
                }
            } else if (this.operandType == Type.LONG_TYPE) {
                v.lcmp();
            } else {
                opcode += 6;
            }
            v.visitJumpInsn(opcode, label);
        }
    }

    public static class Constant
    extends StackValue {
        @Nullable
        private final Object value;

        public Constant(@Nullable Object value, Type type) {
            super(type);
            this.value = value;
        }

        @Override
        public void put(Type type, InstructionAdapter v) {
            if (this.value instanceof Integer) {
                v.iconst((Integer)this.value);
            } else if (this.value instanceof Long) {
                v.lconst((Long)this.value);
            } else if (this.value instanceof Float) {
                v.fconst(((Float)this.value).floatValue());
            } else if (this.value instanceof Double) {
                v.dconst((Double)this.value);
            } else {
                v.aconst(this.value);
            }
            this.coerce(type, v);
        }

        @Override
        public void condJump(Label label, boolean jumpIfFalse, InstructionAdapter v) {
            if (this.value instanceof Boolean) {
                boolean boolValue = (Boolean)this.value;
                if (boolValue ^ jumpIfFalse) {
                    v.goTo(label);
                }
            } else {
                throw new UnsupportedOperationException("don't know how to generate this condjump");
            }
        }
    }

    public static class OnStack
    extends StackValue {
        public OnStack(Type type) {
            super(type);
        }

        @Override
        public void put(Type type, InstructionAdapter v) {
            if (type == Type.VOID_TYPE && this.type != Type.VOID_TYPE) {
                if (this.type.getSize() == 2) {
                    v.pop2();
                } else {
                    v.pop();
                }
            } else {
                this.coerce(type, v);
            }
        }

        @Override
        public void moveToTopOfStack(Type type, InstructionAdapter v, int depth) {
            if (depth == 0) {
                this.put(type, v);
            } else if (depth == 1) {
                if (type.getSize() != 1) {
                    throw new UnsupportedOperationException("don't know how to move type " + type + " to top of stack");
                }
                v.swap();
            } else {
                throw new UnsupportedOperationException("unsupported move-to-top depth " + depth);
            }
        }
    }

    public static class Local
    extends StackValue {
        final int index;

        public Local(int index, Type type) {
            super(type);
            this.index = index;
            if (index < 0) {
                throw new IllegalStateException("local variable index must be non-negative");
            }
        }

        @Override
        public void put(Type type, InstructionAdapter v) {
            v.load(this.index, this.type);
            this.coerce(type, v);
        }

        @Override
        public void store(Type topOfStackType, InstructionAdapter v) {
            Local.coerce(topOfStackType, this.type, v);
            v.store(this.index, this.type);
        }
    }

    private static class None
    extends StackValue {
        public static None INSTANCE = new None();

        private None() {
            super(Type.VOID_TYPE);
        }

        @Override
        public void put(Type type, InstructionAdapter v) {
            this.coerce(type, v);
        }
    }
}

