/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.codegen;

import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jet.codegen.ClassBuilder;
import org.jetbrains.jet.codegen.ClassFileFactory;
import org.jetbrains.jet.codegen.ClosureAnnotator;
import org.jetbrains.jet.codegen.CodegenContext;
import org.jetbrains.jet.codegen.CodegenContexts;
import org.jetbrains.jet.codegen.ExpressionCodegen;
import org.jetbrains.jet.codegen.FrameMap;
import org.jetbrains.jet.codegen.GenerationState;
import org.jetbrains.jet.codegen.ImplementationBodyCodegen;
import org.jetbrains.jet.codegen.JetTypeMapper;
import org.jetbrains.jet.codegen.MapTypeMode;
import org.jetbrains.jet.codegen.MemberCodegen;
import org.jetbrains.jet.codegen.StackValue;
import org.jetbrains.jet.codegen.signature.JvmMethodSignature;
import org.jetbrains.jet.internal.com.google.common.collect.Lists;
import org.jetbrains.jet.internal.com.intellij.openapi.util.Pair;
import org.jetbrains.jet.internal.javax.inject.Inject;
import org.jetbrains.jet.internal.org.objectweb.asm.MethodVisitor;
import org.jetbrains.jet.internal.org.objectweb.asm.Type;
import org.jetbrains.jet.internal.org.objectweb.asm.commons.InstructionAdapter;
import org.jetbrains.jet.lang.descriptors.ClassDescriptor;
import org.jetbrains.jet.lang.descriptors.ScriptDescriptor;
import org.jetbrains.jet.lang.descriptors.ValueParameterDescriptor;
import org.jetbrains.jet.lang.psi.JetDeclaration;
import org.jetbrains.jet.lang.psi.JetScript;
import org.jetbrains.jet.lang.psi.JetTypeParameterListOwner;
import org.jetbrains.jet.lang.resolve.BindingContext;
import org.jetbrains.jet.lang.resolve.java.JdkNames;
import org.jetbrains.jet.lang.resolve.java.JvmClassName;

public class ScriptCodegen {
    public static final JvmClassName SCRIPT_DEFAULT_CLASS_NAME = JvmClassName.byInternalName("Script");
    public static final String LAST_EXPRESSION_VALUE_FIELD_NAME = "rv";
    @NotNull
    private GenerationState state;
    @NotNull
    private ClassFileFactory classFileFactory;
    @NotNull
    private JetTypeMapper jetTypeMapper;
    @NotNull
    private MemberCodegen memberCodegen;
    @NotNull
    private ClosureAnnotator closureAnnotator;
    @NotNull
    private BindingContext bindingContext;
    private List<ScriptDescriptor> earlierScripts;

    @Inject
    public void setState(@NotNull GenerationState state) {
        this.state = state;
    }

    @Inject
    public void setClassFileFactory(@NotNull ClassFileFactory classFileFactory) {
        this.classFileFactory = classFileFactory;
    }

    @Inject
    public void setJetTypeMapper(@NotNull JetTypeMapper jetTypeMapper) {
        this.jetTypeMapper = jetTypeMapper;
    }

    @Inject
    public void setMemberCodegen(@NotNull MemberCodegen memberCodegen) {
        this.memberCodegen = memberCodegen;
    }

    @Inject
    public void setClosureAnnotator(@NotNull ClosureAnnotator closureAnnotator) {
        this.closureAnnotator = closureAnnotator;
    }

    @Inject
    public void setBindingContext(@NotNull BindingContext bindingContext) {
        this.bindingContext = bindingContext;
    }

    public void generate(JetScript scriptDeclaration) {
        ScriptDescriptor scriptDescriptor = this.state.getBindingContext().get(BindingContext.SCRIPT, scriptDeclaration);
        ClassDescriptor classDescriptorForScript = this.closureAnnotator.classDescriptorForScrpitDescriptor(scriptDescriptor);
        CodegenContexts.ScriptContext context = (CodegenContexts.ScriptContext)CodegenContexts.STATIC.intoScript(scriptDescriptor, classDescriptorForScript);
        JvmClassName className = this.closureAnnotator.classNameForClassDescriptor(classDescriptorForScript);
        ClassBuilder classBuilder = this.classFileFactory.newVisitor(className.getInternalName() + ".class");
        classBuilder.defineClass(scriptDeclaration, 50, 1, className.getInternalName(), null, JdkNames.JL_OBJECT.getInternalName(), new String[0]);
        this.genMembers(scriptDeclaration, context, classBuilder);
        this.genFieldsForParameters(scriptDescriptor, classBuilder);
        this.genConstructor(scriptDeclaration, scriptDescriptor, classDescriptorForScript, classBuilder, context.intoFunction(scriptDescriptor.getScriptCodeDescriptor()), this.earlierScripts);
        classBuilder.done();
    }

    private void genConstructor(@NotNull JetScript scriptDeclaration, @NotNull ScriptDescriptor scriptDescriptor, @NotNull ClassDescriptor classDescriptorForScript, @NotNull ClassBuilder classBuilder, @NotNull CodegenContext context, @NotNull List<ScriptDescriptor> importedScripts) {
        Type blockType = this.jetTypeMapper.mapType(scriptDescriptor.getReturnType(), MapTypeMode.VALUE);
        classBuilder.newField(null, 1, LAST_EXPRESSION_VALUE_FIELD_NAME, blockType.getDescriptor(), null, null);
        JvmMethodSignature jvmSignature = this.jetTypeMapper.mapScriptSignature(scriptDescriptor, importedScripts);
        this.state.setScriptConstructorMethod(jvmSignature.getAsmMethod());
        MethodVisitor mv = classBuilder.newMethod(scriptDeclaration, 1, jvmSignature.getAsmMethod().getName(), jvmSignature.getAsmMethod().getDescriptor(), null, null);
        mv.visitCode();
        InstructionAdapter instructionAdapter = new InstructionAdapter(mv);
        JvmClassName className = this.closureAnnotator.classNameForClassDescriptor(classDescriptorForScript);
        instructionAdapter.load(0, className.getAsmType());
        instructionAdapter.invokespecial(JdkNames.JL_OBJECT.getInternalName(), "<init>", "()V");
        instructionAdapter.load(0, className.getAsmType());
        FrameMap frameMap = context.prepareFrame(this.jetTypeMapper);
        for (ScriptDescriptor importedScript : importedScripts) {
            frameMap.enter(importedScript, 1);
        }
        Type[] argTypes = jvmSignature.getAsmMethod().getArgumentTypes();
        int add = 0;
        for (int i = 0; i < scriptDescriptor.getValueParameters().size(); ++i) {
            ValueParameterDescriptor parameter = scriptDescriptor.getValueParameters().get(i);
            frameMap.enter(parameter, argTypes[i + add].getSize());
        }
        ImplementationBodyCodegen.generateInitializers(new ExpressionCodegen(instructionAdapter, frameMap, Type.VOID_TYPE, context, this.state), instructionAdapter, scriptDeclaration.getDeclarations(), this.bindingContext, this.jetTypeMapper);
        int offset = 1;
        for (ScriptDescriptor earlierScript : importedScripts) {
            JvmClassName earlierClassName = this.closureAnnotator.classNameForScriptDescriptor(earlierScript);
            instructionAdapter.load(0, className.getAsmType());
            instructionAdapter.load(offset, earlierClassName.getAsmType());
            offset += earlierClassName.getAsmType().getSize();
            instructionAdapter.putfield(className.getInternalName(), this.getScriptFieldName(earlierScript), earlierClassName.getAsmType().getDescriptor());
        }
        for (ValueParameterDescriptor parameter : scriptDescriptor.getValueParameters()) {
            Type parameterType = this.jetTypeMapper.mapType(parameter.getType(), MapTypeMode.VALUE);
            instructionAdapter.load(0, className.getAsmType());
            instructionAdapter.load(offset, parameterType);
            offset += parameterType.getSize();
            instructionAdapter.putfield(className.getInternalName(), parameter.getName().getIdentifier(), parameterType.getDescriptor());
        }
        StackValue stackValue = new ExpressionCodegen(mv, frameMap, Type.VOID_TYPE, context, this.state).gen(scriptDeclaration.getBlockExpression());
        if (stackValue.type != Type.VOID_TYPE) {
            stackValue.put(stackValue.type, instructionAdapter);
            instructionAdapter.putfield(className.getInternalName(), LAST_EXPRESSION_VALUE_FIELD_NAME, blockType.getDescriptor());
        }
        instructionAdapter.areturn(Type.VOID_TYPE);
        mv.visitMaxs(-1, -1);
        mv.visitEnd();
    }

    private void genFieldsForParameters(@NotNull ScriptDescriptor script, @NotNull ClassBuilder classBuilder) {
        int access;
        for (ScriptDescriptor earlierScript : this.earlierScripts) {
            JvmClassName earlierClassName = this.closureAnnotator.classNameForScriptDescriptor(earlierScript);
            access = 18;
            classBuilder.newField(null, access, this.getScriptFieldName(earlierScript), earlierClassName.getDescriptor(), null, null);
        }
        for (ValueParameterDescriptor parameter : script.getValueParameters()) {
            Type parameterType = this.jetTypeMapper.mapType(parameter.getType(), MapTypeMode.VALUE);
            access = 18;
            classBuilder.newField(null, access, parameter.getName().getIdentifier(), parameterType.getDescriptor(), null, null);
        }
    }

    private void genMembers(@NotNull JetScript scriptDeclaration, @NotNull CodegenContext context, @NotNull ClassBuilder classBuilder) {
        for (JetDeclaration decl : scriptDeclaration.getDeclarations()) {
            this.memberCodegen.generateFunctionOrProperty((JetTypeParameterListOwner)decl, context, classBuilder);
        }
    }

    public void registerEarlierScripts(List<Pair<ScriptDescriptor, JvmClassName>> earlierScripts) {
        for (Pair<ScriptDescriptor, JvmClassName> t : earlierScripts) {
            ScriptDescriptor earlierDescriptor = (ScriptDescriptor)t.first;
            JvmClassName earlierClassName = (JvmClassName)t.second;
            this.closureAnnotator.registerClassNameForScript(earlierDescriptor, earlierClassName);
        }
        ArrayList<ScriptDescriptor> earlierScriptDescriptors = Lists.newArrayList();
        for (Pair<ScriptDescriptor, JvmClassName> t : earlierScripts) {
            ScriptDescriptor earlierDescriptor = (ScriptDescriptor)t.first;
            JvmClassName earlierClassName = (JvmClassName)t.second;
            earlierScriptDescriptors.add(earlierDescriptor);
        }
        this.earlierScripts = earlierScriptDescriptors;
    }

    public int getScriptIndex(@NotNull ScriptDescriptor scriptDescriptor) {
        int index = this.earlierScripts.indexOf(scriptDescriptor);
        if (index < 0) {
            throw new IllegalStateException("Unregistered script: " + scriptDescriptor);
        }
        return index + 1;
    }

    public String getScriptFieldName(@NotNull ScriptDescriptor scriptDescriptor) {
        return "script$" + this.getScriptIndex(scriptDescriptor);
    }
}

