/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.codegen;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.jet.codegen.AnnotationCodegen;
import org.jetbrains.jet.codegen.ClassBuilder;
import org.jetbrains.jet.codegen.ClassBuilderMode;
import org.jetbrains.jet.codegen.CodegenContext;
import org.jetbrains.jet.codegen.CodegenUtil;
import org.jetbrains.jet.codegen.FunctionCodegen;
import org.jetbrains.jet.codegen.GenerationState;
import org.jetbrains.jet.codegen.JetTypeMapper;
import org.jetbrains.jet.codegen.MapTypeMode;
import org.jetbrains.jet.codegen.OwnerKind;
import org.jetbrains.jet.codegen.StackValue;
import org.jetbrains.jet.codegen.StubCodegen;
import org.jetbrains.jet.codegen.signature.JvmPropertyAccessorSignature;
import org.jetbrains.jet.codegen.signature.kotlin.JetMethodAnnotationWriter;
import org.jetbrains.jet.internal.com.intellij.openapi.util.text.StringUtil;
import org.jetbrains.jet.internal.com.intellij.psi.PsiElement;
import org.jetbrains.jet.internal.org.objectweb.asm.FieldVisitor;
import org.jetbrains.jet.internal.org.objectweb.asm.MethodVisitor;
import org.jetbrains.jet.internal.org.objectweb.asm.Type;
import org.jetbrains.jet.internal.org.objectweb.asm.commons.InstructionAdapter;
import org.jetbrains.jet.lang.descriptors.CallableMemberDescriptor;
import org.jetbrains.jet.lang.descriptors.DeclarationDescriptor;
import org.jetbrains.jet.lang.descriptors.Modality;
import org.jetbrains.jet.lang.descriptors.PropertyDescriptor;
import org.jetbrains.jet.lang.descriptors.PropertySetterDescriptor;
import org.jetbrains.jet.lang.descriptors.VariableDescriptor;
import org.jetbrains.jet.lang.descriptors.Visibilities;
import org.jetbrains.jet.lang.psi.JetClass;
import org.jetbrains.jet.lang.psi.JetConstantExpression;
import org.jetbrains.jet.lang.psi.JetExpression;
import org.jetbrains.jet.lang.psi.JetProperty;
import org.jetbrains.jet.lang.psi.JetPropertyAccessor;
import org.jetbrains.jet.lang.resolve.BindingContext;
import org.jetbrains.jet.lang.resolve.BindingContextUtils;
import org.jetbrains.jet.lang.resolve.DescriptorUtils;
import org.jetbrains.jet.lang.resolve.constants.CompileTimeConstant;
import org.jetbrains.jet.lang.resolve.name.Name;

public class PropertyCodegen {
    private final GenerationState state;
    private final FunctionCodegen functionCodegen;
    private final ClassBuilder v;
    private final OwnerKind kind;

    public PropertyCodegen(CodegenContext context, ClassBuilder v, FunctionCodegen functionCodegen, GenerationState state) {
        this.v = v;
        this.functionCodegen = functionCodegen;
        this.state = state;
        this.kind = context.getContextKind();
    }

    public void gen(JetProperty p) {
        VariableDescriptor descriptor = this.state.getBindingContext().get(BindingContext.VARIABLE, p);
        if (!(descriptor instanceof PropertyDescriptor)) {
            throw new UnsupportedOperationException("expect a property to have a property descriptor");
        }
        PropertyDescriptor propertyDescriptor = (PropertyDescriptor)descriptor;
        if (this.kind == OwnerKind.NAMESPACE || this.kind == OwnerKind.IMPLEMENTATION || this.kind == OwnerKind.TRAIT_IMPL) {
            if (this.kind != OwnerKind.TRAIT_IMPL) {
                this.generateBackingField(p, propertyDescriptor);
            }
            this.generateGetter(p, propertyDescriptor);
            this.generateSetter(p, propertyDescriptor);
        } else if (this.kind instanceof OwnerKind.DelegateKind) {
            this.generateDefaultGetter(propertyDescriptor, 1, p);
            if (propertyDescriptor.isVar()) {
                this.generateDefaultSetter(propertyDescriptor, 1, p);
            }
        }
    }

    private void generateBackingField(JetProperty p, PropertyDescriptor propertyDescriptor) {
        if (this.state.getBindingContext().get(BindingContext.BACKING_FIELD_REQUIRED, propertyDescriptor).booleanValue()) {
            int modifiers;
            DeclarationDescriptor containingDeclaration = propertyDescriptor.getContainingDeclaration();
            if (CodegenUtil.isInterface(containingDeclaration)) {
                return;
            }
            Object value = null;
            JetExpression initializer = p.getInitializer();
            if (initializer != null && initializer instanceof JetConstantExpression) {
                CompileTimeConstant<?> compileTimeValue = this.state.getBindingContext().get(BindingContext.COMPILE_TIME_VALUE, initializer);
                Object v0 = value = compileTimeValue != null ? compileTimeValue.getValue() : null;
            }
            if (this.kind == OwnerKind.NAMESPACE) {
                int access = JetTypeMapper.getAccessModifiers(propertyDescriptor, 0);
                modifiers = access | 8;
            } else {
                modifiers = JetTypeMapper.getAccessModifiers(propertyDescriptor, 0);
            }
            if (!propertyDescriptor.isVar()) {
                modifiers |= 0x10;
            }
            if (this.state.getInjector().getJetStandardLibrary().isVolatile(propertyDescriptor)) {
                modifiers |= 0x40;
            }
            Type type = this.state.getInjector().getJetTypeMapper().mapType(propertyDescriptor.getType(), MapTypeMode.VALUE);
            FieldVisitor fieldVisitor = this.v.newField(p, modifiers, p.getName(), type.getDescriptor(), null, value);
            AnnotationCodegen.forField(fieldVisitor, this.state.getInjector().getJetTypeMapper()).genAnnotations(propertyDescriptor);
        }
    }

    private void generateGetter(JetProperty p, PropertyDescriptor propertyDescriptor) {
        JetPropertyAccessor getter = p.getGetter();
        if (getter != null) {
            if (getter.getBodyExpression() != null) {
                JvmPropertyAccessorSignature signature = this.state.getInjector().getJetTypeMapper().mapGetterSignature(propertyDescriptor, this.kind);
                this.functionCodegen.generateMethod(getter, signature.getJvmMethodSignature(), true, signature.getPropertyTypeKotlinSignature(), propertyDescriptor.getGetter());
            } else if (PropertyCodegen.isExternallyAccessible(propertyDescriptor)) {
                this.generateDefaultGetter(p);
            }
        } else if (PropertyCodegen.isExternallyAccessible(propertyDescriptor)) {
            this.generateDefaultGetter(p);
        }
    }

    private static boolean isExternallyAccessible(PropertyDescriptor p) {
        return p.getVisibility() != Visibilities.PRIVATE || DescriptorUtils.isClassObject(p.getContainingDeclaration());
    }

    private void generateSetter(JetProperty p, PropertyDescriptor propertyDescriptor) {
        JetPropertyAccessor setter = p.getSetter();
        if (setter != null) {
            if (setter.getBodyExpression() != null) {
                PropertySetterDescriptor setterDescriptor = propertyDescriptor.getSetter();
                assert (setterDescriptor != null);
                JvmPropertyAccessorSignature signature = this.state.getInjector().getJetTypeMapper().mapSetterSignature(propertyDescriptor, this.kind);
                this.functionCodegen.generateMethod(setter, signature.getJvmMethodSignature(), true, signature.getPropertyTypeKotlinSignature(), setterDescriptor);
            } else if (PropertyCodegen.isExternallyAccessible(propertyDescriptor)) {
                this.generateDefaultSetter(p);
            }
        } else if (PropertyCodegen.isExternallyAccessible(propertyDescriptor) && propertyDescriptor.isVar()) {
            this.generateDefaultSetter(p);
        }
    }

    private void generateDefaultGetter(JetProperty p) {
        PropertyDescriptor propertyDescriptor = (PropertyDescriptor)this.state.getBindingContext().get(BindingContext.VARIABLE, p);
        int flags = JetTypeMapper.getAccessModifiers(propertyDescriptor, 0) | (propertyDescriptor.getModality() == Modality.ABSTRACT ? 1024 : 0);
        this.generateDefaultGetter(propertyDescriptor, flags, p);
    }

    public void generateDefaultGetter(PropertyDescriptor propertyDescriptor, int flags, PsiElement origin) {
        PsiElement psiElement;
        boolean isTrait;
        if (propertyDescriptor.getKind() == CallableMemberDescriptor.Kind.FAKE_OVERRIDE) {
            throw new IllegalStateException("must not generate code for fake overrides");
        }
        if (this.kind == OwnerKind.TRAIT_IMPL) {
            return;
        }
        if (this.kind == OwnerKind.NAMESPACE) {
            flags |= 8;
        }
        boolean bl = isTrait = (psiElement = BindingContextUtils.descriptorToDeclaration(this.state.getBindingContext(), propertyDescriptor.getContainingDeclaration())) instanceof JetClass && ((JetClass)psiElement).isTrait();
        if (isTrait && !(this.kind instanceof OwnerKind.DelegateKind)) {
            flags |= 0x400;
        }
        if (propertyDescriptor.getModality() == Modality.FINAL) {
            flags |= 0x10;
        }
        JvmPropertyAccessorSignature signature = this.state.getInjector().getJetTypeMapper().mapGetterSignature(propertyDescriptor, this.kind);
        String descriptor = signature.getJvmMethodSignature().getAsmMethod().getDescriptor();
        String getterName = PropertyCodegen.getterName(propertyDescriptor.getName());
        MethodVisitor mv = this.v.newMethod(origin, flags, getterName, descriptor, null, null);
        PropertyCodegen.generateJetPropertyAnnotation(mv, signature.getPropertyTypeKotlinSignature(), signature.getJvmMethodSignature().getKotlinTypeParameter(), propertyDescriptor);
        if (propertyDescriptor.getGetter() != null) {
            assert (!propertyDescriptor.getGetter().hasBody());
            AnnotationCodegen.forMethod(mv, this.state.getInjector().getJetTypeMapper()).genAnnotations(propertyDescriptor.getGetter());
        }
        if (this.state.getClassBuilderMode() != ClassBuilderMode.SIGNATURES && (!isTrait || this.kind instanceof OwnerKind.DelegateKind) && propertyDescriptor.getModality() != Modality.ABSTRACT) {
            mv.visitCode();
            if (this.state.getClassBuilderMode() == ClassBuilderMode.STUBS) {
                StubCodegen.generateStubThrow(mv);
            } else {
                InstructionAdapter iv = new InstructionAdapter(mv);
                if (this.kind != OwnerKind.NAMESPACE) {
                    iv.load(0, JetTypeMapper.TYPE_OBJECT);
                }
                Type type = this.state.getInjector().getJetTypeMapper().mapType(propertyDescriptor.getType(), MapTypeMode.VALUE);
                if (this.kind instanceof OwnerKind.DelegateKind != (propertyDescriptor.getKind() == CallableMemberDescriptor.Kind.DELEGATION)) {
                    throw new IllegalStateException("mismatching kind in " + propertyDescriptor);
                }
                if (this.kind instanceof OwnerKind.DelegateKind) {
                    OwnerKind.DelegateKind dk = (OwnerKind.DelegateKind)this.kind;
                    dk.getDelegate().put(JetTypeMapper.TYPE_OBJECT, iv);
                    iv.invokeinterface(dk.getOwnerClass(), getterName, descriptor);
                } else {
                    iv.visitFieldInsn(this.kind == OwnerKind.NAMESPACE ? 178 : 180, this.state.getInjector().getJetTypeMapper().getOwner(propertyDescriptor, this.kind).getInternalName(), propertyDescriptor.getName().getName(), type.getDescriptor());
                }
                iv.areturn(type);
            }
        }
        FunctionCodegen.endVisit(mv, "getter", origin);
    }

    public static void generateJetPropertyAnnotation(MethodVisitor mv, @NotNull String kotlinType, @NotNull String typeParameters, @NotNull PropertyDescriptor propertyDescriptor) {
        JetMethodAnnotationWriter aw = JetMethodAnnotationWriter.visitAnnotation(mv);
        Modality modality = propertyDescriptor.getModality();
        if (CodegenUtil.isInterface(propertyDescriptor.getContainingDeclaration()) && modality != Modality.ABSTRACT) {
            aw.writeFlags(0, modality == Modality.FINAL ? 2 : 1);
        } else {
            aw.writeFlags(0);
        }
        aw.writeTypeParameters(typeParameters);
        aw.writePropertyType(kotlinType);
        aw.visitEnd();
    }

    private void generateDefaultSetter(JetProperty p) {
        PropertyDescriptor propertyDescriptor = (PropertyDescriptor)this.state.getBindingContext().get(BindingContext.VARIABLE, p);
        assert (propertyDescriptor != null);
        int modifiers = JetTypeMapper.getAccessModifiers(propertyDescriptor, 0);
        PropertySetterDescriptor setter = propertyDescriptor.getSetter();
        int flags = setter == null ? modifiers : JetTypeMapper.getAccessModifiers(setter, modifiers);
        this.generateDefaultSetter(propertyDescriptor, flags, p);
    }

    public void generateDefaultSetter(PropertyDescriptor propertyDescriptor, int flags, PsiElement origin) {
        PsiElement psiElement;
        boolean isTrait;
        if (propertyDescriptor.getKind() == CallableMemberDescriptor.Kind.FAKE_OVERRIDE) {
            throw new IllegalStateException("must not generate code for fake overrides");
        }
        if (this.kind == OwnerKind.TRAIT_IMPL) {
            return;
        }
        if (this.kind == OwnerKind.NAMESPACE) {
            flags |= 8;
        }
        boolean bl = isTrait = (psiElement = BindingContextUtils.descriptorToDeclaration(this.state.getBindingContext(), propertyDescriptor.getContainingDeclaration())) instanceof JetClass && ((JetClass)psiElement).isTrait();
        if (isTrait && !(this.kind instanceof OwnerKind.DelegateKind)) {
            flags |= 0x400;
        }
        if (propertyDescriptor.getModality() == Modality.FINAL) {
            flags |= 0x10;
        }
        JvmPropertyAccessorSignature signature = this.state.getInjector().getJetTypeMapper().mapSetterSignature(propertyDescriptor, this.kind);
        String descriptor = signature.getJvmMethodSignature().getAsmMethod().getDescriptor();
        MethodVisitor mv = this.v.newMethod(origin, flags, PropertyCodegen.setterName(propertyDescriptor.getName()), descriptor, null, null);
        PropertyCodegen.generateJetPropertyAnnotation(mv, signature.getPropertyTypeKotlinSignature(), signature.getJvmMethodSignature().getKotlinTypeParameter(), propertyDescriptor);
        if (propertyDescriptor.getSetter() != null) {
            assert (!propertyDescriptor.getSetter().hasBody());
            AnnotationCodegen.forMethod(mv, this.state.getInjector().getJetTypeMapper()).genAnnotations(propertyDescriptor.getSetter());
        }
        if (this.state.getClassBuilderMode() != ClassBuilderMode.SIGNATURES && (!isTrait || this.kind instanceof OwnerKind.DelegateKind)) {
            if (propertyDescriptor.getModality() != Modality.ABSTRACT) {
                mv.visitCode();
                if (this.state.getClassBuilderMode() == ClassBuilderMode.STUBS) {
                    StubCodegen.generateStubThrow(mv);
                } else {
                    InstructionAdapter iv = new InstructionAdapter(mv);
                    Type type = this.state.getInjector().getJetTypeMapper().mapType(propertyDescriptor.getType(), MapTypeMode.VALUE);
                    int paramCode = 0;
                    if (this.kind != OwnerKind.NAMESPACE) {
                        iv.load(0, JetTypeMapper.TYPE_OBJECT);
                        paramCode = 1;
                    }
                    if (this.kind instanceof OwnerKind.DelegateKind != (propertyDescriptor.getKind() == CallableMemberDescriptor.Kind.DELEGATION)) {
                        throw new IllegalStateException("mismatching kind in " + propertyDescriptor);
                    }
                    if (this.kind instanceof OwnerKind.DelegateKind) {
                        OwnerKind.DelegateKind dk = (OwnerKind.DelegateKind)this.kind;
                        iv.load(0, JetTypeMapper.TYPE_OBJECT);
                        dk.getDelegate().put(JetTypeMapper.TYPE_OBJECT, iv);
                        iv.load(paramCode, type);
                        iv.invokeinterface(dk.getOwnerClass(), PropertyCodegen.setterName(propertyDescriptor.getName()), descriptor);
                    } else {
                        iv.load(paramCode, type);
                        iv.visitFieldInsn(this.kind == OwnerKind.NAMESPACE ? 179 : 181, this.state.getInjector().getJetTypeMapper().getOwner(propertyDescriptor, this.kind).getInternalName(), propertyDescriptor.getName().getName(), type.getDescriptor());
                    }
                    iv.visitInsn(177);
                }
            }
            FunctionCodegen.endVisit(mv, "setter", origin);
        }
    }

    public static String getterName(Name propertyName) {
        return "get" + StringUtil.capitalizeWithJavaBeanConvention(propertyName.getName());
    }

    public static String setterName(Name propertyName) {
        return "set" + StringUtil.capitalizeWithJavaBeanConvention(propertyName.getName());
    }

    public void genDelegate(PropertyDescriptor declaration, PropertyDescriptor overriddenDescriptor, StackValue field) {
        JvmPropertyAccessorSignature jvmPropertyAccessorSignature = this.state.getInjector().getJetTypeMapper().mapGetterSignature(declaration, OwnerKind.IMPLEMENTATION);
        this.functionCodegen.genDelegate(declaration, overriddenDescriptor, field, jvmPropertyAccessorSignature.getJvmMethodSignature());
        if (declaration.isVar()) {
            jvmPropertyAccessorSignature = this.state.getInjector().getJetTypeMapper().mapSetterSignature(declaration, OwnerKind.IMPLEMENTATION);
            this.functionCodegen.genDelegate(declaration, overriddenDescriptor, field, jvmPropertyAccessorSignature.getJvmMethodSignature());
        }
    }
}

