/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.codegen;

import java.util.ArrayList;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jet.codegen.ClassBuilder;
import org.jetbrains.jet.codegen.ClassBuilderMode;
import org.jetbrains.jet.codegen.ClassBuilderOnDemand;
import org.jetbrains.jet.codegen.CodegenContext;
import org.jetbrains.jet.codegen.CodegenContexts;
import org.jetbrains.jet.codegen.CompilationErrorHandler;
import org.jetbrains.jet.codegen.ExpressionCodegen;
import org.jetbrains.jet.codegen.FrameMap;
import org.jetbrains.jet.codegen.FunctionCodegen;
import org.jetbrains.jet.codegen.GenerationState;
import org.jetbrains.jet.codegen.StackValue;
import org.jetbrains.jet.internal.com.intellij.openapi.application.ApplicationManager;
import org.jetbrains.jet.internal.com.intellij.openapi.progress.ProcessCanceledException;
import org.jetbrains.jet.internal.com.intellij.openapi.util.Pair;
import org.jetbrains.jet.internal.com.intellij.openapi.vfs.VirtualFile;
import org.jetbrains.jet.internal.com.intellij.psi.PsiFile;
import org.jetbrains.jet.internal.org.objectweb.asm.MethodVisitor;
import org.jetbrains.jet.internal.org.objectweb.asm.Type;
import org.jetbrains.jet.internal.org.objectweb.asm.commons.InstructionAdapter;
import org.jetbrains.jet.lang.descriptors.NamespaceDescriptor;
import org.jetbrains.jet.lang.descriptors.PropertyDescriptor;
import org.jetbrains.jet.lang.diagnostics.DiagnosticUtils;
import org.jetbrains.jet.lang.psi.JetClassOrObject;
import org.jetbrains.jet.lang.psi.JetConstantExpression;
import org.jetbrains.jet.lang.psi.JetDeclaration;
import org.jetbrains.jet.lang.psi.JetExpression;
import org.jetbrains.jet.lang.psi.JetFile;
import org.jetbrains.jet.lang.psi.JetNamedFunction;
import org.jetbrains.jet.lang.psi.JetProperty;
import org.jetbrains.jet.lang.psi.JetScript;
import org.jetbrains.jet.lang.psi.JetTypeParameterListOwner;
import org.jetbrains.jet.lang.resolve.BindingContext;
import org.jetbrains.jet.lang.resolve.java.JvmClassName;
import org.jetbrains.jet.lang.resolve.name.FqName;
import org.jetbrains.jet.lang.resolve.name.Name;
import org.jetbrains.jet.utils.Progress;

public class NamespaceCodegen {
    @NotNull
    private final ClassBuilderOnDemand v;
    @NotNull
    private final FqName name;
    private final GenerationState state;
    private final Collection<JetFile> files;
    private int nextMultiFile = 0;

    public NamespaceCodegen(@NotNull ClassBuilderOnDemand v, final @NotNull FqName fqName, GenerationState state, Collection<JetFile> files) {
        this.v = v;
        this.name = fqName;
        this.state = state;
        this.files = files;
        final PsiFile sourceFile = files.iterator().next().getContainingFile();
        v.addOptionalDeclaration(new ClassBuilderOnDemand.ClassBuilderCallback(){

            @Override
            public void doSomething(@NotNull ClassBuilder v) {
                v.defineClass(sourceFile, 50, 1, NamespaceCodegen.getJVMClassNameForKotlinNs(fqName).getInternalName(), null, "java/lang/Object", new String[0]);
                v.visitSource(sourceFile.getName(), null);
            }
        });
    }

    public void generate(CompilationErrorHandler errorHandler, final Progress progress) {
        ArrayList byFile = new ArrayList();
        for (JetFile file : this.files) {
            ArrayList<JetDeclaration> fileFunctions = new ArrayList<JetDeclaration>();
            for (JetDeclaration declaration : file.getDeclarations()) {
                if (!(declaration instanceof JetNamedFunction)) continue;
                fileFunctions.add(declaration);
            }
            if (fileFunctions.size() <= 0) continue;
            byFile.add(new Pair(file, fileFunctions));
        }
        boolean multiFile = byFile.size() > 1;
        for (JetFile file : this.files) {
            VirtualFile vFile = file.getVirtualFile();
            try {
                String path;
                String string = path = vFile != null ? vFile.getPath() : "no_virtual_file/" + file.getName();
                if (progress != null) {
                    this.v.addOptionalDeclaration(new ClassBuilderOnDemand.ClassBuilderCallback(){

                        @Override
                        public void doSomething(@NotNull ClassBuilder classBuilder) {
                            progress.log("For source: " + path);
                        }
                    });
                }
                this.generate(file, multiFile);
            }
            catch (ProcessCanceledException e) {
                throw e;
            }
            catch (Throwable e) {
                if (errorHandler != null) {
                    errorHandler.reportException(e, vFile == null ? "no file" : vFile.getUrl());
                }
                DiagnosticUtils.throwIfRunningOnServer(e);
                if (!ApplicationManager.getApplication().isInternal()) continue;
                e.printStackTrace();
            }
        }
        if (this.hasNonConstantPropertyInitializers()) {
            this.generateStaticInitializers();
        }
    }

    private void generate(JetFile file, boolean multiFile) {
        for (JetDeclaration declaration : file.getDeclarations()) {
            CodegenContext context;
            NamespaceDescriptor descriptor;
            if (declaration instanceof JetProperty) {
                descriptor = this.state.getBindingContext().get(BindingContext.FILE_TO_NAMESPACE, file);
                context = CodegenContexts.STATIC.intoNamespace(descriptor);
                this.state.getInjector().getMemberCodegen().generateFunctionOrProperty((JetTypeParameterListOwner)declaration, context, this.v.getClassBuilder());
                continue;
            }
            if (declaration instanceof JetNamedFunction) {
                if (multiFile) continue;
                descriptor = this.state.getBindingContext().get(BindingContext.FILE_TO_NAMESPACE, file);
                context = CodegenContexts.STATIC.intoNamespace(descriptor);
                this.state.getInjector().getMemberCodegen().generateFunctionOrProperty((JetTypeParameterListOwner)declaration, context, this.v.getClassBuilder());
                continue;
            }
            if (declaration instanceof JetClassOrObject) {
                descriptor = this.state.getBindingContext().get(BindingContext.FILE_TO_NAMESPACE, file);
                context = CodegenContexts.STATIC.intoNamespace(descriptor);
                this.state.getInjector().getClassCodegen().generate(context, (JetClassOrObject)((Object)declaration));
                continue;
            }
            if (!(declaration instanceof JetScript)) continue;
            this.state.getInjector().getScriptCodegen().generate((JetScript)declaration);
        }
        if (multiFile) {
            int k = 0;
            for (JetDeclaration declaration : file.getDeclarations()) {
                if (!(declaration instanceof JetNamedFunction)) continue;
                ++k;
            }
            if (k > 0) {
                PsiFile containingFile = file.getContainingFile();
                String className = this.name.child(Name.identifier("namespace$src$" + this.nextMultiFile++)).getFqName().replace('.', '/');
                ClassBuilder builder = this.state.forNamespacepart(className, file);
                builder.defineClass(containingFile, 50, 1, className, null, "java/lang/Object", new String[0]);
                builder.visitSource(containingFile.getName(), null);
                for (JetDeclaration declaration : file.getDeclarations()) {
                    if (!(declaration instanceof JetNamedFunction)) continue;
                    NamespaceDescriptor descriptor = this.state.getBindingContext().get(BindingContext.FILE_TO_NAMESPACE, file);
                    CodegenContext context = CodegenContexts.STATIC.intoNamespace(descriptor);
                    this.state.getInjector().getMemberCodegen().generateFunctionOrProperty((JetTypeParameterListOwner)declaration, context, builder);
                    context = CodegenContexts.STATIC.intoNamespacePart(className, descriptor);
                    this.state.getInjector().getMemberCodegen().generateFunctionOrProperty((JetTypeParameterListOwner)declaration, context, this.v.getClassBuilder());
                }
                builder.done();
            }
        }
    }

    private void generateStaticInitializers() {
        final JetFile namespace = this.files.iterator().next();
        this.v.addOptionalDeclaration(new ClassBuilderOnDemand.ClassBuilderCallback(){

            @Override
            public void doSomething(@NotNull ClassBuilder v) {
                MethodVisitor mv = v.newMethod(namespace, 9, "<clinit>", "()V", null, null);
                for (JetFile file : NamespaceCodegen.this.files) {
                    if (NamespaceCodegen.this.state.getClassBuilderMode() != ClassBuilderMode.FULL) continue;
                    mv.visitCode();
                    FrameMap frameMap = new FrameMap();
                    ExpressionCodegen codegen = new ExpressionCodegen(mv, frameMap, Type.VOID_TYPE, CodegenContexts.STATIC, NamespaceCodegen.this.state);
                    for (JetDeclaration declaration : file.getDeclarations()) {
                        JetExpression initializer;
                        if (!(declaration instanceof JetProperty) || (initializer = ((JetProperty)declaration).getInitializer()) == null || initializer instanceof JetConstantExpression) continue;
                        PropertyDescriptor descriptor = (PropertyDescriptor)NamespaceCodegen.this.state.getBindingContext().get(BindingContext.VARIABLE, declaration);
                        assert (descriptor != null);
                        if (descriptor.getReceiverParameter().exists()) continue;
                        codegen.genToJVMStack(initializer);
                        StackValue.Property propValue = codegen.intermediateValueForProperty(descriptor, true, null);
                        propValue.store(propValue.type, new InstructionAdapter(mv));
                    }
                }
                if (NamespaceCodegen.this.state.getClassBuilderMode() == ClassBuilderMode.FULL) {
                    mv.visitInsn(177);
                    FunctionCodegen.endVisit(mv, "static initializer for namespace", namespace);
                    mv.visitEnd();
                }
            }
        });
    }

    private boolean hasNonConstantPropertyInitializers() {
        for (JetFile file : this.files) {
            for (JetDeclaration declaration : file.getDeclarations()) {
                JetExpression initializer;
                if (!(declaration instanceof JetProperty) || (initializer = ((JetProperty)declaration).getInitializer()) == null || initializer instanceof JetConstantExpression) continue;
                return true;
            }
        }
        return false;
    }

    public void done() {
        this.v.done();
    }

    @NotNull
    public static JvmClassName getJVMClassNameForKotlinNs(@NotNull FqName fqName) {
        if (fqName.isRoot()) {
            return JvmClassName.byInternalName("namespace");
        }
        return JvmClassName.byInternalName(fqName.getFqName().replace('.', '/') + "/" + "namespace");
    }
}

