/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.codegen;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.jet.codegen.ClassBuilder;
import org.jetbrains.jet.codegen.CodegenContext;
import org.jetbrains.jet.codegen.CompilationException;
import org.jetbrains.jet.codegen.FunctionCodegen;
import org.jetbrains.jet.codegen.GenerationState;
import org.jetbrains.jet.codegen.PropertyCodegen;
import org.jetbrains.jet.internal.javax.inject.Inject;
import org.jetbrains.jet.lang.psi.JetNamedFunction;
import org.jetbrains.jet.lang.psi.JetProperty;
import org.jetbrains.jet.lang.psi.JetTypeParameterListOwner;

public class MemberCodegen {
    @NotNull
    private GenerationState state;

    @Inject
    public void setState(@NotNull GenerationState state) {
        this.state = state;
    }

    public void generateFunctionOrProperty(@NotNull JetTypeParameterListOwner functionOrProperty, @NotNull CodegenContext context, @NotNull ClassBuilder classBuilder) {
        FunctionCodegen functionCodegen = new FunctionCodegen(context, classBuilder, this.state);
        if (functionOrProperty instanceof JetNamedFunction) {
            try {
                functionCodegen.gen((JetNamedFunction)functionOrProperty);
            }
            catch (CompilationException e) {
                throw e;
            }
            catch (Exception e) {
                throw new CompilationException("Failed to generate function " + functionOrProperty.getName(), e, functionOrProperty);
            }
        } else if (functionOrProperty instanceof JetProperty) {
            try {
                new PropertyCodegen(context, classBuilder, functionCodegen, this.state).gen((JetProperty)functionOrProperty);
            }
            catch (CompilationException e) {
                throw e;
            }
            catch (Exception e) {
                throw new CompilationException("Failed to generate property " + functionOrProperty.getName(), e, functionOrProperty);
            }
        } else {
            throw new IllegalArgumentException("Unknown parameter: " + functionOrProperty);
        }
    }
}

