/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.codegen;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import javax.annotation.PostConstruct;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.codegen.CallableMethod;
import org.jetbrains.jet.codegen.ClassBuilderMode;
import org.jetbrains.jet.codegen.ClosureAnnotator;
import org.jetbrains.jet.codegen.CodegenUtil;
import org.jetbrains.jet.codegen.MapTypeMode;
import org.jetbrains.jet.codegen.OwnerKind;
import org.jetbrains.jet.codegen.PropertyCodegen;
import org.jetbrains.jet.codegen.StackValue;
import org.jetbrains.jet.codegen.TraitImplBodyCodegen;
import org.jetbrains.jet.codegen.signature.BothSignatureWriter;
import org.jetbrains.jet.codegen.signature.JvmMethodParameterKind;
import org.jetbrains.jet.codegen.signature.JvmMethodSignature;
import org.jetbrains.jet.codegen.signature.JvmPropertyAccessorSignature;
import org.jetbrains.jet.internal.com.intellij.psi.PsiElement;
import org.jetbrains.jet.internal.javax.inject.Inject;
import org.jetbrains.jet.internal.org.objectweb.asm.Type;
import org.jetbrains.jet.lang.descriptors.CallableMemberDescriptor;
import org.jetbrains.jet.lang.descriptors.ClassDescriptor;
import org.jetbrains.jet.lang.descriptors.ClassKind;
import org.jetbrains.jet.lang.descriptors.ClassifierDescriptor;
import org.jetbrains.jet.lang.descriptors.ConstructorDescriptor;
import org.jetbrains.jet.lang.descriptors.DeclarationDescriptor;
import org.jetbrains.jet.lang.descriptors.FunctionDescriptor;
import org.jetbrains.jet.lang.descriptors.MemberDescriptor;
import org.jetbrains.jet.lang.descriptors.ModuleDescriptor;
import org.jetbrains.jet.lang.descriptors.NamespaceDescriptor;
import org.jetbrains.jet.lang.descriptors.PropertyDescriptor;
import org.jetbrains.jet.lang.descriptors.ScriptDescriptor;
import org.jetbrains.jet.lang.descriptors.SimpleFunctionDescriptor;
import org.jetbrains.jet.lang.descriptors.TypeParameterDescriptor;
import org.jetbrains.jet.lang.descriptors.ValueParameterDescriptor;
import org.jetbrains.jet.lang.descriptors.VariableDescriptor;
import org.jetbrains.jet.lang.descriptors.Visibilities;
import org.jetbrains.jet.lang.psi.JetClassObject;
import org.jetbrains.jet.lang.psi.JetClassOrObject;
import org.jetbrains.jet.lang.psi.JetElement;
import org.jetbrains.jet.lang.psi.JetObjectDeclaration;
import org.jetbrains.jet.lang.resolve.BindingContext;
import org.jetbrains.jet.lang.resolve.BindingContextUtils;
import org.jetbrains.jet.lang.resolve.DescriptorUtils;
import org.jetbrains.jet.lang.resolve.java.CompilerSpecialMode;
import org.jetbrains.jet.lang.resolve.java.JavaBindingContext;
import org.jetbrains.jet.lang.resolve.java.JavaNamespaceKind;
import org.jetbrains.jet.lang.resolve.java.JvmClassName;
import org.jetbrains.jet.lang.resolve.java.JvmPrimitiveType;
import org.jetbrains.jet.lang.resolve.name.Name;
import org.jetbrains.jet.lang.resolve.scopes.receivers.ReceiverDescriptor;
import org.jetbrains.jet.lang.types.CommonSupertypes;
import org.jetbrains.jet.lang.types.ErrorUtils;
import org.jetbrains.jet.lang.types.IntersectionTypeConstructor;
import org.jetbrains.jet.lang.types.JetType;
import org.jetbrains.jet.lang.types.TypeConstructor;
import org.jetbrains.jet.lang.types.TypeProjection;
import org.jetbrains.jet.lang.types.lang.JetStandardClasses;
import org.jetbrains.jet.lang.types.lang.JetStandardLibrary;
import org.jetbrains.jet.lang.types.lang.PrimitiveType;

public class JetTypeMapper {
    public static final Type TYPE_OBJECT = Type.getObjectType("java/lang/Object");
    public static final Type TYPE_THROWABLE = Type.getObjectType("java/lang/Throwable");
    public static final Type TYPE_NOTHING = Type.getObjectType("jet/Nothing");
    public static final Type JL_NUMBER_TYPE = Type.getObjectType("java/lang/Number");
    public static final Type JL_STRING_BUILDER = Type.getObjectType("java/lang/StringBuilder");
    public static final Type JL_ARRAY_LIST = Type.getObjectType("java/util/ArrayList");
    public static final Type JL_STRING_TYPE = Type.getObjectType("java/lang/String");
    public static final Type JL_CHAR_SEQUENCE_TYPE = Type.getObjectType("java/lang/CharSequence");
    private static final Type JL_COMPARABLE_TYPE = Type.getObjectType("java/lang/Comparable");
    public static final Type JL_CLASS_TYPE = Type.getObjectType("java/lang/Class");
    public static final Type ARRAY_GENERIC_TYPE = Type.getType(Object[].class);
    public static final Type TUPLE0_TYPE = Type.getObjectType("jet/Tuple0");
    private JetStandardLibrary standardLibrary;
    public BindingContext bindingContext;
    private ClosureAnnotator closureAnnotator;
    private CompilerSpecialMode compilerSpecialMode;
    private ClassBuilderMode classBuilderMode;
    private final HashMap<JetType, String> knowTypeNames = new HashMap();
    private final HashMap<JetType, Type> knowTypes = new HashMap();
    public static final Type TYPE_ITERATOR = Type.getObjectType("jet/Iterator");
    public static final Type TYPE_INT_RANGE = Type.getObjectType("jet/IntRange");
    public static final Type TYPE_SHARED_VAR = Type.getObjectType("jet/runtime/SharedVar$Object");
    public static final Type TYPE_SHARED_INT = Type.getObjectType("jet/runtime/SharedVar$Int");
    public static final Type TYPE_SHARED_DOUBLE = Type.getObjectType("jet/runtime/SharedVar$Double");
    public static final Type TYPE_SHARED_FLOAT = Type.getObjectType("jet/runtime/SharedVar$Float");
    public static final Type TYPE_SHARED_BYTE = Type.getObjectType("jet/runtime/SharedVar$Byte");
    public static final Type TYPE_SHARED_SHORT = Type.getObjectType("jet/runtime/SharedVar$Short");
    public static final Type TYPE_SHARED_CHAR = Type.getObjectType("jet/runtime/SharedVar$Char");
    public static final Type TYPE_SHARED_LONG = Type.getObjectType("jet/runtime/SharedVar$Long");
    public static final Type TYPE_SHARED_BOOLEAN = Type.getObjectType("jet/runtime/SharedVar$Boolean");
    public static final Type TYPE_FUNCTION0 = Type.getObjectType("jet/Function0");
    public static final Type TYPE_FUNCTION1 = Type.getObjectType("jet/Function1");

    @Inject
    public void setStandardLibrary(JetStandardLibrary standardLibrary) {
        this.standardLibrary = standardLibrary;
    }

    @Inject
    public void setBindingContext(BindingContext bindingContext) {
        this.bindingContext = bindingContext;
    }

    @Inject
    public void setClosureAnnotator(ClosureAnnotator closureAnnotator) {
        this.closureAnnotator = closureAnnotator;
    }

    @Inject
    public void setCompilerSpecialMode(CompilerSpecialMode compilerSpecialMode) {
        this.compilerSpecialMode = compilerSpecialMode;
    }

    @Inject
    public void setClassBuilderMode(ClassBuilderMode classBuilderMode) {
        this.classBuilderMode = classBuilderMode;
    }

    @PostConstruct
    public void init() {
        this.initKnownTypes();
        this.initKnownTypeNames();
    }

    public boolean hasThis0(ClassDescriptor classDescriptor) {
        return this.closureAnnotator.hasThis0(classDescriptor);
    }

    public ClosureAnnotator getClosureAnnotator() {
        return this.closureAnnotator;
    }

    public static boolean isIntPrimitive(Type type) {
        return type == Type.INT_TYPE || type == Type.SHORT_TYPE || type == Type.BYTE_TYPE || type == Type.CHAR_TYPE;
    }

    public static boolean isPrimitive(Type type) {
        return type.getSort() != 10 && type.getSort() != 9;
    }

    public static Type correctElementType(Type type) {
        String internalName = type.getInternalName();
        assert (internalName.charAt(0) == '[');
        return Type.getType(internalName.substring(1));
    }

    @NotNull
    public JvmClassName getOwner(DeclarationDescriptor descriptor, OwnerKind kind) {
        MapTypeMode mapTypeMode = JetTypeMapper.ownerKindToMapTypeMode(kind);
        DeclarationDescriptor containingDeclaration = descriptor.getContainingDeclaration();
        if (containingDeclaration instanceof NamespaceDescriptor) {
            return this.jvmClassNameForNamespace((NamespaceDescriptor)containingDeclaration);
        }
        if (containingDeclaration instanceof ClassDescriptor) {
            ClassDescriptor classDescriptor = (ClassDescriptor)containingDeclaration;
            if (kind instanceof OwnerKind.DelegateKind) {
                mapTypeMode = MapTypeMode.IMPL;
            } else if (classDescriptor.getKind() == ClassKind.OBJECT) {
                mapTypeMode = MapTypeMode.IMPL;
            }
            Type asmType = this.mapType(classDescriptor.getDefaultType(), mapTypeMode);
            if (asmType.getSort() != 10) {
                throw new IllegalStateException();
            }
            return JvmClassName.byType(asmType);
        }
        if (containingDeclaration instanceof ScriptDescriptor) {
            return this.closureAnnotator.classNameForScriptDescriptor((ScriptDescriptor)containingDeclaration);
        }
        throw new UnsupportedOperationException("don't know how to generate owner for parent " + containingDeclaration);
    }

    public static MapTypeMode ownerKindToMapTypeMode(OwnerKind kind) {
        if (kind == OwnerKind.IMPLEMENTATION || kind == OwnerKind.NAMESPACE || kind instanceof OwnerKind.StaticDelegateKind) {
            return MapTypeMode.IMPL;
        }
        if (kind == OwnerKind.TRAIT_IMPL) {
            return MapTypeMode.TRAIT_IMPL;
        }
        throw new IllegalStateException("must not call this method with kind = " + kind);
    }

    @NotNull
    private JavaNamespaceKind getNsKind(@NotNull NamespaceDescriptor ns) {
        JavaNamespaceKind javaNamespaceKind = this.bindingContext.get(JavaBindingContext.JAVA_NAMESPACE_KIND, ns);
        Boolean src = this.bindingContext.get(BindingContext.NAMESPACE_IS_SRC, ns);
        if (javaNamespaceKind == null && src == null) {
            throw new IllegalStateException("unknown namespace origin: " + ns);
        }
        if (javaNamespaceKind != null) {
            if (javaNamespaceKind == JavaNamespaceKind.CLASS_STATICS && src != null) {
                throw new IllegalStateException("conflicting namespace " + ns + ": it is both java statics and from src");
            }
            return javaNamespaceKind;
        }
        return JavaNamespaceKind.PROPER;
    }

    @NotNull
    private JvmClassName jvmClassNameForNamespace(@NotNull NamespaceDescriptor namespace) {
        StringBuilder r = new StringBuilder();
        List<DeclarationDescriptor> path = DescriptorUtils.getPathWithoutRootNsAndModule(namespace);
        for (DeclarationDescriptor pathElement : path) {
            NamespaceDescriptor ns = (NamespaceDescriptor)pathElement;
            if (r.length() > 0) {
                JavaNamespaceKind nsKind = this.getNsKind((NamespaceDescriptor)ns.getContainingDeclaration());
                if (nsKind == JavaNamespaceKind.PROPER) {
                    r.append("/");
                } else if (nsKind == JavaNamespaceKind.CLASS_STATICS) {
                    r.append("$");
                }
            }
            r.append(ns.getName());
        }
        if (this.getNsKind(namespace) == JavaNamespaceKind.PROPER) {
            if (r.length() > 0) {
                r.append("/");
            }
            r.append("namespace");
        }
        if (r.length() == 0) {
            throw new IllegalStateException("internal error: failed to generate classname for " + namespace);
        }
        return JvmClassName.byInternalName(r.toString());
    }

    @NotNull
    public Type mapReturnType(@NotNull JetType jetType) {
        return this.mapReturnType(jetType, null);
    }

    @NotNull
    private Type mapReturnType(@NotNull JetType jetType, @Nullable BothSignatureWriter signatureVisitor) {
        if (((Object)jetType).equals(JetStandardClasses.getUnitType())) {
            if (signatureVisitor != null) {
                signatureVisitor.writeAsmType(Type.VOID_TYPE, false);
            }
            return Type.VOID_TYPE;
        }
        if (((Object)jetType).equals(JetStandardClasses.getNothingType())) {
            if (signatureVisitor != null) {
                signatureVisitor.writeNothing(false);
            }
            return Type.VOID_TYPE;
        }
        if (((Object)jetType).equals(JetStandardClasses.getNullableNothingType())) {
            if (signatureVisitor != null) {
                signatureVisitor.writeNothing(true);
            }
            return TYPE_OBJECT;
        }
        return this.mapType(jetType, signatureVisitor, MapTypeMode.VALUE);
    }

    public static String getLocalNameForObject(JetObjectDeclaration object) {
        PsiElement parent = object.getParent();
        if (parent instanceof JetClassObject) {
            return "ClassObject$";
        }
        return null;
    }

    public JvmClassName getClassFQName(ClassDescriptor classDescriptor) {
        return JvmClassName.byInternalName(this.getFQName(classDescriptor));
    }

    @NotNull
    private String getFQName(@NotNull DeclarationDescriptor descriptor) {
        DeclarationDescriptor container;
        if ((descriptor = descriptor.getOriginal()) instanceof FunctionDescriptor) {
            throw new IllegalStateException("requested fq name for function: " + descriptor);
        }
        if (descriptor.getContainingDeclaration() instanceof ModuleDescriptor || descriptor instanceof ScriptDescriptor) {
            return "";
        }
        if (descriptor instanceof ModuleDescriptor) {
            throw new IllegalStateException("missed something");
        }
        if (descriptor instanceof ClassDescriptor) {
            ClassDescriptor klass = (ClassDescriptor)descriptor;
            if (klass.getKind() == ClassKind.OBJECT) {
                ClassDescriptor containingKlass;
                if (klass.getContainingDeclaration() instanceof ClassDescriptor && (containingKlass = (ClassDescriptor)klass.getContainingDeclaration()).getKind() == ClassKind.ENUM_CLASS) {
                    return this.getFQName(containingKlass);
                }
            } else if (klass.getKind() == ClassKind.ENUM_ENTRY) {
                return this.getFQName(klass.getContainingDeclaration());
            }
        }
        if ((container = descriptor.getContainingDeclaration()) == null) {
            throw new IllegalStateException("descriptor has no container: " + descriptor);
        }
        Name name = descriptor.getName();
        if (descriptor instanceof ClassDescriptor && name.isSpecial()) {
            ClassDescriptor clazz = (ClassDescriptor)descriptor;
            JvmClassName className = this.closureAnnotator.classNameForClassDescriptor(clazz);
            return className.getInternalName();
        }
        String baseName = this.getFQName(container);
        if (!baseName.isEmpty()) {
            return baseName + (container instanceof NamespaceDescriptor ? "/" : "$") + name.getIdentifier();
        }
        return name.getIdentifier();
    }

    @NotNull
    public Type mapType(@NotNull JetType jetType, @NotNull MapTypeMode kind) {
        return this.mapType(jetType, null, kind);
    }

    @NotNull
    public Type mapType(JetType jetType, @Nullable BothSignatureWriter signatureVisitor, @NotNull MapTypeMode kind) {
        ClassifierDescriptor descriptor;
        TypeConstructor constructor;
        Type known = this.knowTypes.get(jetType);
        if (known != null) {
            if (kind == MapTypeMode.VALUE) {
                return this.mapKnownAsmType(jetType, known, signatureVisitor, false);
            }
            if (kind == MapTypeMode.TYPE_PARAMETER) {
                return this.mapKnownAsmType(jetType, known, signatureVisitor, true);
            }
            if (kind == MapTypeMode.TRAIT_IMPL) {
                throw new IllegalStateException("TRAIT_IMPL is not possible for " + jetType);
            }
            if (kind == MapTypeMode.IMPL) {
                if (this.compilerSpecialMode != CompilerSpecialMode.BUILTINS) {
                    // empty if block
                }
            } else {
                throw new IllegalStateException("unknown kind: " + (Object)((Object)kind));
            }
        }
        if ((constructor = jetType.getConstructor()) instanceof IntersectionTypeConstructor) {
            jetType = CommonSupertypes.commonSupertype(new ArrayList<JetType>(constructor.getSupertypes()));
        }
        if ((descriptor = jetType.getConstructor().getDeclarationDescriptor()) == null) {
            throw new UnsupportedOperationException("no descriptor for type constructor of " + jetType);
        }
        if (ErrorUtils.isError(descriptor)) {
            if (this.classBuilderMode != ClassBuilderMode.SIGNATURES) {
                throw new IllegalStateException("error types are not allowed when classBuilderMode = " + (Object)((Object)this.classBuilderMode));
            }
            Type asmType = Type.getObjectType("error/NonExistentClass");
            if (signatureVisitor != null) {
                JetTypeMapper.visitAsmType(signatureVisitor, asmType, true);
            }
            this.checkValidType(asmType);
            return asmType;
        }
        if (this.standardLibrary.getArray().equals(descriptor)) {
            if (jetType.getArguments().size() != 1) {
                throw new UnsupportedOperationException("arrays must have one type argument");
            }
            JetType memberType = jetType.getArguments().get(0).getType();
            if (signatureVisitor != null) {
                signatureVisitor.writeArrayType(jetType.isNullable());
                this.mapType(memberType, signatureVisitor, MapTypeMode.TYPE_PARAMETER);
                signatureVisitor.writeArrayEnd();
            }
            Type r = !this.isGenericsArray(jetType) ? Type.getType("[" + JetTypeMapper.boxType(this.mapType(memberType, kind)).getDescriptor()) : ARRAY_GENERIC_TYPE;
            this.checkValidType(r);
            return r;
        }
        if (JetStandardClasses.getAny().equals(descriptor)) {
            if (signatureVisitor != null) {
                JetTypeMapper.visitAsmType(signatureVisitor, TYPE_OBJECT, jetType.isNullable());
            }
            this.checkValidType(TYPE_OBJECT);
            return TYPE_OBJECT;
        }
        if (descriptor instanceof ClassDescriptor) {
            boolean forceReal;
            Type asmType;
            if (this.standardLibrary.getComparable().equals(descriptor)) {
                if (jetType.getArguments().size() != 1) {
                    throw new UnsupportedOperationException("Comparable must have one type argument");
                }
                asmType = JL_COMPARABLE_TYPE;
                forceReal = false;
            } else {
                JvmClassName name = this.getClassFQName((ClassDescriptor)descriptor);
                asmType = Type.getObjectType(name.getInternalName() + (kind == MapTypeMode.TRAIT_IMPL ? "$$TImpl" : ""));
                forceReal = this.isForceReal(name);
            }
            if (signatureVisitor != null) {
                signatureVisitor.writeClassBegin(asmType.getInternalName(), jetType.isNullable(), forceReal);
                for (TypeProjection proj : jetType.getArguments()) {
                    signatureVisitor.writeTypeArgument(proj.getProjectionKind());
                    this.mapType(proj.getType(), signatureVisitor, MapTypeMode.TYPE_PARAMETER);
                    signatureVisitor.writeTypeArgumentEnd();
                }
                signatureVisitor.writeClassEnd();
            }
            this.checkValidType(asmType);
            return asmType;
        }
        if (descriptor instanceof TypeParameterDescriptor) {
            Type type = this.mapType(((TypeParameterDescriptor)descriptor).getUpperBoundsAsType(), kind);
            if (signatureVisitor != null) {
                TypeParameterDescriptor typeParameterDescriptor = (TypeParameterDescriptor)jetType.getConstructor().getDeclarationDescriptor();
                signatureVisitor.writeTypeVariable(typeParameterDescriptor.getName(), jetType.isNullable(), type);
            }
            this.checkValidType(type);
            return type;
        }
        throw new UnsupportedOperationException("Unknown type " + jetType);
    }

    private Type mapKnownAsmType(JetType jetType, Type asmType, @Nullable BothSignatureWriter signatureVisitor, boolean boxPrimitive) {
        if (boxPrimitive) {
            Type boxed = JetTypeMapper.boxType(asmType);
            if (signatureVisitor != null) {
                JetTypeMapper.visitAsmType(signatureVisitor, boxed, jetType.isNullable());
            }
            this.checkValidType(boxed);
            return boxed;
        }
        if (signatureVisitor != null) {
            JetTypeMapper.visitAsmType(signatureVisitor, asmType, jetType.isNullable());
        }
        this.checkValidType(asmType);
        return asmType;
    }

    public static void visitAsmType(BothSignatureWriter visitor, Type asmType, boolean nullable) {
        visitor.writeAsmType(asmType, nullable);
    }

    private void checkValidType(@NotNull Type type) {
        if (this.compilerSpecialMode == CompilerSpecialMode.BUILTINS) {
            String descriptor = type.getDescriptor();
            if (descriptor.equals("Ljava/lang/Object;")) {
                return;
            }
            if (descriptor.startsWith("Ljava/")) {
                throw new IllegalStateException("builtins must not reference java.* classes: " + descriptor);
            }
        }
    }

    public static Type unboxType(Type type) {
        JvmPrimitiveType jvmPrimitiveType = JvmPrimitiveType.getByWrapperAsmType(type);
        if (jvmPrimitiveType != null) {
            return jvmPrimitiveType.getAsmType();
        }
        throw new UnsupportedOperationException("Unboxing: " + type);
    }

    public static Type boxType(Type asmType) {
        JvmPrimitiveType jvmPrimitiveType = JvmPrimitiveType.getByAsmType(asmType);
        if (jvmPrimitiveType != null) {
            return jvmPrimitiveType.getWrapper().getAsmType();
        }
        return asmType;
    }

    public CallableMethod mapToCallableMethod(FunctionDescriptor functionDescriptor, boolean superCall, OwnerKind kind) {
        JvmClassName thisClass;
        int invokeOpcode;
        JvmClassName ownerForDefaultImpl;
        JvmClassName owner;
        JvmClassName ownerForDefaultParam;
        if (functionDescriptor == null) {
            return null;
        }
        DeclarationDescriptor functionParent = functionDescriptor.getOriginal().getContainingDeclaration();
        while (functionDescriptor.getKind() == CallableMemberDescriptor.Kind.FAKE_OVERRIDE) {
            functionDescriptor = functionDescriptor.getOverriddenDescriptors().iterator().next();
        }
        JvmMethodSignature descriptor = this.mapSignature(functionDescriptor.getOriginal(), true, kind);
        if (functionParent instanceof NamespaceDescriptor) {
            assert (!superCall);
            ownerForDefaultImpl = ownerForDefaultParam = (owner = this.jvmClassNameForNamespace((NamespaceDescriptor)functionParent));
            invokeOpcode = 184;
            thisClass = null;
        } else if (functionDescriptor instanceof ConstructorDescriptor) {
            assert (!superCall);
            ClassDescriptor containingClass = (ClassDescriptor)functionParent;
            ownerForDefaultImpl = ownerForDefaultParam = (owner = JvmClassName.byType(this.mapType(containingClass.getDefaultType(), MapTypeMode.IMPL)));
            invokeOpcode = 183;
            thisClass = null;
        } else if (functionParent instanceof ScriptDescriptor) {
            ownerForDefaultParam = ownerForDefaultImpl = this.closureAnnotator.classNameForScriptDescriptor((ScriptDescriptor)functionParent);
            owner = ownerForDefaultImpl;
            thisClass = ownerForDefaultImpl;
            invokeOpcode = 182;
        } else if (functionParent instanceof ClassDescriptor) {
            FunctionDescriptor declarationFunctionDescriptor = JetTypeMapper.findAnyDeclaration(functionDescriptor);
            ClassDescriptor currentOwner = (ClassDescriptor)functionParent;
            ClassDescriptor declarationOwner = (ClassDescriptor)declarationFunctionDescriptor.getContainingDeclaration();
            boolean originalIsInterface = CodegenUtil.isInterface(declarationOwner);
            boolean currentIsInterface = CodegenUtil.isInterface(currentOwner);
            ClassDescriptor receiver = currentIsInterface && !originalIsInterface ? declarationOwner : currentOwner;
            boolean isInterface = originalIsInterface && currentIsInterface;
            Type type = this.mapType(receiver.getDefaultType(), MapTypeMode.TYPE_PARAMETER);
            owner = JvmClassName.byType(type);
            ownerForDefaultParam = JvmClassName.byType(this.mapType(declarationOwner.getDefaultType(), MapTypeMode.TYPE_PARAMETER));
            ownerForDefaultImpl = JvmClassName.byInternalName(ownerForDefaultParam.getInternalName() + (originalIsInterface ? "$$TImpl" : ""));
            int n = isInterface ? (superCall ? 184 : 185) : (invokeOpcode = superCall ? 183 : 182);
            if (isInterface && superCall) {
                descriptor = this.mapSignature(functionDescriptor, false, OwnerKind.TRAIT_IMPL);
                owner = JvmClassName.byInternalName(owner.getInternalName() + "$$TImpl");
            }
            thisClass = JvmClassName.byType(this.mapType(receiver.getDefaultType(), MapTypeMode.VALUE));
        } else {
            throw new UnsupportedOperationException("unknown function parent");
        }
        Type receiverParameterType = functionDescriptor.getReceiverParameter().exists() ? this.mapType(functionDescriptor.getOriginal().getReceiverParameter().getType(), MapTypeMode.VALUE) : null;
        return new CallableMethod(owner, ownerForDefaultImpl, ownerForDefaultParam, descriptor, invokeOpcode, thisClass, receiverParameterType, null);
    }

    @NotNull
    private static FunctionDescriptor findAnyDeclaration(@NotNull FunctionDescriptor function) {
        if (function.getOverriddenDescriptors().isEmpty()) {
            return function;
        }
        return JetTypeMapper.findAnyDeclaration(function.getOverriddenDescriptors().iterator().next());
    }

    private JvmMethodSignature mapSignature(FunctionDescriptor f, boolean needGenericSignature, OwnerKind kind) {
        if (kind == OwnerKind.TRAIT_IMPL) {
            needGenericSignature = false;
        }
        BothSignatureWriter signatureVisitor = new BothSignatureWriter(BothSignatureWriter.Mode.METHOD, needGenericSignature);
        this.writeFormalTypeParameters(f.getTypeParameters(), signatureVisitor);
        ReceiverDescriptor receiverTypeRef = f.getReceiverParameter();
        JetType receiverType = !receiverTypeRef.exists() ? null : receiverTypeRef.getType();
        List<ValueParameterDescriptor> parameters = f.getValueParameters();
        signatureVisitor.writeParametersStart();
        if (kind == OwnerKind.TRAIT_IMPL) {
            ClassDescriptor containingDeclaration = (ClassDescriptor)f.getContainingDeclaration();
            JetType jetType = TraitImplBodyCodegen.getSuperClass(containingDeclaration, this.bindingContext);
            Type type = this.mapType(jetType, MapTypeMode.VALUE);
            if (type.getInternalName().equals("java/lang/Object")) {
                jetType = containingDeclaration.getDefaultType();
                type = this.mapType(jetType, MapTypeMode.VALUE);
            }
            signatureVisitor.writeParameterType(JvmMethodParameterKind.THIS);
            signatureVisitor.writeAsmType(type, jetType.isNullable());
            signatureVisitor.writeParameterTypeEnd();
        }
        if (receiverType != null) {
            signatureVisitor.writeParameterType(JvmMethodParameterKind.RECEIVER);
            this.mapType(receiverType, signatureVisitor, MapTypeMode.VALUE);
            signatureVisitor.writeParameterTypeEnd();
        }
        for (ValueParameterDescriptor parameter : parameters) {
            signatureVisitor.writeParameterType(JvmMethodParameterKind.VALUE);
            this.mapType(parameter.getType(), signatureVisitor, MapTypeMode.VALUE);
            signatureVisitor.writeParameterTypeEnd();
        }
        signatureVisitor.writeParametersEnd();
        if (f instanceof ConstructorDescriptor) {
            signatureVisitor.writeVoidReturn();
        } else {
            signatureVisitor.writeReturnType();
            this.mapReturnType(f.getReturnType(), signatureVisitor);
            signatureVisitor.writeReturnTypeEnd();
        }
        return signatureVisitor.makeJvmMethodSignature(f.getName().getName());
    }

    public void writeFormalTypeParameters(List<TypeParameterDescriptor> typeParameters, BothSignatureWriter signatureVisitor) {
        if (signatureVisitor == null) {
            return;
        }
        signatureVisitor.writeFormalTypeParametersStart();
        for (TypeParameterDescriptor typeParameterDescriptor : typeParameters) {
            this.writeFormalTypeParameter(typeParameterDescriptor, signatureVisitor);
        }
        signatureVisitor.writeFormalTypeParametersEnd();
    }

    private void writeFormalTypeParameter(TypeParameterDescriptor typeParameterDescriptor, BothSignatureWriter signatureVisitor) {
        signatureVisitor.writeFormalTypeParameter(typeParameterDescriptor.getName().getName(), typeParameterDescriptor.getVariance(), typeParameterDescriptor.isReified());
        signatureVisitor.writeClassBound();
        for (JetType jetType : typeParameterDescriptor.getUpperBounds()) {
            if (!(jetType.getConstructor().getDeclarationDescriptor() instanceof ClassDescriptor) || CodegenUtil.isInterface(jetType)) continue;
            this.mapType(jetType, signatureVisitor, MapTypeMode.TYPE_PARAMETER);
            break;
        }
        signatureVisitor.writeClassBoundEnd();
        for (JetType jetType : typeParameterDescriptor.getUpperBounds()) {
            if (jetType.getConstructor().getDeclarationDescriptor() instanceof ClassDescriptor && CodegenUtil.isInterface(jetType)) {
                signatureVisitor.writeInterfaceBound();
                this.mapType(jetType, signatureVisitor, MapTypeMode.TYPE_PARAMETER);
                signatureVisitor.writeInterfaceBoundEnd();
            }
            if (!(jetType.getConstructor().getDeclarationDescriptor() instanceof TypeParameterDescriptor)) continue;
            signatureVisitor.writeInterfaceBound();
            this.mapType(jetType, signatureVisitor, MapTypeMode.TYPE_PARAMETER);
            signatureVisitor.writeInterfaceBoundEnd();
        }
        signatureVisitor.writeFormalTypeParameterEnd();
    }

    public JvmMethodSignature mapSignature(Name name, FunctionDescriptor f) {
        ReceiverDescriptor receiver = f.getReceiverParameter();
        BothSignatureWriter signatureWriter = new BothSignatureWriter(BothSignatureWriter.Mode.METHOD, false);
        this.writeFormalTypeParameters(f.getTypeParameters(), signatureWriter);
        signatureWriter.writeParametersStart();
        List<ValueParameterDescriptor> parameters = f.getValueParameters();
        if (receiver.exists()) {
            signatureWriter.writeParameterType(JvmMethodParameterKind.RECEIVER);
            this.mapType(receiver.getType(), signatureWriter, MapTypeMode.VALUE);
            signatureWriter.writeParameterTypeEnd();
        }
        for (ValueParameterDescriptor parameter : parameters) {
            signatureWriter.writeParameterType(JvmMethodParameterKind.VALUE);
            this.mapType(parameter.getType(), signatureWriter, MapTypeMode.VALUE);
            signatureWriter.writeParameterTypeEnd();
        }
        signatureWriter.writeParametersEnd();
        signatureWriter.writeReturnType();
        this.mapReturnType(f.getReturnType(), signatureWriter);
        signatureWriter.writeReturnTypeEnd();
        return signatureWriter.makeJvmMethodSignature(name.getName());
    }

    public JvmPropertyAccessorSignature mapGetterSignature(PropertyDescriptor descriptor, OwnerKind kind) {
        DeclarationDescriptor parentDescriptor = descriptor.getContainingDeclaration();
        boolean isAnnotation = parentDescriptor instanceof ClassDescriptor && ((ClassDescriptor)parentDescriptor).getKind() == ClassKind.ANNOTATION_CLASS;
        String name = isAnnotation ? descriptor.getName().getName() : PropertyCodegen.getterName(descriptor.getName());
        BothSignatureWriter signatureWriter = new BothSignatureWriter(BothSignatureWriter.Mode.METHOD, true);
        this.writeFormalTypeParameters(descriptor.getTypeParameters(), signatureWriter);
        signatureWriter.writeParametersStart();
        if (kind == OwnerKind.TRAIT_IMPL) {
            ClassDescriptor containingDeclaration = (ClassDescriptor)parentDescriptor;
            assert (containingDeclaration != null);
            signatureWriter.writeParameterType(JvmMethodParameterKind.THIS);
            this.mapType(containingDeclaration.getDefaultType(), signatureWriter, MapTypeMode.IMPL);
            signatureWriter.writeParameterTypeEnd();
        }
        if (descriptor.getReceiverParameter().exists()) {
            signatureWriter.writeParameterType(JvmMethodParameterKind.RECEIVER);
            this.mapType(descriptor.getReceiverParameter().getType(), signatureWriter, MapTypeMode.VALUE);
            signatureWriter.writeParameterTypeEnd();
        }
        signatureWriter.writeParametersEnd();
        signatureWriter.writeReturnType();
        this.mapType(descriptor.getType(), signatureWriter, MapTypeMode.VALUE);
        signatureWriter.writeReturnTypeEnd();
        JvmMethodSignature jvmMethodSignature = signatureWriter.makeJvmMethodSignature(name);
        return new JvmPropertyAccessorSignature(jvmMethodSignature, jvmMethodSignature.getKotlinReturnType());
    }

    @Nullable
    public JvmPropertyAccessorSignature mapSetterSignature(PropertyDescriptor descriptor, OwnerKind kind) {
        if (!descriptor.isVar()) {
            return null;
        }
        BothSignatureWriter signatureWriter = new BothSignatureWriter(BothSignatureWriter.Mode.METHOD, true);
        this.writeFormalTypeParameters(descriptor.getTypeParameters(), signatureWriter);
        JetType outType = descriptor.getType();
        signatureWriter.writeParametersStart();
        String name = PropertyCodegen.setterName(descriptor.getName());
        if (kind == OwnerKind.TRAIT_IMPL) {
            ClassDescriptor containingDeclaration = (ClassDescriptor)descriptor.getContainingDeclaration();
            assert (containingDeclaration != null);
            signatureWriter.writeParameterType(JvmMethodParameterKind.THIS);
            this.mapType(containingDeclaration.getDefaultType(), signatureWriter, MapTypeMode.VALUE);
            signatureWriter.writeParameterTypeEnd();
        }
        if (descriptor.getReceiverParameter().exists()) {
            signatureWriter.writeParameterType(JvmMethodParameterKind.RECEIVER);
            this.mapType(descriptor.getReceiverParameter().getType(), signatureWriter, MapTypeMode.VALUE);
            signatureWriter.writeParameterTypeEnd();
        }
        signatureWriter.writeParameterType(JvmMethodParameterKind.VALUE);
        this.mapType(outType, signatureWriter, MapTypeMode.VALUE);
        signatureWriter.writeParameterTypeEnd();
        signatureWriter.writeParametersEnd();
        signatureWriter.writeVoidReturn();
        JvmMethodSignature jvmMethodSignature = signatureWriter.makeJvmMethodSignature(name);
        return new JvmPropertyAccessorSignature(jvmMethodSignature, jvmMethodSignature.getKotlinParameterType(jvmMethodSignature.getParameterCount() - 1));
    }

    private JvmMethodSignature mapConstructorSignature(ConstructorDescriptor descriptor, boolean hasThis0) {
        BothSignatureWriter signatureWriter = new BothSignatureWriter(BothSignatureWriter.Mode.METHOD, true);
        List<ValueParameterDescriptor> parameters = descriptor.getOriginal().getValueParameters();
        this.writeFormalTypeParameters(Collections.<TypeParameterDescriptor>emptyList(), signatureWriter);
        signatureWriter.writeParametersStart();
        if (hasThis0) {
            signatureWriter.writeParameterType(JvmMethodParameterKind.THIS0);
            this.mapType(this.closureAnnotator.getEclosingClassDescriptor(descriptor.getContainingDeclaration()).getDefaultType(), signatureWriter, MapTypeMode.VALUE);
            signatureWriter.writeParameterTypeEnd();
        }
        for (ValueParameterDescriptor parameter : parameters) {
            signatureWriter.writeParameterType(JvmMethodParameterKind.VALUE);
            this.mapType(parameter.getType(), signatureWriter, MapTypeMode.VALUE);
            signatureWriter.writeParameterTypeEnd();
        }
        signatureWriter.writeParametersEnd();
        signatureWriter.writeVoidReturn();
        return signatureWriter.makeJvmMethodSignature("<init>");
    }

    @NotNull
    public JvmMethodSignature mapScriptSignature(@NotNull ScriptDescriptor script, @NotNull List<ScriptDescriptor> importedScripts) {
        BothSignatureWriter signatureWriter = new BothSignatureWriter(BothSignatureWriter.Mode.METHOD, false);
        this.writeFormalTypeParameters(Collections.<TypeParameterDescriptor>emptyList(), signatureWriter);
        signatureWriter.writeParametersStart();
        for (ScriptDescriptor importedScript : importedScripts) {
            signatureWriter.writeParameterType(JvmMethodParameterKind.VALUE);
            this.mapType(this.closureAnnotator.classDescriptorForScrpitDescriptor(importedScript).getDefaultType(), signatureWriter, MapTypeMode.VALUE);
            signatureWriter.writeParameterTypeEnd();
        }
        for (ValueParameterDescriptor valueParameter : script.getValueParameters()) {
            signatureWriter.writeParameterType(JvmMethodParameterKind.VALUE);
            this.mapType(valueParameter.getType(), signatureWriter, MapTypeMode.VALUE);
            signatureWriter.writeParameterTypeEnd();
        }
        signatureWriter.writeParametersEnd();
        signatureWriter.writeVoidReturn();
        return signatureWriter.makeJvmMethodSignature("<init>");
    }

    public CallableMethod mapToCallableMethod(ConstructorDescriptor descriptor, OwnerKind kind, boolean hasThis0) {
        JvmMethodSignature method = this.mapConstructorSignature(descriptor, hasThis0);
        MapTypeMode mapTypeMode = JetTypeMapper.ownerKindToMapTypeMode(kind);
        JetType defaultType = descriptor.getContainingDeclaration().getDefaultType();
        Type mapped = this.mapType(defaultType, mapTypeMode);
        if (mapped.getSort() != 10) {
            throw new IllegalStateException("type must have been mapped to object: " + defaultType + ", actual: " + mapped);
        }
        JvmClassName owner = JvmClassName.byType(mapped);
        return new CallableMethod(owner, owner, owner, method, 183, null, null, null);
    }

    public static int getAccessModifiers(MemberDescriptor p, int defaultFlags) {
        DeclarationDescriptor declaration = p.getContainingDeclaration();
        if (CodegenUtil.isInterface(declaration)) {
            return 1;
        }
        if (p.getVisibility() == Visibilities.PUBLIC) {
            return 1;
        }
        if (p.getVisibility() == Visibilities.PROTECTED) {
            return 4;
        }
        if (p.getVisibility() == Visibilities.PRIVATE) {
            if (DescriptorUtils.isClassObject(declaration)) {
                return defaultFlags;
            }
            return 2;
        }
        return defaultFlags;
    }

    public Collection<String> allJvmNames(JetClassOrObject jetClass) {
        HashSet<String> result = new HashSet<String>();
        ClassDescriptor classDescriptor = this.bindingContext.get(BindingContext.CLASS, jetClass);
        if (classDescriptor != null) {
            result.add(this.mapType(classDescriptor.getDefaultType(), MapTypeMode.IMPL).getInternalName());
        }
        return result;
    }

    private void initKnownTypeNames() {
        this.knowTypeNames.put(JetStandardClasses.getAnyType(), "ANY_TYPE_INFO");
        this.knowTypeNames.put(JetStandardClasses.getNullableAnyType(), "NULLABLE_ANY_TYPE_INFO");
        for (JvmPrimitiveType jvmPrimitiveType : JvmPrimitiveType.values()) {
            PrimitiveType primitiveType = jvmPrimitiveType.getPrimitiveType();
            this.knowTypeNames.put(this.standardLibrary.getPrimitiveJetType(primitiveType), jvmPrimitiveType.name() + "_TYPE_INFO");
            this.knowTypeNames.put(this.standardLibrary.getNullablePrimitiveJetType(primitiveType), "NULLABLE_" + jvmPrimitiveType.name() + "_TYPE_INFO");
            this.knowTypeNames.put(this.standardLibrary.getPrimitiveArrayJetType(primitiveType), jvmPrimitiveType.name() + "_ARRAY_TYPE_INFO");
            this.knowTypeNames.put(this.standardLibrary.getNullablePrimitiveArrayJetType(primitiveType), jvmPrimitiveType.name() + "_ARRAY_TYPE_INFO");
        }
        this.knowTypeNames.put(this.standardLibrary.getStringType(), "STRING_TYPE_INFO");
        this.knowTypeNames.put(this.standardLibrary.getNullableStringType(), "NULLABLE_STRING_TYPE_INFO");
        this.knowTypeNames.put(this.standardLibrary.getTuple0Type(), "TUPLE0_TYPE_INFO");
        this.knowTypeNames.put(this.standardLibrary.getNullableTuple0Type(), "NULLABLE_TUPLE0_TYPE_INFO");
    }

    private void initKnownTypes() {
        PrimitiveType primitiveType;
        this.knowTypes.put(JetStandardClasses.getNothingType(), TYPE_NOTHING);
        this.knowTypes.put(JetStandardClasses.getNullableNothingType(), TYPE_NOTHING);
        for (JvmPrimitiveType jvmPrimitiveType : JvmPrimitiveType.values()) {
            primitiveType = jvmPrimitiveType.getPrimitiveType();
            this.knowTypes.put(this.standardLibrary.getPrimitiveJetType(primitiveType), jvmPrimitiveType.getAsmType());
            this.knowTypes.put(this.standardLibrary.getNullablePrimitiveJetType(primitiveType), jvmPrimitiveType.getWrapper().getAsmType());
        }
        this.knowTypes.put(this.standardLibrary.getNumberType(), JL_NUMBER_TYPE);
        this.knowTypes.put(this.standardLibrary.getStringType(), JL_STRING_TYPE);
        this.knowTypes.put(this.standardLibrary.getNullableStringType(), JL_STRING_TYPE);
        this.knowTypes.put(this.standardLibrary.getCharSequenceType(), JL_CHAR_SEQUENCE_TYPE);
        this.knowTypes.put(this.standardLibrary.getNullableCharSequenceType(), JL_CHAR_SEQUENCE_TYPE);
        this.knowTypes.put(this.standardLibrary.getThrowableType(), TYPE_THROWABLE);
        this.knowTypes.put(this.standardLibrary.getNullableThrowableType(), TYPE_THROWABLE);
        for (JvmPrimitiveType jvmPrimitiveType : JvmPrimitiveType.values()) {
            primitiveType = jvmPrimitiveType.getPrimitiveType();
            this.knowTypes.put(this.standardLibrary.getPrimitiveArrayJetType(primitiveType), jvmPrimitiveType.getAsmArrayType());
            this.knowTypes.put(this.standardLibrary.getNullablePrimitiveArrayJetType(primitiveType), jvmPrimitiveType.getAsmArrayType());
        }
    }

    private boolean isForceReal(JvmClassName className) {
        return JvmPrimitiveType.getByWrapperClass(className) != null || className.getFqName().getFqName().equals("java.lang.String") || className.getFqName().getFqName().equals("java.lang.CharSequence") || className.getFqName().getFqName().equals("java.lang.Object");
    }

    public boolean isGenericsArray(JetType type) {
        ClassifierDescriptor declarationDescriptor = type.getConstructor().getDeclarationDescriptor();
        if (declarationDescriptor instanceof TypeParameterDescriptor) {
            return true;
        }
        if (this.standardLibrary.getArray().equals(declarationDescriptor)) {
            return this.isGenericsArray(type.getArguments().get(0).getType());
        }
        return false;
    }

    public JetType getGenericsElementType(JetType arrayType) {
        JetType type = arrayType.getArguments().get(0).getType();
        return this.isGenericsArray(type) ? type : null;
    }

    public Type getSharedVarType(DeclarationDescriptor descriptor) {
        if (descriptor instanceof PropertyDescriptor) {
            return StackValue.sharedTypeForType(this.mapType(((PropertyDescriptor)descriptor).getReceiverParameter().getType(), MapTypeMode.VALUE));
        }
        if (descriptor instanceof SimpleFunctionDescriptor && descriptor.getContainingDeclaration() instanceof FunctionDescriptor) {
            PsiElement psiElement = BindingContextUtils.descriptorToDeclaration(this.bindingContext, descriptor);
            return this.closureAnnotator.classNameForAnonymousClass((JetElement)psiElement).getAsmType();
        }
        if (descriptor instanceof FunctionDescriptor) {
            return StackValue.sharedTypeForType(this.mapType(((FunctionDescriptor)descriptor).getReceiverParameter().getType(), MapTypeMode.VALUE));
        }
        if (descriptor instanceof VariableDescriptor && this.isVarCapturedInClosure(descriptor)) {
            JetType outType = ((VariableDescriptor)descriptor).getType();
            return StackValue.sharedTypeForType(this.mapType(outType, MapTypeMode.VALUE));
        }
        return null;
    }

    public boolean isVarCapturedInClosure(DeclarationDescriptor descriptor) {
        if (!(descriptor instanceof VariableDescriptor) || descriptor instanceof PropertyDescriptor) {
            return false;
        }
        VariableDescriptor variableDescriptor = (VariableDescriptor)descriptor;
        Boolean aBoolean = this.bindingContext.get(BindingContext.CAPTURED_IN_CLOSURE, variableDescriptor);
        return aBoolean != null && aBoolean != false && variableDescriptor.isVar();
    }
}

