/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.codegen;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.codegen.AnnotationCodegen;
import org.jetbrains.jet.codegen.CallableMethod;
import org.jetbrains.jet.codegen.ClassBodyCodegen;
import org.jetbrains.jet.codegen.ClassBuilder;
import org.jetbrains.jet.codegen.ClassBuilderMode;
import org.jetbrains.jet.codegen.CodeChunk;
import org.jetbrains.jet.codegen.CodegenContext;
import org.jetbrains.jet.codegen.CodegenContexts;
import org.jetbrains.jet.codegen.CodegenUtil;
import org.jetbrains.jet.codegen.CompilationException;
import org.jetbrains.jet.codegen.ConstructorFrameMap;
import org.jetbrains.jet.codegen.ExpressionCodegen;
import org.jetbrains.jet.codegen.FrameMap;
import org.jetbrains.jet.codegen.FunctionCodegen;
import org.jetbrains.jet.codegen.GenerationState;
import org.jetbrains.jet.codegen.JetTypeMapper;
import org.jetbrains.jet.codegen.MapTypeMode;
import org.jetbrains.jet.codegen.ObjectOrClosureCodegen;
import org.jetbrains.jet.codegen.OwnerKind;
import org.jetbrains.jet.codegen.PropertyCodegen;
import org.jetbrains.jet.codegen.StackValue;
import org.jetbrains.jet.codegen.StubCodegen;
import org.jetbrains.jet.codegen.TraitImplBodyCodegen;
import org.jetbrains.jet.codegen.signature.BothSignatureWriter;
import org.jetbrains.jet.codegen.signature.JvmClassSignature;
import org.jetbrains.jet.codegen.signature.JvmMethodParameterKind;
import org.jetbrains.jet.codegen.signature.JvmMethodParameterSignature;
import org.jetbrains.jet.codegen.signature.JvmMethodSignature;
import org.jetbrains.jet.codegen.signature.JvmPropertyAccessorSignature;
import org.jetbrains.jet.codegen.signature.kotlin.JetMethodAnnotationWriter;
import org.jetbrains.jet.codegen.signature.kotlin.JetValueParameterAnnotationWriter;
import org.jetbrains.jet.internal.com.google.common.collect.Lists;
import org.jetbrains.jet.internal.com.intellij.openapi.progress.ProcessCanceledException;
import org.jetbrains.jet.internal.com.intellij.openapi.util.Pair;
import org.jetbrains.jet.internal.com.intellij.psi.PsiElement;
import org.jetbrains.jet.internal.org.objectweb.asm.AnnotationVisitor;
import org.jetbrains.jet.internal.org.objectweb.asm.MethodVisitor;
import org.jetbrains.jet.internal.org.objectweb.asm.Type;
import org.jetbrains.jet.internal.org.objectweb.asm.commons.InstructionAdapter;
import org.jetbrains.jet.internal.org.objectweb.asm.commons.Method;
import org.jetbrains.jet.lang.descriptors.CallableMemberDescriptor;
import org.jetbrains.jet.lang.descriptors.ClassDescriptor;
import org.jetbrains.jet.lang.descriptors.ClassKind;
import org.jetbrains.jet.lang.descriptors.ConstructorDescriptor;
import org.jetbrains.jet.lang.descriptors.DeclarationDescriptor;
import org.jetbrains.jet.lang.descriptors.FunctionDescriptor;
import org.jetbrains.jet.lang.descriptors.Modality;
import org.jetbrains.jet.lang.descriptors.NamespaceDescriptor;
import org.jetbrains.jet.lang.descriptors.PropertyAccessorDescriptor;
import org.jetbrains.jet.lang.descriptors.PropertyDescriptor;
import org.jetbrains.jet.lang.descriptors.PropertyGetterDescriptor;
import org.jetbrains.jet.lang.descriptors.PropertySetterDescriptor;
import org.jetbrains.jet.lang.descriptors.SimpleFunctionDescriptor;
import org.jetbrains.jet.lang.descriptors.TypeParameterDescriptor;
import org.jetbrains.jet.lang.descriptors.ValueParameterDescriptor;
import org.jetbrains.jet.lang.descriptors.VariableDescriptor;
import org.jetbrains.jet.lang.descriptors.Visibilities;
import org.jetbrains.jet.lang.psi.JetCallElement;
import org.jetbrains.jet.lang.psi.JetClass;
import org.jetbrains.jet.lang.psi.JetClassInitializer;
import org.jetbrains.jet.lang.psi.JetClassObject;
import org.jetbrains.jet.lang.psi.JetClassOrObject;
import org.jetbrains.jet.lang.psi.JetDeclaration;
import org.jetbrains.jet.lang.psi.JetDelegationSpecifier;
import org.jetbrains.jet.lang.psi.JetDelegatorByExpressionSpecifier;
import org.jetbrains.jet.lang.psi.JetDelegatorToSuperCall;
import org.jetbrains.jet.lang.psi.JetDelegatorToSuperClass;
import org.jetbrains.jet.lang.psi.JetDelegatorToThisCall;
import org.jetbrains.jet.lang.psi.JetEnumEntry;
import org.jetbrains.jet.lang.psi.JetExpression;
import org.jetbrains.jet.lang.psi.JetNamedFunction;
import org.jetbrains.jet.lang.psi.JetObjectDeclaration;
import org.jetbrains.jet.lang.psi.JetParameter;
import org.jetbrains.jet.lang.psi.JetProperty;
import org.jetbrains.jet.lang.psi.JetSecondaryConstructor;
import org.jetbrains.jet.lang.resolve.BindingContext;
import org.jetbrains.jet.lang.resolve.BindingContextUtils;
import org.jetbrains.jet.lang.resolve.OverridingUtil;
import org.jetbrains.jet.lang.resolve.constants.CompileTimeConstant;
import org.jetbrains.jet.lang.resolve.java.JvmClassName;
import org.jetbrains.jet.lang.resolve.java.JvmStdlibNames;
import org.jetbrains.jet.lang.types.JetType;
import org.jetbrains.jet.lexer.JetTokens;

public class ImplementationBodyCodegen
extends ClassBodyCodegen {
    private JetDelegationSpecifier superCall;
    private String superClass;
    @Nullable
    private JetType superClassType;
    private final JetTypeMapper typeMapper;
    private final BindingContext bindingContext;
    private final List<JetEnumEntry> myEnumConstants = new ArrayList<JetEnumEntry>();

    public ImplementationBodyCodegen(JetClassOrObject aClass, CodegenContext context, ClassBuilder v, GenerationState state) {
        super(aClass, context, v, state);
        this.typeMapper = state.getInjector().getJetTypeMapper();
        this.bindingContext = state.getBindingContext();
    }

    @Override
    protected void generateDeclaration() {
        this.getSuperClass();
        JvmClassSignature signature = this.signature();
        boolean isAbstract = false;
        boolean isInterface = false;
        boolean isFinal = false;
        boolean isStatic = false;
        boolean isAnnotation = false;
        if (this.myClass instanceof JetClass) {
            JetClass jetClass = (JetClass)this.myClass;
            if (jetClass.hasModifier(JetTokens.ABSTRACT_KEYWORD)) {
                isAbstract = true;
            }
            if (jetClass.isTrait()) {
                isAbstract = true;
                isInterface = true;
            }
            if (jetClass.isAnnotation()) {
                isAbstract = true;
                isInterface = true;
                isAnnotation = true;
                signature.getInterfaces().add("java/lang/annotation/Annotation");
            }
            if (!jetClass.hasModifier(JetTokens.OPEN_KEYWORD) && !isAbstract) {
                isFinal = true;
            }
        } else if (this.myClass.getParent() instanceof JetClassObject) {
            isStatic = true;
        }
        int access = 0;
        access |= 1;
        if (isAbstract) {
            access |= 0x400;
        }
        access = isInterface ? (access |= 0x200) : (access |= 0x20);
        if (isFinal) {
            access |= 0x10;
        }
        if (isStatic) {
            access |= 8;
        }
        if (isAnnotation) {
            access |= 0x2000;
        }
        this.v.defineClass(this.myClass, 50, access, signature.getName(), signature.getJavaGenericSignature(), signature.getSuperclassName(), signature.getInterfaces().toArray(new String[0]));
        this.v.visitSource(this.myClass.getContainingFile().getName(), null);
        ClassDescriptor container = ImplementationBodyCodegen.getContainingClassDescriptor(this.descriptor);
        if (container != null) {
            this.v.visitOuterClass(this.typeMapper.mapType(container.getDefaultType(), MapTypeMode.IMPL).getInternalName(), null, null);
        }
        for (DeclarationDescriptor declarationDescriptor : this.descriptor.getUnsubstitutedInnerClassesScope().getAllDescriptors()) {
            assert (declarationDescriptor instanceof ClassDescriptor);
            ClassDescriptor innerClass = (ClassDescriptor)declarationDescriptor;
            int innerClassAccess = 1;
            if (innerClass.getModality() == Modality.FINAL) {
                innerClassAccess |= 0x10;
            } else if (innerClass.getModality() == Modality.ABSTRACT) {
                innerClassAccess |= 0x400;
            }
            if (innerClass.getKind() == ClassKind.TRAIT) {
                innerClassAccess |= 0x200;
            }
            String outerClassInernalName = this.typeMapper.mapType(this.descriptor.getDefaultType(), MapTypeMode.IMPL).getInternalName();
            String innerClassInternalName = this.typeMapper.mapType(innerClass.getDefaultType(), MapTypeMode.IMPL).getInternalName();
            this.v.visitInnerClass(innerClassInternalName, outerClassInernalName, innerClass.getName().getName(), innerClassAccess);
        }
        if (this.descriptor.getClassObjectDescriptor() != null) {
            int innerClassAccess = 25;
            String outerClassInernalName = this.typeMapper.mapType(this.descriptor.getDefaultType(), MapTypeMode.IMPL).getInternalName();
            this.v.visitInnerClass(outerClassInernalName + "$ClassObject$", outerClassInernalName, "ClassObject$", innerClassAccess);
        }
        AnnotationCodegen.forClass(this.v.getVisitor(), this.typeMapper).genAnnotations(this.descriptor);
        if (signature.getKotlinGenericSignature() != null) {
            AnnotationVisitor annotationVisitor = this.v.newAnnotation(this.myClass, JvmStdlibNames.JET_CLASS.getDescriptor(), true);
            annotationVisitor.visit("signature", signature.getKotlinGenericSignature());
            annotationVisitor.visitEnd();
        }
    }

    private static ClassDescriptor getContainingClassDescriptor(ClassDescriptor decl) {
        for (DeclarationDescriptor container = decl.getContainingDeclaration(); container != null && !(container instanceof NamespaceDescriptor); container = container.getContainingDeclaration()) {
            if (!(container instanceof ClassDescriptor)) continue;
            return (ClassDescriptor)container;
        }
        return null;
    }

    private JvmClassSignature signature() {
        LinkedHashSet<String> superInterfacesLinkedHashSet = new LinkedHashSet<String>();
        BothSignatureWriter signatureVisitor = new BothSignatureWriter(BothSignatureWriter.Mode.CLASS, true);
        List<TypeParameterDescriptor> typeParameters = this.descriptor.getTypeConstructor().getParameters();
        this.typeMapper.writeFormalTypeParameters(typeParameters, signatureVisitor);
        signatureVisitor.writeSupersStart();
        signatureVisitor.writeSuperclass();
        if (this.superClassType == null) {
            signatureVisitor.writeClassBegin(this.superClass, false, false);
            signatureVisitor.writeClassEnd();
        } else {
            this.typeMapper.mapType(this.superClassType, signatureVisitor, MapTypeMode.TYPE_PARAMETER);
        }
        signatureVisitor.writeSuperclassEnd();
        superInterfacesLinkedHashSet.add(JvmStdlibNames.JET_OBJECT.getInternalName());
        for (JetDelegationSpecifier specifier : this.myClass.getDelegationSpecifiers()) {
            JetType superType = this.bindingContext.get(BindingContext.TYPE, specifier.getTypeReference());
            assert (superType != null);
            ClassDescriptor superClassDescriptor = (ClassDescriptor)superType.getConstructor().getDeclarationDescriptor();
            if (!CodegenUtil.isInterface(superClassDescriptor)) continue;
            signatureVisitor.writeInterface();
            Type jvmName = this.typeMapper.mapType(superType, signatureVisitor, MapTypeMode.TYPE_PARAMETER);
            signatureVisitor.writeInterfaceEnd();
            superInterfacesLinkedHashSet.add(jvmName.getInternalName());
        }
        ArrayList<String> superInterfaces = new ArrayList<String>(superInterfacesLinkedHashSet);
        signatureVisitor.writeSupersEnd();
        return new JvmClassSignature(this.jvmName(), this.superClass, superInterfaces, signatureVisitor.makeJavaString(), signatureVisitor.makeKotlinClassSignature());
    }

    private String jvmName() {
        if (this.kind != OwnerKind.IMPLEMENTATION) {
            throw new IllegalStateException("must not call this method with kind " + this.kind);
        }
        return this.typeMapper.mapType(this.descriptor.getDefaultType(), MapTypeMode.IMPL).getInternalName();
    }

    protected void getSuperClass() {
        this.superClass = "java/lang/Object";
        this.superClassType = null;
        List<JetDelegationSpecifier> delegationSpecifiers = this.myClass.getDelegationSpecifiers();
        if (this.myClass instanceof JetClass && ((JetClass)this.myClass).isTrait()) {
            return;
        }
        if (this.kind != OwnerKind.IMPLEMENTATION) {
            throw new IllegalStateException("must be impl to reach this code: " + this.kind);
        }
        for (JetDelegationSpecifier specifier : delegationSpecifiers) {
            if (!(specifier instanceof JetDelegatorToSuperClass) && !(specifier instanceof JetDelegatorToSuperCall)) continue;
            JetType superType = this.bindingContext.get(BindingContext.TYPE, specifier.getTypeReference());
            assert (superType != null);
            ClassDescriptor superClassDescriptor = (ClassDescriptor)superType.getConstructor().getDeclarationDescriptor();
            if (CodegenUtil.isInterface(superClassDescriptor)) continue;
            this.superClassType = superType;
            this.superClass = this.typeMapper.mapType(superClassDescriptor.getDefaultType(), MapTypeMode.IMPL).getInternalName();
            this.superCall = specifier;
        }
    }

    @Override
    protected void generateSyntheticParts() {
        this.generateFieldForObjectInstance();
        this.generateFieldForClassObject();
        try {
            this.generatePrimaryConstructor();
        }
        catch (CompilationException e) {
            throw e;
        }
        catch (ProcessCanceledException e) {
            throw e;
        }
        catch (RuntimeException e) {
            throw new RuntimeException("Error generating primary constructor of class " + this.myClass.getName() + " with kind " + this.kind, e);
        }
        this.generateAccessors();
    }

    private void generateAccessors() {
        if (this.context.accessors != null) {
            for (Map.Entry<DeclarationDescriptor, DeclarationDescriptor> entry : this.context.accessors.entrySet()) {
                this.genAccessor(entry);
            }
        }
    }

    private void genAccessor(Map.Entry<DeclarationDescriptor, DeclarationDescriptor> entry) {
        if (entry.getValue() instanceof FunctionDescriptor) {
            FunctionDescriptor bridge = (FunctionDescriptor)entry.getValue();
            FunctionDescriptor original = (FunctionDescriptor)entry.getKey();
            Method method = this.typeMapper.mapSignature(bridge.getName(), bridge).getAsmMethod();
            Method originalMethod = this.typeMapper.mapSignature(original.getName(), original).getAsmMethod();
            Type[] argTypes = method.getArgumentTypes();
            MethodVisitor mv = this.v.newMethod(null, 81, bridge.getName().getName(), method.getDescriptor(), null, null);
            if (this.state.getClassBuilderMode() == ClassBuilderMode.STUBS) {
                StubCodegen.generateStubCode(mv);
            } else if (this.state.getClassBuilderMode() == ClassBuilderMode.FULL) {
                mv.visitCode();
                InstructionAdapter iv = new InstructionAdapter(mv);
                iv.load(0, JetTypeMapper.TYPE_OBJECT);
                int reg = 1;
                for (int i = 0; i < argTypes.length; ++i) {
                    Type argType = argTypes[i];
                    iv.load(reg, argType);
                    reg += argType.getSize();
                }
                iv.invokespecial(this.typeMapper.getOwner(original, OwnerKind.IMPLEMENTATION).getInternalName(), originalMethod.getName(), originalMethod.getDescriptor());
                iv.areturn(method.getReturnType());
                FunctionCodegen.endVisit(iv, "accessor", null);
            }
        } else if (entry.getValue() instanceof PropertyDescriptor) {
            InstructionAdapter iv;
            PropertyDescriptor bridge = (PropertyDescriptor)entry.getValue();
            PropertyDescriptor original = (PropertyDescriptor)entry.getKey();
            Method method = this.typeMapper.mapGetterSignature(bridge, OwnerKind.IMPLEMENTATION).getJvmMethodSignature().getAsmMethod();
            JvmPropertyAccessorSignature originalSignature = this.typeMapper.mapGetterSignature(original, OwnerKind.IMPLEMENTATION);
            Method originalMethod = originalSignature.getJvmMethodSignature().getAsmMethod();
            MethodVisitor mv = this.v.newMethod(null, 81, method.getName(), method.getDescriptor(), null, null);
            PropertyCodegen.generateJetPropertyAnnotation(mv, originalSignature.getPropertyTypeKotlinSignature(), originalSignature.getJvmMethodSignature().getKotlinTypeParameter(), original);
            if (this.state.getClassBuilderMode() == ClassBuilderMode.STUBS) {
                StubCodegen.generateStubCode(mv);
            } else if (this.state.getClassBuilderMode() == ClassBuilderMode.FULL) {
                mv.visitCode();
                iv = new InstructionAdapter(mv);
                iv.load(0, JetTypeMapper.TYPE_OBJECT);
                if (original.getVisibility() == Visibilities.PRIVATE) {
                    iv.getfield(this.typeMapper.getOwner(original, OwnerKind.IMPLEMENTATION).getInternalName(), original.getName().getName(), originalMethod.getReturnType().getDescriptor());
                } else {
                    iv.invokespecial(this.typeMapper.getOwner(original, OwnerKind.IMPLEMENTATION).getInternalName(), originalMethod.getName(), originalMethod.getDescriptor());
                }
                iv.areturn(method.getReturnType());
                FunctionCodegen.endVisit(iv, "accessor", null);
            }
            if (bridge.isVar()) {
                method = this.typeMapper.mapSetterSignature(bridge, OwnerKind.IMPLEMENTATION).getJvmMethodSignature().getAsmMethod();
                JvmPropertyAccessorSignature originalSignature2 = this.typeMapper.mapSetterSignature(original, OwnerKind.IMPLEMENTATION);
                originalMethod = originalSignature2.getJvmMethodSignature().getAsmMethod();
                mv = this.v.newMethod(null, 81, method.getName(), method.getDescriptor(), null, null);
                PropertyCodegen.generateJetPropertyAnnotation(mv, originalSignature2.getPropertyTypeKotlinSignature(), originalSignature2.getJvmMethodSignature().getKotlinTypeParameter(), original);
                if (this.state.getClassBuilderMode() == ClassBuilderMode.STUBS) {
                    StubCodegen.generateStubCode(mv);
                } else if (this.state.getClassBuilderMode() == ClassBuilderMode.FULL) {
                    mv.visitCode();
                    iv = new InstructionAdapter(mv);
                    iv.load(0, JetTypeMapper.TYPE_OBJECT);
                    Type[] argTypes = method.getArgumentTypes();
                    int reg = 1;
                    for (int i = 0; i < argTypes.length; ++i) {
                        Type argType = argTypes[i];
                        iv.load(reg, argType);
                        reg += argType.getSize();
                    }
                    if (original.getVisibility() == Visibilities.PRIVATE && original.getModality() == Modality.FINAL) {
                        iv.putfield(this.typeMapper.getOwner(original, OwnerKind.IMPLEMENTATION).getInternalName(), original.getName().getName(), originalMethod.getArgumentTypes()[0].getDescriptor());
                    } else {
                        iv.invokespecial(this.typeMapper.getOwner(original, OwnerKind.IMPLEMENTATION).getInternalName(), originalMethod.getName(), originalMethod.getDescriptor());
                    }
                    iv.areturn(method.getReturnType());
                    FunctionCodegen.endVisit(iv, "accessor", null);
                }
            }
        } else {
            throw new UnsupportedOperationException();
        }
    }

    private void generateFieldForObjectInstance() {
        if (CodegenUtil.isNonLiteralObject(this.myClass)) {
            Type type = this.typeMapper.mapType(this.descriptor.getDefaultType(), MapTypeMode.VALUE);
            this.v.newField(this.myClass, 25, "$instance", type.getDescriptor(), null, null);
            this.staticInitializerChunks.add(new CodeChunk(){

                @Override
                public void generate(InstructionAdapter v) {
                    String name = ImplementationBodyCodegen.this.jvmName();
                    v.anew(Type.getObjectType(name));
                    v.dup();
                    v.invokespecial(name, "<init>", "()V");
                    v.putstatic(name, "$instance", ImplementationBodyCodegen.this.typeMapper.mapType(ImplementationBodyCodegen.this.descriptor.getDefaultType(), MapTypeMode.VALUE).getDescriptor());
                }
            });
        }
    }

    private void generateFieldForClassObject() {
        final JetClassObject classObject = this.getClassObject();
        if (classObject != null) {
            ClassDescriptor descriptor1 = this.bindingContext.get(BindingContext.CLASS, classObject.getObjectDeclaration());
            Type type = Type.getObjectType(this.typeMapper.mapType(descriptor1.getDefaultType(), MapTypeMode.VALUE).getInternalName());
            this.v.newField(classObject, 9, "$classobj", type.getDescriptor(), null, null);
            this.staticInitializerChunks.add(new CodeChunk(){

                @Override
                public void generate(InstructionAdapter v) {
                    ClassDescriptor descriptor1 = ImplementationBodyCodegen.this.bindingContext.get(BindingContext.CLASS, classObject.getObjectDeclaration());
                    String name = ImplementationBodyCodegen.this.typeMapper.mapType(descriptor1.getDefaultType(), MapTypeMode.IMPL).getInternalName();
                    Type classObjectType = Type.getObjectType(name);
                    v.anew(classObjectType);
                    v.dup();
                    v.invokespecial(name, "<init>", "()V");
                    v.putstatic(ImplementationBodyCodegen.this.typeMapper.mapType(ImplementationBodyCodegen.this.descriptor.getDefaultType(), MapTypeMode.VALUE).getInternalName(), "$classobj", classObjectType.getDescriptor());
                }
            });
        }
    }

    protected void generatePrimaryConstructor() {
        boolean hasOuterThis;
        CallableMethod callableMethod;
        JvmMethodSignature constructorMethod;
        if (this.myClass instanceof JetClass) {
            JetClass aClass = (JetClass)this.myClass;
            if (aClass.isTrait()) {
                return;
            }
            if (aClass.isAnnotation()) {
                return;
            }
        }
        if (this.kind != OwnerKind.IMPLEMENTATION) {
            throw new IllegalStateException("incorrect kind for primary constructor: " + this.kind);
        }
        ConstructorDescriptor constructorDescriptor = this.bindingContext.get(BindingContext.CONSTRUCTOR, this.myClass);
        CodegenContexts.ConstructorContext constructorContext = this.context.intoConstructor(constructorDescriptor, this.typeMapper);
        boolean hasThis0 = this.typeMapper.hasThis0(this.descriptor);
        if (constructorDescriptor == null) {
            BothSignatureWriter signatureWriter = new BothSignatureWriter(BothSignatureWriter.Mode.METHOD, false);
            signatureWriter.writeFormalTypeParametersStart();
            signatureWriter.writeFormalTypeParametersEnd();
            signatureWriter.writeParametersStart();
            if (hasThis0) {
                signatureWriter.writeParameterType(JvmMethodParameterKind.THIS0);
                this.typeMapper.mapType(this.typeMapper.getClosureAnnotator().getEclosingClassDescriptor(this.descriptor).getDefaultType(), signatureWriter, MapTypeMode.VALUE);
                signatureWriter.writeParameterTypeEnd();
            }
            signatureWriter.writeParametersEnd();
            signatureWriter.writeVoidReturn();
            constructorMethod = signatureWriter.makeJvmMethodSignature("<init>");
            callableMethod = new CallableMethod(JvmClassName.byInternalName("Ignored"), null, null, constructorMethod, 183, null, null, null);
        } else {
            callableMethod = this.typeMapper.mapToCallableMethod(constructorDescriptor, this.kind, this.typeMapper.hasThis0(constructorDescriptor.getContainingDeclaration()));
            constructorMethod = callableMethod.getSignature();
        }
        ObjectOrClosureCodegen closure = this.context.closure;
        int firstSuperArgument = -1;
        LinkedList<JvmMethodParameterSignature> consArgTypes = new LinkedList<JvmMethodParameterSignature>(constructorMethod.getKotlinParameterTypes());
        int insert = 0;
        if (closure != null) {
            if (closure.captureThis != null) {
                if (!hasThis0) {
                    consArgTypes.add(insert, new JvmMethodParameterSignature(Type.getObjectType(this.context.getThisDescriptor().getName().getName()), "", JvmMethodParameterKind.THIS0));
                }
                ++insert;
            } else if (hasThis0) {
                ++insert;
            }
            if (closure.captureReceiver != null) {
                consArgTypes.add(insert++, new JvmMethodParameterSignature(closure.captureReceiver, "", JvmMethodParameterKind.RECEIVER));
            }
            for (DeclarationDescriptor descriptor : closure.closure.keySet()) {
                if (descriptor instanceof VariableDescriptor && !(descriptor instanceof PropertyDescriptor)) {
                    Type sharedVarType = this.typeMapper.getSharedVarType(descriptor);
                    Type type = sharedVarType != null ? sharedVarType : this.state.getInjector().getJetTypeMapper().mapType(((VariableDescriptor)descriptor).getType(), MapTypeMode.VALUE);
                    consArgTypes.add(insert++, new JvmMethodParameterSignature(type, "", JvmMethodParameterKind.SHARED_VAR));
                    continue;
                }
                if (descriptor instanceof FunctionDescriptor) assert (closure.captureReceiver != null);
            }
        }
        if (this.myClass instanceof JetObjectDeclaration && ((JetObjectDeclaration)this.myClass).isObjectLiteral()) {
            if (this.superCall instanceof JetDelegatorToSuperCall) {
                DeclarationDescriptor declarationDescriptor;
                if (closure != null) {
                    closure.superCall = (JetDelegatorToSuperCall)this.superCall;
                }
                if ((declarationDescriptor = this.bindingContext.get(BindingContext.REFERENCE_TARGET, ((JetDelegatorToSuperCall)this.superCall).getCalleeExpression().getConstructorReferenceExpression())) instanceof ClassDescriptor) {
                    declarationDescriptor = ((ClassDescriptor)declarationDescriptor).getUnsubstitutedPrimaryConstructor();
                }
                ConstructorDescriptor superConstructor = (ConstructorDescriptor)declarationDescriptor;
                CallableMethod superCallable = this.typeMapper.mapToCallableMethod(superConstructor, OwnerKind.IMPLEMENTATION, this.typeMapper.hasThis0(superConstructor.getContainingDeclaration()));
                firstSuperArgument = insert;
                for (Type t : superCallable.getSignature().getAsmMethod().getArgumentTypes()) {
                    consArgTypes.add(insert++, new JvmMethodParameterSignature(t, "", JvmMethodParameterKind.SHARED_VAR));
                }
            }
            constructorMethod = JvmMethodSignature.simple("<init>", Type.VOID_TYPE, consArgTypes);
        }
        int flags = 1;
        MethodVisitor mv = this.v.newMethod(this.myClass, flags, constructorMethod.getName(), constructorMethod.getAsmMethod().getDescriptor(), constructorMethod.getGenericsSignature(), null);
        if (this.state.getClassBuilderMode() == ClassBuilderMode.SIGNATURES) {
            return;
        }
        AnnotationVisitor jetConstructorVisitor = mv.visitAnnotation(JvmStdlibNames.JET_CONSTRUCTOR.getDescriptor(), true);
        if (constructorDescriptor == null) {
            jetConstructorVisitor.visit("hidden", true);
        }
        jetConstructorVisitor.visitEnd();
        AnnotationCodegen.forMethod(mv, this.typeMapper).genAnnotations(constructorDescriptor);
        if (constructorDescriptor != null) {
            int i = 0;
            if (hasThis0) {
                ++i;
            }
            for (ValueParameterDescriptor valueParameter : constructorDescriptor.getValueParameters()) {
                JetValueParameterAnnotationWriter jetValueParameterAnnotation = JetValueParameterAnnotationWriter.visitParameterAnnotation(mv, i);
                jetValueParameterAnnotation.writeName(valueParameter.getName().getName());
                jetValueParameterAnnotation.writeHasDefaultValue(valueParameter.declaresDefaultValue());
                jetValueParameterAnnotation.writeType(constructorMethod.getKotlinParameterType(i));
                jetValueParameterAnnotation.visitEnd();
                ++i;
            }
        }
        if (this.state.getClassBuilderMode() == ClassBuilderMode.STUBS) {
            StubCodegen.generateStubCode(mv);
            return;
        }
        mv.visitCode();
        List<Object> paramDescrs = constructorDescriptor != null ? constructorDescriptor.getValueParameters() : Collections.emptyList();
        ConstructorFrameMap frameMap = new ConstructorFrameMap(callableMethod, constructorDescriptor, hasThis0);
        InstructionAdapter iv = new InstructionAdapter(mv);
        ExpressionCodegen codegen = new ExpressionCodegen(mv, frameMap, Type.VOID_TYPE, constructorContext, this.state);
        Type classType = this.typeMapper.mapType(this.descriptor.getDefaultType(), MapTypeMode.IMPL);
        JvmClassName classname = JvmClassName.byType(classType);
        HashSet<? extends FunctionDescriptor> overridden = new HashSet<FunctionDescriptor>();
        for (JetDeclaration declaration : this.myClass.getDeclarations()) {
            if (!(declaration instanceof JetNamedFunction)) continue;
            SimpleFunctionDescriptor functionDescriptor = this.bindingContext.get(BindingContext.FUNCTION, declaration);
            assert (functionDescriptor != null);
            overridden.addAll(functionDescriptor.getOverriddenDescriptors());
        }
        if (this.superCall == null) {
            iv.load(0, Type.getType("L" + this.superClass + ";"));
            iv.invokespecial(this.superClass, "<init>", "()V");
        } else if (this.superCall instanceof JetDelegatorToSuperClass) {
            iv.load(0, Type.getType("L" + this.superClass + ";"));
            JetType superType = this.bindingContext.get(BindingContext.TYPE, this.superCall.getTypeReference());
            ArrayList<Type> parameterTypes = new ArrayList<Type>();
            assert (superType != null);
            ClassDescriptor superClassDescriptor = (ClassDescriptor)superType.getConstructor().getDeclarationDescriptor();
            if (this.typeMapper.hasThis0(superClassDescriptor)) {
                iv.load(1, JetTypeMapper.TYPE_OBJECT);
                parameterTypes.add(this.typeMapper.mapType(this.typeMapper.getClosureAnnotator().getEclosingClassDescriptor(this.descriptor).getDefaultType(), MapTypeMode.VALUE));
            }
            Method superCallMethod = new Method("<init>", Type.VOID_TYPE, parameterTypes.toArray(new Type[parameterTypes.size()]));
            iv.invokespecial(this.typeMapper.mapType(superClassDescriptor.getDefaultType(), MapTypeMode.VALUE).getInternalName(), "<init>", superCallMethod.getDescriptor());
        } else {
            ConstructorDescriptor constructorDescriptor1 = (ConstructorDescriptor)this.bindingContext.get(BindingContext.REFERENCE_TARGET, ((JetDelegatorToSuperCall)this.superCall).getCalleeExpression().getConstructorReferenceExpression());
            this.generateDelegatorToConstructorCall(iv, codegen, (JetDelegatorToSuperCall)this.superCall, constructorDescriptor1, frameMap, firstSuperArgument);
        }
        int n = 0;
        for (JetDelegationSpecifier specifier : this.myClass.getDelegationSpecifiers()) {
            if (specifier == this.superCall || !(specifier instanceof JetDelegatorByExpressionSpecifier)) continue;
            iv.load(0, classType);
            codegen.genToJVMStack(((JetDelegatorByExpressionSpecifier)specifier).getDelegateExpression());
            JetType superType = this.bindingContext.get(BindingContext.TYPE, specifier.getTypeReference());
            assert (superType != null);
            ClassDescriptor superClassDescriptor = (ClassDescriptor)superType.getConstructor().getDeclarationDescriptor();
            String delegateField = "$delegate_" + n++;
            Type fieldType = this.typeMapper.mapType(superClassDescriptor.getDefaultType(), MapTypeMode.VALUE);
            String fieldDesc = fieldType.getDescriptor();
            this.v.newField(specifier, 2, delegateField, fieldDesc, null, null);
            StackValue field = StackValue.field(fieldType, classname, delegateField, false);
            field.store(fieldType, iv);
            JetClass superClass = (JetClass)BindingContextUtils.classDescriptorToDeclaration(this.bindingContext, superClassDescriptor);
            CodegenContext delegateContext = this.context.intoClass(superClassDescriptor, new OwnerKind.DelegateKind(StackValue.field(fieldType, classname, delegateField, false), this.typeMapper.mapType(superClassDescriptor.getDefaultType(), MapTypeMode.IMPL).getInternalName()), this.state.getInjector().getJetTypeMapper());
            this.generateDelegates(superClass, delegateContext, field);
        }
        ClassDescriptor outerDescriptor = this.typeMapper.getClosureAnnotator().getEclosingClassDescriptor(this.descriptor);
        boolean bl = hasOuterThis = this.typeMapper.hasThis0(this.descriptor) && outerDescriptor != null;
        if (hasOuterThis) {
            Type type = this.typeMapper.mapType(outerDescriptor.getDefaultType(), MapTypeMode.VALUE);
            String interfaceDesc = type.getDescriptor();
            String fieldName = "this$0";
            this.v.newField(this.myClass, 16, "this$0", interfaceDesc, null, null);
            iv.load(0, classType);
            iv.load(frameMap.getOuterThisIndex(), type);
            iv.putfield(classname.getInternalName(), "this$0", interfaceDesc);
        }
        if (closure != null) {
            int k;
            int n2 = k = hasOuterThis ? 2 : 1;
            if (closure.captureReceiver != null) {
                iv.load(0, JetTypeMapper.TYPE_OBJECT);
                iv.load(1, closure.captureReceiver);
                iv.putfield(this.typeMapper.mapType(this.descriptor.getDefaultType(), MapTypeMode.VALUE).getInternalName(), "receiver$0", closure.captureReceiver.getDescriptor());
                k += closure.captureReceiver.getSize();
            }
            int l = 0;
            for (DeclarationDescriptor varDescr : closure.closure.keySet()) {
                if (!(varDescr instanceof VariableDescriptor) || varDescr instanceof PropertyDescriptor) continue;
                Type sharedVarType = this.typeMapper.getSharedVarType(varDescr);
                if (sharedVarType == null) {
                    sharedVarType = this.typeMapper.mapType(((VariableDescriptor)varDescr).getType(), MapTypeMode.VALUE);
                }
                iv.load(0, JetTypeMapper.TYPE_OBJECT);
                iv.load(k, StackValue.refType(sharedVarType));
                k += StackValue.refType(sharedVarType).getSize();
                iv.putfield(this.typeMapper.mapType(this.descriptor.getDefaultType(), MapTypeMode.VALUE).getInternalName(), "$" + varDescr.getName(), sharedVarType.getDescriptor());
                ++l;
            }
        }
        int curParam = 0;
        List<JetParameter> constructorParameters = this.getPrimaryConstructorParameters();
        for (JetParameter parameter : constructorParameters) {
            if (parameter.getValOrVarNode() != null) {
                VariableDescriptor descriptor = (VariableDescriptor)paramDescrs.get(curParam);
                Type type = this.typeMapper.mapType(descriptor.getType(), MapTypeMode.VALUE);
                iv.load(0, classType);
                iv.load(frameMap.getIndex(descriptor), type);
                iv.putfield(classname.getInternalName(), descriptor.getName().getName(), type.getDescriptor());
            }
            ++curParam;
        }
        ImplementationBodyCodegen.generateInitializers(codegen, iv, this.myClass.getDeclarations(), this.bindingContext, this.typeMapper);
        this.generateTraitMethods(codegen);
        mv.visitInsn(177);
        FunctionCodegen.endVisit(mv, "constructor", this.myClass);
        FunctionCodegen.generateDefaultIfNeeded(constructorContext, this.state, this.v, constructorMethod.getAsmMethod(), constructorDescriptor, OwnerKind.IMPLEMENTATION);
    }

    private void generateTraitMethods(ExpressionCodegen codegen) {
        if (!(this.myClass instanceof JetClass) || ((JetClass)this.myClass).isTrait() || ((JetClass)this.myClass).hasModifier(JetTokens.ABSTRACT_KEYWORD)) {
            return;
        }
        for (Pair<CallableMemberDescriptor, CallableMemberDescriptor> needDelegates : ImplementationBodyCodegen.getTraitImplementations(this.descriptor)) {
            CallableMemberDescriptor callableDescriptor = (CallableMemberDescriptor)needDelegates.first;
            if (needDelegates.second instanceof SimpleFunctionDescriptor) {
                this.generateDelegationToTraitImpl(codegen, (FunctionDescriptor)needDelegates.second, (FunctionDescriptor)needDelegates.first);
                continue;
            }
            if (!(needDelegates.second instanceof PropertyDescriptor)) continue;
            PropertyDescriptor property = (PropertyDescriptor)needDelegates.second;
            List<PropertyAccessorDescriptor> inheritedAccessors = ((PropertyDescriptor)needDelegates.first).getAccessors();
            for (PropertyAccessorDescriptor accessor : property.getAccessors()) {
                for (PropertyAccessorDescriptor inheritedAccessor : inheritedAccessors) {
                    if (inheritedAccessor.getClass() != accessor.getClass()) continue;
                    this.generateDelegationToTraitImpl(codegen, accessor, inheritedAccessor);
                }
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void generateDelegationToTraitImpl(ExpressionCodegen codegen, FunctionDescriptor fun, @NotNull FunctionDescriptor inheritedFun) {
        Method functionOriginal;
        Method function;
        JetClass jetClass;
        ClassDescriptor declaration;
        PsiElement psiElement;
        DeclarationDescriptor containingDeclaration = fun.getContainingDeclaration();
        if (!(containingDeclaration instanceof ClassDescriptor) || !((psiElement = BindingContextUtils.classDescriptorToDeclaration(this.bindingContext, declaration = (ClassDescriptor)containingDeclaration)) instanceof JetClass) || !(jetClass = (JetClass)psiElement).isTrait()) return;
        int flags = 1;
        if (fun instanceof PropertyAccessorDescriptor) {
            PropertyDescriptor property = ((PropertyAccessorDescriptor)fun).getCorrespondingProperty();
            if (fun instanceof PropertyGetterDescriptor) {
                function = this.typeMapper.mapGetterSignature(property, OwnerKind.IMPLEMENTATION).getJvmMethodSignature().getAsmMethod();
                functionOriginal = this.typeMapper.mapGetterSignature(property.getOriginal(), OwnerKind.IMPLEMENTATION).getJvmMethodSignature().getAsmMethod();
            } else {
                if (!(fun instanceof PropertySetterDescriptor)) throw new IllegalStateException("Accessor is neither getter, nor setter, what is it?");
                function = this.typeMapper.mapSetterSignature(property, OwnerKind.IMPLEMENTATION).getJvmMethodSignature().getAsmMethod();
                functionOriginal = this.typeMapper.mapSetterSignature(property.getOriginal(), OwnerKind.IMPLEMENTATION).getJvmMethodSignature().getAsmMethod();
            }
        } else {
            function = this.typeMapper.mapSignature(fun.getName(), fun).getAsmMethod();
            functionOriginal = this.typeMapper.mapSignature(fun.getName(), fun.getOriginal()).getAsmMethod();
        }
        MethodVisitor mv = this.v.newMethod(this.myClass, flags, function.getName(), function.getDescriptor(), null, null);
        AnnotationCodegen.forMethod(mv, this.state.getInjector().getJetTypeMapper()).genAnnotations(fun);
        JvmMethodSignature jvmSignature = this.typeMapper.mapToCallableMethod(inheritedFun, false, OwnerKind.IMPLEMENTATION).getSignature();
        JetMethodAnnotationWriter aw = JetMethodAnnotationWriter.visitAnnotation(mv);
        if (fun instanceof PropertyAccessorDescriptor) {
            aw.writeFlags(0);
            aw.writeTypeParameters(jvmSignature.getKotlinTypeParameter());
            aw.writePropertyType(jvmSignature.getKotlinReturnType());
        } else {
            aw.writeFlags(new int[0]);
            aw.writeNullableReturnType(fun.getReturnType().isNullable());
            aw.writeTypeParameters(jvmSignature.getKotlinTypeParameter());
            aw.writeReturnType(jvmSignature.getKotlinReturnType());
        }
        aw.visitEnd();
        if (this.state.getClassBuilderMode() == ClassBuilderMode.STUBS) {
            StubCodegen.generateStubCode(mv);
        } else if (this.state.getClassBuilderMode() == ClassBuilderMode.FULL) {
            mv.visitCode();
            codegen.generateThisOrOuter(this.descriptor);
            Type[] argTypes = function.getArgumentTypes();
            InstructionAdapter iv = new InstructionAdapter(mv);
            iv.load(0, JetTypeMapper.TYPE_OBJECT);
            int reg = 1;
            for (int i = 0; i < argTypes.length; ++i) {
                Type argType = argTypes[i];
                iv.load(reg, argType);
                reg += argType.getSize();
            }
            JetType jetType = TraitImplBodyCodegen.getSuperClass(declaration, this.bindingContext);
            Type type = this.typeMapper.mapType(jetType, MapTypeMode.IMPL);
            if (type.getInternalName().equals("java/lang/Object")) {
                jetType = declaration.getDefaultType();
                type = this.typeMapper.mapType(jetType, MapTypeMode.IMPL);
            }
            String fdescriptor = functionOriginal.getDescriptor().replace("(", "(" + type.getDescriptor());
            Type type1 = this.typeMapper.mapType(((ClassDescriptor)fun.getContainingDeclaration()).getDefaultType(), MapTypeMode.TRAIT_IMPL);
            iv.invokestatic(type1.getInternalName(), function.getName(), fdescriptor);
            if (function.getReturnType().getSort() == 10) {
                iv.checkcast(function.getReturnType());
            }
            iv.areturn(function.getReturnType());
            FunctionCodegen.endVisit(iv, "trait method", BindingContextUtils.callableDescriptorToDeclaration(this.bindingContext, fun));
        }
        FunctionCodegen.generateBridgeIfNeeded(this.context, this.state, this.v, function, fun, this.kind);
    }

    private void generateDelegatorToConstructorCall(InstructionAdapter iv, ExpressionCodegen codegen, JetCallElement constructorCall, ConstructorDescriptor constructorDescriptor, ConstructorFrameMap frameMap, int firstSuperArgument) {
        ClassDescriptor classDecl = constructorDescriptor.getContainingDeclaration();
        iv.load(0, JetTypeMapper.TYPE_OBJECT);
        if (classDecl.getContainingDeclaration() instanceof ClassDescriptor) {
            iv.load(frameMap.getOuterThisIndex(), this.typeMapper.mapType(((ClassDescriptor)this.descriptor.getContainingDeclaration()).getDefaultType(), MapTypeMode.IMPL));
        }
        CallableMethod method = this.typeMapper.mapToCallableMethod(constructorDescriptor, this.kind, this.typeMapper.hasThis0(constructorDescriptor.getContainingDeclaration()));
        if (this.myClass instanceof JetObjectDeclaration && this.superCall instanceof JetDelegatorToSuperCall && ((JetObjectDeclaration)this.myClass).isObjectLiteral()) {
            ConstructorDescriptor superConstructor = (ConstructorDescriptor)this.bindingContext.get(BindingContext.REFERENCE_TARGET, ((JetDelegatorToSuperCall)this.superCall).getCalleeExpression().getConstructorReferenceExpression());
            CallableMethod superCallable = this.typeMapper.mapToCallableMethod(superConstructor, OwnerKind.IMPLEMENTATION, this.typeMapper.hasThis0(superConstructor.getContainingDeclaration()));
            int nextVar = firstSuperArgument + 1;
            for (Type t : superCallable.getSignature().getAsmMethod().getArgumentTypes()) {
                iv.load(nextVar, t);
                nextVar += t.getSize();
            }
            method.invoke(codegen.v);
        } else {
            codegen.invokeMethodWithArguments(method, constructorCall, StackValue.none());
        }
    }

    @Override
    protected void generateDeclaration(PropertyCodegen propertyCodegen, JetDeclaration declaration, FunctionCodegen functionCodegen) {
        if (declaration instanceof JetSecondaryConstructor) {
            this.generateSecondaryConstructor((JetSecondaryConstructor)declaration);
        } else if (!(declaration instanceof JetClassObject)) {
            if (declaration instanceof JetEnumEntry && !((JetEnumEntry)declaration).hasPrimaryConstructor()) {
                String name = declaration.getName();
                String desc = "L" + this.typeMapper.mapType(this.descriptor.getDefaultType(), MapTypeMode.IMPL).getInternalName() + ";";
                this.v.newField(declaration, 25, name, desc, null, null);
                if (this.myEnumConstants.isEmpty()) {
                    this.staticInitializerChunks.add(new CodeChunk(){

                        @Override
                        public void generate(InstructionAdapter v) {
                            ImplementationBodyCodegen.this.initializeEnumConstants(v);
                        }
                    });
                }
                this.myEnumConstants.add((JetEnumEntry)declaration);
            } else {
                super.generateDeclaration(propertyCodegen, declaration, functionCodegen);
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void initializeEnumConstants(InstructionAdapter v) {
        ExpressionCodegen codegen = new ExpressionCodegen(v, new FrameMap(), Type.VOID_TYPE, this.context, this.state);
        for (JetEnumEntry enumConstant : this.myEnumConstants) {
            String implClass = this.typeMapper.mapType(this.descriptor.getDefaultType(), MapTypeMode.IMPL).getInternalName();
            List<JetDelegationSpecifier> delegationSpecifiers = enumConstant.getDelegationSpecifiers();
            if (delegationSpecifiers.size() > 1) {
                throw new UnsupportedOperationException("multiple delegation specifiers for enum constant not supported");
            }
            v.anew(Type.getObjectType(implClass));
            v.dup();
            if (delegationSpecifiers.size() == 1) {
                JetDelegationSpecifier specifier = delegationSpecifiers.get(0);
                if (!(specifier instanceof JetDelegatorToSuperCall)) throw new UnsupportedOperationException("unsupported type of enum constant initializer: " + specifier);
                JetDelegatorToSuperCall superCall = (JetDelegatorToSuperCall)specifier;
                ConstructorDescriptor constructorDescriptor = (ConstructorDescriptor)this.bindingContext.get(BindingContext.REFERENCE_TARGET, superCall.getCalleeExpression().getConstructorReferenceExpression());
                CallableMethod method = this.typeMapper.mapToCallableMethod(constructorDescriptor, OwnerKind.IMPLEMENTATION, this.typeMapper.hasThis0(constructorDescriptor.getContainingDeclaration()));
                codegen.invokeMethodWithArguments(method, superCall, StackValue.none());
            } else {
                v.invokespecial(implClass, "<init>", "()V");
            }
            v.putstatic(implClass, enumConstant.getName(), "L" + implClass + ";");
        }
    }

    private void generateSecondaryConstructor(JetSecondaryConstructor constructor) {
        ConstructorDescriptor constructorDescriptor = this.bindingContext.get(BindingContext.CONSTRUCTOR, constructor);
        if (constructorDescriptor == null) {
            throw new UnsupportedOperationException("failed to get descriptor for secondary constructor");
        }
        CallableMethod method = this.typeMapper.mapToCallableMethod(constructorDescriptor, this.kind, this.typeMapper.hasThis0(constructorDescriptor.getContainingDeclaration()));
        int flags = 1;
        MethodVisitor mv = this.v.newMethod(constructor, flags, "<init>", method.getSignature().getAsmMethod().getDescriptor(), null, null);
        if (this.state.getClassBuilderMode() == ClassBuilderMode.STUBS) {
            StubCodegen.generateStubCode(mv);
        } else if (this.state.getClassBuilderMode() == ClassBuilderMode.FULL) {
            mv.visitCode();
            ConstructorFrameMap frameMap = new ConstructorFrameMap(method, constructorDescriptor, this.typeMapper.hasThis0(constructorDescriptor.getContainingDeclaration()));
            InstructionAdapter iv = new InstructionAdapter(mv);
            ExpressionCodegen codegen = new ExpressionCodegen(mv, frameMap, Type.VOID_TYPE, this.context, this.state);
            for (JetDelegationSpecifier initializer : constructor.getInitializers()) {
                if (initializer instanceof JetDelegatorToThisCall) {
                    JetDelegatorToThisCall thisCall = (JetDelegatorToThisCall)initializer;
                    DeclarationDescriptor thisDescriptor = this.bindingContext.get(BindingContext.REFERENCE_TARGET, thisCall.getThisReference());
                    if (!(thisDescriptor instanceof ConstructorDescriptor)) {
                        throw new UnsupportedOperationException("expected 'this' delegator to resolve to constructor");
                    }
                    this.generateDelegatorToConstructorCall(iv, codegen, thisCall, (ConstructorDescriptor)thisDescriptor, frameMap, flags);
                    continue;
                }
                throw new UnsupportedOperationException("unknown initializer type");
            }
            JetExpression bodyExpression = constructor.getBodyExpression();
            if (bodyExpression != null) {
                codegen.gen(bodyExpression, Type.VOID_TYPE);
            }
            mv.visitInsn(177);
            FunctionCodegen.endVisit(mv, "constructor", null);
        }
    }

    public static void generateInitializers(@NotNull ExpressionCodegen codegen, @NotNull InstructionAdapter iv, @NotNull List<JetDeclaration> declarations, @NotNull BindingContext bindingContext, @NotNull JetTypeMapper typeMapper) {
        for (JetDeclaration declaration : declarations) {
            if (declaration instanceof JetProperty) {
                JetExpression initializer;
                PropertyDescriptor propertyDescriptor = (PropertyDescriptor)bindingContext.get(BindingContext.VARIABLE, declaration);
                if (!bindingContext.get(BindingContext.BACKING_FIELD_REQUIRED, propertyDescriptor).booleanValue() || (initializer = ((JetProperty)declaration).getInitializer()) == null) continue;
                CompileTimeConstant<?> compileTimeValue = bindingContext.get(BindingContext.COMPILE_TIME_VALUE, initializer);
                if (compileTimeValue != null) {
                    assert (compileTimeValue != null);
                    Object value = compileTimeValue.getValue();
                    Type type = typeMapper.mapType(propertyDescriptor.getType(), MapTypeMode.VALUE);
                    if (JetTypeMapper.isPrimitive(type) ? !propertyDescriptor.getType().isNullable() && value instanceof Number && (type == Type.INT_TYPE && ((Number)value).intValue() == 0 || type == Type.BYTE_TYPE && ((Number)value).byteValue() == 0 || type == Type.LONG_TYPE && ((Number)value).longValue() == 0L || type == Type.SHORT_TYPE && ((Number)value).shortValue() == 0 || type == Type.DOUBLE_TYPE && ((Number)value).doubleValue() == 0.0 || type == Type.FLOAT_TYPE && (float)((Number)value).byteValue() == 0.0f) || type == Type.BOOLEAN_TYPE && value instanceof Boolean && (Boolean)value == false || type == Type.CHAR_TYPE && value instanceof Character && ((Character)value).charValue() == '\u0000' : value == null) continue;
                }
                iv.load(0, JetTypeMapper.TYPE_OBJECT);
                Type type = codegen.expressionType(initializer);
                if (propertyDescriptor.getType().isNullable()) {
                    type = JetTypeMapper.boxType(type);
                }
                codegen.gen(initializer, type);
                JvmClassName owner = typeMapper.getOwner(propertyDescriptor, OwnerKind.IMPLEMENTATION);
                Type propType = typeMapper.mapType(propertyDescriptor.getType(), MapTypeMode.VALUE);
                StackValue.property(propertyDescriptor.getName().getName(), owner, owner, propType, false, false, false, null, null, 0).store(propType, iv);
                continue;
            }
            if (!(declaration instanceof JetClassInitializer)) continue;
            codegen.gen(((JetClassInitializer)declaration).getBody(), Type.VOID_TYPE);
        }
    }

    protected void generateDelegates(JetClass toClass, CodegenContext delegateContext, StackValue field) {
        FunctionCodegen functionCodegen = new FunctionCodegen(delegateContext, this.v, this.state);
        PropertyCodegen propertyCodegen = new PropertyCodegen(delegateContext, this.v, functionCodegen, this.state);
        ClassDescriptor classDescriptor = this.bindingContext.get(BindingContext.CLASS, toClass);
        for (DeclarationDescriptor declaration : this.descriptor.getDefaultType().getMemberScope().getAllDescriptors()) {
            CallableMemberDescriptor callableMemberDescriptor;
            if (!(declaration instanceof CallableMemberDescriptor) || (callableMemberDescriptor = (CallableMemberDescriptor)declaration).getKind() != CallableMemberDescriptor.Kind.DELEGATION) continue;
            Set<? extends CallableMemberDescriptor> overriddenDescriptors = callableMemberDescriptor.getOverriddenDescriptors();
            for (CallableMemberDescriptor callableMemberDescriptor2 : overriddenDescriptors) {
                if (callableMemberDescriptor2.getContainingDeclaration() != classDescriptor) continue;
                if (declaration instanceof PropertyDescriptor) {
                    propertyCodegen.genDelegate((PropertyDescriptor)declaration, (PropertyDescriptor)callableMemberDescriptor2, field);
                    continue;
                }
                if (!(declaration instanceof SimpleFunctionDescriptor)) continue;
                functionCodegen.genDelegate((SimpleFunctionDescriptor)declaration, callableMemberDescriptor2, field);
            }
        }
        for (JetParameter p : toClass.getPrimaryConstructorParameters()) {
            PropertyDescriptor propertyDescriptor;
            if (p.getValOrVarNode() == null || (propertyDescriptor = this.bindingContext.get(BindingContext.PRIMARY_CONSTRUCTOR_PARAMETER, p)) == null) continue;
            propertyCodegen.generateDefaultGetter(propertyDescriptor, 1, p);
            if (!propertyDescriptor.isVar()) continue;
            propertyCodegen.generateDefaultSetter(propertyDescriptor, 1, p);
        }
    }

    @Nullable
    private JetClassObject getClassObject() {
        return this.myClass instanceof JetClass ? ((JetClass)this.myClass).getClassObject() : null;
    }

    public static List<Pair<CallableMemberDescriptor, CallableMemberDescriptor>> getTraitImplementations(@NotNull ClassDescriptor classDescriptor) {
        ArrayList<Pair<CallableMemberDescriptor, CallableMemberDescriptor>> r = Lists.newArrayList();
        block0: for (DeclarationDescriptor decl : classDescriptor.getDefaultType().getMemberScope().getAllDescriptors()) {
            CallableMemberDescriptor callableMemberDescriptor;
            if (!(decl instanceof CallableMemberDescriptor) || (callableMemberDescriptor = (CallableMemberDescriptor)decl).getKind() != CallableMemberDescriptor.Kind.FAKE_OVERRIDE) continue;
            Collection<CallableMemberDescriptor> overriddenDeclarations = OverridingUtil.getOverriddenDeclarations(callableMemberDescriptor);
            for (CallableMemberDescriptor overriddenDeclaration : overriddenDeclarations) {
                if (overriddenDeclaration.getModality() == Modality.ABSTRACT || CodegenUtil.isInterface(overriddenDeclaration.getContainingDeclaration())) continue;
                continue block0;
            }
            for (CallableMemberDescriptor overriddenDeclaration : overriddenDeclarations) {
                if (overriddenDeclaration.getModality() == Modality.ABSTRACT) continue;
                r.add(Pair.create(callableMemberDescriptor, overriddenDeclaration));
            }
        }
        return r;
    }
}

