/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.codegen;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jet.analyzer.AnalyzeExhaust;
import org.jetbrains.jet.codegen.CallableMethod;
import org.jetbrains.jet.codegen.ClassBuilder;
import org.jetbrains.jet.codegen.ClassBuilderFactory;
import org.jetbrains.jet.codegen.ClassBuilderMode;
import org.jetbrains.jet.codegen.ClassFileFactory;
import org.jetbrains.jet.codegen.CodegenContext;
import org.jetbrains.jet.codegen.CompilationErrorHandler;
import org.jetbrains.jet.codegen.GeneratedAnonymousClassDescriptor;
import org.jetbrains.jet.codegen.ImplementationBodyCodegen;
import org.jetbrains.jet.codegen.MapTypeMode;
import org.jetbrains.jet.codegen.NamespaceCodegen;
import org.jetbrains.jet.codegen.ObjectOrClosureCodegen;
import org.jetbrains.jet.codegen.OwnerKind;
import org.jetbrains.jet.codegen.ScriptCodegen;
import org.jetbrains.jet.di.InjectorForJvmCodegen;
import org.jetbrains.jet.internal.com.intellij.openapi.project.Project;
import org.jetbrains.jet.internal.com.intellij.openapi.util.Pair;
import org.jetbrains.jet.internal.com.intellij.util.containers.MultiMap;
import org.jetbrains.jet.internal.org.objectweb.asm.commons.Method;
import org.jetbrains.jet.lang.descriptors.ClassDescriptor;
import org.jetbrains.jet.lang.descriptors.ConstructorDescriptor;
import org.jetbrains.jet.lang.descriptors.ScriptDescriptor;
import org.jetbrains.jet.lang.psi.JetExpression;
import org.jetbrains.jet.lang.psi.JetFile;
import org.jetbrains.jet.lang.psi.JetObjectDeclaration;
import org.jetbrains.jet.lang.psi.JetObjectLiteralExpression;
import org.jetbrains.jet.lang.psi.JetPsiUtil;
import org.jetbrains.jet.lang.psi.JetScript;
import org.jetbrains.jet.lang.resolve.BindingContext;
import org.jetbrains.jet.lang.resolve.java.CompilerSpecialMode;
import org.jetbrains.jet.lang.resolve.java.JvmClassName;
import org.jetbrains.jet.lang.resolve.name.FqName;
import org.jetbrains.jet.utils.Progress;

public class GenerationState {
    private final Project project;
    private final Progress progress;
    @NotNull
    private final AnalyzeExhaust analyzeExhaust;
    @NotNull
    private final List<JetFile> files;
    @NotNull
    private final InjectorForJvmCodegen injector;
    @NotNull
    private final ClassBuilderMode classBuilderMode;
    private boolean used = false;
    private Method scriptConstructorMethod;

    public GenerationState(Project project, ClassBuilderFactory builderFactory, AnalyzeExhaust analyzeExhaust, List<JetFile> files) {
        this(project, builderFactory, Progress.DEAF, analyzeExhaust, files, CompilerSpecialMode.REGULAR);
    }

    public GenerationState(Project project, ClassBuilderFactory builderFactory, Progress progress, @NotNull AnalyzeExhaust exhaust, @NotNull List<JetFile> files, @NotNull CompilerSpecialMode compilerSpecialMode) {
        this.project = project;
        this.progress = progress;
        this.analyzeExhaust = exhaust;
        this.files = files;
        this.classBuilderMode = builderFactory.getClassBuilderMode();
        this.injector = new InjectorForJvmCodegen(this.analyzeExhaust.getStandardLibrary(), this.analyzeExhaust.getBindingContext(), this.files, project, compilerSpecialMode, builderFactory.getClassBuilderMode(), this, builderFactory);
    }

    private void markUsed() {
        if (this.used) {
            throw new IllegalStateException(GenerationState.class + " cannot be used more than once");
        }
        this.used = true;
    }

    @NotNull
    public ClassFileFactory getFactory() {
        return this.getInjector().getClassFileFactory();
    }

    public Progress getProgress() {
        return this.progress;
    }

    public InjectorForJvmCodegen getInjector() {
        return this.injector;
    }

    public BindingContext getBindingContext() {
        return this.analyzeExhaust.getBindingContext();
    }

    @NotNull
    public ClassBuilderMode getClassBuilderMode() {
        return this.classBuilderMode;
    }

    public void setScriptConstructorMethod(@NotNull Method scriptConstructorMethod) {
        this.scriptConstructorMethod = scriptConstructorMethod;
    }

    public Method getScriptConstructorMethod() {
        return this.scriptConstructorMethod;
    }

    public ClassBuilder forClassImplementation(ClassDescriptor aClass) {
        return this.getFactory().newVisitor(this.getInjector().getJetTypeMapper().mapType(aClass.getDefaultType(), MapTypeMode.IMPL).getInternalName() + ".class");
    }

    public ClassBuilder forNamespacepart(String name, JetFile file) {
        return this.getFactory().newVisitor(name + ".class");
    }

    public ClassBuilder forTraitImplementation(ClassDescriptor aClass) {
        return this.getFactory().newVisitor(this.getInjector().getJetTypeMapper().mapType(aClass.getDefaultType(), MapTypeMode.TRAIT_IMPL).getInternalName() + ".class");
    }

    public Pair<JvmClassName, ClassBuilder> forAnonymousSubclass(JetExpression expression) {
        JvmClassName className = this.getInjector().getJetTypeMapper().getClosureAnnotator().classNameForAnonymousClass(expression);
        return Pair.create(className, this.getFactory().forAnonymousSubclass(className));
    }

    public NamespaceCodegen forNamespace(FqName fqName, Collection<JetFile> namespace) {
        return this.getFactory().forNamespace(fqName, namespace);
    }

    public void compileCorrectFiles(@NotNull CompilationErrorHandler errorHandler) {
        this.markUsed();
        for (JetFile file : this.files) {
            if (!file.isScript()) continue;
            this.injector.getClosureAnnotator().registerClassNameForScript(file.getScript(), ScriptCodegen.SCRIPT_DEFAULT_CLASS_NAME);
        }
        this.injector.getScriptCodegen().registerEarlierScripts(Collections.<Pair<ScriptDescriptor, JvmClassName>>emptyList());
        MultiMap<FqName, JetFile> namespaceGrouping = new MultiMap<FqName, JetFile>();
        for (JetFile jetFile : this.files) {
            if (jetFile == null) {
                throw new IllegalArgumentException("A null file given for compilation");
            }
            namespaceGrouping.putValue(JetPsiUtil.getFQName(jetFile), jetFile);
        }
        for (Map.Entry entry : namespaceGrouping.entrySet()) {
            this.generateNamespace((FqName)entry.getKey(), (Collection)entry.getValue(), errorHandler, this.progress);
        }
    }

    public void compileScript(@NotNull JetScript script, @NotNull JvmClassName className, @NotNull List<Pair<ScriptDescriptor, JvmClassName>> earlierScripts, @NotNull CompilationErrorHandler errorHandler) {
        this.markUsed();
        this.injector.getScriptCodegen().registerEarlierScripts(earlierScripts);
        this.injector.getClosureAnnotator().registerClassNameForScript(script, className);
        this.generateNamespace(JetPsiUtil.getFQName((JetFile)script.getContainingFile()), Collections.singleton((JetFile)script.getContainingFile()), errorHandler, this.progress);
    }

    protected void generateNamespace(FqName fqName, Collection<JetFile> namespace, CompilationErrorHandler errorHandler, Progress progress) {
        NamespaceCodegen codegen = this.forNamespace(fqName, namespace);
        codegen.generate(errorHandler, progress);
    }

    public GeneratedAnonymousClassDescriptor generateObjectLiteral(JetObjectLiteralExpression literal, ObjectOrClosureCodegen closure) {
        JetObjectDeclaration objectDeclaration = literal.getObjectDeclaration();
        Pair<JvmClassName, ClassBuilder> nameAndVisitor = this.forAnonymousSubclass(objectDeclaration);
        closure.cv = nameAndVisitor.getSecond();
        closure.name = nameAndVisitor.getFirst();
        CodegenContext objectContext = closure.context.intoAnonymousClass(closure, this.analyzeExhaust.getBindingContext().get(BindingContext.CLASS, objectDeclaration), OwnerKind.IMPLEMENTATION, this.injector.getJetTypeMapper());
        new ImplementationBodyCodegen(objectDeclaration, objectContext, nameAndVisitor.getSecond(), this).generate();
        ConstructorDescriptor constructorDescriptor = this.analyzeExhaust.getBindingContext().get(BindingContext.CONSTRUCTOR, objectDeclaration);
        CallableMethod callableMethod = this.injector.getJetTypeMapper().mapToCallableMethod(constructorDescriptor, OwnerKind.IMPLEMENTATION, this.injector.getJetTypeMapper().hasThis0(constructorDescriptor.getContainingDeclaration()));
        return new GeneratedAnonymousClassDescriptor((JvmClassName)nameAndVisitor.first, callableMethod.getSignature().getAsmMethod(), objectContext.outerWasUsed, null);
    }

    public String createText() {
        StringBuilder answer = new StringBuilder();
        ClassFileFactory factory = this.getFactory();
        List<String> files = factory.files();
        for (String file : files) {
            answer.append("@").append(file).append('\n');
            answer.append(factory.asText(file));
        }
        return answer.toString();
    }

    public void destroy() {
        this.injector.destroy();
    }
}

