/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.codegen;

import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.codegen.AnnotationCodegen;
import org.jetbrains.jet.codegen.ClassBuilder;
import org.jetbrains.jet.codegen.ClassBuilderMode;
import org.jetbrains.jet.codegen.CodegenContext;
import org.jetbrains.jet.codegen.CodegenContexts;
import org.jetbrains.jet.codegen.CodegenUtil;
import org.jetbrains.jet.codegen.CompilationException;
import org.jetbrains.jet.codegen.ExpressionCodegen;
import org.jetbrains.jet.codegen.FrameMap;
import org.jetbrains.jet.codegen.GenerationState;
import org.jetbrains.jet.codegen.JetTypeMapper;
import org.jetbrains.jet.codegen.MapTypeMode;
import org.jetbrains.jet.codegen.NamespaceCodegen;
import org.jetbrains.jet.codegen.OwnerKind;
import org.jetbrains.jet.codegen.PropertyCodegen;
import org.jetbrains.jet.codegen.StackValue;
import org.jetbrains.jet.codegen.StubCodegen;
import org.jetbrains.jet.codegen.signature.JvmMethodSignature;
import org.jetbrains.jet.codegen.signature.kotlin.JetMethodAnnotationWriter;
import org.jetbrains.jet.codegen.signature.kotlin.JetValueParameterAnnotationWriter;
import org.jetbrains.jet.internal.com.intellij.openapi.progress.ProcessCanceledException;
import org.jetbrains.jet.internal.com.intellij.psi.PsiElement;
import org.jetbrains.jet.internal.org.objectweb.asm.Label;
import org.jetbrains.jet.internal.org.objectweb.asm.MethodVisitor;
import org.jetbrains.jet.internal.org.objectweb.asm.Type;
import org.jetbrains.jet.internal.org.objectweb.asm.commons.InstructionAdapter;
import org.jetbrains.jet.internal.org.objectweb.asm.commons.Method;
import org.jetbrains.jet.lang.descriptors.CallableMemberDescriptor;
import org.jetbrains.jet.lang.descriptors.ClassDescriptor;
import org.jetbrains.jet.lang.descriptors.ClassKind;
import org.jetbrains.jet.lang.descriptors.DeclarationDescriptor;
import org.jetbrains.jet.lang.descriptors.FunctionDescriptor;
import org.jetbrains.jet.lang.descriptors.Modality;
import org.jetbrains.jet.lang.descriptors.NamespaceDescriptor;
import org.jetbrains.jet.lang.descriptors.PropertyAccessorDescriptor;
import org.jetbrains.jet.lang.descriptors.SimpleFunctionDescriptor;
import org.jetbrains.jet.lang.descriptors.TypeParameterDescriptor;
import org.jetbrains.jet.lang.descriptors.ValueParameterDescriptor;
import org.jetbrains.jet.lang.psi.JetClass;
import org.jetbrains.jet.lang.psi.JetDeclarationWithBody;
import org.jetbrains.jet.lang.psi.JetExpression;
import org.jetbrains.jet.lang.psi.JetFunctionLiteralExpression;
import org.jetbrains.jet.lang.psi.JetNamedFunction;
import org.jetbrains.jet.lang.psi.JetParameter;
import org.jetbrains.jet.lang.resolve.BindingContext;
import org.jetbrains.jet.lang.resolve.BindingContextUtils;
import org.jetbrains.jet.lang.resolve.DescriptorUtils;
import org.jetbrains.jet.lang.resolve.java.JvmClassName;
import org.jetbrains.jet.lang.resolve.name.Name;
import org.jetbrains.jet.lang.resolve.scopes.receivers.ReceiverDescriptor;

public class FunctionCodegen {
    private final CodegenContext owner;
    private final ClassBuilder v;
    private final GenerationState state;

    public FunctionCodegen(CodegenContext owner, ClassBuilder v, GenerationState state) {
        this.owner = owner;
        this.v = v;
        this.state = state;
    }

    public void gen(JetNamedFunction f) {
        SimpleFunctionDescriptor functionDescriptor = this.state.getBindingContext().get(BindingContext.FUNCTION, f);
        assert (functionDescriptor != null);
        JvmMethodSignature method = this.state.getInjector().getJetTypeMapper().mapToCallableMethod(functionDescriptor, false, this.owner.getContextKind()).getSignature();
        this.generateMethod(f, method, true, null, functionDescriptor);
    }

    public void generateMethod(JetDeclarationWithBody f, JvmMethodSignature jvmMethod, boolean needJetAnnotations, @Nullable String propertyTypeSignature, FunctionDescriptor functionDescriptor) {
        CodegenContexts.MethodContext funContext = this.owner.intoFunction(functionDescriptor);
        JetExpression bodyExpression = f.getBodyExpression();
        this.generatedMethod(bodyExpression, jvmMethod, needJetAnnotations, propertyTypeSignature, funContext, functionDescriptor, f);
    }

    private void generatedMethod(JetExpression bodyExpressions, JvmMethodSignature jvmSignature, boolean needJetAnnotations, @Nullable String propertyTypeSignature, CodegenContexts.MethodContext context, FunctionDescriptor functionDescriptor, JetDeclarationWithBody fun) {
        OwnerKind kind;
        Modality modality;
        if (functionDescriptor.getKind() == CallableMemberDescriptor.Kind.FAKE_OVERRIDE) {
            throw new IllegalStateException("must not generate code for fake overrides");
        }
        List<ValueParameterDescriptor> paramDescrs = functionDescriptor.getValueParameters();
        List<TypeParameterDescriptor> typeParameters = (functionDescriptor instanceof PropertyAccessorDescriptor ? ((PropertyAccessorDescriptor)functionDescriptor).getCorrespondingProperty() : functionDescriptor).getTypeParameters();
        int flags = 1;
        if (!functionDescriptor.getValueParameters().isEmpty() && functionDescriptor.getValueParameters().get(functionDescriptor.getValueParameters().size() - 1).getVarargElementType() != null) {
            flags |= 0x80;
        }
        if ((modality = functionDescriptor.getModality()) == Modality.FINAL) {
            flags |= 0x10;
        }
        if ((kind = context.getContextKind()) == OwnerKind.TRAIT_IMPL) {
            needJetAnnotations = false;
        }
        ReceiverDescriptor expectedThisObject = functionDescriptor.getExpectedThisObject();
        ReceiverDescriptor receiverParameter = functionDescriptor.getReceiverParameter();
        if (kind != OwnerKind.TRAIT_IMPL || bodyExpressions != null) {
            boolean isAbstract;
            boolean isStatic;
            boolean bl = isStatic = kind == OwnerKind.NAMESPACE || kind instanceof OwnerKind.StaticDelegateKind;
            if (isStatic || kind == OwnerKind.TRAIT_IMPL) {
                flags |= 8;
            }
            boolean bl2 = isAbstract = (modality == Modality.ABSTRACT || CodegenUtil.isInterface(functionDescriptor.getContainingDeclaration())) && !isStatic && kind != OwnerKind.TRAIT_IMPL;
            if (isAbstract) {
                flags |= 0x400;
            }
            MethodVisitor mv = this.v.newMethod(fun, flags, jvmSignature.getAsmMethod().getName(), jvmSignature.getAsmMethod().getDescriptor(), jvmSignature.getGenericsSignature(), null);
            AnnotationCodegen.forMethod(mv, this.state.getInjector().getJetTypeMapper()).genAnnotations(functionDescriptor);
            if (this.state.getClassBuilderMode() != ClassBuilderMode.SIGNATURES) {
                int start = 0;
                if (needJetAnnotations) {
                    if (functionDescriptor instanceof PropertyAccessorDescriptor) {
                        PropertyCodegen.generateJetPropertyAnnotation(mv, propertyTypeSignature, jvmSignature.getKotlinTypeParameter(), ((PropertyAccessorDescriptor)functionDescriptor).getCorrespondingProperty());
                    } else if (functionDescriptor instanceof SimpleFunctionDescriptor) {
                        if (propertyTypeSignature != null) {
                            throw new IllegalStateException();
                        }
                        JetMethodAnnotationWriter aw = JetMethodAnnotationWriter.visitAnnotation(mv);
                        if (CodegenUtil.isInterface(functionDescriptor.getContainingDeclaration()) && modality != Modality.ABSTRACT) {
                            aw.writeFlags(modality == Modality.FINAL ? 2 : 1);
                        } else {
                            aw.writeFlags(new int[0]);
                        }
                        aw.writeNullableReturnType(functionDescriptor.getReturnType().isNullable());
                        aw.writeTypeParameters(jvmSignature.getKotlinTypeParameter());
                        aw.writeReturnType(jvmSignature.getKotlinReturnType());
                        aw.visitEnd();
                    } else {
                        throw new IllegalStateException();
                    }
                    if (receiverParameter.exists()) {
                        JetValueParameterAnnotationWriter av = JetValueParameterAnnotationWriter.visitParameterAnnotation(mv, start++);
                        av.writeName("this$receiver");
                        av.writeNullable(receiverParameter.getType().isNullable());
                        av.writeReceiver();
                        if (jvmSignature.getKotlinParameterTypes() != null && jvmSignature.getKotlinParameterTypes().get(0) != null) {
                            av.writeType(jvmSignature.getKotlinParameterTypes().get(0).getKotlinSignature());
                        }
                        av.visitEnd();
                    }
                    for (int i = 0; i != paramDescrs.size(); ++i) {
                        JetValueParameterAnnotationWriter av = JetValueParameterAnnotationWriter.visitParameterAnnotation(mv, i + start);
                        ValueParameterDescriptor parameterDescriptor = paramDescrs.get(i);
                        av.writeName(parameterDescriptor.getName().getName());
                        av.writeHasDefaultValue(parameterDescriptor.declaresDefaultValue());
                        av.writeNullable(parameterDescriptor.getType().isNullable());
                        if (jvmSignature.getKotlinParameterTypes() != null && jvmSignature.getKotlinParameterTypes().get(i) != null) {
                            av.writeType(jvmSignature.getKotlinParameterTypes().get(i + start).getKotlinSignature());
                        }
                        av.visitEnd();
                    }
                }
            }
            if (!isAbstract && this.state.getClassBuilderMode() == ClassBuilderMode.STUBS) {
                StubCodegen.generateStubCode(mv);
            }
            if (!isAbstract && this.state.getClassBuilderMode() == ClassBuilderMode.FULL) {
                InstructionAdapter iv;
                OwnerKind dk;
                mv.visitCode();
                Label methodBegin = new Label();
                mv.visitLabel(methodBegin);
                FrameMap frameMap = context.prepareFrame(this.state.getInjector().getJetTypeMapper());
                ExpressionCodegen codegen = new ExpressionCodegen(mv, frameMap, jvmSignature.getAsmMethod().getReturnType(), context, this.state);
                Type[] argTypes = jvmSignature.getAsmMethod().getArgumentTypes();
                int add = 0;
                if (kind == OwnerKind.TRAIT_IMPL) {
                    ++add;
                }
                if (receiverParameter.exists()) {
                    ++add;
                }
                for (int i = 0; i < paramDescrs.size(); ++i) {
                    ValueParameterDescriptor parameter = paramDescrs.get(i);
                    frameMap.enter(parameter, argTypes[i + add].getSize());
                }
                if (!isStatic && kind instanceof OwnerKind.DelegateKind != (functionDescriptor.getKind() == CallableMemberDescriptor.Kind.DELEGATION)) {
                    throw new IllegalStateException("mismatching kind in " + functionDescriptor);
                }
                HashMap<Name, Label> mapLabelsToDivideLocalVarVisibilityForSharedVar = new HashMap<Name, Label>();
                if (kind instanceof OwnerKind.StaticDelegateKind) {
                    dk = (OwnerKind.StaticDelegateKind)kind;
                    iv = new InstructionAdapter(mv);
                    int k = 0;
                    for (int i = 0; i < argTypes.length; ++i) {
                        Type argType = argTypes[i];
                        iv.load(k, argType);
                        k += argType.getSize();
                    }
                    iv.invokestatic(((OwnerKind.StaticDelegateKind)dk).getOwnerClass(), jvmSignature.getAsmMethod().getName(), jvmSignature.getAsmMethod().getDescriptor());
                    iv.areturn(jvmSignature.getAsmMethod().getReturnType());
                } else if (kind instanceof OwnerKind.DelegateKind) {
                    dk = (OwnerKind.DelegateKind)kind;
                    iv = new InstructionAdapter(mv);
                    iv.load(0, JetTypeMapper.TYPE_OBJECT);
                    ((OwnerKind.DelegateKind)dk).getDelegate().put(JetTypeMapper.TYPE_OBJECT, iv);
                    for (int i = 0; i < argTypes.length; ++i) {
                        Type argType = argTypes[i];
                        iv.load(i + 1, argType);
                    }
                    iv.invokeinterface(((OwnerKind.DelegateKind)dk).getOwnerClass(), jvmSignature.getAsmMethod().getName(), jvmSignature.getAsmMethod().getDescriptor());
                    iv.areturn(jvmSignature.getAsmMethod().getReturnType());
                } else {
                    for (ValueParameterDescriptor parameter : paramDescrs) {
                        Type sharedVarType = this.state.getInjector().getJetTypeMapper().getSharedVarType(parameter);
                        if (sharedVarType == null) continue;
                        Type localVarType = this.state.getInjector().getJetTypeMapper().mapType(parameter.getType(), MapTypeMode.VALUE);
                        int index = frameMap.getIndex(parameter);
                        mv.visitTypeInsn(187, sharedVarType.getInternalName());
                        mv.visitInsn(89);
                        mv.visitInsn(89);
                        mv.visitMethodInsn(183, sharedVarType.getInternalName(), "<init>", "()V");
                        mv.visitVarInsn(localVarType.getOpcode(21), index);
                        mv.visitFieldInsn(181, sharedVarType.getInternalName(), "ref", StackValue.refType(localVarType).getDescriptor());
                        Label labelToDivideLocalVarForSharedVarVisibility = new Label();
                        mv.visitLabel(labelToDivideLocalVarForSharedVarVisibility);
                        mapLabelsToDivideLocalVarVisibilityForSharedVar.put(parameter.getName(), labelToDivideLocalVarForSharedVarVisibility);
                        mv.visitVarInsn(sharedVarType.getOpcode(54), index);
                    }
                    codegen.returnExpression(bodyExpressions);
                }
                Label methodEnd = new Label();
                mv.visitLabel(methodEnd);
                HashSet<String> localVariableNames = new HashSet<String>();
                localVariableNames.addAll(codegen.getLocalVariableNamesForExpression());
                for (ValueParameterDescriptor parameterDescriptor : paramDescrs) {
                    localVariableNames.add(parameterDescriptor.getName().getName());
                }
                int k = 0;
                if (expectedThisObject.exists()) {
                    Type type = this.state.getInjector().getJetTypeMapper().mapType(expectedThisObject.getType(), MapTypeMode.VALUE);
                    mv.visitLocalVariable("this", type.getDescriptor(), null, methodBegin, methodEnd, k++);
                } else if (fun instanceof JetFunctionLiteralExpression || CodegenUtil.isLocalFun(functionDescriptor, this.state.getBindingContext())) {
                    Type type = this.state.getInjector().getJetTypeMapper().mapType(context.getThisDescriptor().getDefaultType(), MapTypeMode.VALUE);
                    mv.visitLocalVariable("this", type.getDescriptor(), null, methodBegin, methodEnd, k++);
                }
                if (receiverParameter.exists()) {
                    Type type = this.state.getInjector().getJetTypeMapper().mapType(receiverParameter.getType(), MapTypeMode.VALUE);
                    mv.visitLocalVariable("this$receiver", type.getDescriptor(), null, methodBegin, methodEnd, k);
                    k += type.getSize();
                }
                for (ValueParameterDescriptor parameter : paramDescrs) {
                    Type type = this.state.getInjector().getJetTypeMapper().mapType(parameter.getType(), MapTypeMode.VALUE);
                    Label divideLabel = (Label)mapLabelsToDivideLocalVarVisibilityForSharedVar.get(parameter.getName());
                    String parameterName = parameter.getName().getName();
                    if (divideLabel != null) {
                        Type sharedVarType = this.state.getInjector().getJetTypeMapper().getSharedVarType(parameter);
                        mv.visitLocalVariable(parameterName, type.getDescriptor(), null, methodBegin, divideLabel, k);
                        String nameForSharedVar = CodegenUtil.generateTmpVariableName(localVariableNames);
                        localVariableNames.add(nameForSharedVar);
                        mv.visitLocalVariable(nameForSharedVar, sharedVarType.getDescriptor(), null, divideLabel, methodEnd, k);
                        k += Math.max(type.getSize(), sharedVarType.getSize());
                        continue;
                    }
                    mv.visitLocalVariable(parameter.getName().getName(), type.getDescriptor(), null, methodBegin, methodEnd, k);
                    k += type.getSize();
                }
                FunctionCodegen.endVisit(mv, null, fun);
                mv.visitEnd();
                FunctionCodegen.generateBridgeIfNeeded(this.owner, this.state, this.v, jvmSignature.getAsmMethod(), functionDescriptor, kind);
            }
        }
        FunctionCodegen.generateDefaultIfNeeded(context, this.state, this.v, jvmSignature.getAsmMethod(), functionDescriptor, kind);
    }

    public static void endVisit(MethodVisitor mv, String description, PsiElement method) {
        try {
            mv.visitMaxs(-1, -1);
        }
        catch (ProcessCanceledException e) {
            throw e;
        }
        catch (Throwable t) {
            throw new CompilationException("wrong code generated" + (description != null ? " for " + description : "") + t.getClass().getName() + " " + t.getMessage(), t, method);
        }
        mv.visitEnd();
    }

    static void generateBridgeIfNeeded(CodegenContext owner, GenerationState state, ClassBuilder v, Method jvmSignature, FunctionDescriptor functionDescriptor, OwnerKind kind) {
        Set<? extends FunctionDescriptor> overriddenFunctions = functionDescriptor.getOverriddenDescriptors();
        if (kind != OwnerKind.TRAIT_IMPL) {
            for (FunctionDescriptor functionDescriptor2 : overriddenFunctions) {
                FunctionCodegen.checkOverride(owner, state, v, jvmSignature, functionDescriptor, functionDescriptor2.getOriginal());
            }
            FunctionCodegen.checkOverride(owner, state, v, jvmSignature, functionDescriptor, functionDescriptor.getOriginal());
        }
    }

    static void generateDefaultIfNeeded(CodegenContexts.MethodContext owner, GenerationState state, ClassBuilder v, Method jvmSignature, @Nullable FunctionDescriptor functionDescriptor, OwnerKind kind) {
        JetClass element;
        PsiElement psiElement;
        DeclarationDescriptor contextClass = owner.getContextDescriptor().getContainingDeclaration();
        if (kind != OwnerKind.TRAIT_IMPL && contextClass instanceof ClassDescriptor && (psiElement = BindingContextUtils.descriptorToDeclaration(state.getBindingContext(), contextClass)) instanceof JetClass && (element = (JetClass)psiElement).isTrait()) {
            return;
        }
        boolean needed = false;
        if (functionDescriptor != null) {
            for (ValueParameterDescriptor parameterDescriptor : functionDescriptor.getValueParameters()) {
                if (!parameterDescriptor.declaresDefaultValue()) continue;
                needed = true;
                break;
            }
        }
        if (needed) {
            boolean isStatic;
            ReceiverDescriptor receiverParameter = functionDescriptor.getReceiverParameter();
            boolean hasReceiver = receiverParameter.exists();
            boolean bl = isStatic = kind == OwnerKind.NAMESPACE || kind instanceof OwnerKind.StaticDelegateKind;
            if (kind == OwnerKind.TRAIT_IMPL) {
                String correctedDescr = "(" + jvmSignature.getDescriptor().substring(jvmSignature.getDescriptor().indexOf(";") + 1);
                jvmSignature = new Method(jvmSignature.getName(), correctedDescr);
            }
            int flags = 4097;
            JvmClassName ownerInternalName = contextClass instanceof NamespaceDescriptor ? NamespaceCodegen.getJVMClassNameForKotlinNs(DescriptorUtils.getFQName(contextClass).toSafe()) : JvmClassName.byType(state.getInjector().getJetTypeMapper().mapType(((ClassDescriptor)contextClass).getDefaultType(), MapTypeMode.IMPL));
            String descriptor = jvmSignature.getDescriptor().replace(")", "I)");
            boolean isConstructor = "<init>".equals(jvmSignature.getName());
            if (!isStatic && !isConstructor) {
                descriptor = descriptor.replace("(", "(" + ownerInternalName.getDescriptor());
            }
            MethodVisitor mv = v.newMethod(null, flags | (isConstructor ? 0 : 8), isConstructor ? "<init>" : jvmSignature.getName() + "$default", descriptor, null, null);
            InstructionAdapter iv = new InstructionAdapter(mv);
            if (state.getClassBuilderMode() == ClassBuilderMode.STUBS) {
                StubCodegen.generateStubCode(mv);
            } else if (state.getClassBuilderMode() == ClassBuilderMode.FULL) {
                mv.visitCode();
                FrameMap frameMap = owner.prepareFrame(state.getInjector().getJetTypeMapper());
                ExpressionCodegen codegen = new ExpressionCodegen(mv, frameMap, jvmSignature.getReturnType(), owner, state);
                int var = 0;
                if (!isStatic) {
                    ++var;
                }
                Type receiverType = receiverParameter.exists() ? state.getInjector().getJetTypeMapper().mapType(receiverParameter.getType(), MapTypeMode.VALUE) : Type.DOUBLE_TYPE;
                if (hasReceiver) {
                    var += receiverType.getSize();
                }
                Type[] argTypes = jvmSignature.getArgumentTypes();
                List<ValueParameterDescriptor> paramDescrs = functionDescriptor.getValueParameters();
                for (int i = 0; i < paramDescrs.size(); ++i) {
                    int size = argTypes[i + (hasReceiver ? 1 : 0)].getSize();
                    var += size;
                }
                int maskIndex = var;
                var = 0;
                if (!isStatic) {
                    mv.visitVarInsn(25, var++);
                }
                if (hasReceiver) {
                    iv.load(var, receiverType);
                    var += receiverType.getSize();
                }
                int extra = hasReceiver ? 1 : 0;
                Type[] argumentTypes = jvmSignature.getArgumentTypes();
                for (int index = 0; index < paramDescrs.size(); ++index) {
                    ValueParameterDescriptor parameterDescriptor = paramDescrs.get(index);
                    Type t = argumentTypes[extra + index];
                    Label endArg = null;
                    if (parameterDescriptor.declaresDefaultValue()) {
                        iv.load(maskIndex, Type.INT_TYPE);
                        iv.iconst(1 << index);
                        iv.and(Type.INT_TYPE);
                        Label loadArg = new Label();
                        iv.ifeq(loadArg);
                        JetParameter jetParameter = (JetParameter)BindingContextUtils.descriptorToDeclaration(state.getBindingContext(), parameterDescriptor);
                        assert (jetParameter != null);
                        codegen.gen(jetParameter.getDefaultValue(), t);
                        endArg = new Label();
                        iv.goTo(endArg);
                        iv.mark(loadArg);
                    }
                    iv.load(var, t);
                    var += t.getSize();
                    if (!parameterDescriptor.declaresDefaultValue()) continue;
                    iv.mark(endArg);
                }
                if (!isStatic) {
                    if (kind == OwnerKind.TRAIT_IMPL) {
                        iv.invokeinterface(ownerInternalName.getInternalName(), jvmSignature.getName(), jvmSignature.getDescriptor());
                    } else if (!isConstructor) {
                        iv.invokevirtual(ownerInternalName.getInternalName(), jvmSignature.getName(), jvmSignature.getDescriptor());
                    } else {
                        iv.invokespecial(ownerInternalName.getInternalName(), jvmSignature.getName(), jvmSignature.getDescriptor());
                    }
                } else {
                    iv.invokestatic(ownerInternalName.getInternalName(), jvmSignature.getName(), jvmSignature.getDescriptor());
                }
                iv.areturn(jvmSignature.getReturnType());
                FunctionCodegen.endVisit(mv, "default method", BindingContextUtils.callableDescriptorToDeclaration(state.getBindingContext(), functionDescriptor));
                mv.visitEnd();
            }
        }
    }

    private static boolean differentMethods(Method method, Method overridden) {
        Type[] overriddenArgumentTypes;
        if (!method.getReturnType().equals(overridden.getReturnType())) {
            return true;
        }
        Type[] methodArgumentTypes = method.getArgumentTypes();
        if (methodArgumentTypes.length != (overriddenArgumentTypes = overridden.getArgumentTypes()).length) {
            return true;
        }
        for (int i = 0; i != methodArgumentTypes.length; ++i) {
            if (methodArgumentTypes[i].equals(overriddenArgumentTypes[i])) continue;
            return true;
        }
        return false;
    }

    private static void checkOverride(CodegenContext owner, GenerationState state, ClassBuilder v, Method jvmSignature, FunctionDescriptor functionDescriptor, FunctionDescriptor overriddenFunction) {
        Method method = state.getInjector().getJetTypeMapper().mapSignature(functionDescriptor.getName(), functionDescriptor).getAsmMethod();
        Method overridden = state.getInjector().getJetTypeMapper().mapSignature(overriddenFunction.getName(), overriddenFunction.getOriginal()).getAsmMethod();
        if (overriddenFunction.getModality() == Modality.ABSTRACT) {
            Set<? extends FunctionDescriptor> overriddenFunctions = overriddenFunction.getOverriddenDescriptors();
            for (FunctionDescriptor functionDescriptor2 : overriddenFunctions) {
                FunctionCodegen.checkOverride(owner, state, v, jvmSignature, overriddenFunction, functionDescriptor2.getOriginal());
            }
        }
        if (FunctionCodegen.differentMethods(method, overridden)) {
            int flags = 65;
            MethodVisitor mv = v.newMethod(null, flags, jvmSignature.getName(), overridden.getDescriptor(), null, null);
            if (state.getClassBuilderMode() == ClassBuilderMode.STUBS) {
                StubCodegen.generateStubCode(mv);
            } else if (state.getClassBuilderMode() == ClassBuilderMode.FULL) {
                mv.visitCode();
                Type[] typeArray = overridden.getArgumentTypes();
                InstructionAdapter iv = new InstructionAdapter(mv);
                iv.load(0, JetTypeMapper.TYPE_OBJECT);
                int reg = 1;
                for (int i = 0; i < typeArray.length; ++i) {
                    Type argType = typeArray[i];
                    iv.load(reg, argType);
                    if (argType.getSort() == 10) {
                        StackValue.onStack(JetTypeMapper.TYPE_OBJECT).put(method.getArgumentTypes()[i], iv);
                    }
                    reg += argType.getSize();
                }
                iv.invokevirtual(state.getInjector().getJetTypeMapper().mapType(((ClassDescriptor)owner.getContextDescriptor()).getDefaultType(), MapTypeMode.VALUE).getInternalName(), jvmSignature.getName(), jvmSignature.getDescriptor());
                if (JetTypeMapper.isPrimitive(jvmSignature.getReturnType()) && !JetTypeMapper.isPrimitive(overridden.getReturnType())) {
                    StackValue.valueOf(iv, jvmSignature.getReturnType());
                }
                if (jvmSignature.getReturnType() == Type.VOID_TYPE) {
                    iv.aconst(null);
                }
                iv.areturn(overridden.getReturnType());
                FunctionCodegen.endVisit(mv, "bridge method", BindingContextUtils.callableDescriptorToDeclaration(state.getBindingContext(), functionDescriptor));
            }
        }
    }

    public void genDelegate(FunctionDescriptor functionDescriptor, CallableMemberDescriptor overriddenDescriptor, StackValue field) {
        JvmMethodSignature jvmMethodSignature = this.state.getInjector().getJetTypeMapper().mapSignature(functionDescriptor.getName(), functionDescriptor);
        this.genDelegate(functionDescriptor, overriddenDescriptor, field, jvmMethodSignature);
    }

    public void genDelegate(CallableMemberDescriptor functionDescriptor, CallableMemberDescriptor overriddenDescriptor, StackValue field, JvmMethodSignature jvmMethodSignature) {
        Method method = jvmMethodSignature.getAsmMethod();
        int flags = 4097;
        MethodVisitor mv = this.v.newMethod(null, flags, method.getName(), method.getDescriptor(), null, null);
        if (this.state.getClassBuilderMode() == ClassBuilderMode.STUBS) {
            StubCodegen.generateStubCode(mv);
        } else if (this.state.getClassBuilderMode() == ClassBuilderMode.FULL) {
            mv.visitCode();
            Type[] argTypes = method.getArgumentTypes();
            InstructionAdapter iv = new InstructionAdapter(mv);
            iv.load(0, JetTypeMapper.TYPE_OBJECT);
            int reg = 1;
            for (int i = 0; i < argTypes.length; ++i) {
                Type argType = argTypes[i];
                iv.load(reg, argType);
                if (argType.getSort() == 10) {
                    StackValue.onStack(JetTypeMapper.TYPE_OBJECT).put(method.getArgumentTypes()[i], iv);
                }
                reg += argType.getSize();
            }
            iv.load(0, JetTypeMapper.TYPE_OBJECT);
            field.put(field.type, iv);
            ClassDescriptor classDescriptor = (ClassDescriptor)overriddenDescriptor.getContainingDeclaration();
            String internalName = this.state.getInjector().getJetTypeMapper().mapType(classDescriptor.getDefaultType(), MapTypeMode.VALUE).getInternalName();
            if (classDescriptor.getKind() == ClassKind.TRAIT) {
                iv.invokeinterface(internalName, method.getName(), method.getDescriptor());
            } else {
                iv.invokevirtual(internalName, method.getName(), method.getDescriptor());
            }
            iv.areturn(method.getReturnType());
            FunctionCodegen.endVisit(mv, "delegate method", BindingContextUtils.descriptorToDeclaration(this.state.getBindingContext(), functionDescriptor));
        }
    }
}

