/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.codegen;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import org.jetbrains.jet.internal.com.google.common.collect.Lists;
import org.jetbrains.jet.internal.gnu.trove.TObjectIntHashMap;
import org.jetbrains.jet.internal.gnu.trove.TObjectIntIterator;
import org.jetbrains.jet.lang.descriptors.DeclarationDescriptor;

public class FrameMap {
    private final TObjectIntHashMap<DeclarationDescriptor> myVarIndex = new TObjectIntHashMap();
    private final TObjectIntHashMap<DeclarationDescriptor> myVarSizes = new TObjectIntHashMap();
    private int myMaxIndex = 0;

    public void enter(DeclarationDescriptor descriptor, int size) {
        this.myVarIndex.put(descriptor, this.myMaxIndex);
        this.myMaxIndex += size;
        this.myVarSizes.put(descriptor, size);
    }

    public int leave(DeclarationDescriptor descriptor) {
        int size = this.myVarSizes.get(descriptor);
        this.myMaxIndex -= size;
        this.myVarSizes.remove(descriptor);
        int oldIndex = this.myVarIndex.remove(descriptor);
        if (oldIndex != this.myMaxIndex) {
            throw new IllegalStateException("descriptor can be left only if it is last");
        }
        return oldIndex;
    }

    public int enterTemp() {
        return this.enterTemp(1);
    }

    public int enterTemp(int size) {
        int result = this.myMaxIndex;
        this.myMaxIndex += size;
        return result;
    }

    public void leaveTemp() {
        --this.myMaxIndex;
    }

    public void leaveTemp(int size) {
        this.myMaxIndex -= size;
    }

    public int getIndex(DeclarationDescriptor descriptor) {
        return this.myVarIndex.contains(descriptor) ? this.myVarIndex.get(descriptor) : -1;
    }

    public Mark mark() {
        return new Mark(this.myMaxIndex);
    }

    /*
     * WARNING - void declaration
     */
    public String toString() {
        void var5_8;
        StringBuilder sb = new StringBuilder();
        if (this.myVarIndex.size() != this.myVarSizes.size()) {
            return "inconsistent";
        }
        class Tuple3<A, B, C> {
            private final A _1;
            private final B _2;
            private final C _3;

            Tuple3(A _1, B _2, C _3) {
                this._1 = _1;
                this._2 = _2;
                this._3 = _3;
            }
        }
        ArrayList<Tuple3<DeclarationDescriptor, Integer, Integer>> descriptors = Lists.newArrayList();
        Object[] arr$ = this.myVarIndex.keys();
        int len$ = arr$.length;
        boolean bl = false;
        while (var5_8 < len$) {
            Object descriptor0 = arr$[var5_8];
            DeclarationDescriptor descriptor = (DeclarationDescriptor)descriptor0;
            int varIndex = this.myVarIndex.get(descriptor);
            int varSize = this.myVarSizes.get(descriptor);
            descriptors.add(new Tuple3<DeclarationDescriptor, Integer, Integer>(descriptor, varIndex, varSize));
            ++var5_8;
        }
        Collections.sort(descriptors, new Comparator<Tuple3<DeclarationDescriptor, Integer, Integer>>(){

            @Override
            public int compare(Tuple3<DeclarationDescriptor, Integer, Integer> left, Tuple3<DeclarationDescriptor, Integer, Integer> right) {
                return (Integer)((Tuple3)left)._2 - (Integer)((Tuple3)right)._2;
            }
        });
        sb.append("size=" + this.myMaxIndex);
        boolean first = true;
        for (Tuple3 tuple3 : descriptors) {
            if (!first) {
                sb.append(", ");
            }
            first = false;
            sb.append(tuple3._1 + ",i=" + tuple3._2 + ",s=" + tuple3._3);
        }
        return sb.toString();
    }

    public class Mark {
        private final int myIndex;

        public Mark(int index) {
            this.myIndex = index;
        }

        public void dropTo() {
            ArrayList descriptorsToDrop = new ArrayList();
            TObjectIntIterator iterator = FrameMap.this.myVarIndex.iterator();
            while (iterator.hasNext()) {
                iterator.advance();
                if (iterator.value() < this.myIndex) continue;
                descriptorsToDrop.add(iterator.key());
            }
            for (DeclarationDescriptor declarationDescriptor : descriptorsToDrop) {
                FrameMap.this.myVarIndex.remove(declarationDescriptor);
                FrameMap.this.myVarSizes.remove(declarationDescriptor);
            }
            FrameMap.this.myMaxIndex = this.myIndex;
        }
    }
}

