/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.codegen;

import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.codegen.ClosureCodegen;
import org.jetbrains.jet.codegen.CodegenContexts;
import org.jetbrains.jet.codegen.FrameMap;
import org.jetbrains.jet.codegen.JetTypeMapper;
import org.jetbrains.jet.codegen.MapTypeMode;
import org.jetbrains.jet.codegen.NamespaceCodegen;
import org.jetbrains.jet.codegen.ObjectOrClosureCodegen;
import org.jetbrains.jet.codegen.OwnerKind;
import org.jetbrains.jet.codegen.StackValue;
import org.jetbrains.jet.internal.org.objectweb.asm.Type;
import org.jetbrains.jet.internal.org.objectweb.asm.commons.InstructionAdapter;
import org.jetbrains.jet.lang.descriptors.CallableDescriptor;
import org.jetbrains.jet.lang.descriptors.CallableMemberDescriptor;
import org.jetbrains.jet.lang.descriptors.ClassDescriptor;
import org.jetbrains.jet.lang.descriptors.ConstructorDescriptor;
import org.jetbrains.jet.lang.descriptors.ConstructorDescriptorImpl;
import org.jetbrains.jet.lang.descriptors.DeclarationDescriptor;
import org.jetbrains.jet.lang.descriptors.FunctionDescriptor;
import org.jetbrains.jet.lang.descriptors.NamespaceDescriptor;
import org.jetbrains.jet.lang.descriptors.PropertyDescriptor;
import org.jetbrains.jet.lang.descriptors.PropertyGetterDescriptor;
import org.jetbrains.jet.lang.descriptors.PropertySetterDescriptor;
import org.jetbrains.jet.lang.descriptors.ScriptDescriptor;
import org.jetbrains.jet.lang.descriptors.SimpleFunctionDescriptor;
import org.jetbrains.jet.lang.descriptors.SimpleFunctionDescriptorImpl;
import org.jetbrains.jet.lang.descriptors.TypeParameterDescriptor;
import org.jetbrains.jet.lang.descriptors.ValueParameterDescriptor;
import org.jetbrains.jet.lang.descriptors.Visibilities;
import org.jetbrains.jet.lang.descriptors.annotations.AnnotationDescriptor;
import org.jetbrains.jet.lang.resolve.DescriptorUtils;
import org.jetbrains.jet.lang.resolve.java.JvmClassName;
import org.jetbrains.jet.lang.resolve.name.Name;
import org.jetbrains.jet.lang.types.JetType;

public abstract class CodegenContext {
    @NotNull
    private final DeclarationDescriptor contextDescriptor;
    private final OwnerKind contextKind;
    @Nullable
    private final CodegenContext parentContext;
    public final ObjectOrClosureCodegen closure;
    HashMap<JetType, Integer> typeInfoConstants;
    HashMap<Integer, JetType> reverseTypeInfoConstants;
    int typeInfoConstantsCount;
    HashMap<DeclarationDescriptor, DeclarationDescriptor> accessors;
    protected StackValue outerExpression;
    protected Type outerWasUsed;

    public CodegenContext(@NotNull DeclarationDescriptor contextDescriptor, OwnerKind contextKind, @Nullable CodegenContext parentContext, @Nullable ObjectOrClosureCodegen closureCodegen) {
        this.contextDescriptor = contextDescriptor;
        this.contextKind = contextKind;
        this.parentContext = parentContext;
        this.closure = closureCodegen;
    }

    protected abstract ClassDescriptor getThisDescriptor();

    public DeclarationDescriptor getClassOrNamespaceDescriptor() {
        DeclarationDescriptor contextDescriptor;
        CodegenContext c = this;
        while (!((contextDescriptor = c.getContextDescriptor()) instanceof ClassDescriptor) && !(contextDescriptor instanceof NamespaceDescriptor)) {
            c = c.getParentContext();
        }
        return contextDescriptor;
    }

    protected CallableDescriptor getReceiverDescriptor() {
        return null;
    }

    protected StackValue getOuterExpression(@Nullable StackValue prefix) {
        if (this.outerExpression == null) {
            throw new UnsupportedOperationException();
        }
        this.outerWasUsed = this.outerExpression.type;
        return prefix != null ? StackValue.composed(prefix, this.outerExpression) : this.outerExpression;
    }

    public DeclarationDescriptor getContextDescriptor() {
        return this.contextDescriptor;
    }

    public String getNamespaceClassName() {
        DeclarationDescriptor descriptor = this.contextDescriptor;
        while (!(descriptor instanceof NamespaceDescriptor)) {
            descriptor = descriptor.getContainingDeclaration();
        }
        return NamespaceCodegen.getJVMClassNameForKotlinNs(DescriptorUtils.getFQName(descriptor).toSafe()).getInternalName();
    }

    public OwnerKind getContextKind() {
        return this.contextKind;
    }

    public CodegenContext intoNamespace(NamespaceDescriptor descriptor) {
        return new CodegenContexts.NamespaceContext(descriptor, this, null);
    }

    public CodegenContext intoNamespacePart(String delegateTo, NamespaceDescriptor descriptor) {
        return new CodegenContexts.NamespaceContext(descriptor, this, new OwnerKind.StaticDelegateKind(StackValue.none(), delegateTo));
    }

    public CodegenContext intoClass(ClassDescriptor descriptor, OwnerKind kind, JetTypeMapper typeMapper) {
        return new CodegenContexts.ClassContext(descriptor, kind, this, typeMapper);
    }

    public CodegenContext intoAnonymousClass(@NotNull ObjectOrClosureCodegen closure, ClassDescriptor descriptor, OwnerKind kind, JetTypeMapper typeMapper) {
        return new CodegenContexts.AnonymousClassContext(descriptor, kind, this, closure, typeMapper);
    }

    public CodegenContexts.MethodContext intoFunction(FunctionDescriptor descriptor) {
        return new CodegenContexts.MethodContext(descriptor, this.getContextKind(), this);
    }

    public CodegenContexts.ConstructorContext intoConstructor(ConstructorDescriptor descriptor, JetTypeMapper typeMapper) {
        if (descriptor == null) {
            descriptor = new ConstructorDescriptorImpl(this.getThisDescriptor(), Collections.<AnnotationDescriptor>emptyList(), true).initialize(Collections.<TypeParameterDescriptor>emptyList(), Collections.<ValueParameterDescriptor>emptyList(), Visibilities.PUBLIC);
        }
        return new CodegenContexts.ConstructorContext(descriptor, this.getContextKind(), this, typeMapper);
    }

    public CodegenContext intoScript(@NotNull ScriptDescriptor script, @NotNull ClassDescriptor classDescriptor) {
        return new CodegenContexts.ScriptContext(script, classDescriptor, OwnerKind.IMPLEMENTATION, this, this.closure);
    }

    public CodegenContexts.ClosureContext intoClosure(FunctionDescriptor funDescriptor, ClassDescriptor classDescriptor, JvmClassName internalClassName, ClosureCodegen closureCodegen, JetTypeMapper typeMapper) {
        return new CodegenContexts.ClosureContext(funDescriptor, classDescriptor, this, closureCodegen, internalClassName, typeMapper);
    }

    public FrameMap prepareFrame(JetTypeMapper mapper) {
        CallableDescriptor receiverDescriptor;
        FrameMap frameMap = new FrameMap();
        if (this.getContextKind() != OwnerKind.NAMESPACE) {
            frameMap.enterTemp();
        }
        if ((receiverDescriptor = this.getReceiverDescriptor()) != null) {
            Type type = mapper.mapType(receiverDescriptor.getReceiverParameter().getType(), MapTypeMode.VALUE);
            frameMap.enterTemp(type.getSize());
        }
        return frameMap;
    }

    @Nullable
    public CodegenContext getParentContext() {
        return this.parentContext;
    }

    public StackValue lookupInContext(DeclarationDescriptor d, InstructionAdapter v, StackValue result) {
        ObjectOrClosureCodegen top = this.closure;
        if (top != null) {
            StackValue answer = top.lookupInContext(d, result);
            if (answer != null) {
                return result == null ? answer : StackValue.composed(result, answer);
            }
            StackValue outer = this.getOuterExpression(null);
            result = result == null ? outer : StackValue.composed(result, outer);
        }
        return this.parentContext != null ? this.parentContext.lookupInContext(d, v, result) : null;
    }

    public Type enclosingClassType(JetTypeMapper typeMapper) {
        CodegenContext cur;
        for (cur = this.getParentContext(); cur != null && !(cur.getContextDescriptor() instanceof ClassDescriptor); cur = cur.getParentContext()) {
        }
        return cur == null ? null : typeMapper.mapType(((ClassDescriptor)cur.getContextDescriptor()).getDefaultType(), MapTypeMode.IMPL);
    }

    public int getTypeInfoConstantIndex(JetType type) {
        Integer index;
        if (this.parentContext != CodegenContexts.STATIC) {
            return this.parentContext.getTypeInfoConstantIndex(type);
        }
        if (this.typeInfoConstants == null) {
            this.typeInfoConstants = new LinkedHashMap<JetType, Integer>();
            this.reverseTypeInfoConstants = new LinkedHashMap<Integer, JetType>();
        }
        if ((index = this.typeInfoConstants.get(type)) == null) {
            index = this.typeInfoConstantsCount++;
            this.typeInfoConstants.put(type, index);
            this.reverseTypeInfoConstants.put(index, type);
        }
        return index;
    }

    DeclarationDescriptor getAccessor(DeclarationDescriptor descriptor) {
        DeclarationDescriptor accessor;
        if (this.accessors == null) {
            this.accessors = new HashMap();
        }
        if ((accessor = this.accessors.get(descriptor = descriptor.getOriginal())) != null) {
            return accessor;
        }
        if (descriptor instanceof SimpleFunctionDescriptor) {
            SimpleFunctionDescriptorImpl myAccessor = new SimpleFunctionDescriptorImpl(this.contextDescriptor, Collections.<AnnotationDescriptor>emptyList(), Name.identifier(descriptor.getName() + "$bridge$" + this.accessors.size()), CallableMemberDescriptor.Kind.DECLARATION);
            SimpleFunctionDescriptor fd = (SimpleFunctionDescriptor)descriptor;
            myAccessor.initialize(fd.getReceiverParameter().exists() ? fd.getReceiverParameter().getType() : null, fd.getExpectedThisObject(), fd.getTypeParameters(), fd.getValueParameters(), fd.getReturnType(), fd.getModality(), fd.getVisibility(), false);
            accessor = myAccessor;
        } else if (descriptor instanceof PropertyDescriptor) {
            PropertyDescriptor pd = (PropertyDescriptor)descriptor;
            PropertyDescriptor myAccessor = new PropertyDescriptor(this.contextDescriptor, Collections.<AnnotationDescriptor>emptyList(), pd.getModality(), pd.getVisibility(), pd.isVar(), pd.isObjectDeclaration(), Name.identifier(pd.getName() + "$bridge$" + this.accessors.size()), CallableMemberDescriptor.Kind.DECLARATION);
            JetType receiverType = pd.getReceiverParameter().exists() ? pd.getReceiverParameter().getType() : null;
            myAccessor.setType(pd.getType(), Collections.emptyList(), pd.getExpectedThisObject(), receiverType);
            PropertyGetterDescriptor pgd = new PropertyGetterDescriptor(myAccessor, Collections.<AnnotationDescriptor>emptyList(), myAccessor.getModality(), myAccessor.getVisibility(), false, false, CallableMemberDescriptor.Kind.DECLARATION);
            pgd.initialize(myAccessor.getType());
            PropertySetterDescriptor psd = new PropertySetterDescriptor(myAccessor, Collections.<AnnotationDescriptor>emptyList(), myAccessor.getModality(), myAccessor.getVisibility(), false, false, CallableMemberDescriptor.Kind.DECLARATION);
            myAccessor.initialize(pgd, psd);
            accessor = myAccessor;
        } else {
            throw new UnsupportedOperationException();
        }
        this.accessors.put(descriptor, accessor);
        return accessor;
    }

    public StackValue getReceiverExpression(JetTypeMapper typeMapper) {
        assert (this.getReceiverDescriptor() != null);
        Type asmType = typeMapper.mapType(this.getReceiverDescriptor().getReceiverParameter().getType(), MapTypeMode.VALUE);
        return this.getThisDescriptor() != null ? StackValue.local(1, asmType) : StackValue.local(0, asmType);
    }

    public abstract boolean isStatic();

    public void copyAccessors(HashMap<DeclarationDescriptor, DeclarationDescriptor> accessors) {
        if (accessors != null) {
            if (this.accessors == null) {
                this.accessors = new HashMap();
            }
            this.accessors.putAll(accessors);
        }
    }
}

