/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.codegen;

import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jet.codegen.CallableMethod;
import org.jetbrains.jet.codegen.ClassBuilder;
import org.jetbrains.jet.codegen.ClassBuilderMode;
import org.jetbrains.jet.codegen.CodegenContext;
import org.jetbrains.jet.codegen.CodegenContexts;
import org.jetbrains.jet.codegen.CodegenUtil;
import org.jetbrains.jet.codegen.EnclosedValueDescriptor;
import org.jetbrains.jet.codegen.ExpressionCodegen;
import org.jetbrains.jet.codegen.FunctionCodegen;
import org.jetbrains.jet.codegen.GeneratedAnonymousClassDescriptor;
import org.jetbrains.jet.codegen.GenerationState;
import org.jetbrains.jet.codegen.JetTypeMapper;
import org.jetbrains.jet.codegen.MapTypeMode;
import org.jetbrains.jet.codegen.ObjectOrClosureCodegen;
import org.jetbrains.jet.codegen.StackValue;
import org.jetbrains.jet.codegen.StubCodegen;
import org.jetbrains.jet.codegen.signature.BothSignatureWriter;
import org.jetbrains.jet.codegen.signature.JvmMethodParameterKind;
import org.jetbrains.jet.codegen.signature.JvmMethodSignature;
import org.jetbrains.jet.internal.com.intellij.openapi.util.Pair;
import org.jetbrains.jet.internal.com.intellij.psi.PsiElement;
import org.jetbrains.jet.internal.org.objectweb.asm.Label;
import org.jetbrains.jet.internal.org.objectweb.asm.MethodVisitor;
import org.jetbrains.jet.internal.org.objectweb.asm.Type;
import org.jetbrains.jet.internal.org.objectweb.asm.commons.InstructionAdapter;
import org.jetbrains.jet.internal.org.objectweb.asm.commons.Method;
import org.jetbrains.jet.internal.org.objectweb.asm.signature.SignatureWriter;
import org.jetbrains.jet.lang.descriptors.ClassDescriptor;
import org.jetbrains.jet.lang.descriptors.DeclarationDescriptor;
import org.jetbrains.jet.lang.descriptors.FunctionDescriptor;
import org.jetbrains.jet.lang.descriptors.PropertyDescriptor;
import org.jetbrains.jet.lang.descriptors.ValueParameterDescriptor;
import org.jetbrains.jet.lang.descriptors.VariableDescriptor;
import org.jetbrains.jet.lang.psi.JetDeclarationWithBody;
import org.jetbrains.jet.lang.psi.JetElement;
import org.jetbrains.jet.lang.psi.JetExpression;
import org.jetbrains.jet.lang.resolve.BindingContext;
import org.jetbrains.jet.lang.resolve.BindingContextUtils;
import org.jetbrains.jet.lang.resolve.java.JvmClassName;
import org.jetbrains.jet.lang.resolve.name.Name;
import org.jetbrains.jet.lang.resolve.scopes.receivers.ReceiverDescriptor;
import org.jetbrains.jet.lang.types.JetType;
import org.jetbrains.jet.lang.types.lang.JetStandardClasses;

public class ClosureCodegen
extends ObjectOrClosureCodegen {
    private final BindingContext bindingContext;

    public ClosureCodegen(GenerationState state, ExpressionCodegen exprContext, CodegenContext context) {
        super(exprContext, context, state);
        this.bindingContext = state.getBindingContext();
    }

    public static JvmMethodSignature erasedInvokeSignature(FunctionDescriptor fd) {
        BothSignatureWriter signatureWriter = new BothSignatureWriter(BothSignatureWriter.Mode.METHOD, false);
        signatureWriter.writeFormalTypeParametersStart();
        signatureWriter.writeFormalTypeParametersEnd();
        boolean isExtensionFunction = fd.getReceiverParameter().exists();
        int paramCount = fd.getValueParameters().size();
        if (isExtensionFunction) {
            ++paramCount;
        }
        signatureWriter.writeParametersStart();
        for (int i = 0; i < paramCount; ++i) {
            signatureWriter.writeParameterType(JvmMethodParameterKind.VALUE);
            signatureWriter.writeAsmType(JetTypeMapper.TYPE_OBJECT, true);
            signatureWriter.writeParameterTypeEnd();
        }
        signatureWriter.writeParametersEnd();
        signatureWriter.writeReturnType();
        signatureWriter.writeAsmType(JetTypeMapper.TYPE_OBJECT, true);
        signatureWriter.writeReturnTypeEnd();
        return signatureWriter.makeJvmMethodSignature("invoke");
    }

    public static CallableMethod asCallableMethod(FunctionDescriptor fd, @NotNull JetTypeMapper typeMapper) {
        JvmMethodSignature descriptor = ClosureCodegen.erasedInvokeSignature(fd);
        JvmClassName owner = ClosureCodegen.getInternalClassName(fd);
        Type receiverParameterType = fd.getReceiverParameter().exists() ? typeMapper.mapType(fd.getOriginal().getReceiverParameter().getType(), MapTypeMode.VALUE) : null;
        CallableMethod result = new CallableMethod(owner, null, null, descriptor, 182, ClosureCodegen.getInternalClassName(fd), receiverParameterType, ClosureCodegen.getInternalClassName(fd).getAsmType());
        return result;
    }

    public JvmMethodSignature invokeSignature(FunctionDescriptor fd) {
        return this.state.getInjector().getJetTypeMapper().mapSignature(Name.identifier("invoke"), fd);
    }

    public GeneratedAnonymousClassDescriptor gen(JetExpression fun) {
        Type enclosingType;
        Pair<JvmClassName, ClassBuilder> nameAndVisitor = this.state.forAnonymousSubclass(fun);
        FunctionDescriptor funDescriptor = (FunctionDescriptor)this.bindingContext.get(BindingContext.DECLARATION_TO_DESCRIPTOR, fun);
        this.cv = nameAndVisitor.getSecond();
        this.name = nameAndVisitor.getFirst();
        SignatureWriter signatureWriter = new SignatureWriter();
        List<ValueParameterDescriptor> parameters = funDescriptor.getValueParameters();
        JvmClassName funClass = ClosureCodegen.getInternalClassName(funDescriptor);
        signatureWriter.visitClassType(funClass.getInternalName());
        for (ValueParameterDescriptor parameter : parameters) {
            this.appendType(signatureWriter, parameter.getType(), '=');
        }
        this.appendType(signatureWriter, funDescriptor.getReturnType(), '=');
        signatureWriter.visitEnd();
        this.cv.defineClass(fun, 50, 1, this.name.getInternalName(), null, funClass.getInternalName(), new String[0]);
        this.cv.visitSource(fun.getContainingFile().getName(), null);
        this.generateBridge(this.name.getInternalName(), funDescriptor, fun, this.cv);
        this.captureThis = this.generateBody(funDescriptor, this.cv, (JetDeclarationWithBody)((Object)fun));
        ClassDescriptor thisDescriptor = this.context.getThisDescriptor();
        Type type = enclosingType = thisDescriptor == null ? null : this.state.getInjector().getJetTypeMapper().mapType(thisDescriptor.getDefaultType(), MapTypeMode.VALUE);
        if (enclosingType == null) {
            this.captureThis = null;
        }
        Method constructor = this.generateConstructor(funClass, fun);
        if (this.captureThis != null) {
            this.cv.newField(fun, 16, "this$0", enclosingType.getDescriptor(), null, null);
        }
        if (this.isConst()) {
            this.generateConstInstance(fun);
        }
        this.cv.done();
        GeneratedAnonymousClassDescriptor answer = new GeneratedAnonymousClassDescriptor(this.name, constructor, this.captureThis, this.captureReceiver);
        for (DeclarationDescriptor descriptor : this.closure.keySet()) {
            EnclosedValueDescriptor valueDescriptor;
            if (descriptor instanceof VariableDescriptor) {
                valueDescriptor = (EnclosedValueDescriptor)this.closure.get(descriptor);
                answer.addArg(valueDescriptor.getOuterValue());
                continue;
            }
            if (!CodegenUtil.isNamedFun(descriptor, this.state.getBindingContext()) || !(descriptor.getContainingDeclaration() instanceof FunctionDescriptor)) continue;
            valueDescriptor = (EnclosedValueDescriptor)this.closure.get(descriptor);
            answer.addArg(valueDescriptor.getOuterValue());
        }
        return answer;
    }

    private void generateConstInstance(PsiElement fun) {
        String classDescr = this.name.getDescriptor();
        this.cv.newField(fun, 26, "$instance", classDescr, null, null);
        MethodVisitor mv = this.cv.newMethod(fun, 9, "$getInstance", "()" + classDescr, null, new String[0]);
        if (this.state.getClassBuilderMode() == ClassBuilderMode.STUBS) {
            StubCodegen.generateStubCode(mv);
        } else if (this.state.getClassBuilderMode() == ClassBuilderMode.FULL) {
            mv.visitCode();
            mv.visitFieldInsn(178, this.name.getInternalName(), "$instance", classDescr);
            mv.visitInsn(89);
            Label ret = new Label();
            mv.visitJumpInsn(199, ret);
            mv.visitInsn(87);
            mv.visitTypeInsn(187, this.name.getInternalName());
            mv.visitInsn(89);
            mv.visitMethodInsn(183, this.name.getInternalName(), "<init>", "()V");
            mv.visitInsn(89);
            mv.visitFieldInsn(179, this.name.getInternalName(), "$instance", classDescr);
            mv.visitLabel(ret);
            mv.visitInsn(176);
            FunctionCodegen.endVisit(mv, "$getInstance", fun);
        }
    }

    private Type generateBody(FunctionDescriptor funDescriptor, ClassBuilder cv, JetDeclarationWithBody body) {
        ClassDescriptor function = this.state.getInjector().getJetTypeMapper().getClosureAnnotator().classDescriptorForFunctionDescriptor(funDescriptor, this.name);
        CodegenContexts.ClosureContext closureContext = this.context.intoClosure(funDescriptor, function, this.name, this, this.state.getInjector().getJetTypeMapper());
        FunctionCodegen fc = new FunctionCodegen(closureContext, cv, this.state);
        JvmMethodSignature jvmMethodSignature = this.invokeSignature(funDescriptor);
        fc.generateMethod(body, jvmMethodSignature, false, null, funDescriptor);
        return closureContext.outerWasUsed;
    }

    private void generateBridge(String className, FunctionDescriptor funDescriptor, JetExpression fun, ClassBuilder cv) {
        JvmMethodSignature bridge = ClosureCodegen.erasedInvokeSignature(funDescriptor);
        Method delegate = this.invokeSignature(funDescriptor).getAsmMethod();
        if (bridge.getAsmMethod().getDescriptor().equals(delegate.getDescriptor())) {
            return;
        }
        MethodVisitor mv = cv.newMethod(fun, 65, "invoke", bridge.getAsmMethod().getDescriptor(), null, new String[0]);
        if (this.state.getClassBuilderMode() == ClassBuilderMode.STUBS) {
            StubCodegen.generateStubCode(mv);
        }
        if (this.state.getClassBuilderMode() == ClassBuilderMode.FULL) {
            mv.visitCode();
            InstructionAdapter iv = new InstructionAdapter(mv);
            iv.load(0, Type.getObjectType(className));
            ReceiverDescriptor receiver = funDescriptor.getReceiverParameter();
            int count = 1;
            if (receiver.exists()) {
                StackValue.local(count, JetTypeMapper.TYPE_OBJECT).put(JetTypeMapper.TYPE_OBJECT, iv);
                StackValue.onStack(JetTypeMapper.TYPE_OBJECT).upcast(this.state.getInjector().getJetTypeMapper().mapType(receiver.getType(), MapTypeMode.VALUE), iv);
                ++count;
            }
            List<ValueParameterDescriptor> params = funDescriptor.getValueParameters();
            for (ValueParameterDescriptor param : params) {
                StackValue.local(count, JetTypeMapper.TYPE_OBJECT).put(JetTypeMapper.TYPE_OBJECT, iv);
                StackValue.onStack(JetTypeMapper.TYPE_OBJECT).upcast(this.state.getInjector().getJetTypeMapper().mapType(param.getType(), MapTypeMode.VALUE), iv);
                ++count;
            }
            iv.invokevirtual(className, "invoke", delegate.getDescriptor());
            StackValue.onStack(delegate.getReturnType()).put(JetTypeMapper.TYPE_OBJECT, iv);
            iv.areturn(JetTypeMapper.TYPE_OBJECT);
            FunctionCodegen.endVisit(mv, "bridge", fun);
        }
    }

    private Method generateConstructor(JvmClassName funClass, PsiElement fun) {
        int argCount = this.captureThis != null ? 1 : 0;
        argCount += this.captureReceiver != null ? 1 : 0;
        ArrayList<DeclarationDescriptor> variableDescriptors = new ArrayList<DeclarationDescriptor>();
        for (DeclarationDescriptor descriptor : this.closure.keySet()) {
            if (descriptor instanceof VariableDescriptor && !(descriptor instanceof PropertyDescriptor)) {
                ++argCount;
                variableDescriptors.add(descriptor);
                continue;
            }
            if (CodegenUtil.isNamedFun(descriptor, this.state.getBindingContext()) && descriptor.getContainingDeclaration() instanceof FunctionDescriptor) {
                ++argCount;
                variableDescriptors.add(descriptor);
                continue;
            }
            if (descriptor instanceof FunctionDescriptor) assert (this.captureReceiver != null);
        }
        Type[] argTypes = new Type[argCount];
        int i = 0;
        if (this.captureThis != null) {
            argTypes[i++] = this.state.getInjector().getJetTypeMapper().mapType(this.context.getThisDescriptor().getDefaultType(), MapTypeMode.VALUE);
        }
        if (this.captureReceiver != null) {
            argTypes[i++] = this.captureReceiver;
        }
        for (DeclarationDescriptor descriptor : this.closure.keySet()) {
            if (descriptor instanceof VariableDescriptor && !(descriptor instanceof PropertyDescriptor)) {
                Type sharedVarType = this.state.getInjector().getJetTypeMapper().getSharedVarType(descriptor);
                Type type = sharedVarType != null ? sharedVarType : this.state.getInjector().getJetTypeMapper().mapType(((VariableDescriptor)descriptor).getType(), MapTypeMode.VALUE);
                argTypes[i++] = type;
                continue;
            }
            if (!CodegenUtil.isNamedFun(descriptor, this.state.getBindingContext()) || !(descriptor.getContainingDeclaration() instanceof FunctionDescriptor)) continue;
            Type type = this.state.getInjector().getJetTypeMapper().getClosureAnnotator().classNameForAnonymousClass((JetElement)BindingContextUtils.descriptorToDeclaration(this.bindingContext, descriptor)).getAsmType();
            argTypes[i++] = type;
        }
        Method constructor = new Method("<init>", Type.VOID_TYPE, argTypes);
        MethodVisitor mv = this.cv.newMethod(fun, 1, "<init>", constructor.getDescriptor(), null, new String[0]);
        if (this.state.getClassBuilderMode() == ClassBuilderMode.STUBS) {
            StubCodegen.generateStubCode(mv);
        } else if (this.state.getClassBuilderMode() == ClassBuilderMode.FULL) {
            mv.visitCode();
            InstructionAdapter iv = new InstructionAdapter(mv);
            iv.load(0, funClass.getAsmType());
            iv.invokespecial(funClass.getInternalName(), "<init>", "()V");
            i = 1;
            for (Type type : argTypes) {
                String fieldName;
                StackValue.local(0, JetTypeMapper.TYPE_OBJECT).put(JetTypeMapper.TYPE_OBJECT, iv);
                StackValue.local(i, type).put(type, iv);
                if (this.captureThis != null && i == 1) {
                    fieldName = "this$0";
                } else if (this.captureReceiver != null && (this.captureThis != null && i == 2 || this.captureThis == null && i == 1)) {
                    fieldName = "receiver$0";
                } else {
                    DeclarationDescriptor removed = (DeclarationDescriptor)variableDescriptors.remove(0);
                    fieldName = "$" + removed.getName();
                }
                i += type.getSize();
                StackValue.field(type, this.name, fieldName, false).store(type, iv);
            }
            iv.visitInsn(177);
            FunctionCodegen.endVisit(iv, "constructor", fun);
        }
        return constructor;
    }

    @NotNull
    public static JvmClassName getInternalClassName(FunctionDescriptor descriptor) {
        int paramCount = descriptor.getValueParameters().size();
        if (descriptor.getReceiverParameter().exists()) {
            return JvmClassName.byInternalName("jet/ExtensionFunction" + paramCount);
        }
        return JvmClassName.byInternalName("jet/Function" + paramCount);
    }

    public static ClassDescriptor getInternalType(FunctionDescriptor descriptor) {
        int paramCount = descriptor.getValueParameters().size();
        if (descriptor.getReceiverParameter().exists()) {
            return JetStandardClasses.getReceiverFunction(paramCount);
        }
        return JetStandardClasses.getFunction(paramCount);
    }

    private void appendType(SignatureWriter signatureWriter, JetType type, char variance) {
        signatureWriter.visitTypeArgument(variance);
        JetTypeMapper typeMapper = this.state.getInjector().getJetTypeMapper();
        Type rawRetType = typeMapper.mapType(type, MapTypeMode.TYPE_PARAMETER);
        signatureWriter.visitClassType(rawRetType.getInternalName());
        signatureWriter.visitEnd();
    }
}

