/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.codegen;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.PostConstruct;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.internal.com.intellij.util.containers.MultiMap;
import org.jetbrains.jet.internal.javax.inject.Inject;
import org.jetbrains.jet.lang.descriptors.ClassDescriptor;
import org.jetbrains.jet.lang.descriptors.ClassDescriptorImpl;
import org.jetbrains.jet.lang.descriptors.ConstructorDescriptor;
import org.jetbrains.jet.lang.descriptors.DeclarationDescriptor;
import org.jetbrains.jet.lang.descriptors.FunctionDescriptor;
import org.jetbrains.jet.lang.descriptors.NamespaceDescriptor;
import org.jetbrains.jet.lang.descriptors.ScriptDescriptor;
import org.jetbrains.jet.lang.descriptors.annotations.AnnotationDescriptor;
import org.jetbrains.jet.lang.psi.JetClass;
import org.jetbrains.jet.lang.psi.JetClassObject;
import org.jetbrains.jet.lang.psi.JetElement;
import org.jetbrains.jet.lang.psi.JetFile;
import org.jetbrains.jet.lang.psi.JetFunctionLiteralExpression;
import org.jetbrains.jet.lang.psi.JetNamedFunction;
import org.jetbrains.jet.lang.psi.JetObjectDeclaration;
import org.jetbrains.jet.lang.psi.JetObjectLiteralExpression;
import org.jetbrains.jet.lang.psi.JetProperty;
import org.jetbrains.jet.lang.psi.JetPsiUtil;
import org.jetbrains.jet.lang.psi.JetScript;
import org.jetbrains.jet.lang.psi.JetVisitorVoid;
import org.jetbrains.jet.lang.resolve.BindingContext;
import org.jetbrains.jet.lang.resolve.DescriptorUtils;
import org.jetbrains.jet.lang.resolve.java.JvmClassName;
import org.jetbrains.jet.lang.resolve.name.FqName;
import org.jetbrains.jet.lang.resolve.name.Name;
import org.jetbrains.jet.lang.resolve.scopes.JetScope;
import org.jetbrains.jet.lang.types.lang.JetStandardClasses;

public class ClosureAnnotator {
    private final Map<JetElement, JvmClassName> classNamesForAnonymousClasses = new HashMap<JetElement, JvmClassName>();
    private final Map<ClassDescriptor, JvmClassName> classNamesForClassDescriptor = new HashMap<ClassDescriptor, JvmClassName>();
    private final Map<String, Integer> anonymousSubclassesCount = new HashMap<String, Integer>();
    private final Map<ScriptDescriptor, JvmClassName> classNameForScript = new HashMap<ScriptDescriptor, JvmClassName>();
    private final Set<JvmClassName> scriptClassNames = new HashSet<JvmClassName>();
    private final Map<DeclarationDescriptor, ClassDescriptorImpl> classesForFunctions = new HashMap<DeclarationDescriptor, ClassDescriptorImpl>();
    private final Map<DeclarationDescriptor, ClassDescriptor> enclosing = new HashMap<DeclarationDescriptor, ClassDescriptor>();
    private final MultiMap<FqName, JetFile> namespaceName2Files = MultiMap.create();
    private BindingContext bindingContext;
    private List<JetFile> files;

    @Inject
    public void setBindingContext(BindingContext bindingContext) {
        this.bindingContext = bindingContext;
    }

    @Inject
    public void setFiles(List<JetFile> files) {
        this.files = files;
    }

    @PostConstruct
    public void init() {
        this.mapFilesToNamespaces(this.files);
        this.prepareAnonymousClasses();
    }

    public ClassDescriptor classDescriptorForFunctionDescriptor(FunctionDescriptor funDescriptor, JvmClassName name) {
        ClassDescriptorImpl classDescriptor = this.classesForFunctions.get(funDescriptor);
        if (classDescriptor == null) {
            int arity = funDescriptor.getValueParameters().size();
            classDescriptor = new ClassDescriptorImpl(funDescriptor, Collections.<AnnotationDescriptor>emptyList(), Name.special("<closure>"));
            this.recordName(classDescriptor, name);
            classDescriptor.initialize(false, Collections.emptyList(), Collections.singleton((funDescriptor.getReceiverParameter().exists() ? JetStandardClasses.getReceiverFunction(arity) : JetStandardClasses.getFunction(arity)).getDefaultType()), JetScope.EMPTY, Collections.<ConstructorDescriptor>emptySet(), null);
            this.classesForFunctions.put(funDescriptor, classDescriptor);
        }
        return classDescriptor;
    }

    public void registerClassNameForScript(@NotNull ScriptDescriptor scriptDescriptor, @NotNull JvmClassName className) {
        JvmClassName oldName = this.classNameForScript.put(scriptDescriptor, className);
        if (oldName != null) {
            throw new IllegalStateException("Rewrite at key " + scriptDescriptor + " for name");
        }
        if (!this.scriptClassNames.add(className)) {
            throw new IllegalStateException("More than one script has class name " + className);
        }
        ClassDescriptorImpl classDescriptor = new ClassDescriptorImpl(scriptDescriptor, Collections.<AnnotationDescriptor>emptyList(), Name.special("<script-" + className + ">"));
        this.recordName(classDescriptor, className);
        classDescriptor.initialize(false, Collections.emptyList(), Collections.singletonList(JetStandardClasses.getAnyType()), JetScope.EMPTY, Collections.<ConstructorDescriptor>emptySet(), null);
        ClassDescriptorImpl oldDescriptor = this.classesForFunctions.put(scriptDescriptor, classDescriptor);
        if (oldDescriptor != null) {
            throw new IllegalStateException("Rewrite at key " + scriptDescriptor + " for class");
        }
    }

    public void registerClassNameForScript(@NotNull JetScript jetScript, @NotNull JvmClassName className) {
        ScriptDescriptor descriptor = this.bindingContext.get(BindingContext.SCRIPT, jetScript);
        if (descriptor == null) {
            throw new IllegalStateException("Descriptor is not found for PSI " + jetScript);
        }
        this.registerClassNameForScript(descriptor, className);
    }

    @NotNull
    public ClassDescriptor classDescriptorForScrpitDescriptor(@NotNull ScriptDescriptor scriptDescriptor) {
        ClassDescriptorImpl classDescriptor = this.classesForFunctions.get(scriptDescriptor);
        if (classDescriptor == null) {
            throw new IllegalStateException("Class for script is not registered: " + scriptDescriptor);
        }
        return classDescriptor;
    }

    @NotNull
    public JvmClassName classNameForScriptPsi(@NotNull JetScript script) {
        ScriptDescriptor scriptDescriptor = this.bindingContext.get(BindingContext.SCRIPT, script);
        if (scriptDescriptor == null) {
            throw new IllegalStateException("Script descriptor not found by PSI " + script);
        }
        return this.classNameForScriptDescriptor(scriptDescriptor);
    }

    @NotNull
    public JvmClassName classNameForScriptDescriptor(@NotNull ScriptDescriptor scriptDescriptor) {
        return this.classNameForClassDescriptor(this.classDescriptorForScrpitDescriptor(scriptDescriptor));
    }

    private void mapFilesToNamespaces(Collection<JetFile> files) {
        for (JetFile file : files) {
            if (file.isScript()) {
                this.namespaceName2Files.putValue(FqName.ROOT, file);
                continue;
            }
            FqName fqName = JetPsiUtil.getFQName(file);
            this.namespaceName2Files.putValue(fqName, file);
        }
    }

    private void prepareAnonymousClasses() {
        MyJetVisitorVoid visitor = new MyJetVisitorVoid();
        for (Map.Entry<FqName, Collection<JetFile>> entry : this.namespaceName2Files.entrySet()) {
            for (JetFile jetFile : entry.getValue()) {
                jetFile.accept(visitor);
            }
        }
    }

    public JvmClassName classNameForAnonymousClass(JetElement expression) {
        if (expression instanceof JetObjectLiteralExpression) {
            JetObjectLiteralExpression jetObjectLiteralExpression = (JetObjectLiteralExpression)expression;
            expression = jetObjectLiteralExpression.getObjectDeclaration();
        }
        if (expression instanceof JetFunctionLiteralExpression) {
            JetFunctionLiteralExpression jetFunctionLiteralExpression = (JetFunctionLiteralExpression)expression;
            expression = jetFunctionLiteralExpression.getFunctionLiteral();
        }
        JvmClassName name = this.classNamesForAnonymousClasses.get(expression);
        assert (name != null);
        return name;
    }

    public ClassDescriptor getEclosingClassDescriptor(ClassDescriptor descriptor) {
        return this.enclosing.get(descriptor);
    }

    public boolean hasThis0(ClassDescriptor classDescriptor) {
        if (DescriptorUtils.isClassObject(classDescriptor)) {
            return false;
        }
        ClassDescriptor other = this.enclosing.get(classDescriptor);
        return other != null;
    }

    private void recordName(@NotNull ClassDescriptor classDescriptor, @NotNull JvmClassName name) {
        JvmClassName old = this.classNamesForClassDescriptor.put(classDescriptor, name);
        if (old != null) {
            throw new IllegalStateException("rewrite at key " + classDescriptor);
        }
    }

    @NotNull
    public JvmClassName classNameForClassDescriptor(@NotNull ClassDescriptor classDescriptor) {
        return this.classNamesForClassDescriptor.get(classDescriptor);
    }

    @Nullable
    public JvmClassName classNameForClassDescriptorIfDefined(@NotNull ClassDescriptor classDescriptor) {
        return this.classNamesForClassDescriptor.get(classDescriptor);
    }

    private class MyJetVisitorVoid
    extends JetVisitorVoid {
        private LinkedList<ClassDescriptor> classStack = new LinkedList();
        private LinkedList<String> nameStack = new LinkedList();

        private MyJetVisitorVoid() {
        }

        private void recordEnclosing(ClassDescriptor classDescriptor) {
            if (this.classStack.size() > 0) {
                ClassDescriptor put = ClosureAnnotator.this.enclosing.put(classDescriptor, this.classStack.peek());
                assert (put == null);
            }
        }

        private JvmClassName recordAnonymousClass(JetElement declaration) {
            JvmClassName name = (JvmClassName)ClosureAnnotator.this.classNamesForAnonymousClasses.get(declaration);
            assert (name == null);
            String top = this.nameStack.peek();
            Integer cnt = (Integer)ClosureAnnotator.this.anonymousSubclassesCount.get(top);
            if (cnt == null) {
                cnt = 0;
            }
            name = JvmClassName.byInternalName(top + "$" + (cnt + 1));
            ClosureAnnotator.this.classNamesForAnonymousClasses.put(declaration, name);
            ClosureAnnotator.this.anonymousSubclassesCount.put(top, cnt + 1);
            return name;
        }

        private JvmClassName recordClassObject(JetClassObject declaration) {
            JvmClassName name = (JvmClassName)ClosureAnnotator.this.classNamesForAnonymousClasses.get(declaration.getObjectDeclaration());
            assert (name == null);
            name = JvmClassName.byInternalName(this.nameStack.peek() + "$ClassObject$");
            ClosureAnnotator.this.classNamesForAnonymousClasses.put(declaration.getObjectDeclaration(), name);
            return name;
        }

        @Override
        public void visitJetElement(JetElement element) {
            super.visitJetElement(element);
            element.acceptChildren(this);
        }

        @Override
        public void visitJetFile(JetFile file) {
            this.nameStack.push(JetPsiUtil.getFQName(file).getFqName().replace('.', '/'));
            file.acceptChildren(this);
            this.nameStack.pop();
        }

        @Override
        public void visitClassObject(JetClassObject classObject) {
            JvmClassName name = this.recordClassObject(classObject);
            ClassDescriptor classDescriptor = ClosureAnnotator.this.bindingContext.get(BindingContext.CLASS, classObject.getObjectDeclaration());
            this.recordEnclosing(classDescriptor);
            ClosureAnnotator.this.recordName(classDescriptor, name);
            this.classStack.push(classDescriptor);
            this.nameStack.push(name.getInternalName());
            super.visitClassObject(classObject);
            this.nameStack.pop();
            this.classStack.pop();
        }

        @Override
        public void visitObjectDeclaration(JetObjectDeclaration declaration) {
            if (declaration.getParent() instanceof JetObjectLiteralExpression || declaration.getParent() instanceof JetClassObject) {
                super.visitObjectDeclaration(declaration);
            } else {
                ClassDescriptor classDescriptor = ClosureAnnotator.this.bindingContext.get(BindingContext.CLASS, declaration);
                if (classDescriptor == null) {
                    return;
                }
                this.recordEnclosing(classDescriptor);
                this.classStack.push(classDescriptor);
                String base = this.nameStack.peek();
                if (classDescriptor.getContainingDeclaration() instanceof NamespaceDescriptor) {
                    this.nameStack.push(base.isEmpty() ? classDescriptor.getName().getName() : base + '/' + classDescriptor.getName());
                } else {
                    this.nameStack.push(base + '$' + classDescriptor.getName());
                }
                super.visitObjectDeclaration(declaration);
                this.nameStack.pop();
                this.classStack.pop();
            }
        }

        @Override
        public void visitClass(JetClass klass) {
            ClassDescriptor classDescriptor = ClosureAnnotator.this.bindingContext.get(BindingContext.CLASS, klass);
            if (classDescriptor == null) {
                return;
            }
            this.recordEnclosing(classDescriptor);
            this.classStack.push(classDescriptor);
            String base = this.nameStack.peek();
            if (classDescriptor.getContainingDeclaration() instanceof NamespaceDescriptor) {
                this.nameStack.push(base.isEmpty() ? classDescriptor.getName().getName() : base + '/' + classDescriptor.getName());
            } else {
                this.nameStack.push(base + '$' + classDescriptor.getName());
            }
            super.visitClass(klass);
            this.nameStack.pop();
            this.classStack.pop();
        }

        @Override
        public void visitObjectLiteralExpression(JetObjectLiteralExpression expression) {
            JvmClassName name = this.recordAnonymousClass(expression.getObjectDeclaration());
            ClassDescriptor classDescriptor = ClosureAnnotator.this.bindingContext.get(BindingContext.CLASS, expression.getObjectDeclaration());
            if (classDescriptor == null) {
                super.visitObjectLiteralExpression(expression);
                return;
            }
            ClosureAnnotator.this.recordName(classDescriptor, name);
            this.recordEnclosing(classDescriptor);
            this.classStack.push(classDescriptor);
            this.nameStack.push(ClosureAnnotator.this.classNameForClassDescriptor(classDescriptor).getInternalName());
            super.visitObjectLiteralExpression(expression);
            this.nameStack.pop();
            this.classStack.pop();
        }

        @Override
        public void visitFunctionLiteralExpression(JetFunctionLiteralExpression expression) {
            JvmClassName name = this.recordAnonymousClass(expression.getFunctionLiteral());
            FunctionDescriptor declarationDescriptor = (FunctionDescriptor)ClosureAnnotator.this.bindingContext.get(BindingContext.DECLARATION_TO_DESCRIPTOR, expression);
            if (declarationDescriptor == null) {
                return;
            }
            ClassDescriptor classDescriptor = ClosureAnnotator.this.classDescriptorForFunctionDescriptor(declarationDescriptor, name);
            this.recordEnclosing(classDescriptor);
            this.classStack.push(classDescriptor);
            this.nameStack.push(ClosureAnnotator.this.classNameForClassDescriptor(classDescriptor).getInternalName());
            super.visitFunctionLiteralExpression(expression);
            this.nameStack.pop();
            this.classStack.pop();
        }

        @Override
        public void visitProperty(JetProperty property) {
            this.nameStack.push(this.nameStack.peek() + '$' + property.getName());
            super.visitProperty(property);
            this.nameStack.pop();
        }

        @Override
        public void visitNamedFunction(JetNamedFunction function) {
            FunctionDescriptor functionDescriptor = (FunctionDescriptor)ClosureAnnotator.this.bindingContext.get(BindingContext.DECLARATION_TO_DESCRIPTOR, function);
            if (functionDescriptor == null) {
                return;
            }
            DeclarationDescriptor containingDeclaration = functionDescriptor.getContainingDeclaration();
            if (containingDeclaration instanceof ClassDescriptor) {
                this.nameStack.push(this.nameStack.peek() + '$' + function.getName());
                super.visitNamedFunction(function);
                this.nameStack.pop();
            } else if (containingDeclaration instanceof NamespaceDescriptor) {
                String peek = this.nameStack.peek();
                peek = peek.isEmpty() ? "namespace" : peek + "/namespace";
                this.nameStack.push(peek + '$' + function.getName());
                super.visitNamedFunction(function);
                this.nameStack.pop();
            } else {
                JvmClassName name = this.recordAnonymousClass(function);
                ClassDescriptor classDescriptor = ClosureAnnotator.this.classDescriptorForFunctionDescriptor(functionDescriptor, name);
                this.recordEnclosing(classDescriptor);
                this.classStack.push(classDescriptor);
                this.nameStack.push(name.getInternalName());
                super.visitNamedFunction(function);
                this.nameStack.pop();
                this.classStack.pop();
            }
        }
    }
}

