/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.codegen;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jet.codegen.ClassBuilder;
import org.jetbrains.jet.codegen.ClassBuilderFactory;
import org.jetbrains.jet.codegen.ClassBuilderOnDemand;
import org.jetbrains.jet.codegen.GenerationState;
import org.jetbrains.jet.codegen.NamespaceCodegen;
import org.jetbrains.jet.internal.javax.inject.Inject;
import org.jetbrains.jet.lang.psi.JetFile;
import org.jetbrains.jet.lang.resolve.java.JvmClassName;
import org.jetbrains.jet.lang.resolve.name.FqName;

public class ClassFileFactory {
    private ClassBuilderFactory builderFactory;
    public GenerationState state;
    private final Map<FqName, NamespaceCodegen> ns2codegen = new HashMap<FqName, NamespaceCodegen>();
    private final Map<String, ClassBuilder> generators = new LinkedHashMap<String, ClassBuilder>();
    private boolean isDone = false;

    @Inject
    public void setBuilderFactory(ClassBuilderFactory builderFactory) {
        this.builderFactory = builderFactory;
    }

    @Inject
    public void setState(GenerationState state) {
        this.state = state;
    }

    ClassBuilder newVisitor(String filePath) {
        this.state.getProgress().log("Emitting: " + filePath);
        ClassBuilder answer = this.builderFactory.newClassBuilder();
        this.generators.put(filePath, answer);
        return answer;
    }

    ClassBuilder forAnonymousSubclass(@NotNull JvmClassName className) {
        return this.newVisitor(className.getInternalName() + ".class");
    }

    NamespaceCodegen forNamespace(final FqName fqName, Collection<JetFile> files) {
        assert (!this.isDone) : "Already done!";
        NamespaceCodegen codegen = this.ns2codegen.get(fqName);
        if (codegen == null) {
            ClassBuilderOnDemand onDemand = new ClassBuilderOnDemand(){

                @Override
                @NotNull
                protected ClassBuilder createClassBuilder() {
                    return ClassFileFactory.this.newVisitor(NamespaceCodegen.getJVMClassNameForKotlinNs(fqName).getInternalName() + ".class");
                }
            };
            codegen = new NamespaceCodegen(onDemand, fqName, this.state, files);
            this.ns2codegen.put(fqName, codegen);
        }
        return codegen;
    }

    private void done() {
        if (!this.isDone) {
            this.isDone = true;
            for (NamespaceCodegen codegen : this.ns2codegen.values()) {
                codegen.done();
            }
        }
    }

    public String asText(String file) {
        this.done();
        return this.builderFactory.asText(this.generators.get(file));
    }

    public byte[] asBytes(String file) {
        this.done();
        return this.builderFactory.asBytes(this.generators.get(file));
    }

    public List<String> files() {
        this.done();
        return new ArrayList<String>(this.generators.keySet());
    }
}

