/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.codegen;

import java.util.HashMap;
import org.jetbrains.jet.codegen.ClassBuilder;
import org.jetbrains.jet.codegen.ClassBuilderMode;
import org.jetbrains.jet.codegen.CodegenContext;
import org.jetbrains.jet.codegen.GenerationState;
import org.jetbrains.jet.codegen.ImplementationBodyCodegen;
import org.jetbrains.jet.codegen.JetTypeMapper;
import org.jetbrains.jet.codegen.OwnerKind;
import org.jetbrains.jet.codegen.TraitImplBodyCodegen;
import org.jetbrains.jet.internal.javax.inject.Inject;
import org.jetbrains.jet.lang.descriptors.ClassDescriptor;
import org.jetbrains.jet.lang.descriptors.DeclarationDescriptor;
import org.jetbrains.jet.lang.psi.JetClass;
import org.jetbrains.jet.lang.psi.JetClassObject;
import org.jetbrains.jet.lang.psi.JetClassOrObject;
import org.jetbrains.jet.lang.psi.JetDeclaration;
import org.jetbrains.jet.lang.psi.JetEnumEntry;
import org.jetbrains.jet.lang.resolve.BindingContext;

public class ClassCodegen {
    private GenerationState state;
    private JetTypeMapper jetTypeMapper;

    @Inject
    public void setState(GenerationState state) {
        this.state = state;
    }

    @Inject
    public void setJetTypeMapper(JetTypeMapper jetTypeMapper) {
        this.jetTypeMapper = jetTypeMapper;
    }

    public void generate(CodegenContext context, JetClassOrObject aClass) {
        ClassDescriptor descriptor = this.state.getBindingContext().get(BindingContext.CLASS, aClass);
        ClassBuilder classBuilder = this.state.forClassImplementation(descriptor);
        CodegenContext contextForInners = context.intoClass(descriptor, OwnerKind.IMPLEMENTATION, this.jetTypeMapper);
        if (this.state.getClassBuilderMode() == ClassBuilderMode.SIGNATURES) {
            this.generateImplementation(context, aClass, OwnerKind.IMPLEMENTATION, contextForInners.accessors, classBuilder);
        }
        for (JetDeclaration declaration : aClass.getDeclarations()) {
            if (declaration instanceof JetClass && !(declaration instanceof JetEnumEntry)) {
                this.generate(contextForInners, (JetClass)declaration);
            }
            if (!(declaration instanceof JetClassObject)) continue;
            this.generate(contextForInners, ((JetClassObject)declaration).getObjectDeclaration());
        }
        if (this.state.getClassBuilderMode() != ClassBuilderMode.SIGNATURES) {
            this.generateImplementation(context, aClass, OwnerKind.IMPLEMENTATION, contextForInners.accessors, classBuilder);
        }
        classBuilder.done();
    }

    private void generateImplementation(CodegenContext context, JetClassOrObject aClass, OwnerKind kind, HashMap<DeclarationDescriptor, DeclarationDescriptor> accessors, ClassBuilder classBuilder) {
        ClassDescriptor descriptor = this.state.getBindingContext().get(BindingContext.CLASS, aClass);
        CodegenContext classContext = context.intoClass(descriptor, kind, this.jetTypeMapper);
        classContext.copyAccessors(accessors);
        new ImplementationBodyCodegen(aClass, classContext, classBuilder, this.state).generate();
        if (aClass instanceof JetClass && ((JetClass)aClass).isTrait()) {
            ClassBuilder traitBuilder = this.state.forTraitImplementation(descriptor);
            new TraitImplBodyCodegen(aClass, context.intoClass(descriptor, OwnerKind.TRAIT_IMPL, this.jetTypeMapper), traitBuilder, this.state).generate();
            traitBuilder.done();
        }
    }
}

