/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.codegen;

import java.io.PrintWriter;
import java.io.StringWriter;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jet.codegen.ClassBuilder;
import org.jetbrains.jet.codegen.ClassBuilderFactory;
import org.jetbrains.jet.codegen.ClassBuilderMode;
import org.jetbrains.jet.internal.org.objectweb.asm.ClassWriter;
import org.jetbrains.jet.internal.org.objectweb.asm.util.TraceClassVisitor;

public class ClassBuilderFactories {
    public static ClassBuilderFactory TEXT = new ClassBuilderFactory(){

        @Override
        @NotNull
        public ClassBuilderMode getClassBuilderMode() {
            return ClassBuilderMode.FULL;
        }

        @Override
        public ClassBuilder newClassBuilder() {
            return new ClassBuilder.Concrete(new TraceClassVisitor(new PrintWriter(new StringWriter())));
        }

        @Override
        public String asText(ClassBuilder builder) {
            TraceClassVisitor visitor = (TraceClassVisitor)builder.getVisitor();
            StringWriter writer = new StringWriter();
            visitor.print(new PrintWriter(writer));
            return writer.toString();
        }

        @Override
        public byte[] asBytes(ClassBuilder builder) {
            throw new UnsupportedOperationException("TEXT generator asked for bytes");
        }
    };

    public static ClassBuilderFactory binaries(final boolean stubs) {
        return new ClassBuilderFactory(){

            @Override
            @NotNull
            public ClassBuilderMode getClassBuilderMode() {
                return stubs ? ClassBuilderMode.STUBS : ClassBuilderMode.FULL;
            }

            @Override
            public ClassBuilder newClassBuilder() {
                return new ClassBuilder.Concrete(new ClassWriter(3){

                    @Override
                    protected String getCommonSuperClass(String type1, String type2) {
                        try {
                            return super.getCommonSuperClass(type1, type2);
                        }
                        catch (Throwable t) {
                            return "java/lang/Object";
                        }
                    }
                });
            }

            @Override
            public String asText(ClassBuilder builder) {
                throw new UnsupportedOperationException("BINARIES generator asked for text");
            }

            @Override
            public byte[] asBytes(ClassBuilder builder) {
                ClassWriter visitor = (ClassWriter)builder.getVisitor();
                return visitor.toByteArray();
            }
        };
    }
}

