/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.codegen;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.jet.codegen.ClassBuilder;
import org.jetbrains.jet.codegen.ClassBuilderMode;
import org.jetbrains.jet.codegen.CodeChunk;
import org.jetbrains.jet.codegen.CodegenContext;
import org.jetbrains.jet.codegen.FunctionCodegen;
import org.jetbrains.jet.codegen.GenerationState;
import org.jetbrains.jet.codegen.JetTypeMapper;
import org.jetbrains.jet.codegen.MapTypeMode;
import org.jetbrains.jet.codegen.OwnerKind;
import org.jetbrains.jet.codegen.PropertyCodegen;
import org.jetbrains.jet.internal.org.objectweb.asm.MethodVisitor;
import org.jetbrains.jet.internal.org.objectweb.asm.Type;
import org.jetbrains.jet.internal.org.objectweb.asm.commons.InstructionAdapter;
import org.jetbrains.jet.lang.descriptors.ClassDescriptor;
import org.jetbrains.jet.lang.descriptors.PropertyDescriptor;
import org.jetbrains.jet.lang.psi.JetClass;
import org.jetbrains.jet.lang.psi.JetClassOrObject;
import org.jetbrains.jet.lang.psi.JetDeclaration;
import org.jetbrains.jet.lang.psi.JetNamedFunction;
import org.jetbrains.jet.lang.psi.JetParameter;
import org.jetbrains.jet.lang.psi.JetProperty;
import org.jetbrains.jet.lang.psi.JetTypeParameterListOwner;
import org.jetbrains.jet.lang.resolve.BindingContext;

public abstract class ClassBodyCodegen {
    protected final GenerationState state;
    protected final JetClassOrObject myClass;
    protected final OwnerKind kind;
    protected final ClassDescriptor descriptor;
    protected final ClassBuilder v;
    protected final CodegenContext context;
    protected final List<CodeChunk> staticInitializerChunks = new ArrayList<CodeChunk>();

    public ClassBodyCodegen(JetClassOrObject aClass, CodegenContext context, ClassBuilder v, GenerationState state) {
        this.state = state;
        this.descriptor = state.getBindingContext().get(BindingContext.CLASS, aClass);
        this.myClass = aClass;
        this.context = context;
        this.kind = context.getContextKind();
        this.v = v;
    }

    public final void generate() {
        this.generateDeclaration();
        this.generateClassBody();
        this.generateSyntheticParts();
        this.generateStaticInitializer();
    }

    protected abstract void generateDeclaration();

    protected void generateSyntheticParts() {
    }

    private void generateClassBody() {
        FunctionCodegen functionCodegen = new FunctionCodegen(this.context, this.v, this.state);
        PropertyCodegen propertyCodegen = new PropertyCodegen(this.context, this.v, functionCodegen, this.state);
        for (JetDeclaration declaration : this.myClass.getDeclarations()) {
            this.generateDeclaration(propertyCodegen, declaration, functionCodegen);
        }
        this.generatePrimaryConstructorProperties(propertyCodegen, this.myClass);
    }

    protected void generateDeclaration(PropertyCodegen propertyCodegen, JetDeclaration declaration, FunctionCodegen functionCodegen) {
        if (declaration instanceof JetProperty || declaration instanceof JetNamedFunction) {
            this.state.getInjector().getMemberCodegen().generateFunctionOrProperty((JetTypeParameterListOwner)declaration, this.context, this.v);
        }
    }

    private void generatePrimaryConstructorProperties(PropertyCodegen propertyCodegen, JetClassOrObject origin) {
        boolean isAnnotation = origin instanceof JetClass && ((JetClass)origin).isAnnotation();
        OwnerKind kind = this.context.getContextKind();
        for (JetParameter p : this.getPrimaryConstructorParameters()) {
            PropertyDescriptor propertyDescriptor;
            if (p.getValOrVarNode() == null || (propertyDescriptor = this.state.getBindingContext().get(BindingContext.PRIMARY_CONSTRUCTOR_PARAMETER, p)) == null) continue;
            if (!isAnnotation) {
                propertyCodegen.generateDefaultGetter(propertyDescriptor, 1, p);
                if (propertyDescriptor.isVar()) {
                    propertyCodegen.generateDefaultSetter(propertyDescriptor, 1, origin);
                }
                if (kind instanceof OwnerKind.DelegateKind || !this.state.getBindingContext().get(BindingContext.BACKING_FIELD_REQUIRED, propertyDescriptor).booleanValue()) continue;
                int modifiers = JetTypeMapper.getAccessModifiers(propertyDescriptor, 0);
                if (!propertyDescriptor.isVar()) {
                    modifiers |= 0x10;
                }
                if (this.state.getInjector().getJetStandardLibrary().isVolatile(propertyDescriptor)) {
                    modifiers |= 0x40;
                }
                Type type = this.state.getInjector().getJetTypeMapper().mapType(propertyDescriptor.getType(), MapTypeMode.VALUE);
                this.v.newField(p, modifiers, p.getName(), type.getDescriptor(), null, null);
                continue;
            }
            Type type = this.state.getInjector().getJetTypeMapper().mapType(propertyDescriptor.getType(), MapTypeMode.VALUE);
            this.v.newMethod(p, 1025, p.getName(), "()" + type.getDescriptor(), null, null);
        }
    }

    protected List<JetParameter> getPrimaryConstructorParameters() {
        if (this.myClass instanceof JetClass) {
            return ((JetClass)this.myClass).getPrimaryConstructorParameters();
        }
        return Collections.emptyList();
    }

    private void generateStaticInitializer() {
        if (this.staticInitializerChunks.size() > 0) {
            MethodVisitor mv = this.v.newMethod(null, 9, "<clinit>", "()V", null, null);
            if (this.state.getClassBuilderMode() == ClassBuilderMode.FULL) {
                mv.visitCode();
                InstructionAdapter v = new InstructionAdapter(mv);
                for (CodeChunk chunk : this.staticInitializerChunks) {
                    chunk.generate(v);
                }
                mv.visitInsn(177);
                FunctionCodegen.endVisit(v, "static initializer", this.myClass);
            }
        }
    }
}

