/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.codegen;

import java.lang.annotation.RetentionPolicy;
import java.util.List;
import java.util.Map;
import org.jetbrains.jet.codegen.JetTypeMapper;
import org.jetbrains.jet.codegen.MapTypeMode;
import org.jetbrains.jet.internal.com.intellij.psi.PsiElement;
import org.jetbrains.jet.internal.org.objectweb.asm.AnnotationVisitor;
import org.jetbrains.jet.internal.org.objectweb.asm.ClassVisitor;
import org.jetbrains.jet.internal.org.objectweb.asm.FieldVisitor;
import org.jetbrains.jet.internal.org.objectweb.asm.MethodVisitor;
import org.jetbrains.jet.lang.descriptors.CallableDescriptor;
import org.jetbrains.jet.lang.descriptors.ClassifierDescriptor;
import org.jetbrains.jet.lang.descriptors.ConstructorDescriptor;
import org.jetbrains.jet.lang.descriptors.DeclarationDescriptor;
import org.jetbrains.jet.lang.descriptors.PropertyDescriptor;
import org.jetbrains.jet.lang.descriptors.ValueParameterDescriptor;
import org.jetbrains.jet.lang.descriptors.annotations.Annotated;
import org.jetbrains.jet.lang.descriptors.annotations.AnnotationDescriptor;
import org.jetbrains.jet.lang.psi.JetAnnotationEntry;
import org.jetbrains.jet.lang.psi.JetCallExpression;
import org.jetbrains.jet.lang.psi.JetClass;
import org.jetbrains.jet.lang.psi.JetDotQualifiedExpression;
import org.jetbrains.jet.lang.psi.JetExpression;
import org.jetbrains.jet.lang.psi.JetModifierList;
import org.jetbrains.jet.lang.psi.JetModifierListOwner;
import org.jetbrains.jet.lang.psi.ValueArgument;
import org.jetbrains.jet.lang.resolve.BindingContext;
import org.jetbrains.jet.lang.resolve.BindingContextUtils;
import org.jetbrains.jet.lang.resolve.calls.DefaultValueArgument;
import org.jetbrains.jet.lang.resolve.calls.ResolvedCall;
import org.jetbrains.jet.lang.resolve.calls.ResolvedValueArgument;
import org.jetbrains.jet.lang.resolve.calls.VarargValueArgument;
import org.jetbrains.jet.lang.resolve.constants.CompileTimeConstant;
import org.jetbrains.jet.lang.resolve.name.Name;
import org.jetbrains.jet.lang.types.JetType;

public abstract class AnnotationCodegen {
    final JetTypeMapper typeMapper;
    final BindingContext bindingContext;

    protected AnnotationCodegen(JetTypeMapper mapper) {
        this.typeMapper = mapper;
        this.bindingContext = this.typeMapper.bindingContext;
    }

    public void genAnnotations(Annotated annotated) {
        if (annotated == null) {
            return;
        }
        if (!(annotated instanceof DeclarationDescriptor)) {
            return;
        }
        PsiElement psiElement = BindingContextUtils.descriptorToDeclaration(this.bindingContext, (DeclarationDescriptor)annotated);
        JetModifierList modifierList = null;
        if (annotated instanceof ConstructorDescriptor && psiElement instanceof JetClass) {
            modifierList = ((JetClass)psiElement).getPrimaryConstructorModifierList();
        } else if (psiElement instanceof JetModifierListOwner) {
            modifierList = ((JetModifierListOwner)psiElement).getModifierList();
        }
        if (modifierList == null) {
            return;
        }
        List<JetAnnotationEntry> annotationEntries = modifierList.getAnnotationEntries();
        for (JetAnnotationEntry annotationEntry : annotationEntries) {
            ResolvedCall<? extends CallableDescriptor> resolvedCall = this.bindingContext.get(BindingContext.RESOLVED_CALL, annotationEntry.getCalleeExpression());
            assert (resolvedCall != null);
            AnnotationDescriptor annotationDescriptor = this.bindingContext.get(BindingContext.ANNOTATION, annotationEntry);
            assert (annotationDescriptor != null);
            JetType type = annotationDescriptor.getType();
            this.genAnnotation(resolvedCall, type);
        }
    }

    private void genAnnotation(ResolvedCall<? extends CallableDescriptor> resolvedCall, JetType type) {
        ClassifierDescriptor classifierDescriptor = type.getConstructor().getDeclarationDescriptor();
        RetentionPolicy rp = AnnotationCodegen.getRetentionPolicy(classifierDescriptor, this.typeMapper);
        if (rp == RetentionPolicy.SOURCE) {
            return;
        }
        String internalName = this.typeMapper.mapType(type, MapTypeMode.VALUE).getDescriptor();
        AnnotationVisitor annotationVisitor = this.visitAnnotation(internalName, rp == RetentionPolicy.RUNTIME);
        this.getAnnotation(resolvedCall, annotationVisitor);
        annotationVisitor.visitEnd();
    }

    private void getAnnotation(ResolvedCall<? extends CallableDescriptor> resolvedCall, AnnotationVisitor annotationVisitor) {
        for (Map.Entry<ValueParameterDescriptor, ResolvedValueArgument> entry : resolvedCall.getValueArguments().entrySet()) {
            ResolvedValueArgument valueArgument = entry.getValue();
            if (valueArgument instanceof DefaultValueArgument) continue;
            Name keyName = entry.getKey().getName();
            this.genAnnotationValueArgument(annotationVisitor, valueArgument, keyName.getName());
        }
    }

    private void genAnnotationValueArgument(AnnotationVisitor annotationVisitor, ResolvedValueArgument valueArgument, String keyName) {
        List<ValueArgument> valueArguments = valueArgument.getArguments();
        if (valueArgument instanceof VarargValueArgument) {
            AnnotationVisitor visitor = annotationVisitor.visitArray(keyName);
            for (ValueArgument argument : valueArguments) {
                this.genAnnotationExpressionValue(visitor, null, argument.getArgumentExpression());
            }
            visitor.visitEnd();
        } else {
            assert (valueArguments.size() == 1) : "Number of arguments on " + keyName + " = " + valueArguments.size();
            JetExpression expression = valueArguments.get(0).getArgumentExpression();
            this.genAnnotationExpressionValue(annotationVisitor, keyName, expression);
        }
    }

    private void genAnnotationExpressionValue(AnnotationVisitor annotationVisitor, String keyName, JetExpression expression) {
        JetCallExpression callExpression;
        ResolvedCall<? extends CallableDescriptor> call;
        CompileTimeConstant<?> compileTimeConstant = this.bindingContext.get(BindingContext.COMPILE_TIME_VALUE, expression);
        if (compileTimeConstant != null) {
            Object value = compileTimeConstant.getValue();
            annotationVisitor.visit(keyName, value);
            return;
        }
        if (expression instanceof JetDotQualifiedExpression) {
            JetDotQualifiedExpression qualifiedExpression = (JetDotQualifiedExpression)expression;
            ResolvedCall<? extends CallableDescriptor> call2 = this.bindingContext.get(BindingContext.RESOLVED_CALL, qualifiedExpression.getSelectorExpression());
            if (call2 != null && call2.getResultingDescriptor() instanceof PropertyDescriptor) {
                PropertyDescriptor descriptor = (PropertyDescriptor)call2.getResultingDescriptor();
                annotationVisitor.visitEnum(keyName, this.typeMapper.mapType(descriptor.getReturnType(), MapTypeMode.VALUE).getDescriptor(), descriptor.getName().getName());
                return;
            }
        } else if (expression instanceof JetCallExpression && (call = this.bindingContext.get(BindingContext.RESOLVED_CALL, (callExpression = (JetCallExpression)expression).getCalleeExpression())) != null) {
            List<AnnotationDescriptor> annotations = call.getResultingDescriptor().getOriginal().getAnnotations();
            String value = null;
            if (annotations != null) {
                for (AnnotationDescriptor annotation : annotations) {
                    if (!"Intrinsic".equals(annotation.getType().getConstructor().getDeclarationDescriptor().getName().getName())) continue;
                    value = (String)annotation.getValueArguments().get(0).getValue();
                    break;
                }
            }
            if ("kotlin.javaClass.function".equals(value)) {
                annotationVisitor.visit(keyName, this.typeMapper.mapType(call.getResultingDescriptor().getReturnType().getArguments().get(0).getType(), MapTypeMode.VALUE));
                return;
            }
            if ("kotlin.arrays.array".equals(value)) {
                AnnotationVisitor visitor = annotationVisitor.visitArray(keyName);
                VarargValueArgument next = (VarargValueArgument)call.getValueArguments().values().iterator().next();
                for (ValueArgument argument : next.getArguments()) {
                    this.genAnnotationExpressionValue(visitor, null, argument.getArgumentExpression());
                }
                visitor.visitEnd();
                return;
            }
            if (call.getResultingDescriptor() instanceof ConstructorDescriptor) {
                ConstructorDescriptor descriptor = (ConstructorDescriptor)call.getResultingDescriptor();
                AnnotationVisitor visitor = annotationVisitor.visitAnnotation(keyName, this.typeMapper.mapType(descriptor.getContainingDeclaration().getDefaultType(), MapTypeMode.VALUE).getDescriptor());
                this.getAnnotation(call, visitor);
                visitor.visitEnd();
                return;
            }
        }
        throw new IllegalStateException("Don't know how to compile annotation value");
    }

    private static RetentionPolicy getRetentionPolicy(ClassifierDescriptor descriptor, JetTypeMapper typeMapper) {
        RetentionPolicy rp = RetentionPolicy.RUNTIME;
        return rp;
    }

    abstract AnnotationVisitor visitAnnotation(String var1, boolean var2);

    public static AnnotationCodegen forClass(final ClassVisitor cv, JetTypeMapper mapper) {
        return new AnnotationCodegen(mapper){

            @Override
            AnnotationVisitor visitAnnotation(String descr, boolean visible) {
                return cv.visitAnnotation(descr, visible);
            }
        };
    }

    public static AnnotationCodegen forMethod(final MethodVisitor mv, JetTypeMapper mapper) {
        return new AnnotationCodegen(mapper){

            @Override
            AnnotationVisitor visitAnnotation(String descr, boolean visible) {
                return mv.visitAnnotation(descr, visible);
            }
        };
    }

    public static AnnotationCodegen forField(final FieldVisitor fv, JetTypeMapper mapper) {
        return new AnnotationCodegen(mapper){

            @Override
            AnnotationVisitor visitAnnotation(String descr, boolean visible) {
                return fv.visitAnnotation(descr, visible);
            }
        };
    }
}

